/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.adventure.text.Component;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.Colors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Translatable {
    private String key;
    private Object[] args;
    private boolean stripColors;
    private final List<Object> appended = new ArrayList<Object>(0);
    private Locale locale;

    private Translatable(String key) {
        this.key = key;
    }

    private Translatable(String key, Object ... args) {
        this.key = key;
        this.args = args;
    }

    public static Translatable of(String key) {
        return new Translatable(key);
    }

    public static Translatable of(String key, Object ... args) {
        return new Translatable(key, args);
    }

    public static Translatable literal(String text) {
        return new LiteralTranslatable(text);
    }

    public String key() {
        return this.key;
    }

    public Object[] args() {
        return this.args;
    }

    @Nullable
    public Locale locale() {
        return this.locale;
    }

    public boolean stripColors() {
        return this.stripColors;
    }

    public String appended() {
        if (this.appended.isEmpty()) {
            return "";
        }
        StringBuilder converted = new StringBuilder();
        for (Object object : this.appended) {
            if (object instanceof String) {
                String string = (String)object;
                converted.append(string);
                continue;
            }
            if (object instanceof Translatable) {
                Translatable translatable = (Translatable)object;
                converted.append(translatable.locale(this.locale).translate());
                continue;
            }
            if (!(object instanceof Component)) continue;
            Component component = (Component)object;
            converted.append(TownyComponents.toLegacy(component));
        }
        return converted.toString();
    }

    public Translatable key(String key) {
        this.key = key;
        return this;
    }

    public Translatable args(Object ... args) {
        this.args = args;
        return this;
    }

    public Translatable stripColors(boolean strip) {
        this.stripColors = strip;
        return this;
    }

    public Translatable append(String append) {
        this.appended.add(append);
        return this;
    }

    public Translatable append(Component append) {
        this.appended.add(append);
        return this;
    }

    public Translatable append(Translatable translatable) {
        this.appended.add(translatable);
        return this;
    }

    public Translatable locale(@Nullable Locale locale) {
        this.locale = locale;
        return this;
    }

    public Translatable locale(@NotNull Resident resident) {
        this.locale = Translation.getLocale(resident);
        return this;
    }

    public Translatable locale(@NotNull CommandSender commandSender) {
        this.locale = Translation.getLocale(commandSender);
        return this;
    }

    public String translate(@NotNull Locale locale) {
        this.locale = locale;
        return this.translate();
    }

    public String translate() {
        this.translateArgs(this.locale);
        String translated = this.args == null ? (this.locale == null ? Translation.of(this.key) : Translation.of(this.key, this.locale)) : (this.locale == null ? Translation.of(this.key, this.args) : Translation.of(this.key, this.locale, this.args));
        translated = translated + this.appended();
        return this.stripColors ? Colors.strip(translated) : translated;
    }

    public Component component(@NotNull Locale locale) {
        this.locale = locale;
        return this.component();
    }

    public Component component() {
        return TownyComponents.miniMessage(this.translate());
    }

    public String forLocale(Resident resident) {
        return this.translate(Translation.getLocale(resident));
    }

    public String forLocale(CommandSender sender) {
        return this.translate(Translation.getLocale(sender));
    }

    public String defaultLocale() {
        return this.translate(Translation.getDefaultLocale());
    }

    private void translateArgs(@Nullable Locale locale) {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (!(this.args[i] instanceof Translatable)) continue;
            this.args[i] = ((Translatable)this.args[i]).locale(locale).translate();
        }
    }

    public String toString() {
        return this.translate();
    }

    public String debug() {
        return "Translatable{key='" + this.key + '\'' + ", args=" + Arrays.toString(this.args) + ", stripColors=" + this.stripColors + ", appended=" + this.appended() + ", locale=" + this.locale + '}';
    }

    private static final class LiteralTranslatable
    extends Translatable {
        private LiteralTranslatable(String key) {
            super(key);
        }

        private LiteralTranslatable(String key, Object ... args) {
            super(key, args);
        }

        @Override
        public String translate() {
            return this.stripColors() ? Colors.strip(this.key() + this.appended()) : this.key() + this.appended();
        }
    }
}

