/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.google.common.base.Preconditions;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Savable;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class TownyObject
implements Nameable,
Savable {
    private String name;
    private Map<String, CustomDataField<?>> metadata = null;

    protected TownyObject(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getTreeString(int depth) {
        return new ArrayList<String>();
    }

    public String getTreeDepth(int depth) {
        char[] fill = new char[depth * 4];
        Arrays.fill(fill, ' ');
        if (depth > 0) {
            fill[0] = 124;
            int offset = (depth - 1) * 4;
            fill[offset] = 43;
            fill[offset + 1] = 45;
            fill[offset + 2] = 45;
        }
        return new String(fill);
    }

    public String toString() {
        return this.getName();
    }

    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, false);
    }

    public void addMetaData(@NotNull CustomDataField<?> md, boolean save) {
        Preconditions.checkNotNull(md);
        if (this.metadata == null) {
            this.metadata = new HashMap();
        }
        this.metadata.put(md.getKey(), md);
        if (save) {
            this.save();
        }
    }

    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, false);
    }

    public boolean removeMetaData(@NotNull CustomDataField<?> md, boolean save) {
        Preconditions.checkNotNull(md);
        return this.removeMetaData(md.getKey(), save);
    }

    public boolean removeMetaData(@NotNull String key) {
        return this.removeMetaData(key, false);
    }

    public boolean removeMetaData(@NotNull String key, boolean save) {
        boolean removed;
        Preconditions.checkNotNull((Object)key);
        if (!this.hasMeta()) {
            return false;
        }
        boolean bl = removed = this.metadata.remove(key) != null;
        if (this.metadata.isEmpty()) {
            this.metadata = null;
        }
        if (save && removed) {
            this.save();
        }
        return removed;
    }

    public @Unmodifiable Collection<CustomDataField<?>> getMetadata() {
        if (this.metadata == null || this.metadata.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.metadata.values());
    }

    @Nullable
    public CustomDataField<?> getMetadata(@NotNull String key) {
        Preconditions.checkNotNull((Object)key);
        if (this.metadata != null) {
            return this.metadata.get(key);
        }
        return null;
    }

    @Nullable
    public <T extends CustomDataField<?>> T getMetadata(@NotNull String key, @NotNull Class<T> cdfClass) {
        CustomDataField<?> cdf;
        Preconditions.checkNotNull(cdfClass);
        Preconditions.checkNotNull((Object)key);
        if (this.metadata != null && cdfClass.isInstance(cdf = this.metadata.get(key))) {
            return (T)cdf;
        }
        return null;
    }

    public boolean hasMeta() {
        return this.metadata != null;
    }

    public boolean hasMeta(@NotNull String key) {
        Preconditions.checkNotNull((Object)key);
        if (this.metadata != null) {
            return this.metadata.containsKey(key);
        }
        return false;
    }

    public <T extends CustomDataField<?>> boolean hasMeta(@NotNull String key, @NotNull Class<T> cdfClass) {
        Preconditions.checkNotNull(cdfClass);
        Preconditions.checkNotNull((Object)key);
        if (this.metadata != null) {
            CustomDataField<?> cdf = this.metadata.get(key);
            return cdfClass.isInstance(cdf);
        }
        return false;
    }
}

