/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.adventure.key.Key;
import com.palmergames.adventure.sound.Sound;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TownyInventory
implements InventoryHolder {
    private static final Sound clickSound = Sound.sound(Key.key("minecraft", "block.stone_button.click_on"), Sound.Source.MASTER, 1.0f, 1.0f);
    private final Inventory inv;

    public TownyInventory(Resident res, Inventory inv, String name) {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)name);
        this.inv.setContents(inv.getContents());
        res.getPlayer().openInventory(this.inv);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    public void playClickSound(Player player) {
        Towny.getAdventure().player(player).playSound(clickSound);
    }

    public void tryPaginate(ItemStack clickedItem, Player player, Resident resident, InventoryView inventoryView) {
        int currentPage = resident.getGUIPageNum();
        try {
            if (clickedItem.getItemMeta().getDisplayName().equals("\u00a76Next")) {
                if (resident.getGUIPageNum() >= resident.getGUIPages().size() - 1) {
                    return;
                }
                resident.setGUIPageNum(++currentPage);
                new TownyInventory(resident, resident.getGUIPage(), inventoryView.getTitle());
                this.playClickSound(player);
            } else if (clickedItem.getItemMeta().getDisplayName().equals("\u00a76Back")) {
                if (resident.getGUIPageNum() > 0) {
                    resident.setGUIPageNum(--currentPage);
                    new TownyInventory(resident, resident.getGUIPage(), inventoryView.getTitle());
                    this.playClickSound(player);
                } else if (resident.getGUIPageNum() == 0 && resident.getGUISelectionType() != null) {
                    this.playClickSound(player);
                    ResidentUtil.openSelectionGUI(resident, resident.getGUISelectionType());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

