/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TownBlockTypeCache {
    private Map<TownBlockType, Integer> typeCache = new ConcurrentHashMap<TownBlockType, Integer>();
    private Map<TownBlockType, Integer> forSaleCache = new ConcurrentHashMap<TownBlockType, Integer>(0);
    private Map<TownBlockType, Integer> residentOwnedCache = new ConcurrentHashMap<TownBlockType, Integer>(0);

    public int getNumTownBlocks(TownBlockType townBlockType, CacheType cacheType) {
        int n;
        switch (cacheType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALL: {
                n = this.typeCache.getOrDefault(townBlockType, 0);
                break;
            }
            case FORSALE: {
                n = this.forSaleCache.getOrDefault(townBlockType, 0);
                break;
            }
            case RESIDENTOWNED: {
                n = this.residentOwnedCache.getOrDefault(townBlockType, 0);
            }
        }
        return n;
    }

    public Map<TownBlockType, Integer> getCache(CacheType cacheType) {
        Map<TownBlockType, Integer> map;
        switch (cacheType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALL: {
                map = Collections.unmodifiableMap(this.typeCache);
                break;
            }
            case FORSALE: {
                map = Collections.unmodifiableMap(this.forSaleCache);
                break;
            }
            case RESIDENTOWNED: {
                map = Collections.unmodifiableMap(this.residentOwnedCache);
            }
        }
        return map;
    }

    public void removeTownBlockOfType(TownBlock townBlock) {
        this.typeCache.merge(townBlock.getType(), -1, Integer::sum);
    }

    public void addTownBlockOfType(TownBlock townBlock) {
        this.typeCache.merge(townBlock.getType(), 1, Integer::sum);
    }

    public void removeTownBlockOfType(TownBlockType type) {
        this.typeCache.merge(type, -1, Integer::sum);
    }

    public void addTownBlockOfType(TownBlockType type) {
        this.typeCache.merge(type, 1, Integer::sum);
    }

    public void removeTownBlockOfTypeForSale(TownBlock townBlock) {
        this.forSaleCache.merge(townBlock.getType(), -1, Integer::sum);
    }

    public void addTownBlockOfTypeForSale(TownBlock townBlock) {
        this.forSaleCache.merge(townBlock.getType(), 1, Integer::sum);
    }

    public void removeTownBlockOfTypeForSale(TownBlockType type) {
        this.forSaleCache.merge(type, -1, Integer::sum);
    }

    public void addTownBlockOfTypeForSale(TownBlockType type) {
        this.forSaleCache.merge(type, 1, Integer::sum);
    }

    public int getNumberOfResidentOwnedTownBlocks() {
        return this.residentOwnedCache.values().stream().mapToInt(d -> d).sum();
    }

    public void removeTownBlockOfTypeResidentOwned(TownBlock townBlock) {
        this.residentOwnedCache.merge(townBlock.getType(), -1, Integer::sum);
    }

    public void addTownBlockOfTypeResidentOwned(TownBlock townBlock) {
        this.residentOwnedCache.merge(townBlock.getType(), 1, Integer::sum);
    }

    public void removeTownBlockOfTypeResidentOwned(TownBlockType type) {
        this.residentOwnedCache.merge(type, -1, Integer::sum);
    }

    public void addTownBlockOfTypeResidentOwned(TownBlockType type) {
        this.residentOwnedCache.merge(type, 1, Integer::sum);
    }

    public static enum CacheType {
        ALL,
        FORSALE,
        RESIDENTOWNED;

    }
}

