/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.adventure.audience.Audience;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.BonusBlockPurchaseCostCalculationEvent;
import com.palmergames.bukkit.towny.event.NationAddTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.event.TownBlockClaimCostCalculationEvent;
import com.palmergames.bukkit.towny.event.town.TownAddAlliedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownAddEnemiedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownConqueredEvent;
import com.palmergames.bukkit.towny.event.town.TownMapColourLocalCalculationEvent;
import com.palmergames.bukkit.towny.event.town.TownMapColourNationalCalculationEvent;
import com.palmergames.bukkit.towny.event.town.TownMayorChangedEvent;
import com.palmergames.bukkit.towny.event.town.TownMayorChosenBySuccessionEvent;
import com.palmergames.bukkit.towny.event.town.TownRemoveAlliedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownRemoveEnemiedTownEvent;
import com.palmergames.bukkit.towny.event.town.TownUnconquerEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnPoint;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Town
extends Government
implements TownBlockOwner {
    private static final String ECONOMY_ACCOUNT_PREFIX = TownySettings.getTownAccountPrefix();
    private final List<Resident> residents = new ArrayList<Resident>();
    private final List<Resident> outlaws = new ArrayList<Resident>();
    private Map<UUID, Town> allies = new LinkedHashMap<UUID, Town>();
    private Map<UUID, Town> enemies = new LinkedHashMap<UUID, Town>();
    private final Set<Resident> trustedResidents = new HashSet<Resident>();
    private final Map<UUID, Town> trustedTowns = new LinkedHashMap<UUID, Town>();
    private List<Location> outpostSpawns = new ArrayList<Location>();
    private List<Jail> jails = null;
    private HashMap<String, PlotGroup> plotGroups = null;
    private TownBlockTypeCache plotTypeCache = new TownBlockTypeCache();
    private Resident mayor;
    private String founderName;
    private int bonusBlocks = 0;
    private int purchasedBlocks = 0;
    private double plotTax = TownySettings.getTownDefaultPlotTax();
    private double commercialPlotTax = TownySettings.getTownDefaultShopTax();
    private double plotPrice = 0.0;
    private double embassyPlotTax = TownySettings.getTownDefaultEmbassyTax();
    private double maxPercentTaxAmount = TownySettings.getMaxTownTaxPercentAmount();
    private double commercialPlotPrice;
    private double embassyPlotPrice;
    private double debtBalance = 0.0;
    private Nation nation;
    private boolean hasUpkeep = true;
    private boolean hasUnlimitedClaims = false;
    private boolean isTaxPercentage = TownySettings.getTownDefaultTaxPercentage();
    private TownBlock homeBlock;
    private TownyWorld world;
    private boolean adminEnabledMobs = false;
    private boolean adminDisabledPVP = false;
    private boolean adminEnabledPVP = false;
    private boolean allowedToWar = TownySettings.getTownDefaultAllowedToWar();
    private boolean isConquered = false;
    private int conqueredDays;
    private int nationZoneOverride = 0;
    private boolean nationZoneEnabled = true;
    private final ConcurrentHashMap<WorldCoord, TownBlock> townBlocks = new ConcurrentHashMap();
    private final TownyPermission permissions = new TownyPermission();
    private boolean ruined = false;
    private long ruinedTime;
    private long joinedNationAt;
    private long movedHomeBlockAt;
    private Jail primaryJail;
    private int manualTownLevel = -1;
    private boolean residentsSorted = false;

    public Town(String name) {
        super(name);
        this.permissions.loadDefault(this);
        this.setTaxes(TownySettings.getTownDefaultTax());
        this.setOpen(TownySettings.getTownDefaultOpen());
        this.setBoard(TownySettings.getTownDefaultBoard());
        this.setNeutral(TownySettings.getTownDefaultNeutral());
        this.setPublic(TownySettings.getTownDefaultPublic());
    }

    public Town(String name, UUID uuid) {
        this(name);
        this.setUUID(uuid);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks.values());
    }

    public int getNumTownBlocks() {
        return this.getTownBlocks().size();
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.hasTownBlock(townBlock.getWorldCoord());
    }

    public boolean hasTownBlock(WorldCoord worldCoord) {
        return this.townBlocks.containsKey(worldCoord);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.put(townBlock.getWorldCoord(), townBlock);
        if (this.townBlocks.size() < 2 && !this.hasHomeBlock()) {
            this.setHomeBlock(townBlock);
        }
        this.getTownBlockTypeCache().addTownBlockOfType(townBlock.getType());
    }

    public TownBlock getTownBlock(WorldCoord worldCoord) {
        if (this.hasTownBlock(worldCoord)) {
            return this.townBlocks.get(worldCoord);
        }
        return null;
    }

    public ConcurrentMap<WorldCoord, TownBlock> getTownBlockMap() {
        return this.townBlocks;
    }

    public TownBlockTypeCache getTownBlockTypeCache() {
        return this.plotTypeCache;
    }

    public Resident getMayor() {
        return this.mayor;
    }

    @Override
    public void setTaxes(double taxes) {
        this.taxes = Math.min(taxes, this.isTaxPercentage ? TownySettings.getMaxTownTaxPercent() : TownySettings.getMaxTownTax());
        if (this.taxes < 0.0) {
            this.taxes = TownySettings.getTownDefaultTax();
        }
    }

    public void forceSetMayor(Resident mayor) throws TownyException {
        if (!this.hasResident(mayor)) {
            throw new TownyException(Translation.of("msg_err_mayor_doesnt_belong_to_town"));
        }
        this.setMayor(mayor, false);
    }

    public void setMayor(Resident mayor) {
        this.setMayor(mayor, true);
    }

    public void setMayor(Resident mayor, boolean callEvent) {
        if (!this.hasResident(mayor)) {
            return;
        }
        if (callEvent) {
            BukkitTools.fireEvent(new TownMayorChangedEvent(this.mayor, mayor));
        }
        this.mayor = mayor;
        TownyPerms.assignPermissions(mayor, null);
    }

    public String getFounder() {
        return this.founderName != null ? this.founderName : (this.getMayor() != null ? this.getMayor().getName() : "None");
    }

    public void setFounder(String founderName) {
        this.founderName = founderName;
    }

    public Nation getNation() throws NotRegisteredException {
        if (this.hasNation()) {
            return this.nation;
        }
        throw new NotRegisteredException(Translation.of("msg_err_town_doesnt_belong_to_any_nation"));
    }

    @Nullable
    public Nation getNationOrNull() {
        return this.nation;
    }

    public void removeNation() {
        if (!this.hasNation()) {
            return;
        }
        Nation oldNation = this.nation;
        for (Resident res : this.getResidents()) {
            if (res.hasTitle() || res.hasSurname()) {
                res.setTitle("");
                res.setSurname("");
            }
            res.updatePermsForNationRemoval();
            res.save();
        }
        try {
            oldNation.removeTown(this);
        }
        catch (EmptyNationException e) {
            TownyUniverse.getInstance().getDataSource().removeNation(oldNation);
            TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", e.getNation().getName()));
        }
        try {
            this.setNation(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.isConquered = false;
        this.conqueredDays = 0;
        this.setJoinedNationAt(0L);
        this.save();
        BukkitTools.fireEvent(new NationRemoveTownEvent(this, oldNation));
    }

    public void setNation(Nation nation) throws AlreadyRegisteredException {
        this.setNation(nation, true);
    }

    public void setNation(Nation nation, boolean updateJoinedAt) throws AlreadyRegisteredException {
        if (this.nation == nation) {
            return;
        }
        if (nation == null) {
            this.nation = null;
            return;
        }
        if (this.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.nation = nation;
        nation.addTown(this);
        if (updateJoinedAt) {
            this.setJoinedNationAt(System.currentTimeMillis());
        }
        TownyPerms.updateTownPerms(this);
        BukkitTools.fireEvent(new NationAddTownEvent(this, nation));
    }

    public List<Resident> getResidents() {
        if (!this.residentsSorted) {
            this.sortResidents();
        }
        return Collections.unmodifiableList(this.residents);
    }

    public List<Resident> getRank(String rank) {
        ArrayList<Resident> residentsWithRank = new ArrayList<Resident>();
        for (Resident resident : this.getResidents()) {
            if (!resident.hasTownRank(rank)) continue;
            residentsWithRank.add(resident);
        }
        return Collections.unmodifiableList(residentsWithRank);
    }

    @Override
    public boolean hasResident(String name) {
        for (Resident resident : this.residents) {
            if (!resident.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResident(Resident resident) {
        return this.residents.contains(resident);
    }

    public boolean hasResident(Player player) {
        return this.hasResident(player.getUniqueId());
    }

    public boolean hasResident(UUID uuid) {
        Resident resident = TownyAPI.getInstance().getResident(uuid);
        return resident != null && this.hasResident(resident);
    }

    public boolean hasResidentWithRank(Resident resident, String rank) {
        return this.hasResident(resident) && resident.hasTownRank(rank);
    }

    void addResident(Resident resident) {
        this.residents.add(resident);
    }

    public void addResidentCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasResident(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), this.getFormattedName()));
        }
        Town residentTown = resident.getTownOrNull();
        if (residentTown != null && !this.equals(residentTown)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), residentTown.getFormattedName()));
        }
    }

    public boolean isMayor(Resident resident) {
        return resident == this.mayor;
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public boolean isCapital() {
        return this.hasNation() && this.nation.isCapital(this);
    }

    public void setHasUpkeep(boolean hasUpkeep) {
        this.hasUpkeep = hasUpkeep;
    }

    public boolean hasUpkeep() {
        return this.hasUpkeep;
    }

    public boolean hasUnlimitedClaims() {
        return TownySettings.areTownBlocksUnlimited() || this.hasUnlimitedClaims;
    }

    public void setHasUnlimitedClaims(boolean hasUnlimitedClaims) {
        this.hasUnlimitedClaims = hasUnlimitedClaims;
    }

    public void setHasMobs(boolean hasMobs) {
        this.permissions.mobs = hasMobs;
    }

    public boolean hasMobs() {
        return this.permissions.mobs;
    }

    public void setAdminEnabledMobs(boolean isMobsForced) {
        this.adminEnabledMobs = isMobsForced;
    }

    public boolean isAdminEnabledMobs() {
        return this.adminEnabledMobs;
    }

    public void setPVP(boolean isPVP) {
        this.permissions.pvp = isPVP;
    }

    public void setAdminDisabledPVP(boolean isPVPDisabled) {
        this.adminDisabledPVP = isPVPDisabled;
    }

    public void setAdminEnabledPVP(boolean isPVPEnabled) {
        this.adminEnabledPVP = isPVPEnabled;
    }

    public boolean isPVP() {
        if (this.isAdminEnabledPVP()) {
            return true;
        }
        if (this.isAdminDisabledPVP()) {
            return false;
        }
        return this.permissions.pvp;
    }

    public boolean isAdminDisabledPVP() {
        return this.adminDisabledPVP;
    }

    public boolean isAdminEnabledPVP() {
        return this.adminEnabledPVP;
    }

    public boolean isAllowedToWar() {
        return this.allowedToWar;
    }

    public void setAllowedToWar(boolean allowedToWar) {
        this.allowedToWar = allowedToWar;
    }

    @Deprecated
    public void setBANG(boolean isBANG) {
        this.setExplosion(isBANG);
    }

    @Deprecated
    public boolean isBANG() {
        return this.isExplosion();
    }

    public void setExplosion(boolean isExplosion) {
        this.permissions.explosion = isExplosion;
    }

    public boolean isExplosion() {
        return this.permissions.explosion;
    }

    public void setTaxPercentage(boolean isPercentage) {
        this.isTaxPercentage = isPercentage;
        if (isPercentage && this.getTaxes() > 100.0) {
            this.setTaxes(0.0);
        }
    }

    public boolean isTaxPercentage() {
        return this.isTaxPercentage;
    }

    public void setFire(boolean isFire) {
        this.permissions.fire = isFire;
    }

    public boolean isFire() {
        return this.permissions.fire;
    }

    public void setBonusBlocks(int bonusBlocks) {
        this.bonusBlocks = bonusBlocks;
    }

    public String getMaxTownBlocksAsAString() {
        if (this.hasUnlimitedClaims()) {
            return "\u221e";
        }
        return String.valueOf(this.getMaxTownBlocks());
    }

    public int getMaxTownBlocks() {
        return TownySettings.getMaxTownBlocks(this);
    }

    public int getBonusBlocks() {
        return this.bonusBlocks;
    }

    public double getBonusBlockCost() {
        double price = Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), this.getPurchasedBlocks()) * TownySettings.getPurchasedBonusBlocksCost();
        double maxprice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        BonusBlockPurchaseCostCalculationEvent event = new BonusBlockPurchaseCostCalculationEvent(this, maxprice == -1.0 ? price : Math.min(price, maxprice), 1);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public double getTownBlockCost() {
        double price = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), this.getTownBlocks().size()) * TownySettings.getClaimPrice());
        double maxprice = TownySettings.getMaxClaimPrice();
        TownBlockClaimCostCalculationEvent event = new TownBlockClaimCostCalculationEvent(this, maxprice == -1.0 ? price : Math.min(price, maxprice), 1);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public double getTownBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        if (inputN == 0) {
            return inputN;
        }
        double nextprice = this.getTownBlockCost();
        double cost = nextprice;
        boolean hasmaxprice = TownySettings.getMaxClaimPrice() != -1.0;
        double maxprice = TownySettings.getMaxClaimPrice();
        for (int i = 1; i < inputN; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), (double)this.getTownBlocks().size() + (double)i) * TownySettings.getClaimPrice());
            if (hasmaxprice && nextprice > maxprice) {
                cost += maxprice * (double)(inputN - i);
                break;
            }
            cost += nextprice;
        }
        TownBlockClaimCostCalculationEvent event = new TownBlockClaimCostCalculationEvent(this, Math.round(cost), inputN);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public double getBonusBlockCostN(int n) throws TownyException {
        if (n < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        double cost = MoneyUtil.returnPurchasedBlocksCost(this.getPurchasedBlocks(), n, this);
        BonusBlockPurchaseCostCalculationEvent event = new BonusBlockPurchaseCostCalculationEvent(this, cost, n);
        BukkitTools.fireEvent(event);
        return event.getPrice();
    }

    public void addBonusBlocks(int bonusBlocks) {
        this.bonusBlocks += bonusBlocks;
    }

    public void setPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks = purchasedBlocks;
    }

    public int getPurchasedBlocks() {
        return this.purchasedBlocks;
    }

    public void addPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks += purchasedBlocks;
    }

    public void setHomeBlock(@Nullable TownBlock homeBlock) {
        this.homeBlock = homeBlock;
        if (homeBlock == null) {
            return;
        }
        if (this.world == null || !this.getHomeblockWorld().getName().equals(homeBlock.getWorld().getName())) {
            this.setWorld(homeBlock.getWorld());
        }
        if (this.spawn != null && !homeBlock.getWorldCoord().equals(Coord.parseCoord(this.spawn))) {
            TownyUniverse.getInstance().removeSpawnPoint(this.spawn);
            this.spawn = null;
        }
        Nation townNation = TownyAPI.getInstance().getTownNationOrNull(this);
        if (this.hasNation() && townNation != null && !townNation.getCapital().equals(this) && TownySettings.getNationRequiresProximity() > 0.0 && townNation.getCapital().hasHomeBlock() && this.hasHomeBlock()) {
            int y2;
            int y1;
            int x2;
            int x1;
            double distance;
            WorldCoord capitalCoord = townNation.getCapital().getHomeBlockOrNull().getWorldCoord();
            WorldCoord townCoord = this.getHomeBlockOrNull().getWorldCoord();
            if (!townNation.getCapital().getHomeblockWorld().equals(this.getHomeblockWorld())) {
                TownyMessaging.sendNationMessagePrefixed(townNation, Translatable.of("msg_nation_town_moved_their_homeblock_too_far", this.getName()));
                this.removeNation();
            }
            if ((distance = MathUtil.distance(x1 = capitalCoord.getX(), x2 = townCoord.getX(), y1 = capitalCoord.getZ(), y2 = townCoord.getZ())) > TownySettings.getNationRequiresProximity()) {
                TownyMessaging.sendNationMessagePrefixed(townNation, Translatable.of("msg_nation_town_moved_their_homeblock_too_far", this.getName()));
                this.removeNation();
            }
        }
    }

    public void forceSetHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            TownyMessaging.sendErrorMsg("town.forceSetHomeblock() is returning null.");
            return;
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            this.setWorld(homeBlock.getWorld());
        }
    }

    public TownBlock getHomeBlock() throws TownyException {
        if (this.hasHomeBlock()) {
            return this.homeBlock;
        }
        throw new TownyException(this.getName() + " has not set a home block.");
    }

    @Nullable
    public TownBlock getHomeBlockOrNull() {
        return this.homeBlock;
    }

    public void setWorld(TownyWorld world) {
        if (world == null) {
            this.world = null;
            return;
        }
        if (this.world == world) {
            return;
        }
        if (this.hasWorld()) {
            try {
                world.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.world = world;
        this.world.addTown(this);
    }

    public TownyWorld getHomeblockWorld() {
        if (this.world != null) {
            return this.world;
        }
        if (this.homeBlock != null) {
            return this.homeBlock.getWorld();
        }
        return TownyUniverse.getInstance().getTownyWorlds().get(0);
    }

    public boolean hasMayor() {
        return this.mayor != null;
    }

    public void removeResident(Resident resident) throws EmptyTownException, NotRegisteredException {
        if (!this.hasResident(resident)) {
            throw new NotRegisteredException();
        }
        this.remove(resident);
        resident.setJoinedTownAt(0L);
        if (this.getNumResidents() == 0) {
            throw new EmptyTownException(this);
        }
    }

    private void remove(Resident resident) {
        if (this.isMayor(resident) && this.residents.size() > 1) {
            this.findNewMayor();
            this.save();
        }
        this.residents.remove(resident);
    }

    public void findNewMayor() {
        for (String rank : TownySettings.getOrderOfMayoralSuccession()) {
            if (!this.findNewMayor(this.getRank(rank))) continue;
            return;
        }
        this.findNewMayor((List<Resident>)this.getResidents());
    }

    private boolean findNewMayor(List<Resident> potentialResidents) {
        for (Resident newMayor : potentialResidents) {
            if (newMayor.equals(this.mayor)) continue;
            TownMayorChosenBySuccessionEvent tmcbse = new TownMayorChosenBySuccessionEvent(this.mayor, newMayor, potentialResidents);
            this.setMayor(tmcbse.getNewMayor());
            return true;
        }
        return false;
    }

    @Override
    public void setSpawn(Location spawn) {
        this.spawn = spawn;
        if (spawn != null) {
            TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.TOWN_SPAWN));
        }
    }

    @Override
    public Location getSpawn() throws TownyException {
        if (this.hasHomeBlock() && this.spawn != null) {
            return this.spawn;
        }
        this.spawn = null;
        throw new TownyException(Translation.of("msg_err_town_has_not_set_a_spawn_location"));
    }

    @Override
    @Nullable
    public Location getSpawnOrNull() {
        return this.spawn;
    }

    public boolean hasHomeBlock() {
        return this.homeBlock != null;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        if (this.hasTownBlock(townBlock)) {
            if (townBlock.isOutpost() || this.isAnOutpost(townBlock.getCoord())) {
                this.removeOutpostSpawn(townBlock.getCoord());
                townBlock.setOutpost(false);
                townBlock.save();
            }
            if (townBlock.isJail()) {
                this.removeJail(townBlock.getJail());
            }
            try {
                if (this.getHomeBlock() == townBlock) {
                    this.setHomeBlock(null);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            Nation testNation = this.getNationOrNull();
            try {
                if (this.hasNation() && testNation != null && testNation.hasSpawn() && townBlock.getWorldCoord().equals(WorldCoord.parseWorldCoord(testNation.getSpawn()))) {
                    testNation.setSpawn(null);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            this.townBlocks.remove(townBlock.getWorldCoord());
            this.getTownBlockTypeCache().removeTownBlockOfType(townBlock.getType());
            if (townBlock.isForSale()) {
                this.getTownBlockTypeCache().removeTownBlockOfTypeForSale(townBlock.getType());
            }
            if (townBlock.hasResident()) {
                this.getTownBlockTypeCache().removeTownBlockOfTypeResidentOwned(townBlock.getType());
            }
            this.save();
        }
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public void addOutpostSpawn(Location spawn) {
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(spawn);
        if (townBlock == null || !townBlock.hasTown() || !townBlock.getTownOrNull().equals(this)) {
            return;
        }
        this.removeOutpostSpawn(Coord.parseCoord(spawn));
        if (!townBlock.isOutpost()) {
            townBlock.setOutpost(true);
            townBlock.save();
        }
        this.outpostSpawns.add(spawn);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.OUTPOST_SPAWN));
        this.save();
    }

    public void forceAddOutpostSpawn(Location spawn) {
        this.outpostSpawns.add(spawn);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.OUTPOST_SPAWN));
    }

    public Location getOutpostSpawn(Integer index) throws TownyException {
        if (this.getMaxOutpostSpawn() == 0 && TownySettings.isOutpostsLimitedByLevels()) {
            throw new TownyException(Translation.of("msg_err_town_has_no_outpost_spawns_set"));
        }
        return this.outpostSpawns.get(Math.min(this.getMaxOutpostSpawn() - 1, Math.max(0, index - 1)));
    }

    public int getMaxOutpostSpawn() {
        return this.outpostSpawns.size();
    }

    public boolean hasOutpostSpawn() {
        return !this.outpostSpawns.isEmpty();
    }

    private boolean isAnOutpost(Coord coord) {
        return new ArrayList<Location>(this.outpostSpawns).stream().anyMatch(spawn -> Coord.parseCoord(spawn).equals(coord));
    }

    public List<Location> getAllOutpostSpawns() {
        return new ArrayList<Location>(this.outpostSpawns);
    }

    public void removeOutpostSpawn(Coord coord) {
        this.getAllOutpostSpawns().stream().filter(spawn -> Coord.parseCoord(spawn).equals(coord)).forEach(spawn -> {
            this.removeOutpostSpawn((Location)spawn);
            TownyUniverse.getInstance().removeSpawnPoint((Location)spawn);
        });
    }

    public void removeOutpostSpawn(Location loc) {
        this.outpostSpawns.remove(loc);
    }

    public void setPlotPrice(double plotPrice) {
        this.plotPrice = Math.min(plotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public double getPlotTypePrice(TownBlockType type) {
        double d;
        switch (type.getName().toLowerCase()) {
            case "shop": {
                d = this.getCommercialPlotPrice();
                break;
            }
            case "embassy": {
                d = this.getEmbassyPlotPrice();
                break;
            }
            default: {
                d = this.getPlotPrice();
            }
        }
        double plotPrice = d;
        return Math.max(plotPrice, 0.0);
    }

    public void setCommercialPlotPrice(double commercialPlotPrice) {
        this.commercialPlotPrice = Math.min(commercialPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getCommercialPlotPrice() {
        return this.commercialPlotPrice;
    }

    public void setEmbassyPlotPrice(double embassyPlotPrice) {
        this.embassyPlotPrice = Math.min(embassyPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getEmbassyPlotPrice() {
        return this.embassyPlotPrice;
    }

    public boolean isHomeBlock(TownBlock townBlock) {
        return this.hasHomeBlock() && townBlock == this.homeBlock;
    }

    public void setPlotTax(double plotTax) {
        this.plotTax = Math.min(plotTax, TownySettings.getMaxPlotTax());
    }

    public double getPlotTax() {
        return this.plotTax;
    }

    public void setCommercialPlotTax(double commercialTax) {
        this.commercialPlotTax = Math.min(commercialTax, TownySettings.getMaxPlotTax());
    }

    public double getCommercialPlotTax() {
        return this.commercialPlotTax;
    }

    public void setEmbassyPlotTax(double embassyPlotTax) {
        this.embassyPlotTax = Math.min(embassyPlotTax, TownySettings.getMaxPlotTax());
    }

    public double getEmbassyPlotTax() {
        return this.embassyPlotTax;
    }

    public void collect(double amount) {
        if (TownyEconomyHandler.isActive()) {
            double bankcap = this.getBankCap();
            if (bankcap > 0.0 && amount + this.getAccount().getHoldingBalance() > bankcap) {
                TownyMessaging.sendPrefixedTownMessage(this, Translatable.of("msg_err_deposit_capped", bankcap));
                return;
            }
            this.getAccount().deposit(amount, null);
        }
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Town (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Mayor: " + (this.hasMayor() ? this.getMayor().getName() : "None"));
        out.add(this.getTreeDepth(depth + 1) + "Home: " + this.homeBlock);
        out.add(this.getTreeDepth(depth + 1) + "Bonus: " + this.bonusBlocks);
        out.add(this.getTreeDepth(depth + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        List<Resident> assistants = this.getRank("assistant");
        if (!assistants.isEmpty()) {
            out.add(this.getTreeDepth(depth + 1) + "Assistants (" + assistants.size() + "): " + Arrays.toString(assistants.toArray(new Resident[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + this.getResidents().size() + "):");
        for (Resident resident : this.getResidents()) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    @Override
    public Collection<Resident> getOutlaws() {
        return Collections.unmodifiableList(this.outlaws);
    }

    public boolean hasOutlaw(String name) {
        return this.outlaws.stream().anyMatch(outlaw -> outlaw.getName().equalsIgnoreCase(name));
    }

    public boolean hasOutlaw(Resident outlaw) {
        return this.outlaws.contains(outlaw);
    }

    public void addOutlaw(Resident resident) throws AlreadyRegisteredException {
        this.addOutlawCheck(resident);
        this.outlaws.add(resident);
    }

    public void addOutlawCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasOutlaw(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_resident_already_an_outlaw"));
        }
        Town residentTown = resident.getTownOrNull();
        if (this.equals(residentTown)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_not_outlaw_in_your_town"));
        }
    }

    public void removeOutlaw(Resident resident) {
        if (this.hasOutlaw(resident)) {
            this.outlaws.remove(resident);
        }
    }

    public void loadOutlaws(List<Resident> outlaws) {
        outlaws.stream().forEach(o -> {
            try {
                this.addOutlaw((Resident)o);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
        });
    }

    public boolean hasValidUUID() {
        return this.uuid != null;
    }

    public void setOutpostSpawns(List<Location> outpostSpawns) {
        this.outpostSpawns = outpostSpawns;
    }

    public boolean isAlliedWith(Town othertown) {
        return CombatUtil.isAlly(this, othertown);
    }

    public int getOutpostLimit() {
        return TownySettings.getMaxOutposts(this);
    }

    public boolean isOverOutpostLimit() {
        return TownySettings.isOutpostsLimitedByLevels() && this.getMaxOutpostSpawn() > this.getOutpostLimit();
    }

    public boolean isOverClaimed() {
        return !this.hasUnlimitedClaims() && this.getTownBlocks().size() > this.getMaxTownBlocks();
    }

    public int availableTownBlocks() {
        return this.getMaxTownBlocks() - this.getTownBlocks().size();
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    public void setConquered(boolean conquered) {
        this.setConquered(conquered, true);
    }

    public void setConquered(boolean conquered, boolean callEvent) {
        if (conquered == this.isConquered) {
            return;
        }
        this.isConquered = conquered;
        if (!callEvent) {
            return;
        }
        if (this.isConquered) {
            BukkitTools.fireEvent(new TownConqueredEvent(this));
        } else {
            BukkitTools.fireEvent(new TownUnconquerEvent(this));
        }
    }

    public boolean isConquered() {
        return this.isConquered;
    }

    public void setConqueredDays(int conqueredDays) {
        this.conqueredDays = conqueredDays;
    }

    public int getConqueredDays() {
        return this.conqueredDays;
    }

    public void addJail(Jail jail) {
        if (!this.hasJails()) {
            this.jails = new ArrayList<Jail>(1);
        }
        this.jails.add(jail);
    }

    public void removeJail(Jail jail) {
        if (this.hasJails() && this.hasJail(jail)) {
            this.jails.remove(jail);
        }
        if (this.getPrimaryJail() != null && this.getPrimaryJail().getUUID().equals(jail.getUUID())) {
            this.setPrimaryJail(null);
        }
    }

    public boolean hasJails() {
        return this.jails != null;
    }

    public boolean hasJail(Jail jail) {
        return this.jails.contains(jail);
    }

    @Nullable
    public Collection<Jail> getJails() {
        if (!this.hasJails()) {
            return null;
        }
        return Collections.unmodifiableCollection(this.jails);
    }

    @Nullable
    public Jail getJail(int i) {
        if (!this.hasJails() || this.jails.size() < i) {
            return null;
        }
        return this.jails.get(--i);
    }

    public void setPrimaryJail(Jail jail) {
        this.primaryJail = jail;
    }

    @Nullable
    public Jail getPrimaryJail() {
        if (this.primaryJail == null && this.hasJails()) {
            return this.getJail(1);
        }
        return this.primaryJail;
    }

    public int getJailedPlayerCount() {
        return this.getJailedResidents().size();
    }

    public List<Resident> getJailedResidents() {
        return Collections.unmodifiableList(new ArrayList<Resident>(TownyUniverse.getInstance().getJailedResidentMap()).stream().filter(res -> res.hasJailTown(this.getName())).collect(Collectors.toList()));
    }

    public void renamePlotGroup(String oldName, PlotGroup group) {
        this.plotGroups.remove(oldName);
        this.plotGroups.put(group.getName(), group);
    }

    public void addPlotGroup(PlotGroup group) {
        if (!this.hasPlotGroups()) {
            this.plotGroups = new HashMap();
        }
        this.plotGroups.put(group.getName(), group);
    }

    public void removePlotGroup(PlotGroup plotGroup) {
        if (this.hasPlotGroups() && this.plotGroups.remove(plotGroup.getName()) != null) {
            for (TownBlock tb : new ArrayList<TownBlock>(plotGroup.getTownBlocks())) {
                if (!tb.hasPlotObjectGroup() || !tb.getPlotObjectGroup().getUUID().equals(plotGroup.getUUID())) continue;
                plotGroup.removeTownBlock(tb);
                tb.removePlotObjectGroup();
                tb.save();
            }
        }
    }

    public Collection<PlotGroup> getPlotGroups() {
        if (this.plotGroups == null || this.plotGroups.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.plotGroups.values());
    }

    public boolean hasPlotGroups() {
        return this.plotGroups != null;
    }

    public boolean hasPlotGroupName(String name) {
        return this.hasPlotGroups() && this.plotGroups.containsKey(name);
    }

    @Nullable
    public PlotGroup getPlotObjectGroupFromName(String name) {
        if (this.hasPlotGroups() && this.hasPlotGroupName(name)) {
            return this.plotGroups.get(name);
        }
        return null;
    }

    @Override
    public double getBankCap() {
        return TownySettings.getTownBankCap(this);
    }

    @Override
    public World getWorld() {
        return this.hasWorld() ? BukkitTools.getWorld(this.getHomeblockWorld().getName()) : BukkitTools.getWorlds().get(0);
    }

    @Override
    public String getBankAccountPrefix() {
        return ECONOMY_ACCOUNT_PREFIX;
    }

    @Override
    public String getFormattedName() {
        String prefix = this.isCapital() && !TownySettings.getCapitalPrefix(this).isEmpty() ? TownySettings.getCapitalPrefix(this) : TownySettings.getTownPrefix(this);
        String postfix = this.isCapital() && !TownySettings.getCapitalPostfix(this).isEmpty() ? TownySettings.getCapitalPostfix(this) : TownySettings.getTownPostfix(this);
        return prefix + this.getName().replace("_", " ") + postfix;
    }

    public String getPrefix() {
        return TownySettings.getTownPrefix(this);
    }

    public String getPostfix() {
        return TownySettings.getTownPostfix(this);
    }

    public double getMaxPercentTaxAmount() {
        return this.maxPercentTaxAmount;
    }

    public void setMaxPercentTaxAmount(double maxPercentTaxAmount) {
        this.maxPercentTaxAmount = Math.min(maxPercentTaxAmount, TownySettings.getMaxTownTaxPercentAmount());
    }

    public boolean isBankrupt() {
        return TownyEconomyHandler.isActive() && this.debtBalance > 0.0;
    }

    public double getDebtBalance() {
        return this.debtBalance;
    }

    public void setDebtBalance(double balance) {
        this.debtBalance = balance;
    }

    public boolean isRuined() {
        return this.ruined;
    }

    public void setRuined(boolean b) {
        this.ruined = b;
    }

    public void setRuinedTime(long time) {
        this.ruinedTime = time;
    }

    public long getRuinedTime() {
        return this.ruinedTime;
    }

    @Override
    @Nullable
    public String getMapColorHexCode() {
        String rawMapColorHexCode = super.getMapColorHexCode();
        TownMapColourLocalCalculationEvent event = new TownMapColourLocalCalculationEvent(this, rawMapColorHexCode);
        BukkitTools.fireEvent(event);
        return event.getMapColorHexCode();
    }

    @Nullable
    public String getNationMapColorHexCode() {
        String rawMapColorHexCode = this.hasNation() ? this.nation.getMapColorHexCode() : null;
        TownMapColourNationalCalculationEvent event = new TownMapColourNationalCalculationEvent(this, rawMapColorHexCode);
        BukkitTools.fireEvent(event);
        return event.getMapColorHexCode();
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveTown(this);
    }

    public void saveTownBlocks() {
        this.townBlocks.values().stream().forEach(tb -> tb.save());
    }

    public int getNationZoneOverride() {
        return this.nationZoneOverride;
    }

    public void setNationZoneOverride(int size) {
        this.nationZoneOverride = size;
    }

    public boolean hasNationZoneOverride() {
        return this.nationZoneOverride > 0;
    }

    public long getJoinedNationAt() {
        return this.joinedNationAt;
    }

    public void setJoinedNationAt(long joinedNationAt) {
        this.joinedNationAt = joinedNationAt;
    }

    public long getMovedHomeBlockAt() {
        return this.movedHomeBlockAt;
    }

    public void setMovedHomeBlockAt(long movedHomeBlockAt) {
        this.movedHomeBlockAt = movedHomeBlockAt;
    }

    private void sortResidents() {
        List sortedResidents = this.residents.stream().sorted(Comparator.comparingLong(Resident::getJoinedTownAt)).collect(Collectors.toList());
        this.residents.clear();
        this.residents.addAll(sortedResidents);
        this.residentsSorted = true;
    }

    public Set<Resident> getTrustedResidents() {
        return this.trustedResidents;
    }

    public boolean hasTrustedResident(Resident resident) {
        Town residentsTown = resident.getTownOrNull();
        return this.trustedResidents.contains(resident) || residentsTown != null && this.hasTrustedTown(residentsTown);
    }

    public void addTrustedResident(Resident resident) {
        this.trustedResidents.add(resident);
    }

    public void removeTrustedResident(Resident resident) {
        this.trustedResidents.remove(resident);
    }

    @Override
    public int getNationZoneSize() {
        if (!TownySettings.getNationZonesEnabled() || !this.hasNation()) {
            return 0;
        }
        if (!this.isCapital() && TownySettings.getNationZonesCapitalsOnly()) {
            return 0;
        }
        if (this.hasNationZoneOverride()) {
            return this.getNationZoneOverride();
        }
        return this.nation.getNationZoneSize() + (this.isCapital() ? TownySettings.getNationZonesCapitalBonusSize() : 0);
    }

    public void loadAllies(List<Town> towns) {
        for (Town town : towns) {
            this.allies.put(town.getUUID(), town);
        }
    }

    public void addAlly(Town town) {
        TownAddAlliedTownEvent taate = new TownAddAlliedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(taate)) {
            TownyMessaging.sendMsg(taate.getCancelMessage());
            return;
        }
        this.enemies.remove(town.getUUID());
        this.allies.put(town.getUUID(), town);
    }

    public void removeAlly(Town town) {
        TownRemoveAlliedTownEvent trate = new TownRemoveAlliedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(trate)) {
            TownyMessaging.sendMsg(trate.getCancelMessage());
            return;
        }
        this.allies.remove(town.getUUID());
    }

    public boolean removeAllAllies() {
        for (Town ally : new ArrayList<Town>(this.getAllies())) {
            this.removeAlly(ally);
            ally.removeAlly(this);
        }
        return this.getAllies().isEmpty();
    }

    public boolean hasAlly(Town town) {
        return this.allies.containsKey(town.getUUID());
    }

    public boolean hasMutualAlly(Town town) {
        return this.hasAlly(town) && town.hasAlly(this);
    }

    public void loadTrustedTowns(List<Town> towns) {
        for (Town trustTown : towns) {
            this.trustedTowns.put(trustTown.getUUID(), trustTown);
        }
    }

    public void addTrustedTown(Town town) {
        this.trustedTowns.put(town.getUUID(), town);
    }

    public void removeTrustedTown(Town town) {
        this.trustedTowns.remove(town.getUUID());
    }

    public boolean removeAllTrustedTowns() {
        for (Town trusted : new ArrayList<Town>(this.getTrustedTowns())) {
            this.removeTrustedTown(trusted);
        }
        return this.getTrustedTowns().isEmpty();
    }

    public boolean hasTrustedTown(Town town) {
        return this.trustedTowns.containsKey(town.getUUID());
    }

    public void loadEnemies(List<Town> towns) {
        for (Town town : towns) {
            this.enemies.put(town.getUUID(), town);
        }
    }

    public void addEnemy(Town town) {
        TownAddEnemiedTownEvent taete = new TownAddEnemiedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(taete)) {
            TownyMessaging.sendMsg(taete.getCancelMessage());
            return;
        }
        this.allies.remove(town.getUUID());
        this.enemies.put(town.getUUID(), town);
    }

    public void removeEnemy(Town town) {
        TownRemoveEnemiedTownEvent trete = new TownRemoveEnemiedTownEvent(this, town);
        if (BukkitTools.isEventCancelled(trete)) {
            TownyMessaging.sendMsg(trete.getCancelMessage());
            return;
        }
        this.enemies.remove(town.getUUID());
    }

    public boolean removeAllEnemies() {
        for (Town enemy : new ArrayList<Town>(this.getEnemies())) {
            this.removeEnemy(enemy);
            enemy.removeEnemy(this);
        }
        return this.getEnemies().isEmpty();
    }

    public boolean hasEnemy(Town town) {
        return this.enemies.containsKey(town.getUUID());
    }

    public List<Town> getEnemies() {
        return Collections.unmodifiableList(this.enemies.values().stream().collect(Collectors.toList()));
    }

    public List<Town> getAllies() {
        return Collections.unmodifiableList(this.allies.values().stream().collect(Collectors.toList()));
    }

    public List<Town> getTrustedTowns() {
        return Collections.unmodifiableList(this.trustedTowns.values().stream().collect(Collectors.toList()));
    }

    public List<Town> getMutualAllies() {
        ArrayList<Town> result = new ArrayList<Town>();
        for (Town ally : this.getAllies()) {
            if (!ally.hasAlly(this)) continue;
            result.add(ally);
        }
        return result;
    }

    public List<UUID> getAlliesUUIDs() {
        return Collections.unmodifiableList(this.allies.keySet().stream().collect(Collectors.toList()));
    }

    public List<UUID> getEnemiesUUIDs() {
        return Collections.unmodifiableList(this.enemies.keySet().stream().collect(Collectors.toList()));
    }

    public List<UUID> getTrustedTownsUUIDS() {
        return Collections.unmodifiableList(this.trustedTowns.keySet().stream().collect(Collectors.toList()));
    }

    public boolean isNationZoneEnabled() {
        return this.nationZoneEnabled;
    }

    public void setNationZoneEnabled(boolean nationZoneEnabled) {
        this.nationZoneEnabled = nationZoneEnabled;
    }

    public boolean isInsideTown(@NotNull Location location) {
        return this.equals(WorldCoord.parseWorldCoord(location).getTownOrNull());
    }

    @Override
    public boolean isNeutral() {
        return (!TownySettings.nationCapitalsCantBeNeutral() || !this.isCapital()) && this.isNeutral;
    }

    public int getLevel() {
        return this.getLevel(this.getNumResidents());
    }

    public int getLevel(int populationSize) {
        if (this.isRuined()) {
            return 0;
        }
        int key = 0;
        for (int populationLevel : TownySettings.getConfigTownLevel().keySet()) {
            if (this.getManualTownLevel() > -1 && ++key == this.getMaxLevel() - this.getManualTownLevel()) {
                return populationLevel;
            }
            if (this.getManualTownLevel() != -1 || populationSize < populationLevel) continue;
            return populationLevel;
        }
        return 0;
    }

    public int getMaxLevel() {
        return TownySettings.getConfigTownLevel().size();
    }

    public int getLevelID() {
        if (this.isRuined()) {
            return 0;
        }
        if (this.getManualTownLevel() > -1) {
            return this.getManualTownLevel();
        }
        int townLevelId = -1;
        for (Integer level : TownySettings.getConfigTownLevel().keySet()) {
            if (level > this.getNumResidents()) continue;
            ++townLevelId;
        }
        return townLevelId;
    }

    public int getManualTownLevel() {
        return this.manualTownLevel;
    }

    public void setManualTownLevel(int manualTownLevel) {
        this.manualTownLevel = manualTownLevel;
    }

    public int getTownBlockTypeLimit(TownBlockType type) {
        if (!TownySettings.areLevelTypeLimitsConfigured()) {
            return -1;
        }
        return TownySettings.getTownLevel(this).townBlockTypeLimits().getOrDefault(type.getName().toLowerCase(Locale.ROOT), -1);
    }

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return TownyAPI.getInstance().getOnlinePlayers(this).stream().map(player -> Towny.getAdventure().player((Player)player)).collect(Collectors.toSet());
    }
}

