/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class Coord {
    private static final int cellSize = TownySettings.getTownBlockSize();
    private final int x;
    private final int z;

    public Coord(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public Coord(Coord coord) {
        this.x = coord.getX();
        this.z = coord.getZ();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Coord add(int xOffset, int zOffset) {
        return new Coord(this.getX() + xOffset, this.getZ() + zOffset);
    }

    public int hashCode() {
        int result = 17;
        result = 27 * result + this.x;
        result = 27 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Coord)) {
            return false;
        }
        Coord o = (Coord)obj;
        return this.x == o.x && this.z == o.z;
    }

    protected static int toCell(int value) {
        return Math.floorDiv(value, Coord.getCellSize());
    }

    public static Coord parseCoord(int x, int z) {
        return new Coord(Coord.toCell(x), Coord.toCell(z));
    }

    public static Coord parseCoord(Entity entity) {
        return Coord.parseCoord(entity.getLocation());
    }

    public static Coord parseCoord(Location loc) {
        return Coord.parseCoord(loc.getBlockX(), loc.getBlockZ());
    }

    public static Coord parseCoord(Block block) {
        return Coord.parseCoord(block.getX(), block.getZ());
    }

    public String toString() {
        return this.getX() + ", " + this.getZ();
    }

    public static int getCellSize() {
        return cellSize;
    }
}

