/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.util.StringMgmt;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonCommand
extends Command {
    private TownyCommandAddonAPI.CommandType commandType;
    private String name;
    private CommandExecutor commandExecutor;
    private TabCompleter tabCompleter = new LegacyTabCompleter(this);
    private Map<Integer, List<String>> tabCompletions = new HashMap<Integer, List<String>>();

    public AddonCommand(TownyCommandAddonAPI.CommandType commandType, String name, CommandExecutor commandExecutor) {
        super(name);
        this.commandType = commandType;
        this.name = name;
        this.commandExecutor = commandExecutor;
        if (commandExecutor instanceof TabCompleter) {
            TabCompleter tabCompleter;
            this.tabCompleter = tabCompleter = (TabCompleter)commandExecutor;
        }
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        return this.execute(sender, args);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args) {
        return this.commandExecutor.onCommand(sender, (Command)this, this.name, StringMgmt.remFirstArg(args));
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String[] args, TownyObject object) {
        return this.commandExecutor.onCommand(sender, (Command)this, this.name, args);
    }

    public TownyCommandAddonAPI.CommandType getCommandType() {
        return this.commandType;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public TabCompleter getTabCompleter() {
        return this.tabCompleter;
    }

    public Map<Integer, List<String>> getTabCompletions() {
        return this.tabCompletions;
    }

    public void setCommandType(TownyCommandAddonAPI.CommandType commandType) {
        this.commandType = commandType;
    }

    public boolean setName(@NotNull String name) {
        this.name = name;
        return super.setName(name);
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        if (commandExecutor instanceof TabCompleter) {
            TabCompleter tabCompleter;
            this.tabCompleter = tabCompleter = (TabCompleter)commandExecutor;
        }
    }

    public void setTabCompleter(@Nullable TabCompleter tabCompleter) {
        this.tabCompleter = tabCompleter == null ? new LegacyTabCompleter(this) : tabCompleter;
    }

    public void setTabCompletions(Map<Integer, List<String>> tabCompletions) {
        this.tabCompletions = tabCompletions;
    }

    public void setTabCompletion(int index, List<String> completions) {
        this.tabCompletions.put(index, completions);
    }

    public List<String> getTabCompletion(CommandSender sender, String[] args) {
        return this.tabCompleter.onTabComplete(sender, (Command)this, this.name, StringMgmt.remFirstArg(args));
    }

    private static final class LegacyTabCompleter
    implements TabCompleter {
        private final AddonCommand command;

        private LegacyTabCompleter(AddonCommand command) {
            this.command = command;
        }

        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
            return this.command().tabCompletions.get(args.length - 2) == null ? Collections.emptyList() : (List)this.command().tabCompletions.get(args.length - 2);
        }

        public String toString() {
            return "LegacyTabCompleter[" + "command=" + (Object)((Object)this.command) + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.command != null ? ((Object)((Object)this.command)).hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals((Object)((LegacyTabCompleter)arg0).command, (Object)this.command);
            {
            }
        }

        public AddonCommand command() {
            return this.command;
        }
    }
}

