/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegistryList<T extends Keyed> {
    private final Registry<T> registry;
    protected final Set<T> tagged = new HashSet<T>();

    public AbstractRegistryList(@NotNull Registry<T> registry, @NotNull Collection<T> collection) {
        this.registry = registry;
        this.tagged.addAll(collection);
    }

    public boolean contains(@NotNull T element) {
        return this.tagged.contains(element);
    }

    public boolean contains(@NotNull NamespacedKey key) {
        Keyed element = this.registry.get(key);
        return element != null && this.contains(element);
    }

    public boolean contains(@NotNull String element) {
        if (element.isEmpty()) {
            return false;
        }
        T matched = BukkitTools.matchRegistry(this.registry, element);
        return matched != null && this.contains(matched);
    }

    public static class Builder<T extends Keyed, F extends AbstractRegistryList<T>> {
        private final Registry<T> registry;
        private final Class<T> clazz;
        private final Function<Collection<T>, F> convertFunction;
        private final Set<Predicate<NamespacedKey>> allMatchPredicates = new HashSet<Predicate<NamespacedKey>>();
        private final Set<Predicate<NamespacedKey>> anyMatchPredicates = new HashSet<Predicate<NamespacedKey>>();
        @Nullable
        private Set<T> exceptions;

        public Builder(Registry<T> registry, Class<T> clazz, Function<Collection<T>, F> function) {
            this.registry = registry;
            this.clazz = clazz;
            this.convertFunction = function;
        }

        public F build() {
            HashSet<Object> matches = new HashSet<Object>();
            if (!this.allMatchPredicates.isEmpty() || !this.anyMatchPredicates.isEmpty()) {
                for (Keyed element : this.registry) {
                    if (!this.allMatchPredicates.stream().allMatch(predicate -> predicate.test(element.getKey())) || !this.anyMatchPredicates.stream().anyMatch(predicate -> predicate.test(element.getKey()))) continue;
                    matches.add(element);
                }
            }
            if (this.exceptions != null) {
                matches.addAll(this.exceptions);
            }
            return (F)((AbstractRegistryList)this.convertFunction.apply(matches));
        }

        public Builder<T, F> startsWith(String startingWith) {
            this.anyMatchPredicates.add(s -> s.getKey().regionMatches(true, 0, startingWith, 0, startingWith.length()));
            return this;
        }

        public Builder<T, F> endsWith(@NotNull String endingWith) {
            this.anyMatchPredicates.add(s -> s.getKey().toLowerCase(Locale.ROOT).endsWith(endingWith.toLowerCase(Locale.ROOT)));
            return this;
        }

        public Builder<T, F> not(@NotNull String name) {
            this.allMatchPredicates.add(s -> !s.getKey().toLowerCase(Locale.ROOT).equals(name.toLowerCase(Locale.ROOT)));
            return this;
        }

        public Builder<T, F> notStartsWith(@NotNull String notStartingWith) {
            this.allMatchPredicates.add(s -> !s.getKey().regionMatches(true, 0, notStartingWith, 0, notStartingWith.length()));
            return this;
        }

        public Builder<T, F> notEndsWith(@NotNull String notEndingWith) {
            this.allMatchPredicates.add(s -> !s.getKey().toLowerCase(Locale.ROOT).endsWith(notEndingWith.toLowerCase(Locale.ROOT)));
            return this;
        }

        public Builder<T, F> contains(@NotNull String containing) {
            this.allMatchPredicates.add(s -> s.getKey().toLowerCase(Locale.ROOT).contains(containing.toLowerCase(Locale.ROOT)));
            return this;
        }

        public Builder<T, F> notContains(@NotNull String notContaining) {
            this.allMatchPredicates.add(s -> !s.getKey().toLowerCase(Locale.ROOT).contains(notContaining.toLowerCase(Locale.ROOT)));
            return this;
        }

        public Builder<T, F> withTag(@NotNull String registry, @NotNull NamespacedKey key) {
            Tag tag = Bukkit.getServer().getTag(registry, key, this.clazz);
            if (tag != null) {
                this.anyMatchPredicates.add(s -> {
                    Keyed exact = this.registry.get(s);
                    return exact != null && tag.isTagged(exact);
                });
            }
            return this;
        }

        public Builder<T, F> excludeTag(@NotNull String registry, @NotNull NamespacedKey key) {
            Tag tag = Bukkit.getServer().getTag(registry, key, this.clazz);
            if (tag != null) {
                this.allMatchPredicates.add(s -> {
                    Keyed exact = this.registry.get(s);
                    return exact == null || !tag.isTagged(exact);
                });
            }
            return this;
        }

        public Builder<T, F> add(String ... names) {
            if (this.exceptions == null) {
                this.exceptions = new HashSet<T>();
            }
            for (String name : names) {
                if (name.isEmpty()) continue;
                T match = BukkitTools.matchRegistry(this.registry, name);
                if (match != null) {
                    this.exceptions.add(match);
                    continue;
                }
                TownyMessaging.sendDebugMsg("Expected element with name '" + name + "' was not found in the " + this.clazz.getSimpleName() + " registry.");
            }
            return this;
        }
    }
}

