/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.BedExplodeEvent;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.PlayerEnterTownEvent;
import com.palmergames.bukkit.towny.event.PlayerLeaveTownEvent;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.event.player.PlayerDeniedBedUseEvent;
import com.palmergames.bukkit.towny.event.player.PlayerEntersIntoTownBorderEvent;
import com.palmergames.bukkit.towny.event.player.PlayerExitsFromTownBorderEvent;
import com.palmergames.bukkit.towny.event.player.PlayerKeepsExperienceEvent;
import com.palmergames.bukkit.towny.event.player.PlayerKeepsInventoryEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.listeners.TownyPaperEvents;
import com.palmergames.bukkit.towny.object.CommandList;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.MinecraftVersion;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.EntityLists;
import com.palmergames.bukkit.util.ItemLists;
import com.palmergames.paperlib.PaperLib;
import com.palmergames.util.StringMgmt;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class TownyPlayerListener
implements Listener {
    private final Towny plugin;
    private CommandList blockedJailCommands;
    private CommandList blockedTownCommands;
    private CommandList blockedTouristCommands;
    private CommandList blockedOutlawCommands;
    private CommandList blockedWarCommands;
    private CommandList ownPlotLimitedCommands;
    private static final MethodHandle GET_RESPAWN_FLAGS;

    public TownyPlayerListener(Towny plugin) {
        this.plugin = plugin;
        this.loadBlockedCommandLists();
        TownySettings.addReloadListener(NamespacedKey.fromString((String)"blocked-commands", (Plugin)plugin), config -> this.loadBlockedCommandLists());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            return;
        }
        if (player.getName().contains(" ")) {
            player.kickPlayer("Invalid name!");
            return;
        }
        if (this.plugin.isError()) {
            this.sendSafeModeMessage(player);
            return;
        }
        this.plugin.getScheduler().run(new OnPlayerLogin(Towny.getPlugin(), player));
    }

    private void sendSafeModeMessage(Player player) {
        try {
            Translatable tipMsg = player.isOp() || player.hasPermission("towny.admin") ? Translatable.of("msg_safe_mode_admin") : Translatable.of("msg_safe_mode_player");
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_safe_mode_base"), tipMsg);
        }
        catch (Exception e) {
            String msg = player.isOp() || player.hasPermission("towny.admin") ? "Check the server's console for more information." : "Tell an admin to check the server's console.";
            player.sendMessage(ChatColor.RED + "[Towny] [Error] Towny is locked in Safe Mode due to an error! " + msg);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident != null) {
            if (!event.getPlayer().getMetadata("vanished").stream().anyMatch(MetadataValue::asBoolean)) {
                resident.setLastOnline(System.currentTimeMillis());
            }
            resident.clearModes();
            resident.save();
            if (TownyTimerHandler.isTeleportWarmupRunning()) {
                TownyAPI.getInstance().abortTeleportRequest(resident);
            }
            if (JailUtil.isQueuedToBeJailed(resident)) {
                event.getPlayer().setHealth(0.0);
            }
        }
        this.plugin.deleteCache(event.getPlayer());
        TownyPerms.removeAttachment(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Location bed;
        if (this.plugin.isError() || this.isEndPortalRespawn(event)) {
            return;
        }
        Player player = event.getPlayer();
        if (!TownySettings.isTownRespawning()) {
            return;
        }
        if (event.isAnchorSpawn() && TownySettings.isRespawnAnchorHigherPrecedence()) {
            return;
        }
        Location respawn = TownyAPI.getInstance().getTownSpawnLocation(player);
        if (TownySettings.getBedUse() && (bed = player.getBedSpawnLocation()) != null) {
            respawn = bed;
        }
        if (respawn == null) {
            return;
        }
        if (TownySettings.isTownRespawningInOtherWorlds() && !player.getWorld().equals(respawn.getWorld())) {
            return;
        }
        event.setRespawnLocation(respawn);
        long protectionTime = TownySettings.getSpawnProtectionDuration();
        if (protectionTime > 0L) {
            Resident res = TownyAPI.getInstance().getResident(player);
            if (res == null) {
                return;
            }
            res.addRespawnProtection(protectionTime);
        }
    }

    private boolean isEndPortalRespawn(PlayerRespawnEvent event) {
        try {
            Collection respawnFlags = GET_RESPAWN_FLAGS.invoke(event);
            for (Enum flag : respawnFlags) {
                if (!"END_PORTAL".equals(flag.name())) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            Player player = event.getPlayer();
            if (player.getWorld().getEnvironment() != World.Environment.THE_END) {
                return false;
            }
            return player.getLocation().getBlock().getType() == Material.END_PORTAL || player.getEyeLocation().getBlock().getType() == Material.END_PORTAL;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJailRespawn(PlayerRespawnEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident != null && resident.isJailed()) {
            event.setRespawnLocation(resident.getJailSpawn());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBuild(event.getPlayer(), event.getBlock().getLocation(), event.getBucket()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getBlockClicked().getType().equals((Object)Material.AIR)) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getBlockClicked().getLocation(), event.getBlockClicked().getType()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR && action != Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (event.hasItem()) {
            Material item = event.getItem().getType();
            Location loc = null;
            loc = clickedBlock != null ? clickedBlock.getLocation() : player.getLocation();
            if (TownySettings.isItemUseMaterial(item, loc)) {
                event.setCancelled(!TownyActionEventExecutor.canItemuse(player, loc, item));
            }
            if (clickedBlock != null) {
                Material clickedMat = clickedBlock.getType();
                if (Tag.BEDS.isTagged((Keyed)item) && Tag.CROPS.isTagged((Keyed)clickedBlock.getType()) && clickedBlock.getLightLevel() == 0) {
                    event.setCancelled(true);
                    return;
                }
                if (ItemLists.AXES.contains(item) && (ItemLists.UNSTRIPPED_WOOD.contains(clickedMat) || ItemLists.WAXED_BLOCKS.contains(clickedMat) || ItemLists.WEATHERABLE_BLOCKS.contains(clickedMat)) || ItemLists.DYES.contains(item) && ItemLists.SIGNS.contains(clickedMat) || item == Material.FLINT_AND_STEEL && clickedMat == Material.TNT || (item == Material.GLASS_BOTTLE || item == Material.SHEARS) && (clickedMat == Material.BEE_NEST || clickedMat == Material.BEEHIVE || clickedMat == Material.PUMPKIN)) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, loc, clickedMat));
                }
                if (item == Material.BONE_MEAL) {
                    event.setCancelled(!TownyActionEventExecutor.canBuild(player, loc, item));
                }
                if (ItemLists.CANDLES.contains(item) && clickedMat == Material.CAKE) {
                    event.setCancelled(!TownyActionEventExecutor.canBuild(player, loc, item));
                }
                if (item == Material.HONEYCOMB && ItemLists.WEATHERABLE_BLOCKS.contains(clickedMat)) {
                    event.setCancelled(!TownyActionEventExecutor.canBuild(player, loc, item));
                }
                if (item == Material.ARMOR_STAND || item == Material.END_CRYSTAL) {
                    event.setCancelled(!TownyActionEventExecutor.canBuild(player, clickedBlock.getRelative(event.getBlockFace()).getLocation(), item));
                }
                if (ItemLists.PLACEABLE_BOOKS.contains(item) && ItemLists.BOOK_CONTAINERS.contains(clickedMat)) {
                    event.setCancelled(!TownyActionEventExecutor.canBuild(player, loc, item));
                }
                if (clickedMat.getKey().equals((Object)NamespacedKey.minecraft((String)"rooted_dirt")) && ItemLists.HOES.contains(item)) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, clickedBlock));
                }
                if (item == Material.HONEYCOMB && ItemLists.SIGNS.contains(clickedMat) && !this.isSignWaxed(clickedBlock) && !TownyActionEventExecutor.canItemuse(player, clickedBlock.getLocation(), clickedMat)) {
                    event.setCancelled(true);
                    return;
                }
                if (ItemLists.BRUSHABLE_BLOCKS.contains(clickedMat) && item == Material.BRUSH && !TownyActionEventExecutor.canDestroy(player, clickedBlock)) {
                    event.setCancelled(true);
                }
            }
        }
        if (clickedBlock != null) {
            Material clickedMat = clickedBlock.getType();
            if (TownySettings.isSwitchMaterial(clickedMat, clickedBlock.getLocation())) {
                event.setCancelled(!TownyActionEventExecutor.canSwitch(player, clickedBlock.getLocation(), clickedMat));
                return;
            }
            if (ItemLists.POTTED_PLANTS.contains(clickedMat) || ItemLists.HARVESTABLE_BERRIES.contains(clickedMat) || ItemLists.REDSTONE_INTERACTABLES.contains(clickedMat) || ItemLists.CANDLES.contains(clickedMat) || clickedMat.getKey().equals((Object)NamespacedKey.minecraft((String)"turtle_egg")) || clickedMat.getKey().equals((Object)NamespacedKey.minecraft((String)"chiseled_bookshelf")) || clickedMat == Material.BEACON || clickedMat == Material.DRAGON_EGG || clickedMat == Material.COMMAND_BLOCK) {
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, clickedBlock.getLocation(), clickedMat));
                return;
            }
            if (TownyPaperEvents.SIGN_OPEN_GET_CAUSE == null && ItemLists.SIGNS.contains(clickedMat) && !this.isSignWaxed(clickedBlock)) {
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, clickedBlock.getLocation(), clickedMat));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBlowsUpBedOrRespawnAnchor(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (event.hasBlock() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Location blockLoc = block.getLocation();
            if (block.getType() == Material.RESPAWN_ANCHOR && !this.isRespawnAnchorWorking(block)) {
                RespawnAnchor anchor = (RespawnAnchor)block.getBlockData();
                if (anchor.getCharges() > 0) {
                    BukkitTools.fireEvent(new BedExplodeEvent(player, blockLoc, null, block.getType()));
                }
                return;
            }
            if (Tag.BEDS.isTagged((Keyed)block.getType()) && player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                Bed bed = (Bed)block.getBlockData();
                BukkitTools.fireEvent(new BedExplodeEvent(player, blockLoc, block.getRelative(bed.getFacing()).getLocation(), block.getType()));
                return;
            }
            if (TownySettings.getBedUse() && (Tag.BEDS.isTagged((Keyed)block.getType()) || this.disallowedAnchorClick(event, block))) {
                PlayerDeniedBedUseEvent pdbue;
                boolean isOwner = false;
                boolean isInnPlot = false;
                boolean isEnemy = false;
                Translatable denialMessage = Translatable.of("msg_err_cant_use_bed");
                if (!TownyAPI.getInstance().isWilderness(blockLoc)) {
                    TownBlock townblock = TownyAPI.getInstance().getTownBlock(blockLoc);
                    Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                    Town town = townblock.getTownOrNull();
                    if (resident == null || town == null) {
                        return;
                    }
                    isOwner = townblock.isOwner(resident);
                    boolean bl = isInnPlot = townblock.getType() == TownBlockType.INN;
                    if (CombatUtil.isEnemyTownBlock(player, townblock.getWorldCoord()) || town.hasOutlaw(resident)) {
                        isEnemy = true;
                        denialMessage = Translatable.of("msg_err_no_sleep_in_enemy_inn");
                    }
                }
                if ((isEnemy || !isOwner && !isInnPlot) && !BukkitTools.isEventCancelled(pdbue = new PlayerDeniedBedUseEvent(player, blockLoc, isEnemy, denialMessage))) {
                    event.setCancelled(true);
                    TownyMessaging.sendErrorMsg((CommandSender)player, pdbue.getDenialMessage());
                }
            }
        }
    }

    private boolean isRespawnAnchorWorking(Block block) {
        boolean allowedInWorld = false;
        try {
            allowedInWorld = block.getWorld().isRespawnAnchorWorks();
        }
        catch (NoSuchMethodError ignored) {
            allowedInWorld = block.getWorld().getEnvironment().equals((Object)World.Environment.NETHER);
        }
        return allowedInWorld;
    }

    private boolean disallowedAnchorClick(PlayerInteractEvent event, Block block) {
        RespawnAnchor anchor;
        BlockData blockData;
        return this.isRespawnAnchorWorking(block) && (blockData = block.getBlockData()) instanceof RespawnAnchor && (anchor = (RespawnAnchor)blockData).getCharges() > 0 && (event.getItem() == null || event.getItem().getType() != Material.GLOWSTONE || anchor.getCharges() >= anchor.getMaximumCharges());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractWithArmourStand(PlayerArmorStandManipulateEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getRightClicked().getLocation(), Material.ARMOR_STAND));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getRightClicked() != null) {
            Material item;
            Player player = event.getPlayer();
            Material mat = null;
            TownyPermission.ActionType actionType = TownyPermission.ActionType.DESTROY;
            EntityType entityType = event.getRightClicked().getType();
            Material material = item = event.getHand().equals((Object)EquipmentSlot.HAND) ? event.getPlayer().getInventory().getItemInMainHand().getType() : event.getPlayer().getInventory().getItemInOffHand().getType();
            if (EntityLists.SWITCH_PROTECTED.contains(entityType)) {
                mat = EntityTypeUtil.parseEntityToMaterial(entityType);
                actionType = TownyPermission.ActionType.SWITCH;
            } else if (EntityLists.DYEABLE.contains(entityType) && ItemLists.DYES.contains(item)) {
                mat = item;
            } else if (EntityLists.RIGHT_CLICK_PROTECTED.contains(entityType)) {
                mat = EntityTypeUtil.parseEntityToMaterial(entityType);
            }
            if (mat != null) {
                if (actionType == TownyPermission.ActionType.DESTROY) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), mat));
                    return;
                }
                if (TownySettings.isSwitchMaterial(mat, event.getRightClicked().getLocation()) && actionType == TownyPermission.ActionType.SWITCH) {
                    event.setCancelled(!TownyActionEventExecutor.canSwitch(player, event.getRightClicked().getLocation(), mat));
                    return;
                }
            }
            if (item != null) {
                if (event.getRightClicked().getType().equals((Object)EntityType.SHEEP) && item == Material.SHEARS && !TownyAPI.getInstance().isWilderness(event.getRightClicked().getLocation())) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), item));
                    return;
                }
                if (item == Material.NAME_TAG) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), item));
                    return;
                }
                if (TownySettings.isItemUseMaterial(item, event.getRightClicked().getLocation())) {
                    event.setCancelled(!TownyActionEventExecutor.canItemuse(player, event.getRightClicked().getLocation(), item));
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from;
        if (PluginIntegrations.getInstance().checkCitizens((Entity)event.getPlayer())) {
            return;
        }
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Player player = event.getPlayer();
        Location to = event.getTo();
        PlayerCache cache = this.plugin.getCache(player);
        Resident resident = townyUniverse.getResident(player.getUniqueId());
        if (resident != null && TownySettings.getTeleportWarmupTime() > 0 && TownySettings.isMovementCancellingSpawnWarmup() && resident.hasRequestedTeleport() && !townyUniverse.getPermissionSource().isTownyAdmin((Permissible)player) && TeleportWarmupTimerTask.abortTeleportRequest(resident)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_teleport_cancelled"));
        }
        try {
            from = cache.getLastLocation();
        }
        catch (NullPointerException e) {
            from = event.getFrom();
        }
        if (WorldCoord.cellChanged(from, to)) {
            TownyWorld fromWorld = TownyAPI.getInstance().getTownyWorld(from.getWorld());
            TownyWorld toWorld = TownyAPI.getInstance().getTownyWorld(to.getWorld());
            if (fromWorld == null || toWorld == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("not_registered"));
                cache.setLastLocation(to);
                return;
            }
            WorldCoord fromCoord = new WorldCoord(fromWorld.getName(), fromWorld.getUUID(), Coord.parseCoord(from));
            WorldCoord toCoord = new WorldCoord(toWorld.getName(), fromWorld.getUUID(), Coord.parseCoord(to));
            this.onPlayerMoveChunk(player, fromCoord, toCoord, from, to, event);
        }
        cache.setLastLocation(to);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Town town;
        TownBlock tb;
        boolean isAdmin;
        if (PluginIntegrations.getInstance().checkCitizens((Entity)event.getPlayer())) {
            return;
        }
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        boolean bl = isAdmin = resident != null && (resident.isAdmin() || resident.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_OUTLAW_TELEPORT_BYPASS.getNode()));
        if (resident != null && resident.isJailed() && !isAdmin) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_jailed_players_no_teleport"));
                event.setCancelled(true);
                return;
            }
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
                return;
            }
            if (!(event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL && event.getCause() != PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT || TownySettings.JailAllowsTeleportItems())) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_jailed_players_no_teleport"));
                event.setCancelled(true);
            }
        }
        if (resident != null && !TownySettings.canOutlawsTeleportOutOfTowns() && !isAdmin && (tb = TownyAPI.getInstance().getTownBlock(event.getFrom())) != null && tb.hasTown() && (town = tb.getTownOrNull()) != null && town.hasOutlaw(resident)) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_outlawed_players_no_teleport"));
                event.setCancelled(true);
                return;
            }
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
                return;
            }
            if (!(TownySettings.canOutlawsUseTeleportItems() || event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL && event.getCause() != PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT)) {
                TownyMessaging.sendErrorMsg((CommandSender)event.getPlayer(), Translatable.of("msg_err_outlawed_players_no_teleport"));
                event.setCancelled(true);
            }
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT && TownySettings.isItemUseMaterial(Material.CHORUS_FRUIT, event.getTo()) && !isAdmin && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getTo(), Material.CHORUS_FRUIT)) {
            event.setCancelled(true);
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && TownySettings.isItemUseMaterial(Material.ENDER_PEARL, event.getTo()) && !isAdmin && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getTo(), Material.ENDER_PEARL)) {
            event.setCancelled(true);
            return;
        }
        if (resident != null && resident.hasRespawnProtection()) {
            resident.removeRespawnProtection();
        }
        this.onPlayerMove((PlayerMoveEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        if (event.getPlayer().isOnline()) {
            TownyPerms.assignPermissions(null, event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerFishEvent(PlayerFishEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_ENTITY)) {
            Player player = event.getPlayer();
            Entity caught = event.getCaught();
            boolean test = false;
            if (caught.getType().equals((Object)EntityType.PLAYER)) {
                TownyWorld world = TownyAPI.getInstance().getTownyWorld(event.getCaught().getWorld());
                if (world == null) {
                    return;
                }
                TownBlock tb = TownyAPI.getInstance().getTownBlock(event.getCaught().getLocation());
                test = !CombatUtil.preventPvP(world, tb);
            } else {
                test = TownyActionEventExecutor.canDestroy(player, caught.getLocation(), Material.GRASS);
            }
            if (!test) {
                event.setCancelled(true);
                event.getHook().remove();
            }
        }
    }

    public void onPlayerMoveChunk(Player player, WorldCoord from, WorldCoord to, Location fromLoc, Location toLoc, PlayerMoveEvent moveEvent) {
        this.plugin.getCache(player).setLastLocation(toLoc);
        this.plugin.getCache(player).updateCoord(to);
        PlayerChangePlotEvent event = new PlayerChangePlotEvent(player, from, to, moveEvent);
        BukkitTools.fireEvent(event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        if (!TownyUniverse.getInstance().hasResident(event.getPlayer().getUniqueId())) {
            return;
        }
        WorldCoord from = event.getFrom();
        WorldCoord to = event.getTo();
        if (to.isWilderness() && from.isWilderness()) {
            return;
        }
        if (to.isWilderness()) {
            BukkitTools.fireEvent(new PlayerExitsFromTownBorderEvent(event.getPlayer(), to, from, from.getTownOrNull(), event.getMoveEvent()));
            BukkitTools.fireEvent(new PlayerLeaveTownEvent(event.getPlayer(), to, from, from.getTownOrNull(), event.getMoveEvent()));
        } else if (from.isWilderness()) {
            BukkitTools.fireEvent(new PlayerEntersIntoTownBorderEvent(event.getPlayer(), to, from, to.getTownOrNull(), event.getMoveEvent()));
            BukkitTools.fireEvent(new PlayerEnterTownEvent(event.getPlayer(), to, from, to.getTownOrNull(), event.getMoveEvent()));
        } else {
            if (to.getTownOrNull().equals(from.getTownOrNull())) {
                return;
            }
            BukkitTools.fireEvent(new PlayerEntersIntoTownBorderEvent(event.getPlayer(), to, from, to.getTownOrNull(), event.getMoveEvent()));
            BukkitTools.fireEvent(new PlayerExitsFromTownBorderEvent(event.getPlayer(), to, from, from.getTownOrNull(), event.getMoveEvent()));
            BukkitTools.fireEvent(new PlayerEnterTownEvent(event.getPlayer(), to, from, to.getTownOrNull(), event.getMoveEvent()));
            BukkitTools.fireEvent(new PlayerLeaveTownEvent(event.getPlayer(), to, from, from.getTownOrNull(), event.getMoveEvent()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onOutlawEnterTown(PlayerEntersIntoTownBorderEvent event) {
        Resident outlaw = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (outlaw == null) {
            return;
        }
        Town town = event.getEnteredTown();
        if (outlaw.isJailed() && outlaw.getJailTown().equals(town)) {
            return;
        }
        if (town.hasOutlaw(outlaw)) {
            ResidentUtil.outlawEnteredTown(outlaw, town, event.getPlayer().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDieInTown(PlayerDeathEvent event) {
        Resident resident = TownyAPI.getInstance().getResident(event.getEntity());
        TownBlock tb = TownyAPI.getInstance().getTownBlock(event.getEntity().getLocation());
        if (resident == null || tb == null) {
            return;
        }
        boolean keepInventory = event.getKeepInventory();
        boolean keepLevel = event.getKeepLevel();
        if (TownySettings.getKeepExperienceInTowns() && !keepLevel) {
            keepLevel = this.tryKeepExperience(event);
        }
        if (TownySettings.getKeepInventoryInTowns() && !keepInventory) {
            keepInventory = this.tryKeepInventory(event);
        }
        if (resident.hasTown() && !keepInventory) {
            Town town = resident.getTownOrNull();
            Town tbTown = tb.getTownOrNull();
            if (TownySettings.getKeepInventoryInOwnTown() && tbTown.equals(town)) {
                keepInventory = this.tryKeepInventory(event);
            }
            if (TownySettings.getKeepInventoryInAlliedTowns() && !keepInventory && tbTown.isAlliedWith(town)) {
                keepInventory = this.tryKeepInventory(event);
            }
        }
        if (TownySettings.getKeepInventoryInArenas() && !keepInventory && tb.getType() == TownBlockType.ARENA) {
            this.tryKeepInventory(event);
        }
        if (TownySettings.getKeepExperienceInArenas() && !keepLevel && tb.getType() == TownBlockType.ARENA) {
            this.tryKeepExperience(event);
        }
    }

    private boolean tryKeepExperience(PlayerDeathEvent event) {
        PlayerKeepsExperienceEvent pkee = new PlayerKeepsExperienceEvent(event);
        if (!BukkitTools.isEventCancelled(pkee)) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
            return true;
        }
        return false;
    }

    private boolean tryKeepInventory(PlayerDeathEvent event) {
        PlayerKeepsInventoryEvent pkie = new PlayerKeepsInventoryEvent(event);
        if (!BukkitTools.isEventCancelled(pkie)) {
            event.setKeepInventory(true);
            event.getDrops().clear();
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerEnterTown(PlayerEntersIntoTownBorderEvent event) {
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        Town town = event.getEnteredTown();
        if (resident != null && resident.isSeeingBorderTitles() && town != null && TownySettings.isNotificationUsingTitles()) {
            String title = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesTownTitle());
            String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesTownSubtitle());
            HashMap<String, Object> placeholders = new HashMap<String, Object>();
            placeholders.put("{townname}", StringMgmt.remUnderscore(TownySettings.isNotificationsTownNamesVerbose() ? town.getFormattedName() : town.getName()));
            placeholders.put("{town_motd}", town.getBoard());
            placeholders.put("{town_residents}", town.getNumResidents());
            placeholders.put("{town_residents_online}", TownyAPI.getInstance().getOnlinePlayers(town).size());
            Nation nation = town.getNationOrNull();
            placeholders.put("{nationname}", nation == null ? "" : String.format(TownySettings.getNotificationTitlesNationNameFormat(), nation.getName()));
            placeholders.put("{nation_residents}", nation == null ? "" : Integer.valueOf(nation.getNumResidents()));
            placeholders.put("{nation_residents_online}", nation == null ? "" : Integer.valueOf(TownyAPI.getInstance().getOnlinePlayers(nation).size()));
            placeholders.put("{nation_motd}", nation == null ? "" : nation.getBoard());
            placeholders.put("{nationcapital}", !town.isCapital() ? "" : this.getCapitalSlug(town.getName(), nation.getName()));
            for (Map.Entry placeholder : placeholders.entrySet()) {
                title = title.replace((CharSequence)placeholder.getKey(), placeholder.getValue().toString());
                subtitle = subtitle.replace((CharSequence)placeholder.getKey(), placeholder.getValue().toString());
            }
            TownyMessaging.sendTitleMessageToResident(resident, title, subtitle, TownySettings.getNotificationTitlesDurationTicks());
        }
    }

    private Object getCapitalSlug(String townName, String nationName) {
        String format = TownySettings.getNotificationTitlesNationCapitalFormat();
        if (format.contains("%t") || format.contains("%n")) {
            return format.replace("%t", townName).replace("%n", nationName);
        }
        return String.format(format, nationName, townName);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLeaveTown(PlayerExitsFromTownBorderEvent event) {
        Resident resident = TownyAPI.getInstance().getResident(event.getPlayer().getUniqueId());
        String worldName = TownyAPI.getInstance().getTownyWorld(event.getPlayer().getWorld()).getFormattedUnclaimedZoneName();
        if (resident == null || worldName == null) {
            return;
        }
        if (TownySettings.isNotificationUsingTitles() && resident.isSeeingBorderTitles() && event.getTo().getTownBlockOrNull() == null) {
            String title = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesWildTitle());
            String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesWildSubtitle());
            if (title.contains("{wilderness}")) {
                title = title.replace("{wilderness}", worldName);
            }
            if (subtitle.contains("{wilderness}")) {
                subtitle = subtitle.replace("{wilderness}", worldName);
            }
            if (title.contains("{townname}")) {
                subtitle = subtitle.replace("{townname}", StringMgmt.remUnderscore(event.getFrom().getTownOrNull().getName()));
            }
            if (subtitle.contains("{townname}")) {
                subtitle = subtitle.replace("{townname}", StringMgmt.remUnderscore(event.getFrom().getTownOrNull().getName()));
            }
            TownyMessaging.sendTitleMessageToResident(resident, title, subtitle, TownySettings.getNotificationTitlesDurationTicks());
        }
        if (resident.isJailed()) {
            JailUtil.unJailResident(resident, UnJailReason.ESCAPE);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTakeLecternBookEvent(PlayerTakeLecternBookEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getLectern().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getLectern().getLocation(), Material.LECTERN));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerUsesCommand(PlayerCommandPreprocessEvent event) {
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident == null || resident.isAdmin()) {
            return;
        }
        String command = event.getMessage();
        if (this.blockJailedPlayerCommand(event.getPlayer(), resident, command)) {
            event.setCancelled(true);
            return;
        }
        if (this.blockWarPlayerCommand(event.getPlayer(), resident, command)) {
            event.setCancelled(true);
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(event.getPlayer());
        if (this.blockOutlawedPlayerCommand(event.getPlayer(), resident, townBlock, command) || this.blockCommandInsideTown(event.getPlayer(), resident, townBlock, command)) {
            event.setCancelled(true);
        }
    }

    public boolean blockWarPlayerCommand(Player player, Resident resident, String command) {
        if (resident.hasTown() && resident.getTownOrNull().hasActiveWar() && this.blockedWarCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_war_blocked"));
            return true;
        }
        return false;
    }

    public boolean blockOutlawedPlayerCommand(Player player, Resident resident, TownBlock townBlock, String command) {
        Town town;
        if (townBlock != null && townBlock.hasTown() && (town = townBlock.getTownOrNull()) != null && town.hasOutlaw(resident) && this.blockedOutlawCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_you_cannot_use_command_while_in_outlaw_town"));
            return true;
        }
        return false;
    }

    public boolean blockJailedPlayerCommand(Player player, Resident resident, String command) {
        if (!resident.isJailed()) {
            return false;
        }
        if (this.blockedJailCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_you_cannot_use_that_command_while_jailed"));
            return true;
        }
        return false;
    }

    public boolean blockCommandInsideTown(Player player, Resident resident, TownBlock townBlock, String command) {
        Town town;
        if (!TownySettings.allowTownCommandBlacklisting()) {
            return false;
        }
        if (resident.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_TOWN_COMMAND_BLACKLIST_BYPASS.getNode())) {
            return false;
        }
        Town town2 = town = townBlock == null ? null : townBlock.getTownOrNull();
        if (town != null && town.hasActiveWar() && this.blockedWarCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_war_blocked"));
            return true;
        }
        if (town != null && this.blockedTownCommands.containsCommand(command) && this.blockedTouristCommands.containsCommand(command)) {
            if (town.hasResident(resident) || resident.hasPermissionNode(PermissionNodes.TOWNY_ADMIN_TOURIST_COMMAND_LIMITATION_BYPASS.getNode()) || TownySettings.doTrustedResidentsBypassTownBlockedCommands() && town.hasTrustedResident(resident) || resident.hasTown() && TownySettings.doAlliesBypassTownBlockedCommands() && CombatUtil.isAlly(town, resident.getTownOrNull())) {
                return false;
            }
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_outsider_blocked", town.getName()));
            return true;
        }
        if (town != null && this.blockedTownCommands.containsCommand(command)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_blocked_inside_towns"));
            return true;
        }
        if (this.ownPlotLimitedCommands.containsCommand(command)) {
            if (town == null) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_limited"));
                return true;
            }
            if (town.hasResident(player) && TownyUniverse.getInstance().getPermissionSource().hasOwnTownOverride(player, Material.DIRT, TownyPermission.ActionType.BUILD)) {
                return false;
            }
            Resident owner = townBlock.getResidentOrNull();
            if (owner != null) {
                if (!owner.getName().equals(player.getName())) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_limited"));
                    return true;
                }
            } else {
                if (town.hasResident(player) && TownyUniverse.getInstance().getPermissionSource().hasTownOwnedOverride(player, Material.DIRT, TownyPermission.ActionType.BUILD)) {
                    return false;
                }
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_command_limited"));
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAdminToolUseOnBlocks(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND || !TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.hasItem() && event.getPlayer().getInventory().getItemInMainHand().getType().getKey().getKey().equalsIgnoreCase(TownySettings.getTool()) && this.plugin.hasPlayerMode(event.getPlayer(), "infotool") && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)event.getPlayer()) && event.getClickedBlock() != null) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            BlockState state = PaperLib.getBlockState(block, false).getState();
            BlockData data = state.getBlockData();
            if (ItemLists.SIGNS.contains(block.getType()) && data instanceof Rotatable) {
                Rotatable rotatable = (Rotatable)data;
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Sign Info"), ChatTools.formatCommand("", "Sign Type", "", block.getType().name()), ChatTools.formatCommand("", "Facing", "", rotatable.getRotation().toString())));
            } else if (Tag.DOORS.isTagged((Keyed)block.getType())) {
                Door door = (Door)block.getBlockData();
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Door Info"), ChatTools.formatCommand("", "Door Type", "", block.getType().getKey().toString()), ChatTools.formatCommand("", "hinged on ", "", String.valueOf(door.getHinge())), ChatTools.formatCommand("", "isOpen", "", String.valueOf(door.isOpen())), ChatTools.formatCommand("", "getFacing", "", door.getFacing().name())));
            } else {
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Block Info"), ChatTools.formatCommand("", "Material", "", block.getType().getKey().toString()), ChatTools.formatCommand("", "MaterialData", "", block.getBlockData().getAsString())));
            }
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAdminToolUseOnEntities(PlayerInteractEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND || !TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getRightClicked() != null && event.getPlayer().getInventory().getItemInMainHand().getType().getKey().getKey().equalsIgnoreCase(TownySettings.getTool()) && this.plugin.hasPlayerMode(event.getPlayer(), "infotool") && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)event.getPlayer())) {
            Entity entity = event.getRightClicked();
            TownyMessaging.sendMessage((Object)event.getPlayer(), Arrays.asList(ChatTools.formatTitle("Entity Info"), ChatTools.formatCommand("", "Entity Class", "", entity.getType().getEntityClass().getSimpleName()), ChatTools.formatCommand("", "Entity Type", "", entity.getType().getKey().toString())));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEggLand(PlayerEggThrowEvent event) {
        if (TownySettings.isItemUseMaterial(Material.EGG, event.getEgg().getLocation()) && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getEgg().getLocation(), Material.EGG)) {
            event.setHatching(false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity;
        if (TownySettings.getRespawnProtectionAllowPickup() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            return;
        }
        if (resident.hasRespawnProtection()) {
            event.setCancelled(true);
            if (!resident.isRespawnPickupWarningShown()) {
                resident.setRespawnPickupWarningShown(true);
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_cannot_pickup_respawn_protection"));
            }
        }
    }

    private void loadBlockedCommandLists() {
        this.blockedJailCommands = new CommandList(TownySettings.getJailBlacklistedCommands());
        this.blockedTouristCommands = new CommandList(TownySettings.getTouristBlockedCommands());
        this.blockedTownCommands = new CommandList(TownySettings.getTownBlacklistedCommands());
        this.blockedOutlawCommands = new CommandList(TownySettings.getOutlawBlacklistedCommands());
        this.blockedWarCommands = new CommandList(TownySettings.getWarBlacklistedCommands());
        this.ownPlotLimitedCommands = new CommandList(TownySettings.getPlayerOwnedPlotLimitedCommands());
    }

    private boolean isSignWaxed(Block block) {
        BlockState blockState;
        if (MinecraftVersion.CURRENT_VERSION.isOlderThan(MinecraftVersion.MINECRAFT_1_20) || !((blockState = PaperLib.getBlockState(block, false).getState()) instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)blockState;
        try {
            return sign.isWaxed();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    static {
        MethodHandle temp = null;
        try {
            temp = MethodHandles.publicLookup().unreflect(PlayerRespawnEvent.class.getMethod("getRespawnFlags", new Class[0]));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GET_RESPAWN_FLAGS = temp;
    }
}

