/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.util.JavaUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TownyPaperEvents
implements Listener {
    private final Towny plugin;
    private static final MethodHandle GET_ORIGIN = TownyPaperEvents.getOriginHandle();
    private static final MethodHandle GET_PRIMER_ENTITY = TownyPaperEvents.getPrimerEntityHandle();
    public static final MethodHandle SIGN_OPEN_GET_CAUSE = TownyPaperEvents.getSignOpenCauseHandle();
    private static final MethodHandle SIGN_OPEN_GET_SIGN = TownyPaperEvents.getSignOpenGetSignHandle();
    private static final String SPIGOT_PRIME_EVENT = "org.bukkit.event.block.TNTPrimeEvent";
    private static final String PAPER_PRIME_EVENT = "com.destroystokyo.paper.event.block.TNTPrimeEvent";
    private static final String SIGN_OPEN_EVENT = "io.papermc.paper.event.player.PlayerOpenSignEvent";

    public TownyPaperEvents(Towny plugin) {
        this.plugin = plugin;
    }

    public void register() {
        if (JavaUtil.classExists(SPIGOT_PRIME_EVENT)) {
            this.registerEvent(SPIGOT_PRIME_EVENT, this::tntPrimeEvent, EventPriority.LOW, true);
        } else if (GET_PRIMER_ENTITY != null) {
            this.registerEvent(PAPER_PRIME_EVENT, this::tntPrimeEvent, EventPriority.LOW, true);
            TownyMessaging.sendDebugMsg("TNTPRimeEvent#getPrimerEntity method found, using TNTPrimeEvent listener.");
        }
        if (GET_ORIGIN != null) {
            this.registerEvent(EntityChangeBlockEvent.class, this.fallingBlockListener(), EventPriority.LOW, true);
            TownyMessaging.sendDebugMsg("Entity#getOrigin found, using falling block listener.");
        }
        if (SIGN_OPEN_GET_CAUSE != null) {
            this.registerEvent(SIGN_OPEN_EVENT, this::openSignListener, EventPriority.LOW, true);
            TownyMessaging.sendDebugMsg("PlayerOpenSignEvent#getCause found, using PlayerOpenSignEvent listener.");
        }
    }

    private <T extends Event> void registerEvent(String className, Supplier<Consumer<T>> executor, EventPriority eventPriority, boolean ignoreCancelled) {
        try {
            Class<Event> eventClass = Class.forName(className).asSubclass(Event.class);
            this.registerEvent(eventClass, executor.get(), eventPriority, ignoreCancelled);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private <T extends Event> void registerEvent(Class<T> eventClass, Consumer<T> consumer, EventPriority eventPriority, boolean ignoreCancelled) {
        Bukkit.getPluginManager().registerEvent(eventClass, (Listener)this, eventPriority, (listener, event) -> consumer.accept(event), (Plugin)this.plugin, ignoreCancelled);
    }

    private Consumer<Event> tntPrimeEvent() {
        return event -> {
            Entity primerEntity = null;
            if (event.getClass().getName().equals(SPIGOT_PRIME_EVENT)) {
                primerEntity = ((TNTPrimeEvent)event).getPrimingEntity();
            } else if (GET_PRIMER_ENTITY != null) {
                try {
                    primerEntity = GET_PRIMER_ENTITY.invoke((Event)event);
                }
                catch (Throwable e) {
                    return;
                }
            }
            if (primerEntity instanceof Projectile) {
                Projectile projectile = (Projectile)primerEntity;
                Cancellable cancellable = (Cancellable)event;
                Block block = ((BlockEvent)event).getBlock();
                ProjectileSource patt4361$temp = projectile.getShooter();
                if (patt4361$temp instanceof Player) {
                    Player player = (Player)patt4361$temp;
                    cancellable.setCancelled(!TownyActionEventExecutor.canDestroy(player, block));
                } else {
                    BlockProjectileSource bps;
                    ProjectileSource patt4592$temp = projectile.getShooter();
                    if (patt4592$temp instanceof BlockProjectileSource && !BorderUtil.allowedMove((bps = (BlockProjectileSource)patt4592$temp).getBlock(), block)) {
                        cancellable.setCancelled(true);
                    }
                }
            }
        };
    }

    private Consumer<EntityChangeBlockEvent> fallingBlockListener() {
        return event -> {
            Location origin;
            if (GET_ORIGIN == null || event.getEntityType() != EntityType.FALLING_BLOCK || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
                return;
            }
            try {
                origin = GET_ORIGIN.invoke(event.getEntity());
            }
            catch (Throwable e) {
                this.plugin.getLogger().log(Level.WARNING, "An exception occurred while invoking Entity#getOrigin reflectively", e);
                return;
            }
            if (origin == null) {
                return;
            }
            if (origin.getBlockZ() == event.getBlock().getZ() && origin.getBlockX() == event.getBlock().getX()) {
                return;
            }
            if (!BorderUtil.allowedMove(origin.getBlock(), event.getBlock())) {
                event.setCancelled(true);
            }
        };
    }

    private Consumer<Event> openSignListener() {
        return event -> {
            Sign sign;
            Enum cause;
            if (SIGN_OPEN_GET_CAUSE == null || SIGN_OPEN_GET_SIGN == null) {
                return;
            }
            try {
                cause = SIGN_OPEN_GET_CAUSE.invoke((Event)event);
                sign = SIGN_OPEN_GET_SIGN.invoke((Event)event);
            }
            catch (Throwable e) {
                this.plugin.getLogger().log(Level.WARNING, "An exception occurred while invoking io.papermc.paper.event.player.PlayerOpenSignEvent#getCause/#getSign reflectively", e);
                return;
            }
            if (!cause.name().equals("INTERACT") || !sign.isPlaced()) {
                return;
            }
            if (!TownyActionEventExecutor.canDestroy(((PlayerEvent)event).getPlayer(), sign.getBlock())) {
                ((Cancellable)event).setCancelled(true);
            }
        };
    }

    private static MethodHandle getOriginHandle() {
        try {
            return MethodHandles.publicLookup().unreflect(Entity.class.getMethod("getOrigin", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static MethodHandle getPrimerEntityHandle() {
        try {
            return MethodHandles.publicLookup().unreflect(Class.forName(PAPER_PRIME_EVENT).getMethod("getPrimerEntity", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static MethodHandle getSignOpenCauseHandle() {
        try {
            return MethodHandles.publicLookup().unreflect(Class.forName(SIGN_OPEN_EVENT).getMethod("getCause", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static MethodHandle getSignOpenGetSignHandle() {
        try {
            return MethodHandles.publicLookup().unreflect(Class.forName(SIGN_OPEN_EVENT).getMethod("getSign", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }
}

