/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.deathprice.NationPaysDeathPriceEvent;
import com.palmergames.bukkit.towny.event.deathprice.PlayerPaysDeathPriceEvent;
import com.palmergames.bukkit.towny.event.deathprice.TownPaysDeathPriceEvent;
import com.palmergames.bukkit.towny.event.player.PlayerKilledPlayerEvent;
import com.palmergames.bukkit.towny.hooks.PluginIntegrations;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.jail.JailReason;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class TownyEntityMonitorListener
implements Listener {
    private final Towny plugin;

    public TownyEntityMonitorListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTakesDamage(EntityDamageEvent event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (TownySettings.isDamageCancellingSpawnWarmup() && TownyTimerHandler.isTeleportWarmupRunning() && !PluginIntegrations.getInstance().checkCitizens((Entity)player)) break block5;
            }
            return;
        }
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (TeleportWarmupTimerTask.abortTeleportRequest(resident)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_teleport_cancelled_damage"));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Player defenderPlayer = event.getEntity();
        Resident defenderResident = TownyUniverse.getInstance().getResident(defenderPlayer.getUniqueId());
        if (defenderResident == null) {
            return;
        }
        EntityDamageEvent entityDamageEvent = defenderPlayer.getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            this.resolvePlayerKilledByEntity(event, defenderPlayer, defenderResident, damageEvent);
        } else if (!TownySettings.isDeathPricePVPOnly()) {
            this.deathPayment(defenderPlayer, defenderResident, null);
        }
    }

    private void resolvePlayerKilledByEntity(PlayerDeathEvent event, Player defenderPlayer, Resident defenderResident, EntityDamageByEntityEvent damageEvent) {
        Projectile projectile;
        ProjectileSource projectileSource;
        Entity attackerEntity = damageEvent.getDamager();
        Player attackerPlayer = null;
        Resident attackerResident = null;
        if (attackerEntity instanceof Projectile && (projectileSource = (projectile = (Projectile)attackerEntity).getShooter()) instanceof Player) {
            Player shooter;
            attackerPlayer = shooter = (Player)projectileSource;
        } else if (attackerEntity instanceof Player) {
            Player player;
            attackerPlayer = player = (Player)attackerEntity;
        }
        if (attackerPlayer != null && attackerPlayer == defenderPlayer) {
            return;
        }
        if (attackerPlayer != null) {
            attackerResident = TownyAPI.getInstance().getResident(attackerPlayer);
        }
        if (attackerPlayer != null && attackerResident != null) {
            BukkitTools.fireEvent(new PlayerKilledPlayerEvent(attackerPlayer, defenderPlayer, attackerResident, defenderResident, defenderPlayer.getLocation(), event));
            this.deathPayment(defenderPlayer, defenderResident, attackerResident);
            this.isJailingAttackers(defenderPlayer, attackerResident, defenderResident);
        } else if (!TownySettings.isDeathPricePVPOnly()) {
            this.deathPayment(defenderPlayer, defenderResident, null);
        }
    }

    private void deathPayment(Player defenderPlayer, Resident defenderResident, @Nullable Resident attackerResident) {
        if (!TownyEconomyHandler.isActive() || !TownySettings.isChargingDeath() || defenderResident.isJailed() || this.hasBypassNode(defenderResident) || this.residentsAllied(defenderResident, attackerResident) || this.killedInInvalidTownBlockType(defenderPlayer)) {
            return;
        }
        double total = 0.0;
        if (TownySettings.getDeathPrice() > 0.0) {
            total = this.takeMoneyFromPlayer(defenderPlayer, attackerResident, defenderResident, total);
        }
        if (TownySettings.getDeathPriceTown() > 0.0 && defenderResident.hasTown()) {
            total = this.takeMoneyFromPlayersTown(defenderPlayer, attackerResident, defenderResident, total);
        }
        if (TownySettings.getDeathPriceNation() > 0.0 && defenderResident.hasNation()) {
            total = this.takeMoneyFromPlayersNation(defenderPlayer, attackerResident, defenderResident, total);
        }
        if (attackerResident != null) {
            TownyMessaging.sendMsg(attackerResident, Translatable.of("msg_you_gained_money_for_killing", TownyEconomyHandler.getFormattedBalance(total), defenderPlayer.getName()));
        }
    }

    private double takeMoneyFromPlayer(Player defenderPlayer, Resident attackerResident, Resident defenderResident, double total) {
        double price = TownySettings.getDeathPrice();
        if (TownySettings.isDeathPricePercentBased()) {
            price = defenderResident.getAccount().getHoldingBalance() * price;
            if (TownySettings.isDeathPricePercentageCapped()) {
                price = Math.min(price, TownySettings.getDeathPricePercentageCap());
            }
        }
        price = Math.min(price, defenderResident.getAccount().getHoldingBalance());
        PlayerPaysDeathPriceEvent ppdpe = new PlayerPaysDeathPriceEvent(defenderResident.getAccount(), price, defenderResident, defenderPlayer);
        if (!BukkitTools.isEventCancelled(ppdpe)) {
            price = ppdpe.getAmount();
            if (attackerResident == null) {
                defenderResident.getAccount().withdraw(price, "Death Payment");
            } else {
                defenderResident.getAccount().payTo(price, attackerResident, "Death Payment");
            }
            total += price;
            TownyMessaging.sendMsg((CommandSender)defenderPlayer, Translatable.of("msg_you_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price)));
        }
        return total;
    }

    private double takeMoneyFromPlayersTown(Player defenderPlayer, Resident attackerResident, Resident defenderResident, double total) {
        Town town = defenderResident.getTownOrNull();
        double price = TownySettings.getDeathPriceTown();
        if (TownySettings.isDeathPricePercentBased()) {
            price = town.getAccount().getHoldingBalance() * price;
        }
        price = Math.min(price, defenderResident.getAccount().getHoldingBalance());
        TownPaysDeathPriceEvent tpdpe = new TownPaysDeathPriceEvent(town.getAccount(), price, defenderResident, defenderPlayer, town);
        if (!BukkitTools.isEventCancelled(tpdpe)) {
            price = tpdpe.getAmount();
            if (attackerResident == null) {
                town.getAccount().withdraw(price, "Death Payment Town");
            } else {
                town.getAccount().payTo(price, attackerResident, "Death Payment Town");
            }
            total += price;
            TownyMessaging.sendTownMessagePrefixed(town, Translatable.of("msg_your_town_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price)));
        }
        return total;
    }

    private double takeMoneyFromPlayersNation(Player defenderPlayer, Resident attackerResident, Resident defenderResident, double total) {
        Nation nation = defenderResident.getNationOrNull();
        double price = TownySettings.getDeathPriceNation();
        if (TownySettings.isDeathPricePercentBased()) {
            price = nation.getAccount().getHoldingBalance() * price;
        }
        price = Math.min(price, defenderResident.getAccount().getHoldingBalance());
        NationPaysDeathPriceEvent npdpe = new NationPaysDeathPriceEvent(nation.getAccount(), price, defenderResident, defenderPlayer, nation);
        if (!BukkitTools.isEventCancelled(npdpe)) {
            price = npdpe.getAmount();
            if (attackerResident == null) {
                nation.getAccount().withdraw(price, "Death Payment Nation");
            } else {
                nation.getAccount().payTo(price, attackerResident, "Death Payment Nation");
            }
            total += price;
            TownyMessaging.sendNationMessagePrefixed(nation, Translatable.of("msg_your_nation_lost_money_dying", TownyEconomyHandler.getFormattedBalance(price)));
        }
        return total;
    }

    private boolean hasBypassNode(Resident defenderResident) {
        return defenderResident.hasPermissionNode(PermissionNodes.TOWNY_BYPASS_DEATH_COSTS.getNode());
    }

    private boolean residentsAllied(Resident defenderResident, Resident attackerResident) {
        return attackerResident != null && CombatUtil.isAlly(attackerResident, defenderResident);
    }

    private boolean killedInInvalidTownBlockType(Player defenderPlayer) {
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(defenderPlayer);
        return townBlock != null && (townBlock.getType().equals(TownBlockType.ARENA) || townBlock.getType().equals(TownBlockType.JAIL));
    }

    private void isJailingAttackers(Player defenderPlayer, Resident attackerResident, Resident defenderResident) {
        if (!TownySettings.isJailingAttackingOutlaws()) {
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(defenderPlayer.getLocation());
        Town attackerTown = attackerResident.getTownOrNull();
        if (!(townBlock != null && townBlock.getType() != TownBlockType.ARENA && attackerResident.hasTown() && !this.alreadyJailed(defenderResident, townBlock) && this.hasJailingNode(attackerResident) && attackerTown.hasJails() && attackerTown.hasOutlaw(defenderResident) && attackerTown.hasTownBlock(townBlock))) {
            return;
        }
        JailUtil.jailResident(defenderResident, attackerTown.getPrimaryJail(), 1, TownySettings.getJailedOutlawJailHours(), JailReason.OUTLAW_DEATH, (CommandSender)attackerResident.getPlayer());
    }

    private boolean hasJailingNode(Resident attackerResident) {
        return attackerResident.hasPermissionNode(PermissionNodes.TOWNY_OUTLAW_JAILER.getNode());
    }

    private boolean alreadyJailed(Resident defenderResident, TownBlock townBlock) {
        boolean jailed = defenderResident.isJailed();
        if (jailed && !townBlock.isJail()) {
            TownyMessaging.sendGlobalMessage(Translatable.of("msg_killed_attempting_to_escape_jail", defenderResident.getName()));
        }
        return jailed;
    }
}

