/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.hooks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.chat.TNCRegister;
import com.palmergames.bukkit.towny.hooks.LuckPermsContexts;
import com.palmergames.bukkit.towny.hooks.TownyPlaceholderExpansion;
import com.palmergames.bukkit.towny.permissions.BukkitPermSource;
import com.palmergames.bukkit.towny.permissions.GroupManagerSource;
import com.palmergames.bukkit.towny.permissions.VaultPermSource;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.util.JavaUtil;
import com.palmergames.util.StringMgmt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginIntegrations {
    private static PluginIntegrations instance;
    private final String[] TOWNYADVANCED_PLUGINS = new String[]{"TownyChat", "TownyFlight", "TownyCultures", "TownyResources", "TownyCombat", "FlagWar", "SiegeWar", "MapTowny", "Dynmap-Towny", "ChestShop-Towny", "mcMMO-Towny", "Towny-TNE", "WorldGuard-Towny"};
    private final String[] SPONSOR_PLUGINS = new String[]{"EventWar", "SiegeConquest", "TownyCamps", "TownyHistories", "TownyRTP", "TownyWayPointTravel", "TownOptionalLWC"};
    private final String NEWLINE_STRING = System.lineSeparator() + "                           ";
    private List<String> warnings = new ArrayList<String>();
    private TownyPlaceholderExpansion papiExpansion = null;
    private LuckPermsContexts luckPermsContexts;
    private boolean citizens2 = false;
    private NamespacedKey eliteKey;

    public static PluginIntegrations getInstance() {
        if (instance == null) {
            instance = new PluginIntegrations();
        }
        return instance;
    }

    public List<String> getTownyPluginsForUniverseCommand() {
        ArrayList<String> out = new ArrayList<String>();
        for (String pluginName : this.TOWNYADVANCED_PLUGINS) {
            this.formatForUniverseCommand(out, pluginName);
        }
        for (String pluginName : this.SPONSOR_PLUGINS) {
            this.formatForUniverseCommand(out, pluginName);
        }
        return out;
    }

    private void formatForUniverseCommand(List<String> out, String pluginName) {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(pluginName);
        if (plugin != null) {
            out.add("\u00a7e" + pluginName + " " + "\u00a72" + plugin.getDescription().getVersion());
        }
    }

    public void checkForPlugins(Towny towny) {
        towny.getLogger().info("Searching for third-party plugins...");
        towny.getLogger().info("Plugins found: ");
        this.detectAndPrintPermissions(towny);
        this.setupAndPrintEconomy(TownySettings.isUsingEconomy());
        this.findSetupAndPrintAddons(towny);
        this.printPluginWarnings();
    }

    private void detectAndPrintPermissions(Towny towny) {
        for (String permissions : this.returnPermissionsProviders(towny).split("\n")) {
            towny.getLogger().info(permissions);
        }
    }

    private void setupAndPrintEconomy(boolean configSetForEconomy) {
        String ecowarn = "No compatible Economy plugins found. Install Vault.jar or Reserve.jar with any of the supported eco systems. If you do not want an economy to be used, set using_economy: false in your Towny config.yml.";
        if (configSetForEconomy && TownyEconomyHandler.setupEconomy()) {
            ecowarn = TownyEconomyHandler.isEssentials() ? "EssentialsX Economy has been known to reset town and nation bank accounts on rare occasions." : "";
            MoneyUtil.checkLegacyDebtAccounts();
        }
        if (TownyEconomyHandler.isActive()) {
            Towny.getPlugin().getLogger().info("  Economy: " + TownyEconomyHandler.getVersion());
        } else if (configSetForEconomy && (this.isPluginPresent("Vault") || this.isPluginPresent("Reserve"))) {
            ecowarn = "No compatible Economy plugins found. If you do not want an economy to be used, set using_economy: false in your Towny config.yml.";
        }
        if (!ecowarn.isEmpty() && configSetForEconomy) {
            this.warnings.add(ecowarn);
        }
    }

    private void findSetupAndPrintAddons(Towny towny) {
        ArrayList<String> addons = new ArrayList<String>();
        for (String townyAdvancedAndSponsorPlugins : this.getTownyPluginsForStartup()) {
            addons.add(townyAdvancedAndSponsorPlugins);
        }
        if (this.isPluginPresent("PlaceholderAPI")) {
            this.enablePAPI(towny);
            this.formatForStartup(addons, "PlaceholderAPI");
        }
        if (this.isPluginPresent("LuckPerms") && TownySettings.isContextsEnabled()) {
            this.enableLuckPermsContexts(towny);
            this.formatForStartup(addons, "LuckPerms");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("TheNewChat")) {
            TNCRegister.initialize();
        }
        this.setCitizens2(Bukkit.getServer().getPluginManager().isPluginEnabled("Citizens"));
        Plugin eliteMobs = Bukkit.getServer().getPluginManager().getPlugin("EliteMobs");
        if (eliteMobs != null) {
            this.eliteKey = new NamespacedKey(eliteMobs, "EliteEntity");
        }
        if (!addons.isEmpty()) {
            towny.getLogger().info("  Add-ons: " + StringMgmt.wrap(String.join((CharSequence)", ", addons), 52, this.NEWLINE_STRING));
        }
    }

    private void printPluginWarnings() {
        if (this.isPluginPresent("Questioner")) {
            this.warnings.add("Questioner.jar present on server, Towny no longer requires Questioner for invites/confirmations. You may safely remove Questioner.jar from your plugins folder.");
        }
        if (this.isPluginPresent("PowerRanks")) {
            this.warnings.add("PowerRanks is incompatible with Towny. PowerRanks will override Towny's ability to give permissions via the townyperms.yml file. You can expect issues with Towny permissions (and other permission providers,) while PowerRanks is installed.");
        }
        if (!this.warnings.isEmpty()) {
            for (String warning : this.warnings) {
                Towny.getPlugin().getLogger().warning(StringMgmt.wrap("  Warning: " + warning, 55, this.NEWLINE_STRING));
            }
            this.warnings.clear();
        }
    }

    private List<String> getTownyPluginsForStartup() {
        ArrayList<String> out = new ArrayList<String>();
        for (String pluginName : this.TOWNYADVANCED_PLUGINS) {
            this.formatForStartup(out, pluginName);
        }
        for (String pluginName : this.SPONSOR_PLUGINS) {
            this.formatForStartup(out, pluginName);
        }
        return out;
    }

    private void formatForStartup(List<String> out, String pluginName) {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(pluginName);
        if (plugin != null) {
            out.add(pluginName + " v" + plugin.getDescription().getVersion());
        }
    }

    private String returnPermissionsProviders(Towny towny) {
        String output = "  Permissions: TownyPerms, ";
        Plugin test = Bukkit.getServer().getPluginManager().getPlugin("GroupManager");
        if (test != null && JavaUtil.classExists("org.anjocaido.groupmanager.GroupManager")) {
            TownyUniverse.getInstance().setPermissionSource(new GroupManagerSource(towny, test));
            output = output + String.format("%s v%s", "GroupManager", test.getDescription().getVersion());
            return output;
        }
        test = Bukkit.getServer().getPluginManager().getPlugin("Vault");
        if (test != null) {
            RegisteredServiceProvider<Chat> chatProvider = this.findChatImplementation();
            RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            if (chatProvider == null) {
                test = null;
            } else {
                TownyUniverse.getInstance().setPermissionSource(new VaultPermSource(towny, (Chat)chatProvider.getProvider()));
                output = permissionProvider != null ? output + permissionProvider.getPlugin().getName() + " v" + permissionProvider.getPlugin().getDescription().getVersion() + " via Vault" : output + String.format("Vault v%s", test.getDescription().getVersion());
                output = output + String.format("\n  Chat: %s v%s via Vault", chatProvider.getPlugin().getName(), chatProvider.getPlugin().getDescription().getVersion());
                return output;
            }
        }
        TownyUniverse.getInstance().setPermissionSource(new BukkitPermSource(towny));
        output = output + "BukkitPermissions";
        return output;
    }

    @Nullable
    private RegisteredServiceProvider<Chat> findChatImplementation() {
        Iterator iterator = Bukkit.getServicesManager().getRegistrations(Chat.class).iterator();
        while (iterator.hasNext()) {
            RegisteredServiceProvider chatProvider = (RegisteredServiceProvider)iterator.next();
            if (chatProvider == null) continue;
            try {
                Field field = Chat.class.getDeclaredField("perms");
                field.setAccessible(true);
                if (field.get(chatProvider.getProvider()) == null) {
                    Towny.getPlugin().getLogger().warning(String.format("WARNING: Plugin %s v%s has an improper Chat implementation, please inform the authors about the following:", chatProvider.getPlugin().getName(), chatProvider.getPlugin().getDescription().getVersion()));
                    Towny.getPlugin().getLogger().warning(String.format("Class '%s' has a null Permission field, which is not supported.", ((Chat)chatProvider.getProvider()).getClass().getName()));
                    if (iterator.hasNext()) continue;
                    return chatProvider;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return chatProvider;
        }
        return null;
    }

    private boolean isPluginPresent(String pluginName) {
        return Bukkit.getServer().getPluginManager().getPlugin(pluginName) != null;
    }

    public void disable3rdPartyPluginIntegrations() {
        this.unregisterLuckPermsContexts();
        this.unloadPAPIExpansion(true);
        this.setCitizens2(false);
    }

    private boolean isPAPI() {
        return this.papiExpansion != null;
    }

    private void enablePAPI(@NotNull Towny towny) {
        this.papiExpansion = new TownyPlaceholderExpansion(towny);
        this.papiExpansion.register();
    }

    public void loadPAPIExpansion(boolean reload) {
        if (reload && this.isPAPI()) {
            this.papiExpansion.register();
        }
    }

    public void unloadPAPIExpansion(boolean reload) {
        if (reload && this.isPAPI()) {
            this.papiExpansion.unregister();
        }
    }

    private void enableLuckPermsContexts(@NotNull Towny towny) {
        this.luckPermsContexts = new LuckPermsContexts(towny);
        this.luckPermsContexts.registerContexts();
    }

    private void unregisterLuckPermsContexts() {
        if (this.luckPermsContexts != null) {
            this.luckPermsContexts.unregisterContexts();
            this.luckPermsContexts = null;
        }
    }

    public boolean checkCitizens(Entity entity) {
        if (this.isCitizens2()) {
            try {
                return CitizensAPI.getNPCRegistry().isNPC(entity);
            }
            catch (NoClassDefFoundError e) {
                this.setCitizens2(false);
            }
        }
        return false;
    }

    private boolean isCitizens2() {
        return this.citizens2;
    }

    public void setCitizens2(boolean b) {
        this.citizens2 = b;
    }

    public boolean checkHostileEliteMobs(Entity entity) {
        return this.isEliteMobsPresent() && entity != null && entity.getPersistentDataContainer().has(this.eliteKey, PersistentDataType.STRING);
    }

    private boolean isEliteMobsPresent() {
        return this.eliteKey != null;
    }
}

