/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.town.toggle;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.CancellableTownyEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TownToggleEvent
extends CancellableTownyEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Town town;
    private final CommandSender sender;
    private final boolean isAdminAction;

    public TownToggleEvent(CommandSender sender, Town town, boolean admin) {
        this.sender = sender;
        this.town = town;
        this.isAdminAction = admin;
        this.setCancelMessage(Translation.of("msg_err_command_disable"));
    }

    @Nullable
    public Resident getResident() {
        Player player = this.getPlayer();
        if (player != null) {
            return TownyUniverse.getInstance().getResident(player.getUniqueId());
        }
        return null;
    }

    @Nullable
    public Player getPlayer() {
        return this.sender instanceof Player ? (Player)this.sender : null;
    }

    public Town getTown() {
        return this.town;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    @Deprecated
    public String getCancellationMsg() {
        return this.getCancelMessage();
    }

    @Deprecated
    public void setCancellationMsg(String cancellationMsg) {
        this.setCancelMessage(cancellationMsg);
    }

    public boolean isAdminAction() {
        return this.isAdminAction;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

