/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.town;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownMayorChosenBySuccessionEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Resident oldMayor;
    private Resident newMayor;
    private final List<Resident> potentialResidents = new ArrayList<Resident>();

    public TownMayorChosenBySuccessionEvent(Resident oldMayor, Resident newMayor, List<Resident> potentialResidents) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.oldMayor = oldMayor;
        this.newMayor = newMayor;
        for (Resident resident : potentialResidents) {
            if (resident == oldMayor) continue;
            this.potentialResidents.add(resident);
        }
    }

    public Resident getOldMayor() {
        return this.oldMayor;
    }

    public Resident getNewMayor() {
        return this.newMayor;
    }

    public void setNewMayor(Resident replacementMayor) {
        this.newMayor = replacementMayor;
    }

    public Town getTown() {
        return TownyAPI.getInstance().getResidentTownOrNull(this.newMayor);
    }

    @Nullable
    public List<Resident> getPotentialMayors() {
        return this.potentialResidents;
    }

    public boolean isNationCapital() {
        return this.getTown().isCapital();
    }

    public boolean isKingChange() {
        return this.oldMayor.isKing();
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

