/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.adventure.text.format.TextColor;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.confirmations.ConfirmationTransaction;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.PreNewTownEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentRankEvent;
import com.palmergames.bukkit.towny.event.TownBlockPermissionChangeEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.event.TownInvitePlayerEvent;
import com.palmergames.bukkit.towny.event.TownPreAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownPreClaimEvent;
import com.palmergames.bukkit.towny.event.TownPreRenameEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentRankEvent;
import com.palmergames.bukkit.towny.event.nation.NationKingChangeEvent;
import com.palmergames.bukkit.towny.event.teleport.OutlawTeleportEvent;
import com.palmergames.bukkit.towny.event.town.TownKickEvent;
import com.palmergames.bukkit.towny.event.town.TownLeaveEvent;
import com.palmergames.bukkit.towny.event.town.TownMayorChangeEvent;
import com.palmergames.bukkit.towny.event.town.TownMergeEvent;
import com.palmergames.bukkit.towny.event.town.TownOutlawAddEvent;
import com.palmergames.bukkit.towny.event.town.TownOutlawRemoveEvent;
import com.palmergames.bukkit.towny.event.town.TownPreInvitePlayerEvent;
import com.palmergames.bukkit.towny.event.town.TownPreMergeEvent;
import com.palmergames.bukkit.towny.event.town.TownPreSetHomeBlockEvent;
import com.palmergames.bukkit.towny.event.town.TownPreUnclaimCmdEvent;
import com.palmergames.bukkit.towny.event.town.TownSetSpawnEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustAddEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustRemoveEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustTownAddEvent;
import com.palmergames.bukkit.towny.event.town.TownTrustTownRemoveEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleExplosionEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleFireEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleMobsEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleNationZoneEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleNeutralEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleOpenEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownTogglePVPEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownTogglePublicEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleTaxPercentEvent;
import com.palmergames.bukkit.towny.event.town.toggle.TownToggleUnknownEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.CancelledEventException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyPermissionChange;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.Translator;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.comparators.ComparatorCaches;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.towny.object.inviteobjects.PlayerJoinTownInvite;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.jail.JailReason;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.MapUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.OutpostUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import com.palmergames.bukkit.towny.utils.TownUtil;
import com.palmergames.bukkit.towny.utils.TownyComponents;
import com.palmergames.bukkit.util.BookFactory;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.io.InvalidObjectException;
import java.lang.invoke.LambdaMetafactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TownCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    @VisibleForTesting
    public static final List<String> townTabCompletes;
    private static final List<String> townSetTabCompletes;
    private static final List<String> townListTabCompletes;
    static final List<String> townToggleTabCompletes;
    private static final List<String> townConsoleTabCompletes;
    static final List<String> townAddRemoveTabCompletes;
    private static final List<String> townClaimTabCompletes;
    public static final List<String> townUnclaimTabCompletes;
    private static final List<String> townInviteTabCompletes;
    private static final List<String> townSetBoardTabCompletes;

    public TownCommand(Towny instance) {
        plugin = instance;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        block143: {
            block142: {
                if (!(sender instanceof Player)) break block142;
                Player player = (Player)sender;
                switch (args[0].toLowerCase()) {
                    case "online": 
                    case "reslist": 
                    case "outlawlist": 
                    case "plots": 
                    case "delete": 
                    case "join": 
                    case "merge": 
                    case "plotgrouplist": 
                    case "allylist": 
                    case "enemylist": 
                    case "baltop": 
                    case "ranklist": {
                        if (args.length == 2) {
                            return TownCommand.getTownyStartingWith(args[1], "t");
                        }
                        break block143;
                    }
                    case "deposit": {
                        if (args.length == 3) {
                            return TownCommand.getTownyStartingWith(args[2], "t");
                        }
                        break block143;
                    }
                    case "spawn": {
                        if (args.length == 2) {
                            List<String> townOrIgnore = TownCommand.getTownyStartingWith(args[1], "t");
                            townOrIgnore.add("-ignore");
                            return NameUtil.filterByStart(townOrIgnore, args[1]);
                        }
                        if (args.length == 3) {
                            List<String> ignore = Collections.singletonList("-ignore");
                            return ignore;
                        }
                    }
                    case "rank": {
                        block58 : switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(townAddRemoveTabCompletes, args[1]);
                            }
                            case 3: {
                                return TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[2]);
                            }
                            case 4: {
                                switch (args[1].toLowerCase()) {
                                    case "add": {
                                        return NameUtil.filterByStart(TownyPerms.getTownRanks(), args[3]);
                                    }
                                    case "remove": {
                                        Resident res = TownyUniverse.getInstance().getResident(args[2]);
                                        if (res == null) break block58;
                                        return res.getTownRanks().isEmpty() ? Collections.emptyList() : NameUtil.filterByStart(res.getTownRanks(), args[3]);
                                    }
                                }
                                return Collections.emptyList();
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "jail": {
                        if (args.length == 2) {
                            List<String> residentOrList = TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[1]);
                            residentOrList.add("list");
                            return NameUtil.filterByStart(residentOrList, args[1]);
                        }
                    }
                    case "unjail": {
                        Resident res;
                        if (args.length == 2 && (res = TownyUniverse.getInstance().getResident(player.getUniqueId())) != null && res.hasTown()) {
                            Town town = res.getTownOrNull();
                            ArrayList<String> jailedResidents = new ArrayList<String>();
                            TownyUniverse.getInstance().getJailedResidentMap().stream().filter(jailee -> jailee.hasJailTown(town.getName())).forEach(jailee -> jailedResidents.add(jailee.getName()));
                            return NameUtil.filterByStart(jailedResidents, args[1]);
                        }
                    }
                    case "outpost": {
                        if (args.length == 2) {
                            return Collections.singletonList("list");
                        }
                        break block143;
                    }
                    case "outlaw": 
                    case "ban": {
                        switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(townAddRemoveTabCompletes, args[1]);
                            }
                            case 3: {
                                switch (args[1].toLowerCase()) {
                                    case "add": {
                                        return TownCommand.getTownyStartingWith(args[2], "r");
                                    }
                                    case "remove": {
                                        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                                        if (resident == null) break;
                                        try {
                                            return NameUtil.filterByStart(NameUtil.getNames(resident.getTown().getOutlaws()), args[2]);
                                        }
                                        catch (TownyException townyException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                return Collections.emptyList();
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "claim": {
                        switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(townClaimTabCompletes, args[1]);
                            }
                            case 3: {
                                if (args[1].equalsIgnoreCase("outpost")) break;
                                return NameUtil.filterByStart(Collections.singletonList("auto"), args[2]);
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "unclaim": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(townUnclaimTabCompletes, args[1]);
                        }
                        break block143;
                    }
                    case "add": {
                        if (args.length == 2) {
                            return this.getVisibleResidentsForPlayerWithoutTownsStartingWith(args[1], sender);
                        }
                        break block143;
                    }
                    case "kick": {
                        if (args.length == 2) {
                            return TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[1]);
                        }
                        break block143;
                    }
                    case "set": {
                        try {
                            Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                            if (res != null) {
                                return TownCommand.townSetTabComplete(sender, res.getTown(), args);
                            }
                        }
                        catch (TownyException res) {
                            // empty catch block
                        }
                        return Collections.emptyList();
                    }
                    case "invite": {
                        switch (args.length) {
                            case 2: {
                                List<String> returnValue = NameUtil.filterByStart(townInviteTabCompletes, args[1]);
                                if (returnValue.size() > 0) {
                                    return returnValue;
                                }
                                if (args[1].startsWith("-")) {
                                    Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                                    if (res == null) {
                                        return null;
                                    }
                                    try {
                                        return NameUtil.filterByStart(res.getTown().getSentInvites().stream().map(Invite::getReceiver).map(Nameable::getName).collect(Collectors.toList()), args[1].substring(1)).stream().map(e -> "-" + e).collect(Collectors.toList());
                                    }
                                    catch (TownyException townyException) {
                                    }
                                } else {
                                    return this.getVisibleResidentsForPlayerWithoutTownsStartingWith(args[1], sender);
                                }
                            }
                            case 3: {
                                switch (args[1].toLowerCase()) {
                                    case "accept": 
                                    case "deny": {
                                        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                                        if (res == null) {
                                            return null;
                                        }
                                        try {
                                            return NameUtil.filterByStart(res.getTown().getReceivedInvites().stream().map(Invite::getSender).map(Nameable::getName).collect(Collectors.toList()), args[2]);
                                        }
                                        catch (TownyException townyException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                return Collections.emptyList();
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "buy": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(Collections.singletonList("bonus"), args[1]);
                        }
                        break block143;
                    }
                    case "toggle": {
                        switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN_TOGGLE, townToggleTabCompletes), args[1]);
                            }
                            case 3: {
                                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                            }
                            case 4: {
                                return TownCommand.getTownResidentNamesOfPlayerStartingWith(player, args[3]);
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "list": {
                        switch (args.length) {
                            case 2: {
                                return Collections.singletonList("by");
                            }
                            case 3: {
                                return NameUtil.filterByStart(townListTabCompletes, args[2]);
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "trust": {
                        switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove", "list"), args[1]);
                            }
                            case 3: {
                                if (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove")) {
                                    return TownCommand.getTownyStartingWith(args[2], "r");
                                }
                                return Collections.emptyList();
                            }
                        }
                        return Collections.emptyList();
                    }
                    case "trusttown": {
                        switch (args.length) {
                            case 2: {
                                return NameUtil.filterByStart(Arrays.asList("add", "remove", "list"), args[1]);
                            }
                            case 3: {
                                if (args[1].equalsIgnoreCase("add")) {
                                    List<String> townsList = TownCommand.getTownyStartingWith(args[2], "t");
                                    townsList.removeAll(TownCommand.getTrustedTownsFromResident(player));
                                    return townsList;
                                }
                                if (args[1].equalsIgnoreCase("remove")) {
                                    return NameUtil.filterByStart(TownCommand.getTrustedTownsFromResident(player), args[2]);
                                }
                                return Collections.emptyList();
                            }
                        }
                        return Collections.emptyList();
                    }
                    default: {
                        if (args.length == 1) {
                            return TownCommand.filterByStartOrGetTownyStartingWith(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN, townTabCompletes), args[0], "t");
                        }
                        if (args.length > 1 && TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN, args[0])) {
                            return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN, args[0]).getTabCompletion(sender, args), args[args.length - 1]);
                        }
                        break block143;
                    }
                }
            }
            if (args.length == 1) {
                return TownCommand.filterByStartOrGetTownyStartingWith(townConsoleTabCompletes, args[0], "t");
            }
        }
        return Collections.emptyList();
    }

    static List<String> townSetTabComplete(CommandSender sender, Town town, String[] args) {
        if (args.length == 2) {
            return NameUtil.filterByStart(TownyCommandAddonAPI.getTabCompletes(TownyCommandAddonAPI.CommandType.TOWN_SET, townSetTabCompletes), args[1]);
        }
        if (args.length > 2) {
            if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, args[1])) {
                return NameUtil.filterByStart(TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, args[1]).getTabCompletion(sender, StringMgmt.remFirstArg(args)), args[args.length - 1]);
            }
            switch (args[1].toLowerCase()) {
                case "mayor": {
                    return NameUtil.filterByStart(NameUtil.getNames(town.getResidents()), args[2]);
                }
                case "perm": {
                    return TownCommand.permTabComplete(StringMgmt.remArgs(args, 2));
                }
                case "tag": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(Collections.singletonList("clear"), args[2]);
                }
                case "title": 
                case "surname": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(NameUtil.getNames(town.getResidents()), args[2]);
                }
                case "board": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(townSetBoardTabCompletes, args[2]);
                }
                case "mapcolor": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(TownySettings.getTownColorsMap().keySet().stream().collect(Collectors.toList()), args[2]);
                }
                default: {
                    return Collections.emptyList();
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (plugin.isError()) {
                TownyMessaging.sendErrorMsg((Object)sender, "Locked in Safe mode!");
                return false;
            }
            try {
                this.parseTownCommand(player, args);
            }
            catch (TownyException te) {
                TownyMessaging.sendErrorMsg(player, te.getMessage((CommandSender)player));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage());
            }
        } else {
            try {
                this.parseTownCommandForConsole(sender, args);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        }
        return true;
    }

    private void parseTownCommandForConsole(CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWN_HELP_CONSOLE.send(sender);
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "list": {
                this.listTowns(sender, split);
                break;
            }
            case "reslist": {
                this.townResList(sender, split);
                break;
            }
            default: {
                if (this.tryTownAddonCommand(sender, split)) {
                    return;
                }
                if (this.tryTownStatusScreen(sender, split)) {
                    return;
                }
                throw new TownyException(Translatable.of("msg_err_invalid_sub"));
            }
        }
    }

    private void parseTownCommand(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            this.townStatusScreen((CommandSender)player, TownCommand.getTownFromPlayerOrThrow(player));
            return;
        }
        if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWN_HELP.send((CommandSender)player);
            return;
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "mayor": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_MAYOR.getNode());
                HelpMenu.TOWN_MAYOR_HELP.send((CommandSender)player);
                break;
            }
            case "here": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_HERE.getNode());
                Town town = TownyAPI.getInstance().getTown(player.getLocation());
                if (town == null) {
                    throw new TownyException(Translatable.of("msg_not_claimed", Coord.parseCoord(player.getLocation())));
                }
                this.townStatusScreen((CommandSender)player, town);
                break;
            }
            case "list": {
                this.listTowns((CommandSender)player, split);
                break;
            }
            case "new": 
            case "create": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_NEW.getNode());
                if (split.length == 1) {
                    throw new TownyException(Translatable.of("msg_specify_name"));
                }
                String townName = String.join((CharSequence)"_", StringMgmt.remFirstArg(split));
                boolean noCharge = TownySettings.getNewTownPrice() == 0.0 || !TownyEconomyHandler.isActive();
                TownCommand.newTown(player, townName, TownCommand.getResidentOrThrow(player), noCharge);
                break;
            }
            case "reclaim": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RECLAIM.getNode());
                if (!TownySettings.getTownRuinsReclaimEnabled()) {
                    throw new TownyException(Translatable.of("msg_err_command_disable"));
                }
                TownRuinUtil.processRuinedTownReclaimRequest(player);
                break;
            }
            case "join": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_JOIN.getNode());
                TownCommand.parseTownJoin((CommandSender)player, StringMgmt.remFirstArg(split));
                break;
            }
            case "leave": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_LEAVE.getNode());
                this.townLeave(player);
                break;
            }
            case "withdraw": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_WITHDRAW.getNode());
                TownyEconomyHandler.economyExecutor().execute(() -> TownCommand.townTransaction(player, StringMgmt.remFirstArg(split), true));
                break;
            }
            case "deposit": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DEPOSIT.getNode());
                TownyEconomyHandler.economyExecutor().execute(() -> TownCommand.townTransaction(player, StringMgmt.remFirstArg(split), false));
                break;
            }
            case "plots": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_PLOTS.getNode());
                this.townPlots((CommandSender)player, split);
                break;
            }
            case "reslist": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RESLIST.getNode());
                this.townResList((CommandSender)player, split);
                break;
            }
            case "plotgrouplist": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_PLOTGROUPLIST.getNode());
                this.townPlotGroupList((CommandSender)player, split);
                break;
            }
            case "outlawlist": {
                this.townOutlawList((CommandSender)player, split);
                break;
            }
            case "allylist": {
                this.townAllyList(player, split);
                break;
            }
            case "enemylist": {
                this.townEnemyList(player, split);
                break;
            }
            case "spawn": {
                boolean ignoreWarning = split.length > 2 && split[2].equals("-ignore");
                TownCommand.townSpawn(player, StringMgmt.remFirstArg(split), false, ignoreWarning);
                break;
            }
            case "rank": {
                this.catchRuinedTown(player);
                this.townRank(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "set": {
                this.catchRuinedTown(player);
                TownCommand.townSet((CommandSender)player, StringMgmt.remFirstArg(split), false, null);
                break;
            }
            case "buy": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_BUY.getNode());
                this.catchRuinedTown(player);
                TownCommand.townBuy((CommandSender)player, StringMgmt.remFirstArg(split), null, false);
                break;
            }
            case "toggle": {
                this.catchRuinedTown(player);
                TownCommand.townToggle((CommandSender)player, StringMgmt.remFirstArg(split), false, null);
                break;
            }
            case "outpost": {
                this.catchRuinedTown(player);
                TownCommand.townOutpost(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "delete": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DELETE.getNode());
                this.catchRuinedTown(player);
                this.townDelete(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "ranklist": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RANKLIST.getNode());
                this.catchRuinedTown(player);
                Town town = split.length > 1 ? TownCommand.getTownOrThrow(split[1]) : TownCommand.getTownFromPlayerOrThrow(player);
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getRanksForTown(town, Translator.locale((CommandSender)player)));
                break;
            }
            case "add": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode());
                this.catchRuinedTown(player);
                TownCommand.townAdd((CommandSender)player, null, StringMgmt.remFirstArg(split));
                break;
            }
            case "invite": 
            case "invites": {
                this.catchRuinedTown(player);
                this.parseInviteCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "kick": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_KICK.getNode());
                this.catchRuinedTown(player);
                TownCommand.townKick(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "claim": {
                this.catchRuinedTown(player);
                TownCommand.parseTownClaimCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "unclaim": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM.getNode());
                this.catchRuinedTown(player);
                TownCommand.parseTownUnclaimCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "takeoverclaim": {
                this.catchRuinedTown(player);
                this.parseTownTakeoverClaimCommand(player);
                break;
            }
            case "online": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_ONLINE.getNode());
                this.catchRuinedTown(player);
                this.parseTownOnlineCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "say": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_SAY.getNode());
                this.catchRuinedTown(player);
                TownyMessaging.sendPrefixedTownMessage(TownCommand.getTownFromPlayerOrThrow(player), TownyComponents.stripClickTags(StringMgmt.join(StringMgmt.remFirstArg(split))));
                break;
            }
            case "outlaw": 
            case "ban": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_OUTLAW.getNode());
                this.catchRuinedTown(player);
                TownCommand.parseTownOutlawCommand((CommandSender)player, StringMgmt.remFirstArg(split), false, TownCommand.getResidentOrThrow(player).getTown());
                break;
            }
            case "bankhistory": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_BANKHISTORY.getNode());
                this.catchRuinedTown(player);
                int pages = 10;
                if (split.length > 1) {
                    pages = MathUtil.getIntOrThrow(split[1]);
                }
                TownCommand.getTownFromPlayerOrThrow(player).generateBankHistoryBook(player, pages);
                break;
            }
            case "merge": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_MERGE.getNode());
                this.catchRuinedTown(player);
                TownCommand.parseTownMergeCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "jail": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_JAIL.getNode());
                this.catchRuinedTown(player);
                TownCommand.parseJailCommand((CommandSender)player, null, StringMgmt.remFirstArg(split), false);
                break;
            }
            case "unjail": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_UNJAIL.getNode());
                this.catchRuinedTown(player);
                TownCommand.parseUnJailCommand((CommandSender)player, null, StringMgmt.remFirstArg(split), false);
                break;
            }
            case "purge": {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_PURGE.getNode());
                this.catchRuinedTown(player);
                this.parseTownPurgeCommand(player, StringMgmt.remFirstArg(split));
                break;
            }
            case "trust": {
                this.catchRuinedTown(player);
                TownCommand.parseTownTrustCommand((CommandSender)player, StringMgmt.remFirstArg(split), null);
                break;
            }
            case "trusttown": {
                this.catchRuinedTown(player);
                TownCommand.parseTownTrustTownCommand((CommandSender)player, StringMgmt.remFirstArg(split), null);
                break;
            }
            case "baltop": {
                this.catchRuinedTown(player);
                Town town = split.length > 1 ? TownCommand.getTownOrThrow(split[1]) : TownCommand.getTownFromPlayerOrThrow(player);
                TownCommand.parseTownBaltop(player, town);
                break;
            }
            default: {
                if (this.tryTownAddonCommand((CommandSender)player, split)) {
                    return;
                }
                if (this.tryTownStatusScreen((CommandSender)player, split)) {
                    return;
                }
                throw new TownyException(Translatable.of("msg_err_invalid_sub"));
            }
        }
    }

    private boolean tryTownStatusScreen(CommandSender sender, String[] split) throws NoPermissionException {
        Town town = TownyUniverse.getInstance().getTown(split[0]);
        if (town != null) {
            Player player;
            if (sender instanceof Player && !town.hasResident((player = (Player)sender).getName())) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_OTHERTOWN.getNode());
            }
            this.townStatusScreen(sender, town);
            return true;
        }
        return false;
    }

    private boolean tryTownAddonCommand(CommandSender sender, String[] split) {
        if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN, split[0]).execute(sender, "town", split);
            return true;
        }
        return false;
    }

    private void catchRuinedTown(Player player) throws TownyException {
        if (TownRuinUtil.isPlayersTownRuined(player)) {
            throw new TownyException(Translatable.of("msg_err_cannot_use_command_because_town_ruined"));
        }
    }

    private void townEnemyList(Player player, String[] split) throws TownyException {
        Town town;
        Town town2 = town = split.length == 1 ? TownCommand.getTownFromPlayerOrThrow(player) : TownCommand.getTownOrThrow(split[1]);
        if (town.getEnemies().isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_town_has_no_enemies"));
        } else {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(town.getName() + " " + Translatable.of("status_nation_enemies").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_enemies").forLocale((CommandSender)player), new ArrayList<TownyObject>(town.getEnemies())));
        }
    }

    private void townAllyList(Player player, String[] split) throws TownyException {
        Town town;
        Town town2 = town = split.length == 1 ? TownCommand.getTownFromPlayerOrThrow(player) : TownCommand.getTownOrThrow(split[1]);
        if (town.getAllies().isEmpty()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_error_town_has_no_allies"));
        } else {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(town.getName() + " " + Translatable.of("status_nation_allies").forLocale((CommandSender)player)));
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_nation_allies").forLocale((CommandSender)player), new ArrayList<TownyObject>(town.getAllies())));
        }
    }

    private void parseTownPurgeCommand(Player player, String[] arg) throws TownyException {
        if (arg.length == 0) {
            HelpMenu.TOWN_PURGE.send((CommandSender)player);
            return;
        }
        Town town = TownCommand.getTownFromPlayerOrThrow(player);
        int days = MathUtil.getIntOrThrow(arg[0]);
        if (days < 1) {
            throw new TownyException(Translatable.of("msg_err_days_must_be_greater_than_0"));
        }
        List<Resident> kickList = TownUtil.gatherInactiveResidents((List<Resident>)town.getResidents(), days);
        if (kickList.isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_no_one_to_purge"));
        }
        Confirmation.runOnAccept(() -> {
            kickList.forEach(Resident::removeTown);
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_purge_complete_x_removed", kickList.size()));
        }).setTitle(Translatable.of("msg_purging_will_remove_the_following_residents", StringMgmt.join(kickList, ", "))).sendTo((CommandSender)player);
    }

    private void parseInviteCommand(Player player, String[] newSplit) throws TownyException {
        Resident resident = TownCommand.getResidentOrThrow(player);
        String received = Translatable.of("town_received_invites").forLocale((CommandSender)player).replace("%a", Integer.toString(resident.getTown().getReceivedInvites().size())).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident.getTown())));
        String sent = Translatable.of("town_sent_invites").forLocale((CommandSender)player).replace("%a", Integer.toString(resident.getTown().getSentInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentInvitesMaxAmount(resident.getTown())));
        if (newSplit.length == 0) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_SEE_HOME.getNode());
            HelpMenu.TOWN_INVITE.send((CommandSender)player);
            TownyMessaging.sendMessage((Object)player, sent);
            TownyMessaging.sendMessage((Object)player, received);
            return;
        }
        if (newSplit.length >= 1) {
            Nation nation;
            Collection invites;
            Town town;
            if (newSplit[0].equalsIgnoreCase("help") || newSplit[0].equalsIgnoreCase("?")) {
                HelpMenu.TOWN_INVITE.send((CommandSender)player);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("sent")) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_LIST_SENT.getNode());
                Collection sentinvites = resident.getTown().getSentInvites();
                int page = 1;
                if (newSplit.length >= 2) {
                    try {
                        page = Integer.parseInt(newSplit[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, (List<Invite>)sentinvites, page, true);
                TownyMessaging.sendMessage((Object)player, sent);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("received")) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_LIST_RECEIVED.getNode());
                Collection receivedinvites = resident.getTown().getReceivedInvites();
                int page = 1;
                if (newSplit.length >= 2) {
                    try {
                        page = Integer.parseInt(newSplit[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, (List<Invite>)receivedinvites, page, false);
                TownyMessaging.sendMessage((Object)player, received);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("accept")) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ACCEPT.getNode());
                town = resident.getTown();
                invites = town.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_town_no_invites"));
                    return;
                }
                if (newSplit.length >= 2) {
                    nation = TownyUniverse.getInstance().getNation(newSplit[1]);
                    if (nation == null) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_town_specify_invite"));
                    InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
                    return;
                }
                Invite toAccept = null;
                for (Invite invite : InviteHandler.getActiveInvites()) {
                    if (!invite.getSender().equals(nation) || !invite.getReceiver().equals(town)) continue;
                    toAccept = invite;
                    break;
                }
                if (toAccept != null) {
                    try {
                        InviteHandler.acceptInvite(toAccept);
                        return;
                    }
                    catch (TownyException | InvalidObjectException e) {
                        plugin.getLogger().log(Level.WARNING, "unknown exception occurred while accepting invite", e);
                    }
                }
            }
            if (newSplit[0].equalsIgnoreCase("deny")) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_DENY.getNode());
                town = resident.getTown();
                invites = town.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_town_no_invites"));
                    return;
                }
                if (newSplit.length >= 2) {
                    nation = TownyUniverse.getInstance().getNation(newSplit[1]);
                    if (nation == null) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_town_specify_invite"));
                    InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
                    return;
                }
                Invite toDecline = null;
                for (Invite invite : InviteHandler.getActiveInvites()) {
                    if (!invite.getSender().equals(nation) || !invite.getReceiver().equals(town)) continue;
                    toDecline = invite;
                    break;
                }
                if (toDecline != null) {
                    try {
                        InviteHandler.declineInvite(toDecline, false);
                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("successful_deny"));
                    }
                    catch (InvalidObjectException e) {
                        plugin.getLogger().log(Level.WARNING, "unknown exception occurred while declining invite", e);
                    }
                }
            } else {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD.getNode());
                TownCommand.townAdd((CommandSender)player, null, newSplit);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseTownOutlawCommand(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        block18: {
            block19: {
                block17: {
                    townyUniverse = TownyUniverse.getInstance();
                    if (split.length != 0) break block17;
                    if (!admin) {
                        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle("/town outlaw"));
                        TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "/town outlaw", "add/remove [name]", ""));
                    } else {
                        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle("/ta town [town] outlaw"));
                        TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "/ta town [town] outlaw", "add/remove [name]", ""));
                    }
                    break block18;
                }
                target = null;
                targetTown = null;
                if (split.length < 2) {
                    throw new TownyException(Translatable.of("msg_usage", new Object[]{"/town outlaw add/remove [name]"}));
                }
                resident = admin == false ? TownCommand.getResidentOrThrow(sender.getName()) : town.getMayor();
                target = townyUniverse.getResident(split[1]);
                if (target == null) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_name", new Object[]{split[1]}));
                    return;
                }
                if (!split[0].equalsIgnoreCase("add")) break block19;
                try {
                    if (target.hasTown()) {
                        targetTown = TownyAPI.getInstance().getResidentTownOrNull(target);
                    }
                    if (resident.getTown().getMayor().equals(target)) {
                        return;
                    }
                    BukkitTools.ifCancelledThenThrow(new TownOutlawAddEvent(sender, target, town));
                    if (targetTown != null && targetTown.getUUID().equals(town.getUUID())) {
                        target.removeTown();
                        outlawer = admin != false ? Translatable.of("admin_sing") : sender.getName();
                        TownyMessaging.sendMsg(target, Translatable.of("msg_kicked_by", new Object[]{outlawer}));
                        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_kicked", new Object[]{outlawer, target.getName()}));
                    }
                    town.addOutlaw(target);
                    town.save();
                    if (target.getPlayer() != null && target.getPlayer().isOnline()) {
                        TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_declared_outlaw", new Object[]{town.getName()}));
                        loc = target.getPlayer().getLocation();
                        if (TownySettings.areNewOutlawsTeleportedAway() && TownyAPI.getInstance().getTownBlock(loc) != null && TownyAPI.getInstance().getTown(loc) == town) {
                            event = new OutlawTeleportEvent(target, town, loc);
                            if (BukkitTools.isEventCancelled(event)) {
                                return;
                            }
                            if (TownySettings.getOutlawTeleportWarmup() > 0) {
                                TownyMessaging.sendMsg(target, Translatable.of("msg_outlaw_kick_cooldown", new Object[]{town, TimeMgmt.formatCountdownTime(TownySettings.getOutlawTeleportWarmup())}));
                            }
                            outlawRes = target;
                            TownCommand.plugin.getScheduler().runLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$parseTownOutlawCommand$6(org.bukkit.Location com.palmergames.bukkit.towny.object.Town com.palmergames.bukkit.towny.object.Resident ), ()V)((Location)loc, (Town)town, (Resident)outlawRes), (long)TownySettings.getOutlawTeleportWarmup() * 20L);
                        }
                    }
                    TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_you_have_declared_an_outlaw", new Object[]{target.getName(), town.getName()}));
                    if (!admin) ** GOTO lbl69
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_you_have_declared_an_outlaw", new Object[]{target.getName(), town.getName()}));
                }
                catch (AlreadyRegisteredException e) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_err_resident_already_an_outlaw"));
                    return;
                }
            }
            if (!split[0].equalsIgnoreCase("remove")) ** GOTO lbl67
            if (town.hasOutlaw(target)) {
                BukkitTools.ifCancelledThenThrow(new TownOutlawRemoveEvent(sender, target, town));
                town.removeOutlaw(target);
                town.save();
                if (target.getPlayer() != null && target.getPlayer().isOnline()) {
                    TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_undeclared_outlaw", new Object[]{town.getName()}));
                }
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_you_have_undeclared_an_outlaw", new Object[]{target.getName(), town.getName()}));
                if (admin) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_you_have_undeclared_an_outlaw", new Object[]{target.getName(), town.getName()}));
                }
            } else {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_err_player_not_an_outlaw"));
                return;
lbl67:
                // 1 sources

                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", new Object[]{split[0]}));
                return;
            }
lbl69:
            // 3 sources

            town.save();
        }
    }

    private void townPlots(CommandSender sender, String[] args) throws TownyException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        Town town = null;
        if (args.length == 1 && player != null) {
            this.catchRuinedTown(player);
            town = TownCommand.getTownFromPlayerOrThrow(player);
        } else {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        Translator translator = Translator.locale(sender);
        if (town == null) {
            throw new TownyException(translator.of("msg_specify_name"));
        }
        ArrayList<String> out = new ArrayList<String>();
        out.add(ChatTools.formatTitle(town + translator.of("msg_town_plots_title")));
        String townSize = translator.of("msg_town_plots_town_size", town.getTownBlocks().size(), town.getMaxTownBlocksAsAString());
        if (!town.hasUnlimitedClaims()) {
            if (TownySettings.isSellingBonusBlocks(town)) {
                townSize = townSize + translator.of("msg_town_plots_town_bought", town.getPurchasedBlocks(), TownySettings.getMaxPurchasedBlocks(town));
            }
            if (town.getBonusBlocks() > 0) {
                townSize = townSize + translator.of("msg_town_plots_town_bonus", town.getBonusBlocks());
            }
            if (TownySettings.getNationBonusBlocks(town) > 0) {
                townSize = townSize + translator.of("msg_town_plots_town_nationbonus", TownySettings.getNationBonusBlocks(town));
            }
        }
        out.add(townSize);
        TownBlockTypeCache typeCache = town.getTownBlockTypeCache();
        out.add(translator.of("msg_town_plots_town_owned_land", town.getTownBlocks().size() - typeCache.getNumberOfResidentOwnedTownBlocks()));
        String typeHeader = translator.of("msg_town_plots_type_header");
        if (TownyEconomyHandler.isActive()) {
            typeHeader = typeHeader + translator.of("msg_town_plots_type_header_revenue");
        }
        out.add(typeHeader);
        for (TownBlockType type : TownBlockTypeHandler.getTypes().values()) {
            int residentOwned = typeCache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.RESIDENTOWNED);
            String plotTypeLine = translator.of("msg_town_plots_type_line", type.getFormattedName(), residentOwned, typeCache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.FORSALE), typeCache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.ALL));
            if (TownyEconomyHandler.isActive()) {
                plotTypeLine = plotTypeLine + translator.of("msg_town_plots_type_line_revenue", TownyEconomyHandler.getFormattedBalance((double)residentOwned * type.getTax(town)));
            }
            out.add(plotTypeLine);
        }
        out.add(Translatable.of("msg_town_plots_revenue_disclaimer").forLocale((CommandSender)player));
        TownyMessaging.sendMessage((Object)sender, out);
    }

    private void parseTownOnlineCommand(Player player, String[] split) throws TownyException {
        Translator translator = Translator.locale((CommandSender)player);
        if (split.length > 0) {
            Town town = TownCommand.getTownOrThrow(split[0]);
            List<Resident> onlineResidents = ResidentUtil.getOnlineResidentsViewable(player, town);
            if (onlineResidents.size() > 0) {
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(translator.of("msg_town_online"), town, player));
            } else {
                TownyMessaging.sendMessage((Object)player, "\u00a7f0 " + translator.of("res_list") + " " + translator.of("msg_town_online") + ": " + town);
            }
        } else {
            TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(translator.of("msg_town_online"), TownCommand.getTownFromPlayerOrThrow(player), player));
        }
    }

    public void listTowns(CommandSender sender, String[] split) throws TownyException {
        boolean console = true;
        Player player = null;
        if (split.length == 2 && split[1].equals("?")) {
            HelpMenu.TOWN_LIST.send(sender);
            return;
        }
        if (sender instanceof Player) {
            console = false;
            player = (Player)sender;
        }
        if (split.length < 2 && !console) {
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_LIST_RESIDENTS.getNode());
        }
        ArrayList<Town> townsToSort = new ArrayList<Town>(TownyUniverse.getInstance().getTowns());
        int page = 1;
        boolean pageSet = false;
        boolean comparatorSet = false;
        ComparatorType type = ComparatorType.RESIDENTS;
        int total = (int)Math.ceil((double)townsToSort.size() / 10.0);
        for (int i = 1; i < split.length; ++i) {
            if (split[i].equalsIgnoreCase("by")) {
                if (comparatorSet) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_multiple_comparators"));
                    return;
                }
                if (++i < split.length) {
                    comparatorSet = true;
                    if (split[i].equalsIgnoreCase("resident")) {
                        split[i] = "residents";
                    }
                    if (!console) {
                        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_LIST.getNode(split[i]));
                    }
                    if (!townListTabCompletes.contains(split[i].toLowerCase())) {
                        throw new TownyException(Translatable.of("msg_error_invalid_comparator_town", townListTabCompletes.stream().filter(comp -> sender.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_LIST.getNode((String)comp))).collect(Collectors.joining(", "))));
                    }
                } else {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_missing_comparator"));
                    return;
                }
                type = ComparatorType.valueOf(split[i].toUpperCase(Locale.ROOT));
                comparatorSet = true;
                continue;
            }
            if (pageSet) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_too_many_pages"));
                return;
            }
            page = MathUtil.getPositiveIntOrThrow(split[i]);
            if (page == 0) {
                throw new TownyException(Translatable.of("msg_error_must_be_int"));
            }
            pageSet = true;
        }
        if (page > total) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("list_err_not_enough_pages", total));
            return;
        }
        int pageNumber = page;
        int totalNumber = total;
        ComparatorType finalType = type;
        try {
            if (!TownySettings.isTownListRandom()) {
                plugin.getScheduler().runAsync(() -> TownyMessaging.sendTownList(sender, ComparatorCaches.getTownListCache(finalType), finalType, pageNumber, totalNumber));
            } else {
                ArrayList<TextComponent> output = new ArrayList<TextComponent>();
                ArrayList<Town> towns = new ArrayList<Town>(TownyUniverse.getInstance().getTowns());
                Collections.shuffle(towns);
                for (Town town : towns) {
                    TextComponent townName = (TextComponent)Component.text(StringMgmt.remUnderscore(town.getName()), (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand("/towny:town spawn " + town + " -ignore"));
                    townName = (TextComponent)townName.append(Component.text(" - ", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text("(" + town.getResidents().size() + ")", (TextColor)NamedTextColor.AQUA)));
                    if (town.isOpen()) {
                        townName = (TextComponent)((TextComponent)townName.append(Component.space())).append(Translatable.of("status_title_open").locale(sender).component());
                    }
                    Translatable spawnCost = Translatable.of("msg_spawn_cost_free");
                    if (TownyEconomyHandler.isActive()) {
                        spawnCost = Translatable.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(town.getSpawnCost()));
                    }
                    townName = (TextComponent)townName.hoverEvent(HoverEvent.showText(Translatable.of("msg_click_spawn", town).append("\n").append(spawnCost).locale(sender).component()));
                    output.add(townName);
                }
                TownyMessaging.sendTownList(sender, output, finalType, pageNumber, totalNumber);
            }
        }
        catch (RuntimeException e) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_error_comparator_failed"));
        }
    }

    public static void townToggle(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWN_TOGGLE_HELP.send(sender);
            return;
        }
        if (!admin) {
            Resident resident = TownCommand.getResidentOrThrow(sender.getName());
            town = resident.getTown();
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_TOGGLE.getNode(split[0].toLowerCase()));
        }
        Optional<Boolean> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "public": {
                TownCommand.townTogglePublic(sender, admin, town, choice);
                break;
            }
            case "pvp": {
                TownCommand.townTogglePVP(sender, split, admin, town, permSource, choice);
                break;
            }
            case "explosion": {
                TownCommand.townToggleExplosion(sender, split, admin, town, choice);
                break;
            }
            case "fire": {
                TownCommand.townToggleFire(sender, split, admin, town, choice);
                break;
            }
            case "mobs": {
                TownCommand.townToggleMobs(sender, split, admin, town, choice);
                break;
            }
            case "taxpercent": {
                TownCommand.townToggleTaxPercent(sender, admin, town, choice);
                break;
            }
            case "open": {
                TownCommand.townToggleOpen(sender, admin, town, choice);
                break;
            }
            case "neutral": 
            case "peaceful": {
                TownCommand.townToggleNeutral(sender, admin, town, permSource, choice);
                break;
            }
            case "nationzone": {
                TownCommand.townToggleNationZone(sender, admin, town, choice);
                break;
            }
            default: {
                if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_TOGGLE, split[0])) {
                    TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_TOGGLE, split[0]).execute(sender, "town", split);
                    return;
                }
                BukkitTools.ifCancelledThenThrow(new TownToggleUnknownEvent(sender, town, admin, split));
            }
        }
        switch (split[0].toLowerCase(Locale.ROOT)) {
            case "pvp": 
            case "explosion": 
            case "fire": 
            case "mobs": {
                for (TownBlock townBlock : town.getTownBlocks()) {
                    if (townBlock.hasResident() || townBlock.isChanged()) continue;
                    townBlock.setType(townBlock.getType());
                    townBlock.save();
                }
                break;
            }
        }
        BukkitTools.fireEvent(new TownBlockSettingsChangedEvent(town));
        town.save();
    }

    private static void townTogglePublic(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        TownTogglePublicEvent preEvent = new TownTogglePublicEvent(sender, town, admin, choice.orElse(!town.isPublic()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setPublic(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_public", town.isPublic() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_public", town.isPublic() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townTogglePVP(CommandSender sender, String[] split, boolean admin, Town town, TownyPermissionSource permSource, Optional<Boolean> choice) throws TownyException {
        String uuid = town.getUUID().toString();
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
            if (TownySettings.getPVPCoolDownTime() > 0 && CooldownTimerTask.hasCooldown(uuid, CooldownTimerTask.CooldownType.PVP) && !permSource.isTownyAdmin((Permissible)sender)) {
                throw new TownyException(Translatable.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(uuid, CooldownTimerTask.CooldownType.PVP)));
            }
            if (TownySettings.getOutsidersPreventPVPToggle() && choice.orElse(!town.isPVP()).booleanValue()) {
                for (Player target : Bukkit.getOnlinePlayers()) {
                    if (town.hasResident(target) || !town.equals(TownyAPI.getInstance().getTown(target.getLocation()))) continue;
                    throw new TownyException(Translatable.of("msg_cant_toggle_pvp_outsider_in_town"));
                }
            }
        }
        TownTogglePVPEvent preEvent = new TownTogglePVPEvent(sender, town, admin, choice.orElse(!town.isPVP()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setPVP(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_pvp", town.getName(), town.isPVP() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_pvp", town.getName(), town.isPVP() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
        if (TownySettings.getPVPCoolDownTime() > 0 && !admin && !permSource.isTownyAdmin((Permissible)sender)) {
            CooldownTimerTask.addCooldownTimer(uuid, CooldownTimerTask.CooldownType.PVP);
        }
    }

    private static void townToggleExplosion(CommandSender sender, String[] split, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
        }
        TownToggleExplosionEvent preEvent = new TownToggleExplosionEvent(sender, town, admin, choice.orElse(!town.isExplosion()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setExplosion(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_expl", town.getName(), town.isExplosion() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_expl", town.getName(), town.isExplosion() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleFire(CommandSender sender, String[] split, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
        }
        TownToggleFireEvent preEvent = new TownToggleFireEvent(sender, town, admin, choice.orElse(!town.isFire()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setFire(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_fire", town.getName(), town.isFire() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_fire", town.getName(), town.isFire() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleMobs(CommandSender sender, String[] split, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (!admin) {
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
        }
        TownToggleMobsEvent preEvent = new TownToggleMobsEvent(sender, town, admin, choice.orElse(!town.hasMobs()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setHasMobs(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_mobs", town.getName(), town.hasMobs() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_mobs", town.getName(), town.hasMobs() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleTaxPercent(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        TownToggleTaxPercentEvent preEvent = new TownToggleTaxPercentEvent(sender, town, admin, choice.orElse(!town.isTaxPercentage()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setTaxPercentage(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_taxpercent", town.isTaxPercentage() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_taxpercent", town.isTaxPercentage() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void townToggleOpen(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (town.isBankrupt()) {
            throw new TownyException(Translatable.of("msg_err_bankrupt_town_cannot_toggle_open"));
        }
        TownToggleOpenEvent preEvent = new TownToggleOpenEvent(sender, town, admin, choice.orElse(!town.isOpen()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setOpen(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_open", town.isOpen() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_open", town.isOpen() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
        if (town.isOpen()) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_toggle_open_on_warning"));
        }
    }

    private static void townToggleNeutral(CommandSender sender, boolean admin, Town town, TownyPermissionSource permSource, Optional<Boolean> choice) throws TownyException {
        String uuid = town.getUUID().toString();
        if (TownySettings.getPeacefulCoolDownTime() > 0 && !admin && !permSource.isTownyAdmin((Permissible)sender) && CooldownTimerTask.hasCooldown(uuid, CooldownTimerTask.CooldownType.NEUTRALITY)) {
            throw new TownyException(Translatable.of("msg_err_cannot_toggle_neutral_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(uuid, CooldownTimerTask.CooldownType.NEUTRALITY)));
        }
        boolean peacefulState = choice.orElse(!town.isNeutral());
        double cost = TownySettings.getTownNeutralityCost(town);
        if (TownySettings.nationCapitalsCantBeNeutral() && town.isCapital()) {
            throw new TownyException(Translatable.of("msg_err_capital_cannot_be_peaceful"));
        }
        if (town.isNeutral() && peacefulState) {
            throw new TownyException(Translatable.of("msg_town_already_peaceful"));
        }
        if (!town.isNeutral() && !peacefulState) {
            throw new TownyException(Translatable.of("msg_town_already_not_peaceful"));
        }
        if (peacefulState && TownyEconomyHandler.isActive() && !town.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_town_cant_peaceful"));
        }
        TownToggleNeutralEvent preEvent = new TownToggleNeutralEvent(sender, town, admin, choice.orElse(!town.isNeutral()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        if (peacefulState && TownyEconomyHandler.isActive() && cost > 0.0) {
            town.getAccount().withdraw(cost, "Peaceful Town Cost");
            TownyMessaging.sendMsg(sender, Translatable.of("msg_you_paid", TownyEconomyHandler.getFormattedBalance(cost)));
        }
        town.setNeutral(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_peaceful", town.isNeutral() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_peaceful", town.isNeutral() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
        if (TownySettings.getPeacefulCoolDownTime() > 0 && !admin && !permSource.isTownyAdmin((Permissible)sender)) {
            CooldownTimerTask.addCooldownTimer(uuid, CooldownTimerTask.CooldownType.NEUTRALITY);
        }
        if (TownyPerms.hasPeacefulNodes()) {
            TownyPerms.updateTownPerms(town);
        }
    }

    private static void townToggleNationZone(CommandSender sender, boolean admin, Town town, Optional<Boolean> choice) throws TownyException {
        if (town.getNationZoneSize() < 1) {
            throw new TownyException(Translatable.of("msg_err_your_town_has_no_nationzone_to_toggle"));
        }
        TownToggleNationZoneEvent preEvent = new TownToggleNationZoneEvent(sender, town, admin, choice.orElse(!town.isNationZoneEnabled()));
        BukkitTools.ifCancelledThenThrow(preEvent);
        town.setNationZoneEnabled(preEvent.getFutureState());
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_changed_nationzone", town.isNationZoneEnabled() ? Translatable.of("enabled") : Translatable.of("disabled")));
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_changed_nationzone", town.isNationZoneEnabled() ? Translatable.of("enabled") : Translatable.of("disabled")));
        }
    }

    private static void parseUnJailCommand(CommandSender sender, Town town, String[] split, boolean admin) throws TownyException {
        if (!admin) {
            town = TownCommand.getTownFromPlayerOrThrow((Player)sender);
        }
        if (split.length != 1) {
            HelpMenu.TOWN_UNJAIL.send(sender);
            return;
        }
        Resident jailedResident = TownyUniverse.getInstance().getResident(split[0]);
        if (jailedResident == null || !jailedResident.isJailed() || jailedResident.isJailed() && !jailedResident.getJail().getTown().equals(town)) {
            throw new TownyException(Translatable.of("msg_player_not_jailed_in_your_town"));
        }
        JailUtil.unJailResident(jailedResident, UnJailReason.PARDONED);
        if (admin) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_resident_unjailed", jailedResident));
        }
    }

    private static void parseJailCommand(CommandSender sender, Town town, String[] split, boolean admin) throws TownyException {
        if (!admin) {
            town = TownCommand.getTownFromPlayerOrThrow((Player)sender);
        }
        if (!town.hasJails()) {
            throw new TownyException(Translatable.of("msg_town_has_no_jails"));
        }
        if (split.length == 0) {
            if (TownySettings.isAllowingBail() && TownyEconomyHandler.isActive()) {
                HelpMenu.TOWN_JAILWITHBAIL.send(sender);
            } else {
                HelpMenu.TOWN_JAIL.send(sender);
            }
            return;
        }
        if (split[0].equalsIgnoreCase("list")) {
            TownCommand.parseJailListCommand(sender, town, StringMgmt.remFirstArg(split));
            return;
        }
        int hours = 2;
        double bail = TownySettings.isAllowingBail() && TownyEconomyHandler.isActive() ? TownySettings.getBailAmount() : 0.0;
        int jailNum = 1;
        int cell = 1;
        Jail jail = town.getPrimaryJail();
        double initialJailFee = TownyEconomyHandler.isActive() && TownySettings.initialJailFee() > 0.0 ? TownySettings.initialJailFee() : 0.0;
        try {
            long time;
            Resident jailedResident = TownCommand.getResidentOrThrow(split[0]);
            if (!town.hasResident(jailedResident)) {
                throw new TownyException(Translatable.of("msg_resident_not_your_town"));
            }
            if (jailedResident.isJailed()) {
                throw new TownyException(Translatable.of("msg_err_resident_is_already_jailed", jailedResident.getName()));
            }
            if (TownySettings.newPlayerJailImmunity() > 0L && (time = jailedResident.getRegistered() + TownySettings.newPlayerJailImmunity() - System.currentTimeMillis()) > 0L) {
                throw new TownyException(Translatable.of("msg_resident_has_not_played_long_enough_to_be_jailed", jailedResident.getName(), TimeMgmt.getFormattedTimeValue(time)));
            }
            if (initialJailFee > 0.0 && !town.getAccount().canPayFromHoldings(initialJailFee)) {
                throw new TownyException(Translatable.of("msg_not_enough_money_in_bank_to_jail_x_fee_is_x", jailedResident, initialJailFee));
            }
            if (!jailedResident.isOnline()) {
                throw new TownyException(Translatable.of("msg_player_is_not_online", jailedResident.getName()));
            }
            Player jailedPlayer = jailedResident.getPlayer();
            if (!admin && jailedPlayer.getUniqueId().equals(((Player)sender).getUniqueId())) {
                throw new TownyException(Translatable.of("msg_no_self_jailing"));
            }
            Town jaileeLocTown = TownyAPI.getInstance().getTown(jailedPlayer.getLocation());
            if (jaileeLocTown != null) {
                if (!TownySettings.canOutlawsTeleportOutOfTowns() && jaileeLocTown.hasOutlaw(jailedResident)) {
                    throw new TownyException(Translatable.of("msg_err_resident_cannot_be_jailed_because_they_are_outlawed_there"));
                }
                if (jaileeLocTown.hasNation() && jailedResident.hasNation() && TownySettings.getDisallowedTownSpawnZones().contains("enemy") && jaileeLocTown.getNationOrNull().hasEnemy(jailedResident.getNationOrNull())) {
                    throw new TownyException(Translatable.of("msg_err_resident_cannot_be_jailed_because_they_are_enemied_there"));
                }
            }
            if (split.length > 1) {
                int offset;
                int n = offset = TownySettings.isAllowingBail() && TownyEconomyHandler.isActive() ? 1 : 0;
                if (!TownCommand.checkArgumentsPassedForJail(sender, split, offset)) {
                    return;
                }
                hours = TownCommand.setJailHours(sender, split);
                if (offset == 1 && split.length >= 3) {
                    bail = TownCommand.setBail(sender, split);
                }
                if (split.length >= 3 + offset && (jail = town.getJail(Integer.valueOf(split[2 + offset]))) == null) {
                    throw new TownyException(Translatable.of("msg_err_the_town_does_not_have_that_many_jails"));
                }
                if (split.length == 4 + offset && !jail.hasJailCell(cell = Integer.valueOf(split[3 + offset]).intValue())) {
                    throw new TownyException(Translatable.of("msg_err_that_jail_plot_does_not_have_that_many_cells"));
                }
            }
            if (TownySettings.getMaxJailedPlayerCount() > 0 && town.getJailedPlayerCount() >= TownySettings.getMaxJailedPlayerCount()) {
                if (TownySettings.getMaxJailedNewJailBehavior() == 0) {
                    throw new TownyException(Translatable.of("msg_town_has_no_jailslots"));
                }
                JailUtil.maxJailedUnjail(town);
            }
            JailUtil.jailResidentWithBail(jailedResident, jail, cell, hours, bail, JailReason.MAYOR, sender);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_player_has_been_sent_to_jail_number", jailedPlayer.getName(), jailNum));
            }
            if (initialJailFee > 0.0) {
                town.getAccount().withdraw(initialJailFee, "New Prisoner fee for " + jailedResident.getName());
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_x_has_been_withdrawn_for_jailing_of_prisoner_x", initialJailFee, jailedResident));
            }
        }
        catch (NullPointerException e) {
            plugin.getLogger().log(Level.WARNING, "while parsing jail command", e);
        }
    }

    private static boolean checkArgumentsPassedForJail(CommandSender sender, String[] split, int offset) {
        try {
            Integer.parseInt(split[1]);
            if (offset == 1 && split.length > 2) {
                Double.parseDouble(split[2]);
            }
            if (split.length > 2 + offset) {
                Integer.parseInt(split[2 + offset]);
            }
            if (split.length > 3 + offset) {
                Integer.parseInt(split[3 + offset]);
            }
        }
        catch (NumberFormatException e) {
            if (offset == 1) {
                HelpMenu.TOWN_JAILWITHBAIL.send(sender);
            } else {
                HelpMenu.TOWN_JAIL.send(sender);
            }
            return false;
        }
        return true;
    }

    private static int setJailHours(CommandSender sender, String[] split) {
        int hours = Math.min(2, Integer.valueOf(split[1]));
        if (hours > TownySettings.getJailedMaxHours()) {
            hours = TownySettings.getJailedMaxHours();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_err_higher_than_max_allowed_hours_x", TownySettings.getJailedMaxHours()));
        }
        return hours;
    }

    private static double setBail(CommandSender sender, String[] split) {
        double bail = Math.min(1.0, Double.valueOf(split[2]));
        if (bail > TownySettings.getBailMaxAmount()) {
            bail = TownySettings.getBailMaxAmount();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_err_higher_than_max_allowed_bail_x", TownySettings.getBailMaxAmount()));
        }
        return bail;
    }

    private static void parseJailListCommand(CommandSender sender, Town town, String[] args) {
        try {
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_JAIL_LIST.getNode());
                Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
                if (resident == null || !resident.hasTown()) {
                    throw new TownyException(Translatable.of("msg_err_must_belong_town"));
                }
            }
            int page = 1;
            int total = (int)Math.ceil((double)town.getJails().size() / 10.0);
            if (args.length == 1 && (page = MathUtil.getPositiveIntOrThrow(args[0])) == 0) {
                throw new TownyException(Translatable.of("msg_error_must_be_int"));
            }
            if (page > total) {
                throw new TownyException(Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
            }
            TownyMessaging.sendJailList(player, town, page, total);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
    }

    private static void toggleTest(Town town, String split) throws TownyException {
        if ((split = split.toLowerCase()).contains("mobs")) {
            if (town.getHomeblockWorld().isForceTownMobs()) {
                throw new TownyException(Translatable.of("msg_world_mobs"));
            }
            if (town.isAdminEnabledMobs()) {
                throw new TownyException(Translatable.of("msg_town_mobs"));
            }
        }
        if (split.contains("fire") && town.getHomeblockWorld().isForceFire()) {
            throw new TownyException(Translatable.of("msg_world_fire"));
        }
        if (split.contains("explosion") && town.getHomeblockWorld().isForceExpl()) {
            throw new TownyException(Translatable.of("msg_world_expl"));
        }
        if (split.contains("pvp") && town.getHomeblockWorld().isForcePVP()) {
            throw new TownyException(Translatable.of("msg_world_pvp"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void townRank(Player player, String[] split) throws TownyException {
        if (split.length == 0) {
            TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle("/town rank"));
            TownyMessaging.sendMessage((Object)player, ChatTools.formatCommand("", "/town rank", "add/remove [resident] rank", ""));
            return;
        }
        Town town = null;
        if (split.length < 3) {
            throw new TownyException("Eg: /town rank add/remove [resident] [rank]");
        }
        Resident target = TownCommand.getResidentOrThrow(split[1]);
        town = TownCommand.getTownFromPlayerOrThrow(player);
        if (town != target.getTown()) {
            throw new TownyException(Translatable.of("msg_resident_not_your_town"));
        }
        String rank = TownyPerms.matchTownRank(split[2]);
        if (rank == null) {
            throw new TownyException(Translatable.of("msg_unknown_rank_available_ranks", split[2], StringMgmt.join(TownyPerms.getTownRanks(), ", ")));
        }
        TownCommand.checkPermOrThrowWithMessage((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(rank.toLowerCase()), Translatable.of("msg_no_permission_to_give_rank"));
        if (split[0].equalsIgnoreCase("add")) {
            if (target.hasTownRank(rank)) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_resident_already_has_rank", target.getName(), Translatable.of("town_sing")));
                return;
            }
            BukkitTools.ifCancelledThenThrow(new TownAddResidentRankEvent(target, rank, town));
            target.addTownRank(rank);
            if (target.isOnline()) {
                TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_been_given_rank", Translatable.of("town_sing"), rank));
                plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_given_rank", Translatable.of("town_sing"), rank, target.getName()));
        } else {
            if (!split[0].equalsIgnoreCase("remove")) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_invalid_property", split[0]));
                return;
            }
            if (!target.hasTownRank(rank)) {
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_resident_doesnt_have_rank", target.getName(), Translatable.of("town_sing")));
                return;
            }
            BukkitTools.ifCancelledThenThrow(new TownRemoveResidentRankEvent(target, rank, town));
            target.removeTownRank(rank);
            if (target.isOnline()) {
                TownyMessaging.sendMsg(target, Translatable.of("msg_you_have_had_rank_taken", Translatable.of("town_sing"), rank));
                plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
            }
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_you_have_taken_rank_from", Translatable.of("town_sing"), rank, target.getName()));
        }
        target.save();
    }

    public static void townSet(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        Resident resident;
        if (split.length == 0) {
            HelpMenu.TOWN_SET.send(sender);
            return;
        }
        Nation nation = null;
        Player player = null;
        if (sender instanceof Player) {
            Player p;
            player = p = (Player)sender;
        }
        if (!admin && player != null) {
            resident = TownCommand.getResidentOrThrow(player);
            town = resident.getTown();
        } else {
            resident = town.getMayor();
        }
        if (town.hasNation()) {
            nation = town.getNationOrNull();
        }
        if (split[0].equalsIgnoreCase("board")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode());
            TownCommand.townSetBoard(sender, String.join((CharSequence)" ", StringMgmt.remFirstArg(split)), town);
        } else if (split[0].equalsIgnoreCase("title")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode());
            TownCommand.townSetTitle(sender, split, admin);
        } else if (split[0].equalsIgnoreCase("taxpercentcap")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TAXPERCENTCAP.getNode());
            TownCommand.townSetTaxPercent(sender, split, town);
        } else if (split[0].equalsIgnoreCase("surname")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode());
            TownCommand.townSetSurname(sender, split, admin);
        } else if (split[0].equalsIgnoreCase("mayor")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_MAYOR.getNode());
            TownCommand.townSetMayor(sender, split, admin, town, resident);
        } else if (split[0].equalsIgnoreCase("taxes")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TAXES.getNode());
            TownCommand.townSetTaxes(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("plottax")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PLOTTAX.getNode());
            TownCommand.townSetPlotTax(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("shoptax")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SHOPTAX.getNode());
            TownCommand.townSetShopTax(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("embassytax")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_EMBASSYTAX.getNode());
            TownCommand.townSetEmbassyTax(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("plotprice")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PLOTPRICE.getNode());
            TownCommand.townSetPlotPrice(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("shopprice")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SHOPPRICE.getNode());
            TownCommand.townSetShopPrice(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("embassyprice")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_EMBASSYPRICE.getNode());
            TownCommand.townSetEmbassyPrice(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("spawncost")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SPAWNCOST.getNode());
            TownCommand.townSetSpawnCost(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("name")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_NAME.getNode());
            TownCommand.townSetName(sender, split, town);
        } else if (split[0].equalsIgnoreCase("tag")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TAG.getNode());
            TownCommand.townSetTag(sender, split, admin, town);
        } else if (split[0].equalsIgnoreCase("homeblock")) {
            TownCommand.catchConsole(sender);
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_HOMEBLOCK.getNode());
            TownCommand.townSetHomeblock(player, town, nation);
        } else if (split[0].equalsIgnoreCase("spawn")) {
            TownCommand.catchConsole(sender);
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SPAWN.getNode());
            TownCommand.townSetSpawn(player, town, admin);
        } else if (split[0].equalsIgnoreCase("outpost")) {
            TownCommand.catchConsole(sender);
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_OUTPOST.getNode());
            TownCommand.townSetOutpost(sender, town, player);
        } else if (split[0].equalsIgnoreCase("perm")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PERM.getNode());
            TownCommand.toggleTest(town, StringMgmt.join(split, " "));
            TownCommand.setTownBlockOwnerPermissions(sender, town, StringMgmt.remFirstArg(split));
        } else if (split[0].equalsIgnoreCase("primaryjail")) {
            TownCommand.catchConsole(sender);
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_PRIMARYJAIL.getNode());
            TownCommand.townSetPrimaryJail(player, town);
        } else if (split[0].equalsIgnoreCase("mapcolor")) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_MAPCOLOR.getNode());
            TownCommand.townSetMapColor(sender, split, town);
        } else if (TownyCommandAddonAPI.hasCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, split[0])) {
            TownyCommandAddonAPI.getAddonCommand(TownyCommandAddonAPI.CommandType.TOWN_SET, split[0]).execute(sender, "town", split);
        } else {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", "town"));
            return;
        }
        town.save();
        if (nation != null) {
            nation.save();
        }
    }

    public static void townSetBoard(CommandSender sender, String board, Town town) throws TownyException {
        if (board.isEmpty()) {
            throw new TownyException("Eg: /town set board " + Translatable.of("town_help_9").forLocale(sender));
        }
        if ("reset".equalsIgnoreCase(board)) {
            board = TownySettings.getTownDefaultBoard();
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_board_reset"));
        } else if ("none".equalsIgnoreCase(board) || "clear".equalsIgnoreCase(board)) {
            board = "";
        } else {
            if (!NameValidation.isValidString(board)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_string_board_not_set"));
                return;
            }
            if (board.length() > 159) {
                board = board.substring(0, 159);
            }
        }
        town.setBoard(board);
        town.save();
        TownyMessaging.sendTownBoard(sender, town);
    }

    @Deprecated
    public static void townSetTitle(CommandSender sender, String[] split, boolean admin, Town town, Resident resident, Player player) throws TownyException {
        TownCommand.townSetTitle(sender, split, admin);
    }

    public static void townSetTitle(@NotNull CommandSender sender, @NotNull String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set title bilbo Jester");
        }
        Resident resident = TownCommand.getResidentOrThrow(split[1]);
        String title = StringMgmt.join(NameValidation.checkAndFilterArray(StringMgmt.remArgs(split, 2)));
        TownCommand.townSetTitle(sender, resident, title, admin);
    }

    public static void townSetTitle(@NotNull CommandSender sender, @NotNull Resident resident, @NotNull String title, boolean admin) throws TownyException {
        Player player;
        boolean sameTown;
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode());
        boolean bl = sameTown = sender instanceof Player && CombatUtil.isSameTown(TownCommand.getResidentOrThrow(player = (Player)sender), resident);
        if (!admin && !sameTown) {
            throw new TownyException(Translatable.of("msg_err_not_same_town", resident.getName()));
        }
        if ((title = NameValidation.filterName(title)).length() > TownySettings.getMaxTitleLength()) {
            throw new TownyException(Translatable.of("msg_err_input_too_long"));
        }
        if (NameValidation.isConfigBlacklistedName(title)) {
            throw new TownyException(Translatable.of("msg_invalid_name"));
        }
        resident.setTitle(title);
        resident.save();
        Translatable message = resident.hasTitle() ? Translatable.of("msg_set_title", resident.getName(), Colors.translateColorCodes(resident.getTitle())) : Translatable.of("msg_clear_title_surname", "Title", resident.getName());
        TownyMessaging.sendPrefixedTownMessage(resident, message);
        if (admin && !sameTown) {
            TownyMessaging.sendMsg(sender, message);
        }
    }

    @Deprecated
    public static void townSetSurname(CommandSender sender, String[] split, boolean admin, Town town, Resident resident, Player player) throws TownyException {
        TownCommand.townSetSurname(sender, split, admin);
    }

    public static void townSetSurname(CommandSender sender, String[] split, boolean admin) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set surname bilbo the dwarf ");
        }
        Resident resident = TownCommand.getResidentOrThrow(split[1]);
        String surname = StringMgmt.join(NameValidation.checkAndFilterArray(StringMgmt.remArgs(split, 2)));
        TownCommand.townSetSurname(sender, resident, surname, admin);
    }

    public static void townSetSurname(@NotNull CommandSender sender, @NotNull Resident resident, @NotNull String surname, boolean admin) throws TownyException {
        Player player;
        boolean sameTown;
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode());
        boolean bl = sameTown = sender instanceof Player && CombatUtil.isSameTown(TownCommand.getResidentOrThrow(player = (Player)sender), resident);
        if (!admin && !sameTown) {
            throw new TownyException(Translatable.of("msg_err_not_same_town", resident.getName()));
        }
        if ((surname = NameValidation.filterName(surname)).length() > TownySettings.getMaxTitleLength()) {
            throw new TownyException(Translatable.of("msg_err_input_too_long"));
        }
        if (NameValidation.isConfigBlacklistedName(surname)) {
            throw new TownyException(Translatable.of("msg_invalid_name"));
        }
        resident.setSurname(surname);
        resident.save();
        Translatable message = resident.hasSurname() ? Translatable.of("msg_set_surname", resident.getName(), Colors.translateColorCodes(resident.getSurname())) : Translatable.of("msg_clear_title_surname", "Surname", resident.getName());
        TownyMessaging.sendPrefixedTownMessage(resident, message);
        if (admin && !sameTown) {
            TownyMessaging.sendMsg(sender, message);
        }
    }

    public static void townSetMayor(CommandSender sender, String[] split, boolean admin, Town town, Resident resident) throws TownyException, NotRegisteredException {
        NationKingChangeEvent nationKingChangeEvent;
        if (split.length < 2) {
            throw new TownyException("Eg: /town set mayor Dumbo");
        }
        if (!admin && !resident.isMayor()) {
            throw new TownyException(Translatable.of("msg_not_mayor"));
        }
        Resident oldMayor = town.getMayor();
        Resident newMayor = TownCommand.getResidentOrThrow(split[1]);
        if (!town.hasResident(split[1])) {
            throw new TownyException(Translatable.of("msg_err_mayor_doesnt_belong_to_town"));
        }
        TownMayorChangeEvent townMayorChangeEvent = new TownMayorChangeEvent(sender, oldMayor, newMayor);
        if (BukkitTools.isEventCancelled(townMayorChangeEvent) && !admin) {
            throw new TownyException(townMayorChangeEvent.getCancelMessage());
        }
        if (town.isCapital() && BukkitTools.isEventCancelled(nationKingChangeEvent = new NationKingChangeEvent(oldMayor, newMayor)) && !admin) {
            throw new TownyException(nationKingChangeEvent.getCancelMessage());
        }
        town.setMayor(newMayor);
        if (oldMayor != null) {
            TownyPerms.assignPermissions(oldMayor, null);
            plugin.deleteCache(oldMayor);
        }
        plugin.deleteCache(newMayor);
        if (admin) {
            town.setHasUpkeep(!newMayor.isNPC());
            TownyMessaging.sendMsg(sender, Translatable.of("msg_new_mayor", newMayor.getName()));
        }
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_new_mayor", newMayor.getName()));
    }

    public static void townSetTaxes(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set taxes 7");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            if (town.isTaxPercentage() && amount > 100.0) {
                throw new TownyException(Translatable.of("msg_err_not_percentage"));
            }
            if (TownySettings.getTownDefaultTaxMinimumTax() > amount) {
                throw new TownyException(Translatable.of("msg_err_tax_minimum_not_met", TownySettings.getTownDefaultTaxMinimumTax()));
            }
            town.setTaxes(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_tax", sender.getName(), town.getTaxes()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_tax", sender.getName(), town.getTaxes()));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetPlotTax(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set plottax 10");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (!TownySettings.isNegativePlotTaxAllowed() && amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            town.setPlotTax(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_plottax", sender.getName(), town.getPlotTax()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_plottax", sender.getName(), town.getPlotTax()));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetShopTax(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set shoptax 10");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (!TownySettings.isNegativePlotTaxAllowed() && amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            town.setCommercialPlotTax(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_alttax", sender.getName(), "shop", town.getCommercialPlotTax()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_alttax", sender.getName(), "shop", town.getCommercialPlotTax()));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetEmbassyTax(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set embassytax 10");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (!TownySettings.isNegativePlotTaxAllowed() && amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            town.setEmbassyPlotTax(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_alttax", sender.getName(), "embassy", town.getEmbassyPlotTax()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_alttax", sender.getName(), "embassy", town.getEmbassyPlotTax()));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetPlotPrice(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set plotprice 50");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            town.setPlotPrice(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_plotprice", sender.getName(), town.getPlotPrice()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_plotprice", sender.getName(), town.getPlotPrice()));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetShopPrice(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set shopprice 50");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            town.setCommercialPlotPrice(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_altprice", sender.getName(), "shop", town.getCommercialPlotPrice()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_altprice", sender.getName(), "shop", town.getCommercialPlotPrice()));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetEmbassyPrice(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set embassyprice 50");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            town.setEmbassyPlotPrice(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_set_altprice", sender.getName(), "embassy", town.getEmbassyPlotPrice()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_altprice", sender.getName(), "embassy", town.getEmbassyPlotPrice()));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetSpawnCost(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set spawncost 50");
        }
        try {
            Double amount = Double.parseDouble(split[1]);
            if (amount < 0.0) {
                throw new TownyException(Translatable.of("msg_err_negative_money"));
            }
            if (TownySettings.getSpawnTravelCost() < amount) {
                throw new TownyException(Translatable.of("msg_err_cannot_set_spawn_cost_more_than", TownySettings.getSpawnTravelCost()));
            }
            town.setSpawnCost(amount);
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_spawn_cost_set_to", sender.getName(), Translatable.of("town_sing"), split[1]));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_spawn_cost_set_to", sender.getName(), Translatable.of("town_sing"), split[1]));
        }
        catch (NumberFormatException e) {
            throw new TownyException(Translatable.of("msg_error_must_be_num"));
        }
    }

    public static void townSetName(CommandSender sender, String[] split, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set name BillyBobTown");
        }
        String name = String.join((CharSequence)"_", StringMgmt.remFirstArg(split));
        if (NameValidation.isBlacklistName(name) || TownyUniverse.getInstance().hasTown(name) || !TownySettings.areNumbersAllowedInTownNames() && NameValidation.containsNumbers(name)) {
            throw new TownyException(Translatable.of("msg_invalid_name"));
        }
        if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
            name = StringMgmt.capitalizeStrings(name);
        }
        if (TownyEconomyHandler.isActive() && TownySettings.getTownRenameCost() > 0.0) {
            if (!town.getAccount().canPayFromHoldings(TownySettings.getTownRenameCost())) {
                throw new TownyException(Translatable.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(TownySettings.getTownRenameCost())));
            }
            Town finalTown = town;
            String finalName = name;
            Confirmation.runOnAccept(() -> TownCommand.townRename(sender, finalTown, finalName)).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getTownRenameCost()))).sendTo(sender);
        } else {
            TownCommand.townRename(sender, town, name);
        }
    }

    public static void townSetTag(CommandSender sender, String[] split, boolean admin, Town town) throws TownyException, InvalidNameException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set tag PLTC");
        }
        if (split[1].equalsIgnoreCase("clear")) {
            town.setTag(" ");
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_reset_town_tag", sender.getName()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_reset_town_tag", sender.getName()));
        } else {
            if (split[1].length() > TownySettings.getMaxTagLength()) {
                throw new TownyException(Translatable.of("msg_err_tag_too_long"));
            }
            town.setTag(NameValidation.checkAndFilterName(split[1]));
            if (admin) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_set_town_tag", sender.getName(), town.getTag()));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_set_town_tag", sender.getName(), town.getTag()));
        }
    }

    public static void townSetHomeblock(Player player, Town town, @Nullable Nation nation) throws TownyException {
        double distance;
        Coord coord = Coord.parseCoord((Entity)player);
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null || townBlock == null || !townBlock.hasTown() || townBlock.getTownOrNull() != town) {
            throw new TownyException(Translatable.of("msg_area_not_own"));
        }
        if (TownySettings.getHomeBlockMovementCooldownHours() > 0 && town.getMovedHomeBlockAt() > 0L && TimeTools.getHours(System.currentTimeMillis() - town.getMovedHomeBlockAt()) < TownySettings.getHomeBlockMovementCooldownHours()) {
            long timeRemaining = town.getMovedHomeBlockAt() + TimeTools.getMillis(TownySettings.getHomeBlockMovementCooldownHours() + "h") - System.currentTimeMillis();
            throw new TownyException(Translatable.of("msg_err_you_have_moved_your_homeblock_too_recently_wait_x", TimeMgmt.getFormattedTimeValue(timeRemaining)));
        }
        if (town.hasHomeBlock() && town.getHomeBlock().getWorldCoord().equals(townBlock.getWorldCoord())) {
            throw new TownyException(Translatable.of("msg_err_homeblock_already_set_here"));
        }
        if (world.hasTowns() && TownySettings.getMinDistanceFromTownHomeblocks() > 0 || TownySettings.getMaxDistanceBetweenHomeblocks() > 0 || TownySettings.getMinDistanceBetweenHomeblocks() > 0) {
            int distanceToNextNearestHomeblock = world.getMinDistanceFromOtherTownsHomeBlocks(coord, town);
            if (distanceToNextNearestHomeblock < TownySettings.getMinDistanceFromTownHomeblocks() || distanceToNextNearestHomeblock < TownySettings.getMinDistanceBetweenHomeblocks()) {
                throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
            }
            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && distanceToNextNearestHomeblock > TownySettings.getMaxDistanceBetweenHomeblocks()) {
                throw new TownyException(Translatable.of("msg_too_far"));
            }
        }
        if (TownySettings.getHomeBlockMovementDistanceInTownBlocks() > 0 && (distance = MathUtil.distance(town.getHomeBlock().getCoord(), townBlock.getCoord())) > (double)TownySettings.getHomeBlockMovementDistanceInTownBlocks()) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_move_your_homeblock_this_far_limit_is_x_you_are_x", TownySettings.getHomeBlockMovementDistanceInTownBlocks(), Math.floor(distance)));
        }
        BukkitTools.ifCancelledThenThrow(new TownPreSetHomeBlockEvent(town, townBlock, player));
        if (nation != null && TownySettings.getNationRequiresProximity() > 0.0 && town.isCapital()) {
            List<Town> removedTowns = nation.gatherOutOfRangeTowns(nation.getTowns(), town);
            if (!removedTowns.isEmpty()) {
                Town finalTown = town;
                TownBlock finalTB = townBlock;
                Nation finalNation = nation;
                Location playerLocation = player.getLocation();
                Confirmation.runOnAccept(() -> {
                    finalTown.setHomeBlock(finalTB);
                    finalTown.setSpawn(playerLocation);
                    town.setMovedHomeBlockAt(System.currentTimeMillis());
                    finalNation.removeOutOfRangeTowns();
                    TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_town_home", coord.toString()));
                }).setTitle(Translatable.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", "))).sendTo((CommandSender)player);
            } else {
                town.setHomeBlock(townBlock);
                town.setSpawn(player.getLocation());
                town.setMovedHomeBlockAt(System.currentTimeMillis());
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_town_home", coord.toString()));
            }
        } else {
            town.setHomeBlock(townBlock);
            town.setSpawn(player.getLocation());
            town.setMovedHomeBlockAt(System.currentTimeMillis());
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_town_home", coord.toString()));
        }
    }

    public static void townSetSpawn(Player player, Town town, boolean admin) throws TownyException {
        if (!town.hasHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_homeblock_has_not_been_set"));
        }
        TownSetSpawnEvent event = new TownSetSpawnEvent(town, player, player.getLocation());
        if (BukkitTools.isEventCancelled(event) && !admin && !event.getCancelMessage().isEmpty()) {
            throw new TownyException(event.getCancelMessage());
        }
        Location newSpawn = admin ? player.getLocation() : event.getNewSpawn();
        TownBlock tb = TownyAPI.getInstance().getTownBlock(newSpawn);
        if (!(tb != null && tb.hasTown() && tb.getTownOrNull().equals(town) && town.getHomeBlock().getWorldCoord().equals(tb.getWorldCoord()))) {
            throw new TownyException(Translatable.of("msg_err_spawn_not_within_homeblock"));
        }
        if (town.getSpawnOrNull() != null) {
            TownyUniverse.getInstance().removeSpawnPoint(town.getSpawnOrNull());
        }
        town.setSpawn(newSpawn);
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_set_town_spawn"));
    }

    public static void townSetOutpost(CommandSender sender, Town town, Player player) throws TownyException {
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(player);
        if (townBlock == null || !townBlock.hasTown() || !townBlock.isOutpost()) {
            throw new TownyException(Translatable.of("msg_err_location_is_not_within_an_outpost_plot"));
        }
        if (!townBlock.getTownOrNull().equals(town)) {
            throw new TownyException(Translatable.of("msg_not_own_area"));
        }
        town.addOutpostSpawn(player.getLocation());
        TownyMessaging.sendMsg(sender, Translatable.of("msg_set_outpost_spawn"));
    }

    public static void townSetPrimaryJail(Player player, Town town) throws TownyException {
        TownBlock tb = TownyAPI.getInstance().getTownBlock(player);
        if (tb == null || !tb.isJail()) {
            throw new TownyException(Translatable.of("msg_err_location_is_not_within_a_jail_plot"));
        }
        Jail jail = tb.getJail();
        town.setPrimaryJail(jail);
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_primary_jail_set_for_town"));
    }

    public static void townSetMapColor(CommandSender sender, String[] split, Town town) throws TownyException {
        if (split.length < 2) {
            throw new TownyException("Eg: /town set mapcolor brown.");
        }
        String color = StringMgmt.join(StringMgmt.remFirstArg(split), " ").toLowerCase(Locale.ROOT);
        if (!TownySettings.getTownColorsMap().containsKey(color)) {
            throw new TownyException(Translatable.of("msg_err_invalid_nation_map_color", TownySettings.getTownColorsMap().keySet().toString()));
        }
        if (TownySettings.getTownSetMapColourCost() > 0.0) {
            Confirmation.runOnAccept(() -> TownCommand.setTownMapColor(town, color)).setTitle(Translatable.of("msg_confirm_purchase", TownySettings.getTownSetMapColourCost())).setCost(new ConfirmationTransaction(() -> TownySettings.getTownSetMapColourCost(), town.getAccount(), "Cost of setting town map color.")).sendTo(sender);
        } else {
            TownCommand.setTownMapColor(town, color);
        }
    }

    private static void setTownMapColor(Town town, String color) {
        town.setMapColorHexCode(TownySettings.getTownColorsMap().get(color));
        town.save();
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_map_color_changed", color));
    }

    public static void townSetTaxPercent(CommandSender sender, String[] split, Town town) throws TownyException {
        if (!town.isTaxPercentage()) {
            throw new TownyException(Translatable.of("msg_max_tax_amount_only_for_percent"));
        }
        if (split.length < 2) {
            throw new TownyException("Eg. /town set taxpercentcap 10000");
        }
        town.setMaxPercentTaxAmount(Double.parseDouble(split[1]));
        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_tax_max_percent_amount", sender.getName(), TownyEconomyHandler.getFormattedBalance(town.getMaxPercentTaxAmount())));
    }

    private static void parseTownBaltop(Player player, Town town) {
        plugin.getScheduler().runAsync(() -> {
            StringBuilder sb = new StringBuilder();
            ArrayList<Resident> residents = new ArrayList<Resident>(town.getResidents());
            residents.sort(Comparator.comparingDouble(res -> res.getAccount().getCachedBalance()).reversed());
            int i = 0;
            for (Resident res2 : residents) {
                sb.append(Translatable.of("msg_baltop_book_format", ++i, res2.getName(), TownyEconomyHandler.getFormattedBalance(res2.getAccount().getCachedBalance())).forLocale((CommandSender)player) + "\n");
            }
            ItemStack book = BookFactory.makeBook("Town Baltop", town.getName(), sb.toString());
            plugin.getScheduler().run((Entity)player, () -> player.openBook(book));
        });
    }

    public static void townBuy(CommandSender sender, String[] split, @Nullable Town town, boolean admin) throws TownyException {
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translatable.of("msg_err_no_economy"));
        }
        if (town == null && sender instanceof Player) {
            Player player = (Player)sender;
            town = TownCommand.getTownFromPlayerOrThrow(player);
        }
        if (!TownySettings.isSellingBonusBlocks(town) && !TownySettings.isBonusBlocksPerTownLevel()) {
            throw new TownyException("Config.yml has bonus blocks diabled at max_purchased_blocks: '0' ");
        }
        if (TownySettings.isBonusBlocksPerTownLevel() && TownySettings.getMaxBonusBlocks(town) == 0) {
            throw new TownyException("Config.yml has bonus blocks disabled at town_level section: townBlockBonusBuyAmount: 0");
        }
        if (split.length == 0 || !split[0].equalsIgnoreCase("bonus")) {
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle("/town buy"));
            String line = "\u00a7e[Purchased Bonus] \u00a72Cost: \u00a7a%s\u00a78 | \u00a72Max: \u00a7a%d";
            TownyMessaging.sendMessage((Object)sender, String.format(line, TownyEconomyHandler.getFormattedBalance(town.getBonusBlockCost()), TownySettings.getMaxPurchasedBlocks(town)));
            if (TownySettings.getPurchasedBonusBlocksIncreaseValue() != 1.0) {
                TownyMessaging.sendMessage((Object)sender, "\u00a72Cost Increase per TownBlock: \u00a7a+" + new DecimalFormat("##.##%").format(TownySettings.getPurchasedBonusBlocksIncreaseValue() - 1.0));
            }
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "/town buy", "bonus [n]", ""));
            return;
        }
        if (split.length != 2) {
            throw new TownyException(Translatable.of("msg_must_specify_amnt", "/town buy bonus"));
        }
        TownCommand.townBuyBonusTownBlocks(town, MathUtil.getIntOrThrow(split[1].trim()), sender);
    }

    public static void townBuyBonusTownBlocks(Town town, int inputN, CommandSender sender) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translatable.of("msg_err_negative"));
        }
        int current = town.getPurchasedBlocks();
        int n = current + inputN > TownySettings.getMaxPurchasedBlocks(town) ? TownySettings.getMaxPurchasedBlocks(town) - current : inputN;
        if (n == 0) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_purchase_any_more_bonus_blocks"));
        }
        double cost = town.getBonusBlockCostN(n);
        if (!town.getAccount().canPayFromHoldings(cost)) {
            throw new TownyException(Translatable.of("msg_no_funds_to_buy", n, Translatable.of("bonus_townblocks"), TownyEconomyHandler.getFormattedBalance(cost)));
        }
        Confirmation.runOnAccept(() -> {
            town.addPurchasedBlocks(n);
            TownyMessaging.sendMsg(sender, Translatable.of("msg_buy", n, Translatable.of("bonus_townblocks"), TownyEconomyHandler.getFormattedBalance(cost)));
            town.save();
        }).setCost(new ConfirmationTransaction(() -> cost, town.getAccount(), String.format("Town Buy Bonus (%d)", n), Translatable.of("msg_no_funds_to_buy", n, Translatable.of("bonus_townblocks"), TownyEconomyHandler.getFormattedBalance(cost)))).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(cost))).sendTo(sender);
    }

    public static void newTown(Player player, String name, Resident resident, boolean noCharge) throws TownyException {
        if (TownySettings.hasTownLimit() && TownyUniverse.getInstance().getTowns().size() >= TownySettings.getTownLimit()) {
            throw new TownyException(Translatable.of("msg_err_universe_limit"));
        }
        if (!resident.isAdmin() && CooldownTimerTask.hasCooldown(player.getName(), CooldownTimerTask.CooldownType.TOWN_DELETE)) {
            throw new TownyException(Translatable.of("msg_err_cannot_create_new_town_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(player.getName(), CooldownTimerTask.CooldownType.TOWN_DELETE)));
        }
        name = TownCommand.filterNameOrThrow(name);
        if (resident.hasTown()) {
            throw new TownyException(Translatable.of("msg_err_already_res", resident.getName()));
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null || !world.isUsingTowny()) {
            throw new TownyException(Translatable.of("msg_set_use_towny_off"));
        }
        if (!world.isClaimable()) {
            throw new TownyException(Translatable.of("msg_not_claimable"));
        }
        Location spawnLocation = player.getLocation();
        Coord key = Coord.parseCoord((Entity)player);
        if (!TownyAPI.getInstance().isWilderness(spawnLocation)) {
            throw new TownyException(Translatable.of("msg_already_claimed_1", key));
        }
        if (world.hasTowns()) {
            TownCommand.testDistancesOrThrow(world, key);
        }
        if (noCharge || !TownyEconomyHandler.isActive()) {
            BukkitTools.ifCancelledThenThrow(new PreNewTownEvent(player, name, spawnLocation));
            TownCommand.newTown(world, name, resident, key, spawnLocation, player);
            TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_town", player.getName(), StringMgmt.remUnderscore(name)));
            return;
        }
        if (!resident.getAccount().canPayFromHoldings(TownySettings.getNewTownPrice())) {
            throw new TownyException(Translatable.of("msg_no_funds_new_town2", resident.getName().equals(player.getName()) ? Translatable.of("msg_you") : resident.getName(), TownySettings.getNewTownPrice()));
        }
        String finalName = name;
        Confirmation.runOnAccept(() -> {
            try {
                TownCommand.newTown(world, finalName, resident, key, spawnLocation, player);
                TownyMessaging.sendGlobalMessage(Translatable.of("msg_new_town", player.getName(), StringMgmt.remUnderscore(finalName)));
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                plugin.getLogger().log(Level.WARNING, "An exception occurred while creating a new town", e);
            }
        }).setCancellableEvent(new PreNewTownEvent(player, name, spawnLocation)).setTitle(Translatable.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getNewTownPrice()))).setCost(new ConfirmationTransaction(TownySettings::getNewTownPrice, resident.getAccount(), "New Town Cost", Translatable.of("msg_no_funds_new_town2", resident.getName().equals(player.getName()) ? Translatable.of("msg_you") : resident.getName(), TownySettings.getNewTownPrice()))).sendTo((CommandSender)player);
    }

    public static Town newTown(TownyWorld world, String name, Resident resident, Coord key, Location spawn, Player player) throws TownyException {
        TownyUniverse.getInstance().newTown(name);
        Town town = TownyUniverse.getInstance().getTown(name);
        if (town == null) {
            throw new TownyException(String.format("Error fetching new town from name '%s'", name));
        }
        TownBlock townBlock = new TownBlock(key.getX(), key.getZ(), world);
        townBlock.setTown(town);
        TownPreClaimEvent preClaimEvent = new TownPreClaimEvent(town, townBlock, player, false, true);
        preClaimEvent.setCancelMessage(Translation.of("msg_claim_error", 1, 1));
        if (BukkitTools.isEventCancelled(preClaimEvent)) {
            TownyUniverse.getInstance().removeTownBlock(townBlock);
            TownyUniverse.getInstance().unregisterTown(town);
            town = null;
            townBlock = null;
            throw new TownyException(preClaimEvent.getCancelMessage());
        }
        town.setRegistered(System.currentTimeMillis());
        town.setMapColorHexCode(MapUtil.generateRandomTownColourAsHexCode());
        resident.setTown(town);
        town.setMayor(resident, false);
        town.setFounder(resident.getName());
        townBlock.setType(townBlock.getType());
        town.setSpawn(spawn);
        if (resident.isNPC()) {
            town.setHasUpkeep(false);
        }
        if (world.isUsingPlotManagementRevert()) {
            PlotBlockData plotChunk = TownyRegenAPI.getPlotChunk(townBlock);
            if (plotChunk != null && TownyRegenAPI.getRegenQueueList().contains(townBlock.getWorldCoord())) {
                TownyRegenAPI.removeFromActiveRegeneration(plotChunk);
                TownyRegenAPI.removeFromRegenQueueList(townBlock.getWorldCoord());
                TownyRegenAPI.addPlotChunkSnapshot(plotChunk);
            } else {
                TownyRegenAPI.handleNewSnapshot(townBlock);
            }
        }
        if (TownyEconomyHandler.isActive()) {
            TownyMessaging.sendDebugMsg("Creating new Town account: " + TownySettings.getTownAccountPrefix() + name);
            try {
                town.getAccount().setBalance(0.0, "Setting 0 balance for Town");
            }
            catch (NullPointerException e1) {
                throw new TownyException("The server economy plugin " + TownyEconomyHandler.getVersion() + " could not return the Town account!");
            }
        }
        if (TownySettings.isTownTagSetAutomatically()) {
            town.setTag(name.substring(0, Math.min(name.length(), TownySettings.getMaxTagLength())).replace("_", "").replace("-", ""));
        }
        resident.save();
        townBlock.save();
        town.save();
        world.save();
        plugin.updateCache(townBlock.getWorldCoord());
        BukkitTools.fireEvent(new NewTownEvent(town));
        return town;
    }

    private static void testDistancesOrThrow(TownyWorld world, Coord key) throws TownyException {
        if (TownySettings.getMinDistanceFromTownPlotblocks() > 0 || TownySettings.getNewTownMinDistanceFromTownPlots() > 0) {
            int minDistance = TownySettings.getNewTownMinDistanceFromTownPlots();
            if (minDistance <= 0) {
                minDistance = TownySettings.getMinDistanceFromTownPlotblocks();
            }
            if (world.getMinDistanceFromOtherTownsPlots(key) < minDistance) {
                throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("townblock")));
            }
        }
        if (TownySettings.getMinDistanceFromTownHomeblocks() > 0 || TownySettings.getMaxDistanceBetweenHomeblocks() > 0 || TownySettings.getMinDistanceBetweenHomeblocks() > 0 || TownySettings.getNewTownMinDistanceFromTownHomeblocks() > 0) {
            int distanceToNextNearestHomeblock = world.getMinDistanceFromOtherTownsHomeBlocks(key);
            int minDistance = TownySettings.getNewTownMinDistanceFromTownHomeblocks();
            if (minDistance <= 0) {
                minDistance = TownySettings.getMinDistanceFromTownHomeblocks();
            }
            if (distanceToNextNearestHomeblock < minDistance || distanceToNextNearestHomeblock < TownySettings.getMinDistanceBetweenHomeblocks()) {
                throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
            }
            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && TownyUniverse.getInstance().getTowns().size() > 0 && distanceToNextNearestHomeblock > TownySettings.getMaxDistanceBetweenHomeblocks()) {
                throw new TownyException(Translatable.of("msg_too_far"));
            }
        }
    }

    private static String filterNameOrThrow(String name) throws TownyException {
        String filteredName;
        if (TownySettings.getTownAutomaticCapitalisationEnabled()) {
            name = StringMgmt.capitalizeStrings(name);
        }
        try {
            filteredName = NameValidation.checkAndFilterName(name);
        }
        catch (InvalidNameException e) {
            filteredName = null;
        }
        if (filteredName == null || TownyUniverse.getInstance().hasTown(filteredName) || !TownySettings.areNumbersAllowedInTownNames() && NameValidation.containsNumbers(filteredName)) {
            throw new TownyException(Translatable.of("msg_err_invalid_name", name));
        }
        name = filteredName;
        return name;
    }

    public static void townRename(CommandSender sender, Town town, String newName) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        String uuid = town.getUUID().toString();
        if (CooldownTimerTask.hasCooldown(uuid, CooldownTimerTask.CooldownType.TOWN_RENAME)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_you_must_wait_x_seconds_before_renaming_your_town", CooldownTimerTask.getCooldownRemaining(uuid, CooldownTimerTask.CooldownType.TOWN_RENAME)));
            return;
        }
        TownPreRenameEvent event = new TownPreRenameEvent(town, newName);
        if (BukkitTools.isEventCancelled(event)) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_rename_cancelled"));
            return;
        }
        double renameCost = TownySettings.getTownRenameCost();
        if (TownyEconomyHandler.isActive() && renameCost > 0.0 && !town.getAccount().withdraw(renameCost, String.format("Town renamed to: %s", newName))) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(renameCost)));
            return;
        }
        CooldownTimerTask.addCooldownTimer(uuid, CooldownTimerTask.CooldownType.TOWN_RENAME);
        try {
            townyUniverse.getDataSource().renameTown(town, newName);
            town = townyUniverse.getTown(newName);
            if (town == null) {
                throw new TownyException("Error renaming town! Cannot fetch town with new name " + newName);
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_town_set_name", sender.getName(), town.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
    }

    public void townLeave(Player player) throws TownyException {
        Resident resident = TownCommand.getResidentOrThrow(player);
        Town town = TownCommand.getTownFromResidentOrThrow(resident);
        if (resident.isMayor()) {
            throw new TownyException(Translatable.of("msg_mayor_abandon"));
        }
        if (resident.isJailed() && TownySettings.JailDeniesTownLeave() && resident.getJailTown().getName().equals(town.getName())) {
            throw new TownyException(Translatable.of("msg_cannot_abandon_town_while_jailed"));
        }
        Confirmation.runOnAccept(() -> {
            if (resident.isJailed() && resident.getJailTown().getUUID().equals(town.getUUID())) {
                JailUtil.unJailResident(resident, UnJailReason.LEFT_TOWN);
            }
            if (town.hasResident(resident)) {
                resident.removeTown();
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_left_town", resident.getName()));
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_left_town", resident.getName()));
            TownCommand.checkTownResidents(town);
        }).setCancellableEvent(new TownLeaveEvent(resident, town)).sendTo((CommandSender)player);
    }

    public static void townSpawn(Player player, String[] split, Boolean outpost, boolean ignoreWarning) throws TownyException {
        String notAffordMSG;
        Town town;
        if (split.length == 1 && split[0].equals("-ignore") || split.length > 1 && split[1].equals("-ignore")) {
            ignoreWarning = true;
        }
        if (split.length == 0 || outpost.booleanValue() || split[0].equals("-ignore")) {
            town = TownCommand.getTownFromPlayerOrThrow(player);
            notAffordMSG = Translatable.of("msg_err_cant_afford_tp").forLocale((CommandSender)player);
        } else {
            town = TownCommand.getTownOrThrow(split[0]);
            notAffordMSG = Translatable.of("msg_err_cant_afford_tp_town", town.getName()).forLocale((CommandSender)player);
        }
        SpawnUtil.sendToTownySpawn(player, split, town, notAffordMSG, outpost, ignoreWarning, SpawnType.TOWN);
    }

    public void townDelete(Player player, String[] split) throws TownyException {
        Town town;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Town town2 = town = split.length == 0 ? TownCommand.getTownFromPlayerOrThrow(player) : TownCommand.getTownOrThrow(split[0]);
        if (split.length == 0 || town.hasResident(player) && townyUniverse.getPermissionSource().testPermission((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DELETE.getNode())) {
            if (TownySettings.getTownRuinsEnabled()) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_warning_town_ruined_if_deleted", TownySettings.getTownRuinsMaxDurationHours()));
                if (TownySettings.getTownRuinsReclaimEnabled()) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_warning_town_ruined_if_deleted2", TownySettings.getTownRuinsMinDurationHours()));
                }
            }
            Confirmation.runOnAccept(() -> {
                townyUniverse.getDataSource().removeTown(town);
                if (TownySettings.getTownUnclaimCoolDownTime() > 0) {
                    CooldownTimerTask.addCooldownTimer(player.getName(), CooldownTimerTask.CooldownType.TOWN_DELETE);
                }
            }).sendTo((CommandSender)player);
            return;
        }
        TownCommand.checkPermOrThrowWithMessage((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_DELETE.getNode(), Translatable.of("msg_err_admin_only_delete_town"));
        Confirmation.runOnAccept(() -> {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("town_deleted_by_admin", town.getName()));
            townyUniverse.getDataSource().removeTown(town);
        }).sendTo((CommandSender)player);
    }

    public static void townKick(Player player, String[] names) {
        Town town;
        Resident resident;
        try {
            resident = TownCommand.getResidentOrThrow(player);
            town = resident.getTown();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg(player, x.getMessage((CommandSender)player));
            return;
        }
        TownCommand.townKickResidents((CommandSender)player, resident, town, ResidentUtil.getValidatedResidentsOfTown((CommandSender)player, town, names));
        plugin.resetCache();
    }

    public static void townAddResidents(CommandSender sender, Town town, List<Resident> invited) {
        String name;
        boolean admin = false;
        if (sender instanceof Player) {
            name = ((Player)sender).getName();
            if (TownyUniverse.getInstance().getPermissionSource().isTownyAdmin((Permissible)((Player)sender))) {
                admin = true;
            }
        } else {
            name = "Console";
            admin = true;
        }
        for (Resident newMember : new ArrayList<Resident>(invited)) {
            try {
                if (!admin) {
                    BukkitTools.ifCancelledThenThrow(new TownPreAddResidentEvent(town, newMember));
                }
                if (BukkitTools.matchPlayer(newMember.getName()).isEmpty()) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_offline_no_join", newMember.getName()));
                    invited.remove(newMember);
                    continue;
                }
                if (!newMember.hasPermissionNode(PermissionNodes.TOWNY_TOWN_RESIDENT.getNode())) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_not_allowed_join", newMember.getName()));
                    invited.remove(newMember);
                    continue;
                }
                if (TownySettings.getMaxResidentsPerTown() > 0 && town.getResidents().size() >= TownySettings.getMaxResidentsForTown(town)) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_max_residents_per_town_reached", TownySettings.getMaxResidentsForTown(town)));
                    invited.remove(newMember);
                    continue;
                }
                if (town.hasNation() && TownySettings.getMaxResidentsPerNation() > 0 && town.getNationOrNull().getResidents().size() >= TownySettings.getMaxResidentsPerNation()) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_cannot_add_nation_over_resident_limit", TownySettings.getMaxResidentsPerNation(), newMember.getName()));
                    invited.remove(newMember);
                    continue;
                }
                if (!admin && TownySettings.getTownInviteCooldown() > 0L && System.currentTimeMillis() / 1000L - newMember.getRegistered() / 1000L < TownySettings.getTownInviteCooldown()) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_resident_doesnt_meet_invite_cooldown", newMember));
                    invited.remove(newMember);
                    continue;
                }
                if (TownySettings.getMaxNumResidentsWithoutNation() > 0 && !town.hasNation() && town.getResidents().size() >= TownySettings.getMaxNumResidentsWithoutNation()) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_unable_to_add_more_residents_without_nation", TownySettings.getMaxNumResidentsWithoutNation()));
                    invited.remove(newMember);
                    continue;
                }
                town.addResidentCheck(newMember);
                TownCommand.townInviteResident(sender, town, newMember);
            }
            catch (TownyException e) {
                invited.remove(newMember);
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
            }
        }
        if (invited.size() > 0) {
            StringBuilder msg = new StringBuilder();
            for (Resident newMember : invited) {
                msg.append(newMember.getName()).append(", ");
            }
            msg = new StringBuilder(msg.substring(0, msg.length() - 2));
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_invited_join_town", name, msg.toString()));
            town.save();
        } else {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_invalid_name"));
        }
    }

    public static void townAddResident(Town town, Resident resident) throws AlreadyRegisteredException {
        if (town.hasOutlaw(resident)) {
            town.removeOutlaw(resident);
        }
        resident.setTown(town);
        plugin.deleteCache(resident);
        resident.save();
        town.save();
    }

    private static void townInviteResident(CommandSender sender, Town town, Resident newMember) throws TownyException {
        PlayerJoinTownInvite invite = new PlayerJoinTownInvite(sender, newMember, town);
        BukkitTools.ifCancelledThenThrow(new TownPreInvitePlayerEvent(invite));
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                newMember.newReceivedInvite(invite);
                town.newSentInvite(invite);
                InviteHandler.addInvite(invite);
                Player player = TownyAPI.getInstance().getPlayer(newMember);
                if (player != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)player, invite);
                }
            } else {
                throw new TownyException(Translatable.of("msg_err_player_already_invited", newMember.getName()));
            }
            BukkitTools.fireEvent(new TownInvitePlayerEvent(invite));
        }
        catch (TooManyInvitesException e) {
            newMember.deleteReceivedInvite(invite);
            town.deleteSentInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    private static void townRevokeInviteResident(CommandSender sender, Town town, List<Resident> residents) {
        block2: for (Resident invited : residents) {
            if (!InviteHandler.inviteIsActive(town, invited)) continue;
            for (Invite invite : invited.getReceivedInvites()) {
                if (!invite.getSender().equals(town)) continue;
                try {
                    InviteHandler.declineInvite(invite, true);
                    TownyMessaging.sendMsg(sender, Translatable.of("town_revoke_invite_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    plugin.getLogger().log(Level.WARNING, "An exception occurred while revoking invites for town " + town.getName(), e);
                }
            }
        }
    }

    public static void townKickResidents(CommandSender sender, Resident resident, Town town, List<Resident> kicking) {
        Resident resident2;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            resident2 = TownyAPI.getInstance().getResident(player);
        } else {
            resident2 = null;
        }
        Resident senderResident = resident2;
        for (Resident member : new ArrayList<Resident>(kicking)) {
            TownKickEvent townKickEvent;
            block16: {
                block15: {
                    if (!town.hasResident(member)) {
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_resident_not_your_town"));
                        kicking.remove(member);
                        continue;
                    }
                    if (resident == member) {
                        TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_you_cannot_kick_yourself"));
                        kicking.remove(member);
                        continue;
                    }
                    if (member.isMayor()) break block15;
                    if (senderResident == null || senderResident.isMayor() || !town.hasResident(senderResident)) break block16;
                    if (!TownySettings.getTownUnkickableRanks().stream().anyMatch(member::hasTownRank)) break block16;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_you_cannot_kick_this_resident", member));
                kicking.remove(member);
                continue;
            }
            if (BukkitTools.isEventCancelled(townKickEvent = new TownKickEvent(member, sender))) {
                TownyMessaging.sendErrorMsg((Object)sender, townKickEvent.getCancelMessage());
                kicking.remove(member);
                continue;
            }
            member.removeTown();
        }
        if (kicking.size() > 0) {
            Player kickingPlayer;
            String string;
            String message = kicking.stream().map(TownyObject::getName).collect(Collectors.joining(", "));
            if (sender instanceof Player) {
                Player player = (Player)sender;
                string = player.getName();
            } else {
                string = "CONSOLE";
            }
            String kickerName = string;
            for (Resident member : kicking) {
                TownyMessaging.sendMsg(member, Translatable.of("msg_kicked_by", kickerName));
            }
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_kicked", kickerName, message));
            if (!(sender instanceof Player) || !town.hasResident(kickingPlayer = (Player)sender)) {
                TownyMessaging.sendMessage((Object)sender, Translation.translateTranslatables(sender, "", Translatable.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())), Translatable.of("msg_kicked", kickerName, message)));
            }
            town.save();
        } else {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_invalid_name"));
        }
        TownCommand.checkTownResidents(town);
    }

    public static void checkTownResidents(Town town) {
        if (!town.hasNation()) {
            return;
        }
        Nation nation = town.getNationOrNull();
        if (town.isCapital() && TownySettings.getNumResidentsCreateNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
            for (Town newCapital : nation.getTowns()) {
                if (newCapital.getNumResidents() < TownySettings.getNumResidentsCreateNation()) continue;
                nation.setCapital(newCapital);
                if (TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                    town.removeNation();
                    TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_capital_not_enough_residents_left_nation", town.getName()));
                }
                TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_not_enough_residents_no_longer_capital", newCapital.getName()));
                return;
            }
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_nation_disbanded_town_not_enough_residents", town.getName()));
            TownyMessaging.sendGlobalMessage(Translatable.of("msg_del_nation", nation));
            TownyUniverse.getInstance().getDataSource().removeNation(nation);
            if (TownyEconomyHandler.isActive() && TownySettings.isRefundNationDisbandLowResidents()) {
                town.getAccount().deposit(TownySettings.getNewNationPrice(), "nation refund");
                TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_not_enough_residents_refunded", TownySettings.getNewNationPrice()));
            }
        } else if (!town.isCapital() && TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translatable.of("msg_town_not_enough_residents_left_nation", town.getName()));
            town.removeNation();
        }
    }

    public static void parseTownJoin(CommandSender sender, String[] args) {
        try {
            String exceptionMsg;
            String contextualResidentName;
            String townName;
            String residentName;
            boolean console = false;
            if (sender instanceof Player) {
                if (args.length < 1) {
                    throw new TownyException(Translatable.of("msg_usage", "/town join [town]"));
                }
                Player player = (Player)sender;
                residentName = player.getName();
                townName = args[0];
                contextualResidentName = "You";
                exceptionMsg = "msg_err_already_res2";
            } else {
                if (args.length < 2) {
                    throw new TownyException(Translatable.of("msg_usage", "town join [resident] [town]"));
                }
                residentName = args[0];
                townName = args[1];
                contextualResidentName = residentName;
                exceptionMsg = "msg_err_already_res";
            }
            Resident resident = TownCommand.getResidentOrThrow(residentName);
            Town town = TownCommand.getTownOrThrow(townName);
            if (resident.hasTown()) {
                throw new TownyException(Translatable.of(exceptionMsg, contextualResidentName));
            }
            if (!console) {
                if (!town.isOpen()) {
                    throw new TownyException(Translatable.of("msg_err_not_open", town.getFormattedName()));
                }
                if (town.hasNation() && TownySettings.getMaxResidentsPerNation() > 0 && town.getNationOrNull().getResidents().size() >= TownySettings.getMaxResidentsPerNation()) {
                    throw new TownyException(Translatable.of("msg_err_cannot_join_nation_over_resident_limit", TownySettings.getMaxResidentsPerNation()));
                }
                if (TownySettings.getMaxResidentsPerTown() > 0 && town.getResidents().size() >= TownySettings.getMaxResidentsForTown(town)) {
                    throw new TownyException(Translatable.of("msg_err_max_residents_per_town_reached", TownySettings.getMaxResidentsForTown(town)));
                }
                if (TownySettings.getMaxNumResidentsWithoutNation() > 0 && !town.hasNation() && town.getResidents().size() >= TownySettings.getMaxNumResidentsWithoutNation()) {
                    throw new TownyException(Translatable.of("msg_err_unable_to_add_more_residents_without_nation", TownySettings.getMaxNumResidentsWithoutNation()));
                }
                if (town.hasOutlaw(resident)) {
                    throw new TownyException(Translatable.of("msg_err_outlaw_in_open_town"));
                }
            }
            BukkitTools.ifCancelledThenThrow(new TownPreAddResidentEvent(town, resident));
            TownCommand.townAddResident(town, resident);
            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_join_town", resident.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage(sender));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
        }
    }

    public static void townAdd(CommandSender sender, Town specifiedTown, String[] names) throws TownyException {
        List<Resident> toRevoke;
        Town town;
        String string;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            string = player.getName();
        } else {
            string = "Console";
        }
        String name = string;
        boolean console = !(sender instanceof Player);
        try {
            if (console) {
                town = specifiedTown;
            } else {
                Resident resident = TownCommand.getResidentOrThrow(name);
                town = specifiedTown == null ? resident.getTown() : specifiedTown;
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)sender, x.getMessage(sender));
            return;
        }
        if (town.isBankrupt()) {
            throw new TownyException(Translatable.of("msg_err_bankrupt_town_cannot_invite"));
        }
        if (TownySettings.getMaxDistanceFromTownSpawnForInvite() > 0) {
            if (!town.hasSpawn()) {
                throw new TownyException(Translatable.of("msg_err_townspawn_has_not_been_set"));
            }
            Location spawnLoc = town.getSpawn();
            ArrayList<Object> newNames = new ArrayList<Object>();
            int maxDistance = TownySettings.getMaxDistanceFromTownSpawnForInvite();
            for (String nameForDistanceTest : names) {
                double distance;
                Player player = BukkitTools.getPlayerExact(nameForDistanceTest);
                if (player == null) continue;
                Location playerLoc = player.getLocation();
                try {
                    distance = spawnLoc.distance(playerLoc);
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_player_too_far_from_town_spawn", nameForDistanceTest, maxDistance));
                    continue;
                }
                if (distance <= (double)maxDistance) {
                    newNames.add(nameForDistanceTest);
                    continue;
                }
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_player_too_far_from_town_spawn", nameForDistanceTest, maxDistance));
            }
            names = newNames.toArray(new String[0]);
        }
        ArrayList<String> resList = new ArrayList<String>(Arrays.asList(names));
        ArrayList<String> newResList = new ArrayList<String>();
        ArrayList<String> removeInvites = new ArrayList<String>();
        for (String resName : resList) {
            if (resName.startsWith("-")) {
                removeInvites.add(resName.substring(1));
                continue;
            }
            if (!town.hasResident(resName)) {
                newResList.add(resName);
                continue;
            }
            removeInvites.add(resName);
        }
        if (newResList.size() + removeInvites.size() > 1) {
            TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_INVITE_ADD_MULTIPLE.getNode());
        }
        names = newResList.toArray(new String[0]);
        String[] namesToRemove = removeInvites.toArray(new String[0]);
        if (namesToRemove.length != 0 && !(toRevoke = TownCommand.getValidatedResidentsForInviteRevoke(sender, namesToRemove, town)).isEmpty()) {
            TownCommand.townRevokeInviteResident(sender, town, toRevoke);
        }
        if (names.length != 0) {
            TownCommand.townAddResidents(sender, town, ResidentUtil.getValidatedResidents(sender, names));
        }
        if (!console) {
            plugin.resetCache(BukkitTools.getPlayerExact(name));
        }
    }

    public static void setTownBlockOwnerPermissions(CommandSender sender, TownBlockOwner townBlockOwner, String[] split) {
        TownCommand.setTownBlockPermissions(sender, townBlockOwner, townBlockOwner.getPermissions(), split, false);
    }

    public static void setTownBlockPermissions(CommandSender sender, TownBlockOwner townBlockOwner, TownyPermission perm, String[] split, boolean friend) {
        TownyPermissionChange permChange;
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split.length > 3) {
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle("/... set perm"));
            if (townBlockOwner instanceof Town) {
                TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
            }
            if (townBlockOwner instanceof Resident) {
                TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
            }
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("", "set perm", "reset", ""));
            if (townBlockOwner instanceof Town) {
                TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Eg", "/town set perm", "ally off", ""));
            }
            if (townBlockOwner instanceof Resident) {
                TownyMessaging.sendMessage((Object)sender, ChatTools.formatCommand("Eg", "/resident set perm", "friend build on", ""));
            }
            return;
        }
        if (friend && split[0].equalsIgnoreCase("friend")) {
            split[0] = "resident";
        }
        if (friend && split[0].equalsIgnoreCase("town")) {
            split[0] = "nation";
        }
        if (split.length == 1) {
            if (split[0].equalsIgnoreCase("reset")) {
                for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
                    if ((!(townBlockOwner instanceof Town) || townBlock.hasResident()) && (!(townBlockOwner instanceof Resident) || !townBlock.hasResident())) continue;
                    TownyPermissionChange permChange2 = new TownyPermissionChange(TownyPermissionChange.Action.RESET, true, townBlock);
                    try {
                        BukkitTools.ifCancelledThenThrow(new TownBlockPermissionChangeEvent(townBlock, permChange2));
                    }
                    catch (CancelledEventException e) {
                        sender.sendMessage(e.getCancelMessage());
                        return;
                    }
                    townBlock.setType(townBlock.getType());
                    townBlock.save();
                }
                if (townBlockOwner instanceof Town) {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_set_perms_reset", "Town owned"));
                } else {
                    TownyMessaging.sendMsg(sender, Translatable.of("msg_set_perms_reset", "your"));
                }
                plugin.resetCache();
                return;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[0]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.ALL_PERMS, b, new Object[0]);
                perm.change(permChange);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_set_perm_syntax_error"));
                return;
            }
        }
        if (split.length == 2) {
            boolean b;
            try {
                b = StringMgmt.parseOnOff(split[1]);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_set_perm_syntax_error"));
                return;
            }
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            } else if (split[0].equalsIgnoreCase("itemuse")) {
                split[0] = "item_use";
            }
            try {
                TownyPermission.PermLevel permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase(Locale.ROOT));
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.PERM_LEVEL, b, new Object[]{permLevel});
                perm.change(permChange);
            }
            catch (IllegalArgumentException permLevelException) {
                try {
                    TownyPermission.ActionType actionType = TownyPermission.ActionType.valueOf(split[0].toUpperCase(Locale.ROOT));
                    permChange = new TownyPermissionChange(TownyPermissionChange.Action.ACTION_TYPE, b, new Object[]{actionType});
                    perm.change(permChange);
                }
                catch (IllegalArgumentException actionTypeException) {
                    TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_set_perm_syntax_error"));
                    return;
                }
            }
        } else {
            TownyPermission.ActionType actionType;
            TownyPermission.PermLevel permLevel;
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            }
            if (split[1].equalsIgnoreCase("itemuse")) {
                split[1] = "item_use";
            }
            try {
                permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase(Locale.ROOT));
                actionType = TownyPermission.ActionType.valueOf(split[1].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ignore) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_set_perm_syntax_error"));
                return;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[2]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.SINGLE_PERM, b, new Object[]{permLevel, actionType});
                perm.change(permChange);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_set_perm_syntax_error"));
                return;
            }
        }
        for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
            if (townBlock.isChanged()) continue;
            try {
                BukkitTools.ifCancelledThenThrow(new TownBlockPermissionChangeEvent(townBlock, permChange));
            }
            catch (CancelledEventException e) {
                sender.sendMessage(e.getCancelMessage());
                continue;
            }
            if (townBlockOwner instanceof Town && !townBlock.hasResident()) {
                townBlock.setType(townBlock.getType());
                townBlock.save();
                continue;
            }
            if (!(townBlockOwner instanceof Resident)) continue;
            townBlock.setType(townBlock.getType());
            townBlock.save();
        }
        Translator translator = Translator.locale(sender);
        TownyMessaging.sendMsg(sender, translator.of("msg_set_perms"));
        TownyMessaging.sendMessage((Object)sender, "\u00a72" + translator.of("status_perm") + " " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
        TownyMessaging.sendMessage((Object)sender, "\u00a72" + translator.of("status_pvp") + " " + (perm.pvp ? translator.of("status_on") : translator.of("status_off")) + " " + "\u00a72" + translator.of("explosions") + " " + (perm.explosion ? translator.of("status_on") : translator.of("status_off")) + " " + "\u00a72" + translator.of("firespread") + " " + (perm.fire ? translator.of("status_on") : translator.of("status_off")) + " " + "\u00a72" + translator.of("mobspawns") + " " + (perm.mobs ? translator.of("status_on") : translator.of("status_off")));
        plugin.resetCache();
    }

    public static void parseTownClaimCommand(Player player, String[] split) throws TownyException {
        WorldCoord firstWorldCoord;
        int numAdjacent;
        List<WorldCoord> selection;
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            HelpMenu.TOWN_CLAIM.send((CommandSender)player);
            return;
        }
        Resident resident = TownCommand.getResidentOrThrow(player);
        Town town = TownCommand.getTownFromResidentOrThrow(resident);
        if (town.isBankrupt() && town.getTownBlocks().size() != 0) {
            throw new TownyException(Translatable.of("msg_err_bankrupt_town_cannot_claim"));
        }
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (world == null || !world.isUsingTowny()) {
            throw new TownyException(Translatable.of("msg_set_use_towny_off"));
        }
        if (!world.isClaimable()) {
            throw new TownyException(Translatable.of("msg_not_claimable"));
        }
        boolean outpost = false;
        boolean isAdmin = resident.isAdmin();
        Coord key = Coord.parseCoord(plugin.getCache(player).getLastLocation());
        if (split.length == 1 && split[0].equalsIgnoreCase("outpost")) {
            if (!TownySettings.isAllowingOutposts()) {
                throw new TownyException(Translatable.of("msg_outpost_disable"));
            }
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_OUTPOST.getNode());
            OutpostUtil.OutpostTests(town, resident, world, key, isAdmin, false);
            if (!TownyAPI.getInstance().isWilderness(plugin.getCache(player).getLastLocation())) {
                throw new TownyException(Translatable.of("msg_already_claimed_1", key));
            }
            selection = new ArrayList<WorldCoord>();
            selection.add(new WorldCoord(world.getName(), key));
            outpost = true;
        } else {
            if (split.length != 0 && TownyAPI.getInstance().getTownyWorld(split[0]) != null) {
                throw new TownyException(Translatable.of("tc_err_invalid_command"));
            }
            TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_TOWN.getNode());
            selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), split, true);
            if (selection.size() > 1) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_TOWN_MULTIPLE.getNode());
            }
            if ((selection = AreaSelectionUtil.filterOutTownOwnedBlocks(selection)).isEmpty()) {
                throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
            }
        }
        if (!town.hasUnlimitedClaims() && selection.size() > town.availableTownBlocks()) {
            throw new TownyException(Translatable.of("msg_err_not_enough_blocks"));
        }
        if (selection.size() == 1 && selection.get(0).getTownOrNull() != null) {
            throw new TownyException(Translatable.of("msg_already_claimed", selection.get(0).getTownOrNull()));
        }
        TownyMessaging.sendDebugMsg("townClaim: Pre-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
        selection = AreaSelectionUtil.filterInvalidProximityToHomeblock(selection, town);
        if (selection.isEmpty()) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
        }
        if ((selection = AreaSelectionUtil.filterInvalidProximityTownBlocks(selection, town)).isEmpty()) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("townblock")));
        }
        int minAdjacentBlocks = TownySettings.getMinAdjacentBlocks();
        if (!outpost && minAdjacentBlocks > 0 && TownCommand.townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(town, minAdjacentBlocks) && (numAdjacent = TownCommand.numAdjacentTownOwnedTownBlocks(town, firstWorldCoord = selection.get(0))) < minAdjacentBlocks && TownCommand.numAdjacentOutposts(town, firstWorldCoord) == 0) {
            throw new TownyException(Translatable.of("msg_min_adjacent_blocks", minAdjacentBlocks, numAdjacent));
        }
        TownyMessaging.sendDebugMsg("townClaim: Post-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
        if (!(outpost || TownCommand.isEdgeBlock((TownBlockOwner)town, selection) || town.getTownBlocks().isEmpty())) {
            throw new TownyException(Translatable.of("msg_err_not_attached_edge"));
        }
        int blockedClaims = 0;
        String cancelMessage = "";
        boolean isHomeblock = town.getTownBlocks().size() == 0;
        for (WorldCoord coord : selection) {
            TownPreClaimEvent preClaimEvent = new TownPreClaimEvent(town, new TownBlock(coord.getX(), coord.getZ(), world), player, outpost, isHomeblock);
            if (!BukkitTools.isEventCancelled(preClaimEvent)) continue;
            ++blockedClaims;
            cancelMessage = preClaimEvent.getCancelMessage();
        }
        if (blockedClaims > 0) {
            throw new TownyException(String.format(cancelMessage, blockedClaims, selection.size()));
        }
        if (TownyEconomyHandler.isActive()) {
            boolean isOutpost = outpost;
            List<WorldCoord> finalSelection = selection;
            TownyEconomyHandler.economyExecutor().execute(() -> {
                try {
                    double blockCost = isOutpost ? TownySettings.getOutpostCost() : (finalSelection.size() == 1 ? town.getTownBlockCost() : town.getTownBlockCostN(finalSelection.size()));
                    if (!town.getAccount().canPayFromHoldings(blockCost)) {
                        double missingAmount = blockCost - town.getAccount().getHoldingBalance();
                        throw new TownyException(Translatable.of("msg_no_funds_claim2", finalSelection.size(), TownyEconomyHandler.getFormattedBalance(blockCost), TownyEconomyHandler.getFormattedBalance(missingAmount), new DecimalFormat("#").format(missingAmount)));
                    }
                    town.getAccount().withdraw(blockCost, String.format("Town Claim (%d) by %s", finalSelection.size(), player.getName()));
                    plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, finalSelection, isOutpost, true, false));
                }
                catch (NullPointerException e2) {
                    TownyMessaging.sendErrorMsg(player, "The server economy plugin " + TownyEconomyHandler.getVersion() + " could not return the Town account!");
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
                }
            });
        } else {
            plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, selection, outpost, true, false));
        }
    }

    private static boolean townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(Town town, int minAdjacentBlocks) {
        if (minAdjacentBlocks == 3 && town.getTownBlocks().size() < 5) {
            return false;
        }
        return town.getTownBlocks().size() > minAdjacentBlocks;
    }

    public static void parseTownUnclaimCommand(Player player, String[] split) throws TownyException {
        int minAdjacentBlocks;
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            HelpMenu.TOWN_UNCLAIM.send((CommandSender)player);
            return;
        }
        Resident resident = TownCommand.getResidentOrThrow(player);
        Town town = TownCommand.getTownFromResidentOrThrow(resident);
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(player.getWorld());
        if (split.length == 1 && split[0].equalsIgnoreCase("all")) {
            TownCommand.parseTownUnclaimAllCommand(player, town, resident, world);
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM.getNode());
        if (split.length == 3 && TownyAPI.getInstance().getTownyWorld(split[0]) != null) {
            throw new TownyException(Translatable.of("tc_err_invalid_command"));
        }
        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(town, WorldCoord.parseWorldCoord((Entity)player), split);
        if ((selection = AreaSelectionUtil.filterOwnedBlocks(town, selection)).isEmpty()) {
            throw new TownyException(Translatable.of("msg_err_empty_area_selection"));
        }
        if (selection.get(0).getTownBlock().isHomeBlock()) {
            throw new TownyException(Translatable.of("msg_err_cannot_unclaim_homeblock"));
        }
        if (AreaSelectionUtil.filterHomeBlock(town, selection)) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_cannot_unclaim_homeblock"));
        }
        if ((minAdjacentBlocks = TownySettings.getMinAdjacentBlocks()) > 0 && TownCommand.townHasClaimedEnoughLandToBeRestrictedByAdjacentClaims(town, minAdjacentBlocks)) {
            WorldCoord firstWorldCoord = selection.get(0);
            for (WorldCoord wc : firstWorldCoord.getCardinallyAdjacentWorldCoords(true)) {
                int numAdjacent;
                if (wc.isWilderness() || !wc.hasTown(town) || (numAdjacent = TownCommand.numAdjacentTownOwnedTownBlocks(town, wc)) - 1 >= minAdjacentBlocks || TownCommand.numAdjacentOutposts(town, wc) != 0) continue;
                throw new TownyException(Translatable.of("msg_err_cannot_unclaim_not_enough_adjacent_claims", wc.getX(), wc.getZ(), numAdjacent));
            }
        }
        BukkitTools.ifCancelledThenThrow(new TownPreUnclaimCmdEvent(town, resident, world, selection));
        if (TownyEconomyHandler.isActive() && TownySettings.getClaimRefundPrice() < 0.0) {
            double cost = Math.abs(TownySettings.getClaimRefundPrice() * (double)selection.size());
            if (!town.getAccount().canPayFromHoldings(cost)) {
                TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_your_town_cannot_afford_unclaim", TownyEconomyHandler.getFormattedBalance(cost)));
                return;
            }
            List<WorldCoord> finalSelection = selection;
            Confirmation.runOnAccept(() -> {
                if (!town.getAccount().canPayFromHoldings(cost)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_your_town_cannot_afford_unclaim", TownyEconomyHandler.getFormattedBalance(cost)));
                    return;
                }
                plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, finalSelection, false, false, false));
            }).setTitle(Translatable.of("confirmation_unclaiming_costs", TownyEconomyHandler.getFormattedBalance(cost))).sendTo((CommandSender)player);
            return;
        }
        plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, selection, false, false, false));
    }

    private static void parseTownUnclaimAllCommand(Player player, Town town, Resident resident, TownyWorld world) throws TownyException {
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_UNCLAIM_ALL.getNode());
        ArrayList<WorldCoord> selection = new ArrayList<WorldCoord>();
        selection.addAll(town.getTownBlocks().stream().map(TownBlock::getWorldCoord).collect(Collectors.toList()));
        if (town.hasHomeBlock()) {
            selection.remove(town.getHomeBlock().getWorldCoord());
        }
        BukkitTools.ifCancelledThenThrow(new TownPreUnclaimCmdEvent(town, resident, world, selection));
        if (TownyEconomyHandler.isActive() && TownySettings.getClaimRefundPrice() < 0.0) {
            int numTownBlocks = town.getTownBlocks().size() - (town.hasHomeBlock() ? 1 : 0);
            String formattedCost = TownyEconomyHandler.getFormattedBalance(Math.abs(TownySettings.getClaimRefundPrice() * (double)numTownBlocks));
            Confirmation.runOnAcceptAsync(new TownClaim(plugin, player, town, null, false, false, false)).setTitle(Translatable.of("confirmation_unclaiming_costs", formattedCost)).sendTo((CommandSender)player);
            return;
        }
        plugin.getScheduler().runAsync(new TownClaim(plugin, player, town, null, false, false, false));
    }

    private void parseTownTakeoverClaimCommand(Player player) throws TownyException {
        int numAdjacent;
        long ageNeeded;
        TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_TAKEOVERCLAIM.getNode());
        this.catchRuinedTown(player);
        if (!TownySettings.isOverClaimingAllowingStolenLand()) {
            throw new TownyException(Translatable.of("msg_err_taking_over_claims_is_not_enabled"));
        }
        Town town = TownCommand.getTownFromPlayerOrThrow(player);
        long ageRequirement = TownySettings.getOverclaimingTownAgeRequirement();
        if (ageRequirement > 0L && (ageNeeded = System.currentTimeMillis() - ageRequirement) < town.getRegistered()) {
            throw new TownyException(Translatable.of("msg_err_your_town_is_not_old_enough_to_overclaim", TimeMgmt.getFormattedTimeValue(town.getRegistered() - ageNeeded)));
        }
        if (town.getTownBlocks().size() == 0) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_make_this_your_homeblock"));
        }
        WorldCoord wc = WorldCoord.parseWorldCoord((Entity)player);
        if (wc.isWilderness()) {
            throw new TownyException(Translatable.of("msg_not_own_place"));
        }
        if (wc.getTownOrNull().equals(town)) {
            throw new TownyException(Translatable.of("msg_already_claimed_1"));
        }
        if (!wc.canBeStolen()) {
            throw new TownyException(Translatable.of("msg_err_this_townblock_cannot_be_taken_over"));
        }
        if (!town.hasUnlimitedClaims() && town.availableTownBlocks() < 1) {
            throw new TownyException(Translatable.of("msg_err_not_enough_blocks"));
        }
        if (!TownCommand.isEdgeBlock((TownBlockOwner)town, wc)) {
            throw new TownyException(Translatable.of("msg_err_not_attached_edge"));
        }
        int minAdjacentBlocks = TownySettings.getMinAdjacentBlocks();
        if (minAdjacentBlocks > 0 && town.getTownBlocks().size() > minAdjacentBlocks && (numAdjacent = TownCommand.numAdjacentTownOwnedTownBlocks(town, wc)) < minAdjacentBlocks && TownCommand.numAdjacentOutposts(town, wc) == 0) {
            throw new TownyException(Translatable.of("msg_min_adjacent_blocks", minAdjacentBlocks, numAdjacent));
        }
        if (this.takeoverWouldCutATownIntoTwoSections(wc, town)) {
            throw new TownyException(Translatable.of("msg_err_you_cannot_over_claim_would_cut_into_two"));
        }
        if (TownySettings.isOverClaimingPreventedByHomeBlockRadius() && AreaSelectionUtil.isTooCloseToHomeBlock(wc, town)) {
            throw new TownyException(Translatable.of("msg_too_close2", Translatable.of("homeblock")));
        }
        if (BukkitTools.isEventCancelled(new TownPreClaimEvent(town, wc.getTownBlockOrNull(), player, false, false))) {
            throw new TownyException(Translatable.of("msg_err_another_plugin_cancelled_takeover"));
        }
        double cost = TownySettings.getTakeoverClaimPrice();
        String costSlug = !TownyEconomyHandler.isActive() || cost <= 0.0 ? Translatable.of("msg_spawn_cost_free").forLocale((CommandSender)player) : TownyEconomyHandler.getFormattedBalance(cost);
        String townName = wc.getTownOrNull().getName();
        Confirmation.runOnAccept(() -> Bukkit.getScheduler().runTask((Plugin)plugin, (Runnable)new TownClaim(plugin, player, town, Arrays.asList(wc), false, true, false))).setTitle(Translatable.of("confirmation_you_are_about_to_take_over_a_claim", townName, costSlug)).setCost(new ConfirmationTransaction(() -> cost, town.getAccount(), "Takeover Claim (" + wc.toString() + ") from " + townName + ".")).sendTo((CommandSender)player);
    }

    private boolean takeoverWouldCutATownIntoTwoSections(WorldCoord worldCoord, Town townOverClaiming) {
        Town overclaimed = worldCoord.getTownOrNull();
        List<WorldCoord> surroundingClaims = worldCoord.getCardinallyAdjacentWorldCoords(true);
        long townOwned = surroundingClaims.stream().filter(wc -> wc.hasTown(overclaimed)).count();
        if (townOwned < 2L) {
            return false;
        }
        long wildOr3rdPartyOwned = surroundingClaims.stream().filter(wc -> !wc.hasTown(overclaimed) && !wc.hasTown(townOverClaiming)).count();
        return wildOr3rdPartyOwned > 0L;
    }

    public static void parseTownMergeCommand(Player player, String[] args) throws TownyException {
        TownCommand.parseTownMergeCommand((CommandSender)player, args, TownCommand.getTownFromPlayerOrThrow(player), false);
    }

    public static void parseTownMergeCommand(CommandSender sender, String[] args, @NotNull Town remainingTown, boolean admin) throws TownyException {
        Player player;
        if (args.length <= 0) {
            throw new TownyException(Translatable.of("msg_specify_name"));
        }
        if (!admin && sender instanceof Player && !TownCommand.getResidentOrThrow(player = (Player)sender).isMayor()) {
            throw new TownyException(Translatable.of("msg_town_merge_err_mayor_only"));
        }
        Town succumbingTown = TownCommand.getTownOrThrow(args[0]);
        if (succumbingTown.getName().equals(remainingTown.getName())) {
            throw new TownyException(Translatable.of("msg_err_invalid_name", args[0]));
        }
        if (TownySettings.getMaxDistanceForTownMerge() > 0 && TownCommand.homeBlockDistance(remainingTown, succumbingTown) > TownySettings.getMaxDistanceForTownMerge()) {
            throw new TownyException(Translatable.of("msg_town_merge_err_not_close", succumbingTown.getName(), TownySettings.getMaxDistanceForTownMerge()));
        }
        int newResidentsAmount = remainingTown.getNumResidents() + succumbingTown.getNumResidents();
        if (TownySettings.getMaxResidentsPerTown() > 0 && newResidentsAmount > TownySettings.getMaxResidentsForTown(remainingTown)) {
            throw new TownyException(Translatable.of("msg_town_merge_err_too_many_residents", TownySettings.getMaxResidentsForTown(remainingTown)));
        }
        if (!remainingTown.hasUnlimitedClaims() && remainingTown.getNumTownBlocks() + succumbingTown.getNumTownBlocks() > TownySettings.getMaxTownBlocks(remainingTown, newResidentsAmount)) {
            throw new TownyException(Translatable.of("msg_town_merge_err_too_many_townblocks", TownySettings.getMaxTownBlocks(remainingTown, newResidentsAmount)));
        }
        if (remainingTown.getPurchasedBlocks() + succumbingTown.getPurchasedBlocks() > TownySettings.getMaxPurchasedBlocks(remainingTown, newResidentsAmount)) {
            throw new TownyException(Translatable.of("msg_town_merge_err_too_many_purchased_townblocks", TownySettings.getMaxPurchasedBlocks(remainingTown, newResidentsAmount)));
        }
        if (TownySettings.isAllowingOutposts() && TownySettings.isOutpostsLimitedByLevels() && remainingTown.getMaxOutpostSpawn() + succumbingTown.getMaxOutpostSpawn() > TownySettings.getMaxOutposts(remainingTown, newResidentsAmount)) {
            throw new TownyException(Translatable.of("msg_town_merge_err_too_many_outposts", TownySettings.getMaxOutposts(remainingTown, newResidentsAmount)));
        }
        if (!BukkitTools.isOnline(succumbingTown.getMayor().getName()) || succumbingTown.getMayor().isNPC()) {
            throw new TownyException(Translatable.of("msg_town_merge_other_offline", succumbingTown.getName(), succumbingTown.getMayor().getName()));
        }
        double baseCost = TownySettings.getBaseCostForTownMerge();
        double townblockCost = 0.0;
        double bankruptcyCost = 0.0;
        double purchasedBlockCost = 0.0;
        double cost = 0.0;
        if (!admin && TownyEconomyHandler.isActive()) {
            townblockCost = remainingTown.getTownBlockCostN(succumbingTown.getNumTownBlocks()) * ((double)TownySettings.getPercentageCostPerPlot() * 0.01);
            if (succumbingTown.isBankrupt()) {
                bankruptcyCost = Math.abs(succumbingTown.getAccount().getHoldingBalance());
            }
            if (succumbingTown.getPurchasedBlocks() > 0 && TownySettings.getPurchasedBonusBlocksIncreaseValue() != 1.0) {
                int purchasedBlocks = succumbingTown.getPurchasedBlocks();
                double priceAlreadyPaid = MoneyUtil.returnPurchasedBlocksCost(0, purchasedBlocks, succumbingTown);
                purchasedBlockCost = remainingTown.getBonusBlockCostN(purchasedBlocks) - priceAlreadyPaid;
            }
            cost = baseCost + townblockCost + bankruptcyCost + purchasedBlockCost;
            if (!remainingTown.getAccount().canPayFromHoldings(cost)) {
                throw new TownyException(Translatable.of("msg_town_merge_err_not_enough_money", TownCommand.prettyMoney(remainingTown.getAccount().getHoldingBalance()), TownCommand.prettyMoney(cost)));
            }
        }
        if (cost > 0.0) {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_warning", succumbingTown.getName(), TownCommand.prettyMoney(cost)));
            if (bankruptcyCost > 0.0) {
                TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_debt_warning", succumbingTown.getName()));
            }
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_cost_breakdown", TownCommand.prettyMoney(baseCost), TownCommand.prettyMoney(townblockCost), TownCommand.prettyMoney(bankruptcyCost), TownCommand.prettyMoney(purchasedBlockCost)));
            Town finalSuccumbingTown = succumbingTown;
            Town finalRemainingTown = remainingTown;
            double finalCost = cost;
            Confirmation.runOnAccept(() -> TownCommand.sendTownMergeRequest(sender, finalRemainingTown, finalSuccumbingTown, finalCost)).runOnCancel(() -> TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_cancelled"))).sendTo(sender);
        } else {
            TownCommand.sendTownMergeRequest(sender, remainingTown, succumbingTown, cost);
        }
    }

    private static String prettyMoney(double cost) {
        return TownyEconomyHandler.getFormattedBalance(cost);
    }

    private static void sendTownMergeRequest(CommandSender sender, Town remainingTown, Town succumbingTown, double cost) {
        TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_request_sent", succumbingTown.getName()));
        TownyMessaging.sendMsg(succumbingTown.getMayor(), Translatable.of("msg_town_merge_request_received", remainingTown.getName(), sender.getName(), remainingTown.getName()));
        Confirmation.runOnAccept(() -> {
            TownPreMergeEvent townPreMergeEvent = new TownPreMergeEvent(remainingTown, succumbingTown);
            if (BukkitTools.isEventCancelled(townPreMergeEvent)) {
                TownyMessaging.sendErrorMsg(succumbingTown.getMayor().getPlayer(), townPreMergeEvent.getCancelMessage());
                TownyMessaging.sendErrorMsg((Object)sender, townPreMergeEvent.getCancelMessage());
                return;
            }
            if (TownyEconomyHandler.isActive() && cost > 0.0 && !remainingTown.getAccount().withdraw(cost, Translation.of("msg_town_merge_cost_withdraw"))) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_town_merge_err_not_enough_money", (int)remainingTown.getAccount().getHoldingBalance(), (int)cost));
                return;
            }
            UUID succumbingTownUUID = succumbingTown.getUUID();
            String succumbingTownName = succumbingTown.getName();
            TownyUniverse.getInstance().getDataSource().mergeTown(remainingTown, succumbingTown);
            TownyMessaging.sendGlobalMessage(Translatable.of("town1_has_merged_with_town2", succumbingTown, remainingTown));
            TownMergeEvent townMergeEvent = new TownMergeEvent(remainingTown, succumbingTownName, succumbingTownUUID);
            BukkitTools.fireEvent(townMergeEvent);
        }).runOnCancel(() -> {
            TownyMessaging.sendMsg(sender, Translatable.of("msg_town_merge_request_denied"));
            TownyMessaging.sendMsg(succumbingTown.getMayor(), Translatable.of("msg_town_merge_cancelled"));
        }).sendTo((CommandSender)BukkitTools.getPlayerExact(succumbingTown.getMayor().getName()));
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, List<WorldCoord> worldCoords) {
        for (WorldCoord worldCoord : worldCoords) {
            if (!TownCommand.isEdgeBlock(owner, worldCoord)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, WorldCoord worldCoord) {
        for (WorldCoord wc : worldCoord.getCardinallyAdjacentWorldCoords(new boolean[0])) {
            if (wc.isWilderness() || !wc.getTownBlockOrNull().isOwner(owner)) continue;
            return true;
        }
        return false;
    }

    public static int numAdjacentTownOwnedTownBlocks(Town town, WorldCoord worldCoord) {
        return (int)worldCoord.getCardinallyAdjacentWorldCoords(true).stream().filter(wc -> wc.hasTown(town)).count();
    }

    public static int numAdjacentOutposts(Town town, WorldCoord worldCoord) {
        return (int)worldCoord.getCardinallyAdjacentWorldCoords(true).stream().filter(wc -> wc.hasTown(town)).map(wc -> wc.getTownBlockOrNull()).filter(TownBlock::isOutpost).count();
    }

    public static List<Resident> getValidatedResidentsForInviteRevoke(Object sender, String[] names, Town town) {
        ArrayList<Resident> toRevoke = new ArrayList<Resident>();
        for (Invite invite : town.getSentInvites()) {
            for (String name : names) {
                Resident revokeRes;
                if (!invite.getReceiver().getName().equalsIgnoreCase(name) || (revokeRes = TownyUniverse.getInstance().getResident(name)) == null) continue;
                toRevoke.add(revokeRes);
            }
        }
        return toRevoke;
    }

    private static void townTransaction(Player player, String[] args, boolean withdraw) {
        try {
            int amount;
            if (args.length == 0) {
                throw new TownyException(Translatable.of("msg_must_specify_amnt", withdraw ? "/town withdraw" : "/town deposit"));
            }
            Resident resident = TownCommand.getResidentOrThrow(player);
            Town town = null;
            if (!withdraw && args.length == 2 && !(town = TownCommand.getTownOrThrow(args[1])).hasResident(player)) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_DEPOSIT_OTHERTOWN.getNode());
            }
            if (town == null && !resident.hasTown()) {
                throw new TownyException(Translatable.of("msg_err_dont_belong_town"));
            }
            if (town == null) {
                town = resident.getTownOrNull();
            }
            if ((amount = "all".equalsIgnoreCase(args[0].trim()) ? (int)Math.floor(withdraw ? town.getAccount().getHoldingBalance() : resident.getAccount().getHoldingBalance()) : MathUtil.getIntOrThrow(args[0].trim())) == 0) {
                throw new TownyException(Translatable.of("msg_err_amount_must_be_greater_than_zero"));
            }
            if (withdraw) {
                MoneyUtil.townWithdraw(player, resident, town, amount);
            } else {
                MoneyUtil.townDeposit(player, resident, town, null, amount);
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg(player, e.getMessage((CommandSender)player));
        }
    }

    private static void townOutpost(Player player, String[] args) throws TownyException {
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("list")) {
                TownCommand.checkPermOrThrow((Permissible)player, PermissionNodes.TOWNY_COMMAND_TOWN_OUTPOST_LIST.getNode());
                Town town = TownCommand.getTownFromPlayerOrThrow(player);
                List<Location> outposts = town.getAllOutpostSpawns();
                int page = 1;
                int total = (int)Math.ceil((double)outposts.size() / 10.0);
                if (args.length == 2 && (page = MathUtil.getPositiveIntOrThrow(args[1])) == 0) {
                    throw new TownyException(Translatable.of("msg_error_must_be_int"));
                }
                if (page > total) {
                    throw new TownyException(Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
                }
                TownyMessaging.sendOutpostList(player, town, page, total);
            } else {
                boolean ignoreWarning = args.length == 1 && args[0].equals("-ignore");
                TownCommand.townSpawn(player, args, true, ignoreWarning);
            }
        } else {
            TownCommand.townSpawn(player, args, true, false);
        }
    }

    private void townStatusScreen(CommandSender sender, Town town) {
        plugin.getScheduler().runAsync(() -> TownyMessaging.sendStatusScreen(sender, TownyFormatter.getStatus(town, sender)));
    }

    private void townResList(CommandSender sender, String[] args) throws TownyException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        Town town = null;
        if (args.length == 1 && player != null) {
            this.catchRuinedTown(player);
            town = TownCommand.getTownFromPlayerOrThrow(player);
        } else if (args.length == 2) {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        TownyMessaging.sendMessage((Object)sender, ChatTools.formatTitle(town.getName() + " " + Translatable.of("res_list").forLocale(sender)));
        TownyMessaging.sendMessage((Object)sender, TownyFormatter.getFormattedTownyObjects(Translatable.of("res_list").forLocale(sender), new ArrayList<TownyObject>(town.getResidents())));
    }

    private void townPlotGroupList(CommandSender sender, String[] args) throws TownyException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player != null) {
            this.catchRuinedTown(player);
        }
        Town town = null;
        if (args.length > 1) {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        if (town == null && player != null) {
            town = TownCommand.getTownFromPlayerOrThrow(player);
        }
        if (!town.hasPlotGroups()) {
            throw new TownyException(Translatable.of("msg_err_this_town_has_no_plot_groups"));
        }
        int page = 1;
        int total = (int)Math.ceil((double)town.getPlotGroups().size() / 10.0);
        if (args.length > 1 && (page = MathUtil.getPositiveIntOrThrow(args[args.length - 1])) == 0) {
            throw new TownyException(Translatable.of("msg_error_must_be_int"));
        }
        if (page > total) {
            throw new TownyException(Translatable.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
        }
        TownyMessaging.sendPlotGroupList(sender, town, page, total);
    }

    private void townOutlawList(CommandSender sender, String[] args) throws TownyException {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        Town town = null;
        if (args.length == 1 && player != null) {
            this.catchRuinedTown(player);
            town = TownCommand.getTownFromPlayerOrThrow(player);
        } else if (args.length == 2) {
            town = TownCommand.getTownOrThrow(args[1]);
        }
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedTownyObjects(Translatable.of("outlaws").forLocale(sender), new ArrayList<TownyObject>(town.getOutlaws())));
    }

    public static void parseTownTrustCommand(CommandSender sender, String[] args, @Nullable Town town) throws TownyException {
        if (args.length < 1 || args.length < 2 && (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove")) || args.length == 1 && !args[0].equalsIgnoreCase("list")) {
            HelpMenu.TOWN_TRUST_HELP.send(sender);
            return;
        }
        if (town == null && sender instanceof Player) {
            Player player = (Player)sender;
            town = TownCommand.getTownFromPlayerOrThrow(player);
        }
        if (args[0].equalsIgnoreCase("list")) {
            List<String> output = town.getTrustedResidents().isEmpty() ? Collections.singletonList(Translatable.of("status_no_town").forLocale(sender)) : town.getTrustedResidents().stream().map(res -> res.getName()).collect(Collectors.toList());
            TownyMessaging.sendMessage((Object)sender, TownyFormatter.getFormattedStrings(Translatable.of("status_trustedlist").forLocale(sender), output));
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_TRUST.getNode());
        Resident resident = TownyAPI.getInstance().getResident(args[1]);
        if (resident == null || resident.isNPC()) {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_not_registered_1", args[1]));
            return;
        }
        if (args[0].equalsIgnoreCase("add")) {
            if (town.hasTrustedResident(resident)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_already_trusted", resident.getName(), Translatable.of("town_sing")));
                return;
            }
            BukkitTools.ifCancelledThenThrow(new TownTrustAddEvent(sender, resident, town));
            town.addTrustedResident(resident);
            plugin.deleteCache(resident);
            TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_added", resident.getName(), Translatable.of("town_sing")));
            if (BukkitTools.isOnline(resident.getName())) {
                String string;
                Player player = resident.getPlayer();
                Object[] objectArray = new Object[3];
                if (sender instanceof Player) {
                    Player player2 = (Player)sender;
                    string = player2.getName();
                } else {
                    string = "Console";
                }
                objectArray[0] = string;
                objectArray[1] = Translatable.of("town_sing");
                objectArray[2] = town.getName();
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_added_2", objectArray));
            }
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (!town.hasTrustedResident(resident)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_not_trusted", resident.getName(), Translatable.of("town_sing")));
                return;
            }
            BukkitTools.ifCancelledThenThrow(new TownTrustRemoveEvent(sender, resident, town));
            town.removeTrustedResident(resident);
            plugin.deleteCache(resident);
            TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_removed", resident.getName(), Translatable.of("town_sing")));
            if (BukkitTools.isOnline(resident.getName())) {
                String string;
                Player player = resident.getPlayer();
                Object[] objectArray = new Object[3];
                if (sender instanceof Player) {
                    Player player3 = (Player)sender;
                    string = player3.getName();
                } else {
                    string = "Console";
                }
                objectArray[0] = string;
                objectArray[1] = Translatable.of("town_sing");
                objectArray[2] = town.getName();
                TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_trusted_removed_2", objectArray));
            }
        } else {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", args[0]));
            return;
        }
        town.save();
    }

    public static void parseTownTrustTownCommand(CommandSender sender, String[] args, @Nullable Town town) throws TownyException {
        if (args.length < 1 || args.length < 2 && ("add".equalsIgnoreCase(args[0]) || "remove".equalsIgnoreCase(args[0])) || args.length == 1 && !"list".equalsIgnoreCase(args[0])) {
            HelpMenu.TOWN_TRUSTTOWN_HELP.send(sender);
            return;
        }
        if (town == null && sender instanceof Player) {
            Player player = (Player)sender;
            town = TownCommand.getTownFromPlayerOrThrow(player);
        }
        if ("list".equalsIgnoreCase(args[0])) {
            TownyMessaging.sendMessage((Object)sender, TownyFormatter.getFormattedTownyObjects(Translatable.of("status_trustedlist").forLocale(sender), new ArrayList<TownyObject>(town.getTrustedTowns())));
            return;
        }
        TownCommand.checkPermOrThrow((Permissible)sender, PermissionNodes.TOWNY_COMMAND_TOWN_TRUSTTOWN.getNode());
        Town trustTown = TownCommand.getTownOrThrow(args[1]);
        if (args[0].equalsIgnoreCase("add")) {
            if (town.hasTrustedTown(trustTown)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_already_trusted", trustTown.getName(), Translatable.of("town_sing")));
                return;
            }
            if (town == trustTown) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_already_trusted", trustTown.getName(), Translatable.of("town_sing")));
                return;
            }
            BukkitTools.ifCancelledThenThrow(new TownTrustTownAddEvent(sender, trustTown, town));
            Town finalTown = town;
            Confirmation.runOnAccept(() -> {
                trustTown.getResidents().forEach(res -> plugin.deleteCache((Resident)res));
                TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_added", trustTown.getName(), Translatable.of("town_sing")));
                finalTown.addTrustedTown(trustTown);
            }).setTitle(Translatable.of("confirmation_msg_trusttown_consequences")).sendTo(sender);
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (!town.hasTrustedTown(trustTown)) {
                TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_not_trusted", trustTown.getName(), Translatable.of("town_sing")));
                return;
            }
            BukkitTools.ifCancelledThenThrow(new TownTrustTownRemoveEvent(sender, trustTown, town));
            town.removeTrustedTown(trustTown);
            trustTown.getResidents().forEach(res -> plugin.deleteCache((Resident)res));
            TownyMessaging.sendMsg(sender, Translatable.of("msg_trusted_removed", trustTown.getName(), Translatable.of("town_sing")));
        } else {
            TownyMessaging.sendErrorMsg(sender, Translatable.of("msg_err_invalid_property", args[0]));
            return;
        }
        town.save();
    }

    public static List<String> getTrustedTownsFromResident(Player player) {
        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (res != null && res.hasTown()) {
            return res.getTownOrNull().getTrustedTowns().stream().map(TownyObject::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static int homeBlockDistance(Town town1, Town town2) {
        if (!town1.hasHomeBlock() || !town2.hasHomeBlock()) {
            return Integer.MAX_VALUE;
        }
        return (int)MathUtil.distance(town1.getHomeBlockOrNull().getCoord(), town2.getHomeBlockOrNull().getCoord());
    }

    private static /* synthetic */ void lambda$parseTownOutlawCommand$6(Location loc, Town town, Resident outlawRes) {
        if (TownyAPI.getInstance().getTown(loc) == town) {
            SpawnUtil.outlawTeleport(town, outlawRes);
        }
    }

    static {
        townTabCompletes = Arrays.asList("here", "leave", "list", "online", "new", "plots", "add", "kick", "spawn", "takeoverclaim", "claim", "unclaim", "withdraw", "delete", "outlawlist", "deposit", "outlaw", "ban", "outpost", "purge", "plotgrouplist", "ranklist", "rank", "reclaim", "reslist", "say", "set", "toggle", "join", "invite", "buy", "mayor", "bankhistory", "merge", "jail", "unjail", "trust", "trusttown", "allylist", "enemylist", "baltop");
        townSetTabCompletes = Arrays.asList("board", "mayor", "homeblock", "spawn", "spawncost", "mapcolor", "name", "outpost", "perm", "tag", "taxes", "plottax", "plotprice", "shopprice", "shoptax", "embassyprice", "embassytax", "title", "surname", "taxpercentcap", "primaryjail");
        townListTabCompletes = Arrays.asList("residents", "balance", "bankrupt", "founded", "name", "online", "open", "public", "ruined", "townblocks", "upkeep");
        townToggleTabCompletes = Arrays.asList("explosion", "fire", "mobs", "nationzone", "neutral", "peaceful", "public", "pvp", "taxpercent", "open");
        townConsoleTabCompletes = Arrays.asList("?", "help", "list");
        townAddRemoveTabCompletes = Arrays.asList("add", "remove");
        townClaimTabCompletes = Arrays.asList("outpost", "auto", "circle", "rect");
        townUnclaimTabCompletes = Arrays.asList("circle", "rect", "all");
        townInviteTabCompletes = Arrays.asList("sent", "received", "accept", "deny");
        townSetBoardTabCompletes = Arrays.asList("none", "reset");
    }
}

