/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NoPermissionException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCommand
implements TabCompleter {
    private static final List<String> setPermTabCompletes = Arrays.asList("on", "off", "resident", "friend", "town", "nation", "ally", "outsider", "build", "destroy", "switch", "itemuse", "reset");
    private static final List<String> setLevelCompletes = Arrays.asList("resident", "ally", "outsider", "nation", "friend", "town");
    private static final List<String> setTypeCompletes = Arrays.asList("build", "destroy", "switch", "itemuse");
    public static final List<String> setOnOffCompletes = Collections.unmodifiableList(Arrays.asList("on", "off"));
    private static final List<String> toggleTypeOnOffCompletes = Arrays.asList("build", "destroy", "switch", "itemuse", "on", "off");
    public static final List<String> numbers = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9");

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return BaseCommand.getTownyStartingWith(args[args.length - 1], "rtn");
    }

    public static List<String> getTownyStartingWith(String arg, String type) {
        ArrayList<String> matches = new ArrayList<String>();
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (type.contains("r")) {
            matches.addAll(townyUniverse.getResidentsTrie().getStringsFromKey(arg));
        }
        if (type.contains("t")) {
            matches.addAll(townyUniverse.getTownsTrie().getStringsFromKey(arg));
        }
        if (type.contains("n")) {
            matches.addAll(townyUniverse.getNationsTrie().getStringsFromKey(arg));
        }
        if (type.contains("w")) {
            matches.addAll(NameUtil.filterByStart(NameUtil.getNames(townyUniverse.getTownyWorlds()), arg));
        }
        return matches;
    }

    public static List<String> filterByStartOrGetTownyStartingWith(List<String> filters, String arg, String type) {
        List<String> filtered = NameUtil.filterByStart(filters, arg);
        if (type.isEmpty()) {
            return filtered;
        }
        if (type.contains("+")) {
            filtered.addAll(BaseCommand.getTownyStartingWith(arg, type));
            return filtered;
        }
        if (filtered.size() > 0) {
            return filtered;
        }
        return BaseCommand.getTownyStartingWith(arg, type);
    }

    static List<String> permTabComplete(String[] args) {
        switch (args.length) {
            case 1: {
                return NameUtil.filterByStart(setPermTabCompletes, args[0]);
            }
            case 2: {
                if (setTypeCompletes.contains(args[0].toLowerCase())) {
                    return NameUtil.filterByStart(setOnOffCompletes, args[1]);
                }
                if (!setLevelCompletes.contains(args[0].toLowerCase())) break;
                return NameUtil.filterByStart(toggleTypeOnOffCompletes, args[1]);
            }
            case 3: {
                return NameUtil.filterByStart(setOnOffCompletes, args[2]);
            }
            default: {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getNationResidentNamesOfPlayerStartingWith(Player player, String str) {
        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (res != null && res.hasNation()) {
            return NameUtil.filterByStart(NameUtil.getNames(res.getNationOrNull().getResidents()), str);
        }
        return Collections.emptyList();
    }

    public static List<String> getTownResidentNamesOfPlayerStartingWith(Player player, String str) {
        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (res != null && res.hasTown()) {
            return NameUtil.filterByStart(NameUtil.getNames(res.getTownOrNull().getResidents()), str);
        }
        return new ArrayList<String>();
    }

    public static List<String> getResidentsOfTownStartingWith(String townName, String str) {
        Town town = TownyUniverse.getInstance().getTown(townName);
        if (town != null) {
            return NameUtil.filterByStart(NameUtil.getNames(town.getResidents()), str);
        }
        return Collections.emptyList();
    }

    public static List<String> getResidentsWithoutTownStartingWith(String str) {
        List<Resident> residents = BaseCommand.getOnlinePlayersWithoutTown();
        if (!residents.isEmpty()) {
            return NameUtil.filterByStart(NameUtil.getNames(residents), str);
        }
        return Collections.emptyList();
    }

    public List<String> getVisibleResidentsForPlayerWithoutTownsStartingWith(String arg, CommandSender sender) {
        if (!(sender instanceof Player)) {
            return BaseCommand.getResidentsWithoutTownStartingWith(arg);
        }
        Player player = (Player)sender;
        List residents = BaseCommand.getOnlinePlayersWithoutTown().stream().map(Resident::getPlayer).filter(p -> p != null && player.canSee(p)).map(Player::getName).collect(Collectors.toCollection(ArrayList::new));
        return !residents.isEmpty() ? NameUtil.filterByStart(residents, arg) : Collections.emptyList();
    }

    protected static Optional<Boolean> parseToggleChoice(String str) {
        if (str.equalsIgnoreCase("on")) {
            return Optional.of(true);
        }
        if (str.equalsIgnoreCase("off")) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @NotNull
    protected static Town getTownFromPlayerOrThrow(Player player) throws TownyException {
        return BaseCommand.getTownFromResidentOrThrow(BaseCommand.getResidentOrThrow(player));
    }

    @NotNull
    protected static Town getTownFromResidentOrThrow(@NotNull Resident resident) throws TownyException {
        if (!resident.hasTown()) {
            throw new TownyException(Translatable.of("msg_err_townyobject_x_has_no_town", resident));
        }
        return resident.getTownOrNull();
    }

    @NotNull
    protected static Resident getResidentOrThrow(UUID playerUUID) throws TownyException {
        Resident res = TownyUniverse.getInstance().getResident(playerUUID);
        if (res == null) {
            throw new TownyException(Translatable.of("msg_err_not_registered"));
        }
        return res;
    }

    @NotNull
    @Contract(value="null -> fail")
    protected static Resident getResidentOrThrow(@Nullable Player player) throws TownyException {
        return TownyAPI.getInstance().getResidentOrThrow(player);
    }

    @NotNull
    protected static Resident getResidentOrThrow(String residentName) throws TownyException {
        Resident res = TownyUniverse.getInstance().getResident(residentName);
        if (res == null) {
            throw new TownyException(Translatable.of("msg_err_resident_unknown", residentName));
        }
        return res;
    }

    @NotNull
    protected static Town getTownOrThrow(String townName) throws TownyException {
        Town town = TownyUniverse.getInstance().getTown(townName);
        if (town == null) {
            throw new TownyException(Translatable.of("msg_err_town_unknown", townName));
        }
        return town;
    }

    @NotNull
    protected static Nation getNationOrThrow(String nationName) throws TownyException {
        Nation nation = TownyUniverse.getInstance().getNation(nationName);
        if (nation == null) {
            throw new TownyException(Translatable.of("msg_err_nation_unknown", nationName));
        }
        return nation;
    }

    @NotNull
    protected static Nation getNationFromPlayerOrThrow(Player player) throws TownyException {
        return BaseCommand.getNationFromResidentOrThrow(BaseCommand.getResidentOrThrow(player));
    }

    @NotNull
    protected static Nation getNationFromResidentOrThrow(Resident resident) throws TownyException {
        if (!resident.hasNation()) {
            throw new TownyException(Translatable.of("msg_err_townyobject_x_has_no_nation", resident));
        }
        return resident.getNationOrNull();
    }

    @NotNull
    protected static Nation getNationFromTownOrThrow(Town town) throws TownyException {
        Nation nation = town.getNationOrNull();
        if (nation == null) {
            throw new TownyException(Translatable.of("msg_err_townyobject_x_has_no_nation", town));
        }
        return nation;
    }

    private static List<Resident> getOnlinePlayersWithoutTown() {
        ArrayList<Resident> townlessResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident == null || resident.hasTown()) continue;
            townlessResidents.add(resident);
        }
        return townlessResidents;
    }

    public static void catchPlayer(CommandSender sender) throws TownyException {
        if (sender instanceof Player) {
            throw new TownyException(Translatable.of("msg_err_console_only"));
        }
    }

    public static Player catchConsole(CommandSender sender) throws TownyException {
        if (!(sender instanceof Player)) {
            throw new TownyException(Translatable.of("msg_err_player_only"));
        }
        Player player = (Player)sender;
        return player;
    }

    public static void checkPermOrThrow(Permissible permissible, String node) throws NoPermissionException {
        TownyUniverse.getInstance().getPermissionSource().testPermissionOrThrow(permissible, node);
    }

    public static void checkPermOrThrowWithMessage(Permissible permissible, String node, Translatable errormsg) throws NoPermissionException {
        TownyUniverse.getInstance().getPermissionSource().testPermissionOrThrow(permissible, node, errormsg);
    }
}

