/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.config.migration;

import com.palmergames.bukkit.config.CommentedConfiguration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class RunnableMigrations {
    private final Map<String, Consumer<CommentedConfiguration>> BY_NAME = new HashMap<String, Consumer<CommentedConfiguration>>();
    private final Consumer<CommentedConfiguration> MIGRATE_NOTIFICATIONS = config -> {
        if (Boolean.parseBoolean(config.getString("notification.notifications_appear_in_action_bar", "true"))) {
            config.set("notification.notifications_appear_as", "action_bar");
        } else if (Boolean.parseBoolean(config.getString("notification.notifications_appear_on_bossbar", "false"))) {
            config.set("notification.notifications_appear_as", "bossbar");
        } else {
            config.set("notification.notifications_appear_as", "chat");
        }
    };
    private final Consumer<CommentedConfiguration> ADD_TOWNBLOCKTYPE_LIMITS = config -> {
        for (Map level : config.getMapList("levels.town_level")) {
            level.put("townBlockTypeLimits", new HashMap());
        }
    };

    public RunnableMigrations() {
        this.BY_NAME.put("migrate_notifications", this.MIGRATE_NOTIFICATIONS);
        this.BY_NAME.put("add_townblocktype_limits", this.ADD_TOWNBLOCKTYPE_LIMITS);
    }

    @Nullable
    public Consumer<CommentedConfiguration> getByName(String name) {
        return this.BY_NAME.get(name.toLowerCase(Locale.ROOT));
    }

    public boolean addMigration(String name, Consumer<CommentedConfiguration> migration) {
        if (this.BY_NAME.containsKey(name.toLowerCase(Locale.ROOT))) {
            return false;
        }
        this.BY_NAME.put(name.toLowerCase(Locale.ROOT), migration);
        return true;
    }
}

