/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.config.migration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.config.migration.Change;
import com.palmergames.bukkit.config.migration.MigrationType;
import com.palmergames.bukkit.config.migration.RunnableMigrations;
import com.palmergames.bukkit.config.migration.VersionDeserializer;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ConfigMigrator {
    private final String migrationFilename;
    private final Version lastRunVersion;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Version.class, (Object)new VersionDeserializer()).create();
    private final CommentedConfiguration config;
    private final CommentedConfiguration townyperms;
    private final boolean earlyRun;
    private final Plugin plugin;
    private final RunnableMigrations runnableMigrations = new RunnableMigrations();

    public ConfigMigrator(@NotNull CommentedConfiguration config, @NotNull String filename, boolean earlyRun) {
        Objects.requireNonNull(config, "ConfigMigrator: config cannot be null");
        Objects.requireNonNull(filename, "ConfigMigrator: filename cannot be null");
        this.migrationFilename = filename;
        this.config = config;
        this.townyperms = TownyPerms.getTownyPermsFile();
        this.earlyRun = earlyRun;
        this.plugin = Towny.getPlugin();
        this.lastRunVersion = Version.fromString(config.getString(ConfigNodes.LAST_RUN_VERSION.getRoot(), "0.0.0.0"));
    }

    public ConfigMigrator(@NotNull Plugin plugin, @NotNull CommentedConfiguration config, @NotNull String filename, @NotNull Version lastRunVersion, boolean earlyRun) {
        Objects.requireNonNull(config, "ConfigMigrator: config cannot be null");
        Objects.requireNonNull(filename, "ConfigMigrator: filename cannot be null");
        Objects.requireNonNull(lastRunVersion, "ConfigMigrator: lastRunVersion cannot be null");
        Objects.requireNonNull(plugin, "ConfigMigrator: plugin cannot be null");
        this.plugin = plugin;
        this.config = config;
        this.migrationFilename = filename;
        this.lastRunVersion = lastRunVersion;
        this.earlyRun = earlyRun;
        this.townyperms = TownyPerms.getTownyPermsFile();
    }

    public void migrate() {
        boolean saveTownyperms = false;
        int totalChangeCount = 0;
        for (Migration migration : this.readMigrator()) {
            int changeCount;
            if (this.lastRunVersion.compareTo(migration.version) >= 0 || (changeCount = this.getChangeCount(migration)) == 0) continue;
            this.plugin.getLogger().info("Config: " + migration.version + " applying " + changeCount + " automatic update" + (changeCount == 1 ? "" : "s") + "...");
            for (Change change : migration.changes) {
                if (change.type.early != this.earlyRun) continue;
                this.performChange(change);
                ++totalChangeCount;
                if (change.type != MigrationType.TOWNYPERMS_ADD) continue;
                saveTownyperms = true;
            }
        }
        if (totalChangeCount > 0) {
            this.config.save();
            if (saveTownyperms) {
                this.townyperms.save();
            }
        }
    }

    private int getChangeCount(Migration migration) {
        int i = 0;
        for (Change change : migration.changes) {
            if (change.type.early != this.earlyRun) continue;
            ++i;
        }
        return i;
    }

    private void performChange(Change change) {
        switch (change.type) {
            case OVERWRITE: {
                this.config.set(change.path, change.value);
                TownyMessaging.sendDebugMsg("Reseting config.yml value at " + change.path + " to " + change.value + ".");
                break;
            }
            case APPEND: {
                String base = this.config.getString(change.path);
                this.config.set(change.path, base + change.value);
                TownyMessaging.sendDebugMsg("Adding " + change.value + " to config.yml value at " + change.path + ".");
                break;
            }
            case TOWN_LEVEL_ADD: {
                this.addTownLevelProperty(change.key, change.value);
                break;
            }
            case NATION_LEVEL_ADD: {
                this.addNationLevelProperty(change.key, change.value);
                break;
            }
            case TOWNYPERMS_ADD: {
                this.addPermissions(change.path, change.value);
                TownyMessaging.sendDebugMsg("Updating townyperms.yml, adding " + change.value + " to " + change.path + " group.");
                break;
            }
            case REPLACE: {
                Object value = this.config.get(change.path);
                if (!(value instanceof String)) break;
                String string = (String)value;
                this.config.set(change.path, string.replaceAll(change.key, change.value));
                break;
            }
            case MOVE: {
                Object oldValue = this.config.get(change.path);
                if (oldValue == null) break;
                this.config.set(change.value, oldValue);
                break;
            }
            case REMOVE: {
                Object path = this.config.get(change.path);
                if (path == null) break;
                TownyMessaging.sendDebugMsg("Removing unneeded config entry: " + change.path);
                this.config.set(change.path, null);
                break;
            }
            case RUNNABLE: {
                Consumer<CommentedConfiguration> consumer = this.runnableMigrations.getByName(change.key);
                if (consumer != null) {
                    consumer.accept(this.config);
                    break;
                }
                this.plugin.getLogger().warning("Config Migrator: Could not find runnable migration with key " + change.key);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Change type: " + change);
            }
        }
        if (change.worldAction != null) {
            for (TownyWorld world : TownyUniverse.getInstance().getTownyWorlds()) {
                TownyMessaging.sendDebugMsg("Updating " + world.getName() + " with " + change.value);
                change.worldAction.getAction().accept(world, change);
                world.save();
            }
        }
    }

    private void addPermissions(String key, String value) {
        List<String> groupNodes = TownyPerms.getPermsOfGroup(key);
        if (groupNodes.contains(value)) {
            return;
        }
        groupNodes.add(value);
        this.townyperms.set(key, groupNodes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Migration> readMigrator() {
        try (InputStream is = this.plugin.getResource(this.migrationFilename);){
            List list;
            if (is == null) {
                this.plugin.getLogger().warning("Could not find config migrator file '" + this.migrationFilename + "' in the jar.");
                List<Migration> list2 = Collections.emptyList();
                return list2;
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                list = (List)GSON.fromJson((Reader)reader, new TypeToken<List<Migration>>(){}.getType());
            }
            return list;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public void addTownLevelProperty(String key, String value) {
        List mapList = this.config.getMapList("levels.town_level");
        TownyMessaging.sendDebugMsg("Updating town_level with " + key + " set to " + value);
        for (Map genericMap : mapList) {
            Map map = genericMap;
            if (map.containsKey(key)) continue;
            map.put(key, value);
        }
        this.config.set("levels.town_level", mapList);
    }

    public void addNationLevelProperty(String key, String value) {
        List mapList = this.config.getMapList("levels.nation_level");
        TownyMessaging.sendDebugMsg("Updating nation_level with " + key + " set to " + value);
        for (Map genericMap : mapList) {
            Map map = genericMap;
            if (map.containsKey(key)) continue;
            map.put(key, value);
        }
        this.config.set("levels.nation_level", mapList);
    }

    public RunnableMigrations getRunnableMigrations() {
        return this.runnableMigrations;
    }

    static final class Migration {
        Version version;
        List<Change> changes;

        Migration() {
        }

        public String toString() {
            return "Migration{version=" + this.version + ", changes=" + this.changes + '}';
        }
    }
}

