/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.eventwar;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import java.util.HashSet;
import org.bukkit.entity.Player;

public class WarZoneData {
    private HashSet<Player> attackers = new HashSet();
    private HashSet<Player> defenders = new HashSet();
    private HashSet<Town> attackerTowns = new HashSet();
    private HashSet<Player> allPlayers = new HashSet();

    public int getHealthChange() {
        return this.defenders.size() - this.attackers.size();
    }

    public void addAttacker(Player p) throws NotRegisteredException {
        if (!p.isDead()) {
            Resident resident = TownyUniverse.getInstance().getResident(p.getUniqueId());
            if (resident == null) {
                throw new NotRegisteredException(Translation.of("msg_not_registered_1", p.getName()));
            }
            this.attackerTowns.add(resident.getTown());
            this.allPlayers.add(p);
            this.attackers.add(p);
        }
    }

    public void addDefender(Player p) {
        if (!p.isDead()) {
            this.allPlayers.add(p);
            this.defenders.add(p);
        }
    }

    public boolean hasAttackers() {
        return !this.attackers.isEmpty();
    }

    public boolean hasDefenders() {
        return !this.defenders.isEmpty();
    }

    public HashSet<Player> getAttackers() {
        return this.attackers;
    }

    public HashSet<Player> getDefenders() {
        return this.defenders;
    }

    public HashSet<Town> getAttackerTowns() {
        return this.attackerTowns;
    }

    public Player getRandomAttacker() {
        int index = (int)(Math.random() * (double)this.attackers.size());
        int curIndex = 0;
        for (Player p : this.attackers) {
            if (curIndex == index) {
                return p;
            }
            ++curIndex;
        }
        return null;
    }

    public Player getRandomDefender() {
        int index = (int)(Math.random() * (double)this.defenders.size());
        int curIndex = 0;
        for (Player p : this.defenders) {
            if (curIndex == index) {
                return p;
            }
            ++curIndex;
        }
        return null;
    }

    public HashSet<Player> getAllPlayers() {
        return this.allPlayers;
    }
}

