/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.NationSpawnEvent;
import com.palmergames.bukkit.towny.event.SpawnEvent;
import com.palmergames.bukkit.towny.event.TownSpawnEvent;
import com.palmergames.bukkit.towny.event.teleport.ResidentSpawnEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.NationSpawnLevel;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownSpawnLevel;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.TownyServerAccount;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.paperlib.PaperLib;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SpawnUtil {
    private static Towny plugin;

    public static void initialize(Towny plugin) {
        SpawnUtil.plugin = plugin;
    }

    public static void sendToTownySpawn(Player player, String[] split, TownyObject townyObject, String notAffordMSG, boolean outpost, boolean ignoreWarn, SpawnType spawnType) throws TownyException {
        try {
            List<String> disallowedZones;
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            Resident resident = townyUniverse.getResident(player.getUniqueId());
            if (resident == null) {
                throw new TownyException(Translatable.of("msg_err_not_registered_1", player.getName()));
            }
            if (TownySettings.getSpawnCooldownTime() > 0 && CooldownTimerTask.hasCooldown(resident.getName(), CooldownTimerTask.CooldownType.TELEPORT)) {
                throw new TownyException(Translatable.of("msg_err_cannot_spawn_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(resident.getName(), CooldownTimerTask.CooldownType.TELEPORT)));
            }
            if (resident.isJailed()) {
                throw new TownyException(Translatable.of("msg_cannot_spawn_while_jailed"));
            }
            Town town = null;
            Nation nation = null;
            Location spawnLoc = null;
            TownSpawnLevel townSpawnPermission = null;
            NationSpawnLevel nationSpawnPermission = null;
            boolean isTownyAdmin = townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_SPAWN_ADMIN.getNode());
            switch (spawnType) {
                case RESIDENT: {
                    if (resident.hasTown()) {
                        town = resident.getTown();
                    }
                    spawnLoc = TownySettings.getBedUse() && player.getBedSpawnLocation() != null ? player.getBedSpawnLocation() : (town != null ? town.getSpawn() : plugin.getCache(player).getLastLocation().getWorld().getSpawnLocation());
                    if (isTownyAdmin) {
                        townSpawnPermission = TownSpawnLevel.ADMIN;
                        break;
                    }
                    townSpawnPermission = TownSpawnLevel.TOWN_RESIDENT;
                    break;
                }
                case TOWN: {
                    Nation playerNation;
                    town = (Town)townyObject;
                    if (outpost) {
                        if (!town.hasOutpostSpawn()) {
                            throw new TownyException(Translatable.of("msg_err_outpost_spawn"));
                        }
                        Integer index = null;
                        try {
                            if (!split[split.length - 1].contains("name:")) {
                                index = Integer.parseInt(split[split.length - 1]);
                            } else {
                                split[split.length - 1] = split[split.length - 1].replace("name:", "").replace("_", " ");
                                for (Location loc : town.getAllOutpostSpawns()) {
                                    String name;
                                    TownBlock tboutpost = TownyAPI.getInstance().getTownBlock(loc);
                                    if (tboutpost == null || !(name = !tboutpost.hasPlotObjectGroup() ? tboutpost.getName() : tboutpost.getPlotObjectGroup().getName()).startsWith(split[split.length - 1])) continue;
                                    index = 1 + town.getAllOutpostSpawns().indexOf(loc);
                                }
                                if (index == null) {
                                    index = 1;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            index = 1;
                            split[split.length - 1] = split[split.length - 1].replace("_", " ");
                            for (Location loc : town.getAllOutpostSpawns()) {
                                String name;
                                TownBlock tboutpost = TownyAPI.getInstance().getTownBlock(loc);
                                if (tboutpost == null || !(name = !tboutpost.hasPlotObjectGroup() ? tboutpost.getName() : tboutpost.getPlotObjectGroup().getName()).startsWith(split[split.length - 1].toLowerCase())) continue;
                                index = 1 + town.getAllOutpostSpawns().indexOf(loc);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException i) {
                            index = 1;
                        }
                        if (TownySettings.isOutpostLimitStoppingTeleports() && TownySettings.isOutpostsLimitedByLevels() && town.isOverOutpostLimit() && Math.max(1, index) > town.getOutpostLimit()) {
                            throw new TownyException(Translatable.of("msg_err_over_outposts_limit", town.getMaxOutpostSpawn(), town.getOutpostLimit()));
                        }
                        spawnLoc = town.getOutpostSpawn(Math.max(1, index));
                    } else {
                        spawnLoc = town.getSpawn();
                    }
                    if (isTownyAdmin) {
                        townSpawnPermission = TownSpawnLevel.ADMIN;
                    } else if (split.length == 0 && !outpost) {
                        townSpawnPermission = TownSpawnLevel.TOWN_RESIDENT;
                    } else if (!resident.hasTown()) {
                        townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
                    } else if (resident.getTown() == town) {
                        townSpawnPermission = outpost ? TownSpawnLevel.TOWN_RESIDENT_OUTPOST : TownSpawnLevel.TOWN_RESIDENT;
                    } else if (resident.hasNation() && town.hasNation()) {
                        Nation targetNation;
                        playerNation = resident.getTown().getNation();
                        if (playerNation == (targetNation = town.getNation())) {
                            if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus()) {
                                throw new TownyException(Translatable.of("msg_err_ally_isnt_public", town));
                            }
                            townSpawnPermission = TownSpawnLevel.PART_OF_NATION;
                        } else {
                            if (targetNation.hasEnemy(playerNation)) {
                                throw new TownyException(Translatable.of("msg_err_public_spawn_enemy"));
                            }
                            if (targetNation.hasAlly(playerNation)) {
                                if (!town.isPublic() && TownySettings.isAllySpawningRequiringPublicStatus()) {
                                    throw new TownyException(Translatable.of("msg_err_ally_isnt_public", town));
                                }
                                townSpawnPermission = TownSpawnLevel.NATION_ALLY;
                            } else {
                                townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
                            }
                        }
                    } else {
                        townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
                    }
                    TownyMessaging.sendDebugMsg(townSpawnPermission.toString() + " " + townSpawnPermission.isAllowed(town));
                    townSpawnPermission.checkIfAllowed(plugin, player, town);
                    if (!isTownyAdmin && !(townSpawnPermission != TownSpawnLevel.UNAFFILIATED ? townSpawnPermission.hasPermissionNode(plugin, player, town) : town.isPublic())) {
                        throw new TownyException(Translatable.of("msg_err_not_public"));
                    }
                    if (isTownyAdmin || !town.hasOutlaw(resident)) break;
                    throw new TownyException(Translatable.of("msg_error_cannot_town_spawn_youre_an_outlaw_in_town", town));
                }
                case NATION: {
                    Nation playerNation;
                    nation = (Nation)townyObject;
                    spawnLoc = nation.getSpawn();
                    if (isTownyAdmin) {
                        nationSpawnPermission = NationSpawnLevel.ADMIN;
                    } else if (split.length == 0) {
                        nationSpawnPermission = NationSpawnLevel.PART_OF_NATION;
                    } else if (!resident.hasTown()) {
                        nationSpawnPermission = NationSpawnLevel.UNAFFILIATED;
                    } else if (resident.hasNation()) {
                        playerNation = resident.getTown().getNation();
                        if (playerNation == nation) {
                            nationSpawnPermission = NationSpawnLevel.PART_OF_NATION;
                        } else {
                            if (nation.hasEnemy(playerNation)) {
                                throw new TownyException(Translatable.of("msg_err_public_spawn_enemy"));
                            }
                            nationSpawnPermission = nation.hasAlly(playerNation) ? NationSpawnLevel.NATION_ALLY : NationSpawnLevel.UNAFFILIATED;
                        }
                    } else {
                        nationSpawnPermission = NationSpawnLevel.UNAFFILIATED;
                    }
                    nationSpawnPermission.checkIfAllowed(plugin, player, nation);
                    if (isTownyAdmin || (nationSpawnPermission != NationSpawnLevel.UNAFFILIATED ? nationSpawnPermission.hasPermissionNode(plugin, player, nation) : nation.isPublic())) break;
                    throw new TownyException(Translatable.of("msg_err_nation_not_public"));
                }
            }
            if (!isTownyAdmin && !(disallowedZones = TownySettings.getDisallowedTownSpawnZones()).isEmpty()) {
                Town townAtPlayerLoc = TownyAPI.getInstance().getTown(player.getLocation());
                if (townAtPlayerLoc == null && disallowedZones.contains("unclaimed")) {
                    throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.getTypeName(), Translatable.of("msg_the_wilderness")));
                }
                if (townAtPlayerLoc != null) {
                    if (townAtPlayerLoc.hasOutlaw(player.getName()) && disallowedZones.contains("outlaw")) {
                        throw new TownyException(Translatable.of("msg_err_outlawed_players_no_teleport"));
                    }
                    if (resident.hasNation() && townAtPlayerLoc.hasNation()) {
                        Nation resNation;
                        if (CombatUtil.isEnemy(resident.getTownOrNull(), townAtPlayerLoc) && disallowedZones.contains("enemy")) {
                            throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.getTypeName(), Translatable.of("msg_enemy_areas")));
                        }
                        Nation townLocNation = townAtPlayerLoc.getNationOrNull();
                        if (!townLocNation.hasAlly(resNation = resident.getNationOrNull()) && !townLocNation.hasEnemy(resNation) && disallowedZones.contains("neutral")) {
                            throw new TownyException(Translatable.of("msg_err_x_spawn_disallowed_from_x", spawnType.getTypeName(), Translatable.of("msg_neutral_towns")));
                        }
                    }
                }
            }
            double travelCost = 0.0;
            String spawnPermission = null;
            Account payee = null;
            if (TownyEconomyHandler.isActive() && !townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_SPAWN_FREECHARGE.getNode()) && !townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOCHARGE.getNode())) {
                switch (spawnType) {
                    case RESIDENT: 
                    case TOWN: {
                        travelCost = Math.min(townSpawnPermission.getCost(town), townSpawnPermission.getCost());
                        spawnPermission = String.format(spawnType.getTypeName() + " (%s)", new Object[]{townSpawnPermission});
                        payee = town.getAccount();
                        break;
                    }
                    case NATION: {
                        travelCost = Math.min(nationSpawnPermission.getCost(nation), nationSpawnPermission.getCost());
                        spawnPermission = String.format(spawnType.getTypeName() + " (%s)", new Object[]{nationSpawnPermission});
                        payee = nation.getAccount();
                    }
                }
                if (!TownySettings.isTownSpawnPaidToTown()) {
                    payee = EconomyAccount.SERVER_ACCOUNT;
                }
                if (travelCost > 0.0 && resident.getAccount().getHoldingBalance() < travelCost) {
                    throw new TownyException(notAffordMSG);
                }
            }
            if (!SpawnUtil.sendSpawnEvent(player, spawnType, spawnLoc)) {
                return;
            }
            if (TownyEconomyHandler.isActive() && travelCost > 0.0) {
                double finalCost = travelCost;
                TownyServerAccount finalPayee = payee;
                String finalSpawnPerm = spawnPermission;
                Location finalLoc = spawnLoc;
                if (ignoreWarn || !TownySettings.isSpawnWarnConfirmationUsed()) {
                    if (resident.getAccount().payTo(finalCost, finalPayee, finalSpawnPerm)) {
                        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_cost_spawn", TownyEconomyHandler.getFormattedBalance(finalCost)));
                        SpawnUtil.initiateSpawn(player, finalLoc);
                    }
                } else {
                    String title = Translatable.of("msg_spawn_warn", TownyEconomyHandler.getFormattedBalance(travelCost)).forLocale((CommandSender)player);
                    Confirmation.runOnAccept(() -> {
                        if (resident.getAccount().payTo(finalCost, finalPayee, finalSpawnPerm)) {
                            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_cost_spawn", TownyEconomyHandler.getFormattedBalance(finalCost)));
                            SpawnUtil.initiateSpawn(player, finalLoc);
                        }
                    }).setTitle(title).sendTo((CommandSender)player);
                }
            } else {
                SpawnUtil.initiateSpawn(player, spawnLoc);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public static boolean sendSpawnEvent(Player player, SpawnType type, Location spawnLoc) {
        SpawnEvent spawnEvent = null;
        switch (type) {
            case RESIDENT: {
                spawnEvent = new ResidentSpawnEvent(player, player.getLocation(), spawnLoc);
                break;
            }
            case TOWN: {
                spawnEvent = new TownSpawnEvent(player, player.getLocation(), spawnLoc);
                break;
            }
            case NATION: {
                spawnEvent = new NationSpawnEvent(player, player.getLocation(), spawnLoc);
            }
        }
        Bukkit.getPluginManager().callEvent(spawnEvent);
        if (spawnEvent.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, spawnEvent.getCancelMessage());
            return false;
        }
        return true;
    }

    private static void initiateSpawn(Player player, Location spawnLoc) {
        if (TownyTimerHandler.isTeleportWarmupRunning() && !TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOWARMUP.getNode())) {
            TownyMessaging.sendMsg((CommandSender)player, Translatable.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
            TownyAPI.getInstance().requestTeleport(player, spawnLoc);
        } else {
            if (player.getVehicle() != null) {
                player.getVehicle().eject();
            }
            PaperLib.teleportAsync((Entity)player, spawnLoc, PlayerTeleportEvent.TeleportCause.COMMAND);
            if (TownySettings.getSpawnCooldownTime() > 0 && !TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_SPAWN_ADMIN_NOCOOLDOWN.getNode())) {
                CooldownTimerTask.addCooldownTimer(player.getName(), CooldownTimerTask.CooldownType.TELEPORT);
            }
        }
    }

    public static void outlawTeleport(Town town, Resident outlaw) {
        Location spawnLocation = town.getWorld().getSpawnLocation();
        Player outlawedPlayer = outlaw.getPlayer();
        if (!TownySettings.getOutlawTeleportWorld().equals("")) {
            spawnLocation = Objects.requireNonNull(Bukkit.getWorld((String)TownySettings.getOutlawTeleportWorld())).getSpawnLocation();
        }
        if (outlawedPlayer.getBedSpawnLocation() != null && TownyAPI.getInstance().getTown(outlawedPlayer.getBedSpawnLocation()) != town) {
            spawnLocation = outlawedPlayer.getBedSpawnLocation();
        }
        if (outlaw.hasTown() && TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer) != null) {
            spawnLocation = TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer);
        }
        TownyMessaging.sendMsg(outlaw, Translatable.of("msg_outlaw_kicked", town));
        PaperLib.teleportAsync((Entity)outlaw.getPlayer(), spawnLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }
}

