/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.util.JavaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class EntityTypeUtil {
    private static List<EntityType> ExplosiveEntityTypes = new ArrayList<EntityType>(Arrays.asList(EntityType.CREEPER, EntityType.DRAGON_FIREBALL, EntityType.FIREBALL, EntityType.SMALL_FIREBALL, EntityType.FIREWORK, EntityType.MINECART_TNT, EntityType.PRIMED_TNT, EntityType.WITHER, EntityType.WITHER_SKULL, EntityType.ENDER_CRYSTAL));
    private static List<EntityType> ExplosivePVMEntityTypes = new ArrayList<EntityType>(Arrays.asList(EntityType.CREEPER, EntityType.DRAGON_FIREBALL, EntityType.FIREBALL, EntityType.SMALL_FIREBALL, EntityType.WITHER, EntityType.WITHER_SKULL, EntityType.ENDER_CRYSTAL));
    private static List<EntityType> ExplosivePVPEntityTypes = new ArrayList<EntityType>(Arrays.asList(EntityType.FIREWORK, EntityType.MINECART_TNT, EntityType.PRIMED_TNT));

    public static boolean isInstanceOfAny(List<Class<?>> classesOfWorldMobsToRemove2, Object obj) {
        for (Class<?> c : classesOfWorldMobsToRemove2) {
            if (!c.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static List<Class<?>> parseLivingEntityClassNames(List<String> mobClassNames, String errorPrefix) {
        ArrayList livingEntityClasses = new ArrayList();
        for (String mobClassName : mobClassNames) {
            if (mobClassName.isEmpty()) continue;
            try {
                Class<?> c = Class.forName("org.bukkit.entity." + mobClassName);
                if (JavaUtil.isSubInterface(LivingEntity.class, c)) {
                    livingEntityClasses.add(c);
                    continue;
                }
                throw new Exception();
            }
            catch (ClassNotFoundException e) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable class.", errorPrefix, mobClassName));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(String.format("%s%s is not an acceptable living entity.", errorPrefix, mobClassName));
            }
        }
        return livingEntityClasses;
    }

    @Nullable
    public static Material parseEntityToMaterial(EntityType entityType) {
        Material material = null;
        switch (entityType) {
            case AXOLOTL: {
                material = Material.AXOLOTL_SPAWN_EGG;
                break;
            }
            case COD: {
                material = Material.COD;
                break;
            }
            case SALMON: {
                material = Material.SALMON;
                break;
            }
            case PUFFERFISH: {
                material = Material.PUFFERFISH;
                break;
            }
            case TROPICAL_FISH: {
                material = Material.TROPICAL_FISH;
                break;
            }
            case ITEM_FRAME: {
                material = Material.ITEM_FRAME;
                break;
            }
            case GLOW_ITEM_FRAME: {
                material = Material.GLOW_ITEM_FRAME;
                break;
            }
            case PAINTING: {
                material = Material.PAINTING;
                break;
            }
            case ARMOR_STAND: {
                material = Material.ARMOR_STAND;
                break;
            }
            case LEASH_HITCH: {
                material = Material.LEAD;
                break;
            }
            case ENDER_CRYSTAL: {
                material = Material.END_CRYSTAL;
                break;
            }
            case MINECART: 
            case MINECART_MOB_SPAWNER: {
                material = Material.MINECART;
                break;
            }
            case MINECART_CHEST: {
                material = Material.CHEST_MINECART;
                break;
            }
            case MINECART_FURNACE: {
                material = Material.FURNACE_MINECART;
                break;
            }
            case MINECART_COMMAND: {
                material = Material.COMMAND_BLOCK_MINECART;
                break;
            }
            case MINECART_HOPPER: {
                material = Material.HOPPER_MINECART;
                break;
            }
            case MINECART_TNT: {
                material = Material.TNT_MINECART;
                break;
            }
            case BOAT: {
                material = Material.OAK_BOAT;
                break;
            }
        }
        return material;
    }

    public static boolean isExplosive(EntityType entityType) {
        return ExplosiveEntityTypes.contains(entityType);
    }

    public static boolean isPVPExplosive(EntityType entityType) {
        return ExplosivePVPEntityTypes.contains(entityType);
    }

    public static boolean isPVMExplosive(EntityType entityType) {
        return ExplosivePVMEntityTypes.contains(entityType);
    }
}

