/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.CellBorder;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class BorderUtil {
    public static List<CellBorder> getOuterBorder(List<WorldCoord> worldCoords) {
        ArrayList<CellBorder> borderCoords = new ArrayList<CellBorder>();
        for (WorldCoord worldCoord : worldCoords) {
            boolean[] blArray = new boolean[8];
            blArray[0] = !worldCoords.contains(worldCoord.add(-1, 0));
            blArray[1] = !worldCoords.contains(worldCoord.add(-1, -1));
            blArray[2] = !worldCoords.contains(worldCoord.add(0, -1));
            blArray[3] = !worldCoords.contains(worldCoord.add(1, -1));
            blArray[4] = !worldCoords.contains(worldCoord.add(1, 0));
            blArray[5] = !worldCoords.contains(worldCoord.add(1, 1));
            blArray[6] = !worldCoords.contains(worldCoord.add(0, 1));
            boolean bl = blArray[7] = !worldCoords.contains(worldCoord.add(-1, 1));
            CellBorder border = new CellBorder(worldCoord, blArray);
            if (!border.hasAnyBorder()) continue;
            borderCoords.add(border);
        }
        return borderCoords;
    }

    public static List<CellBorder> getPlotBorder(List<WorldCoord> worldCoords) {
        ArrayList<CellBorder> borderCoords = new ArrayList<CellBorder>();
        for (WorldCoord worldCoord : worldCoords) {
            CellBorder border = BorderUtil.getPlotBorder(worldCoord);
            borderCoords.add(border);
        }
        return borderCoords;
    }

    public static CellBorder getPlotBorder(WorldCoord worldCoord) {
        return new CellBorder(worldCoord, new boolean[]{true, true, true, true, true, true, true, true});
    }

    public static List<BlockState> allowedBlocks(List<BlockState> blocks, Block originBlock) {
        return blocks.stream().filter(blockState -> BorderUtil.allowedMove(originBlock, blockState.getBlock())).collect(Collectors.toList());
    }

    public static List<BlockState> disallowedBlocks(List<BlockState> blocks, Block originBlock) {
        return blocks.stream().filter(blockState -> !BorderUtil.allowedMove(originBlock, blockState.getBlock())).collect(Collectors.toList());
    }

    public static boolean allowedMove(Block block, Block blockTo) {
        WorldCoord to;
        WorldCoord from = WorldCoord.parseWorldCoord(block);
        if (from.equals(to = WorldCoord.parseWorldCoord(blockTo)) || TownyAPI.getInstance().isWilderness(to)) {
            return true;
        }
        if (!from.hasTownBlock()) {
            return false;
        }
        TownBlock currentTownBlock = from.getTownBlockOrNull();
        TownBlock destinationTownBlock = to.getTownBlockOrNull();
        if (currentTownBlock.hasResident() != destinationTownBlock.hasResident()) {
            return false;
        }
        if (currentTownBlock.hasResident() && destinationTownBlock.hasResident() && currentTownBlock.getResidentOrNull() == destinationTownBlock.getResidentOrNull()) {
            return true;
        }
        return currentTownBlock.getTownOrNull() == destinationTownBlock.getTownOrNull() && !currentTownBlock.hasResident() && !destinationTownBlock.hasResident();
    }
}

