/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlotClaim
extends Thread {
    Towny plugin;
    private final Player player;
    private final Resident resident;
    private final List<WorldCoord> selection;
    private final boolean claim;
    private final boolean admin;
    private final boolean groupClaim;

    public PlotClaim(Towny plugin, Player player, Resident resident, List<WorldCoord> selection, boolean claim, boolean admin, boolean groupClaim) {
        this.plugin = plugin;
        this.player = player;
        this.resident = resident;
        this.selection = selection;
        this.claim = claim;
        this.admin = admin;
        this.groupClaim = groupClaim;
        this.setPriority(1);
    }

    @Override
    public void run() {
        int claimed = 0;
        if (this.player != null) {
            if (this.claim) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_process_claim"));
            } else {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_process_unclaim"));
            }
        }
        if (this.selection != null) {
            for (WorldCoord worldCoord : this.selection) {
                block27: {
                    try {
                        if (!worldCoord.getTownBlock().hasPlotObjectGroup()) break block27;
                        if (TownyEconomyHandler.isActive() && worldCoord.getTownBlock().getPlotObjectGroup().getPrice() != -1.0) {
                            if (worldCoord.getTownBlock().getPlotObjectGroup().hasResident()) {
                                if (!this.resident.getAccount().payTo(worldCoord.getTownBlock().getPlotObjectGroup().getPrice(), worldCoord.getTownBlock().getPlotObjectGroup().getResident(), "Plot Group - Buy From Seller")) {
                                    TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_no_money_purchase_plot"));
                                    break;
                                }
                            } else {
                                double bankcap = TownySettings.getTownBankCap();
                                if (bankcap > 0.0 && worldCoord.getTownBlock().getPlotObjectGroup().getPrice() + worldCoord.getTownBlock().getPlotObjectGroup().getTown().getAccount().getHoldingBalance() > bankcap) {
                                    throw new TownyException(Translatable.of("msg_err_deposit_capped", bankcap));
                                }
                                if (!this.resident.getAccount().payTo(worldCoord.getTownBlock().getPlotObjectGroup().getPrice(), worldCoord.getTownBlock().getPlotObjectGroup().getTown(), "Plot Group - Buy From Town")) {
                                    TownyMessaging.sendErrorMsg((CommandSender)this.player, Translatable.of("msg_no_money_purchase_plot"));
                                    break;
                                }
                            }
                        }
                        if (!this.residentGroupClaim(this.selection)) break block27;
                        ++claimed;
                        worldCoord.getTownBlock().getPlotObjectGroup().setResident(this.resident);
                        worldCoord.getTownBlock().getPlotObjectGroup().setPrice(-1.0);
                        TownyMessaging.sendPrefixedTownMessage(worldCoord.getTownBlock().getTown(), Translatable.of("msg_player_successfully_bought_group_x", this.player.getName(), worldCoord.getTownBlock().getPlotObjectGroup().getName()));
                        worldCoord.getTownBlock().getPlotObjectGroup().save();
                        break;
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)this.player, e.getMessage((CommandSender)this.player));
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)this.player, e.getMessage());
                    }
                }
                if (!TownyAPI.getInstance().isTownyWorld(worldCoord.getBukkitWorld())) continue;
                try {
                    if (this.claim) {
                        if (this.groupClaim) continue;
                        if (!this.admin) {
                            if (!this.residentClaim(worldCoord)) continue;
                            ++claimed;
                            continue;
                        }
                        this.adminClaim(worldCoord);
                        ++claimed;
                        continue;
                    }
                    this.residentUnclaim(worldCoord);
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)this.player, x.getMessage((CommandSender)this.player));
                }
            }
        } else if (!this.claim) {
            this.residentUnclaimAll();
        }
        if (this.player != null) {
            if (this.claim) {
                if (this.selection != null && this.selection.size() > 0 && claimed > 0) {
                    TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_claimed").forLocale((CommandSender)this.player) + " " + (this.selection.size() > 5 ? Translatable.of("msg_total_townblocks").forLocale((CommandSender)this.player) + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
                } else {
                    TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_not_claimed_1"));
                }
            } else if (this.selection != null) {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_unclaimed").forLocale((CommandSender)this.player) + " " + (this.selection.size() > 5 ? Translatable.of("msg_total_townblocks").forLocale((CommandSender)this.player) + this.selection.size() : Arrays.toString(this.selection.toArray(new WorldCoord[0]))));
            } else {
                TownyMessaging.sendMsg((CommandSender)this.player, Translatable.of("msg_unclaimed"));
            }
        }
        this.resident.save();
        this.plugin.resetCache();
    }

    private boolean residentGroupClaim(List<WorldCoord> worldCoords) throws TownyException {
        for (int i = 0; i < worldCoords.size(); ++i) {
            WorldCoord worldCoord = worldCoords.get(i);
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                Town town = townBlock.getTown();
                PlotGroup group = townBlock.getPlotObjectGroup();
                if (this.resident.hasTown() && this.resident.getTown() != town && !townBlock.getType().equals((Object)TownBlockType.EMBASSY) || !this.resident.hasTown() && !townBlock.getType().equals((Object)TownBlockType.EMBASSY)) {
                    throw new TownyException(Translatable.of("msg_err_not_part_town"));
                }
                if (townBlock.getPlotObjectGroup().hasResident()) {
                    Resident owner = townBlock.getPlotObjectGroup().getResident();
                    if (group.getPrice() != -1.0) {
                        int maxPlots = TownySettings.getMaxResidentPlots(this.resident);
                        int extraPlots = TownySettings.getMaxResidentExtraPlots(this.resident);
                        if (maxPlots != -1) {
                            maxPlots += extraPlots;
                        }
                        if (maxPlots >= 0 && this.resident.getTownBlocks().size() + group.getTownBlocks().size() > maxPlots) {
                            throw new TownyException(Translatable.of("msg_max_plot_own", maxPlots));
                        }
                        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_buy_resident_plot", this.resident.getName(), owner.getName(), townBlock.getPlotObjectGroup().getPrice()));
                        townBlock.setResident(this.resident);
                        owner.save();
                        group.save();
                        townBlock.save();
                        if (i >= worldCoords.size() - 2) {
                            TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_player_successfully_bought_group_x", this.resident.getName(), group.getName()));
                        }
                        this.plugin.updateCache(worldCoord);
                        continue;
                    }
                    if (this.player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode())) {
                        if (TownyEconomyHandler.isActive() && !town.getAccount().payTo(0.0, owner, "Plot - Buy Back")) {
                            throw new TownyException(Translatable.of("msg_town_no_money_purchase_plot"));
                        }
                        TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_buy_resident_plot", town.getName(), owner.getName(), 0.0));
                        townBlock.setResident(this.resident);
                        owner.save();
                        group.save();
                        townBlock.save();
                        continue;
                    }
                    throw new AlreadyRegisteredException(Translatable.of("msg_already_claimed", owner.getName()).forLocale((CommandSender)this.player));
                }
                if (townBlock.getPlotObjectGroup().getPrice() == -1.0) {
                    throw new TownyException(Translatable.of("msg_err_plot_nfs"));
                }
                townBlock.setResident(this.resident);
                townBlock.setType(townBlock.getType());
                townBlock.save();
                continue;
            }
            catch (NotRegisteredException e) {
                throw new TownyException(Translatable.of("msg_err_not_part_town"));
            }
        }
        return true;
    }

    private boolean residentClaim(WorldCoord worldCoord) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            Town town = townBlock.getTown();
            if (this.resident.hasTown() && this.resident.getTown() != town && !townBlock.getType().equals((Object)TownBlockType.EMBASSY) || !this.resident.hasTown() && !townBlock.getType().equals((Object)TownBlockType.EMBASSY)) {
                throw new TownyException(Translatable.of("msg_err_not_part_town"));
            }
            if (townBlock.hasResident()) {
                Resident owner = townBlock.getResidentOrNull();
                if (townBlock.getPlotPrice() != -1.0) {
                    if (TownyEconomyHandler.isActive() && !this.resident.getAccount().payTo(townBlock.getPlotPrice(), owner, "Plot - Buy From Seller")) {
                        throw new TownyException(Translatable.of("msg_no_money_purchase_plot"));
                    }
                    int maxPlots = TownySettings.getMaxResidentPlots(this.resident);
                    int extraPlots = TownySettings.getMaxResidentExtraPlots(this.resident);
                    if (maxPlots != -1) {
                        maxPlots += extraPlots;
                    }
                    if (maxPlots >= 0 && this.resident.getTownBlocks().size() + 1 > maxPlots) {
                        throw new TownyException(Translatable.of("msg_max_plot_own", maxPlots));
                    }
                    TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_buy_resident_plot", this.resident.getName(), owner.getName(), townBlock.getPlotPrice()));
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setResident(this.resident);
                    townBlock.setType(townBlock.getType());
                    owner.save();
                    townBlock.save();
                    this.plugin.updateCache(worldCoord);
                    return true;
                }
                if (this.player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode())) {
                    if (TownyEconomyHandler.isActive() && !town.getAccount().payTo(0.0, owner, "Plot - Buy Back")) {
                        throw new TownyException(Translatable.of("msg_town_no_money_purchase_plot"));
                    }
                    TownyMessaging.sendPrefixedTownMessage(town, Translatable.of("msg_buy_resident_plot", town.getName(), owner.getName(), 0.0));
                    townBlock.setResident(null);
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setType(townBlock.getType());
                    owner.save();
                    townBlock.save();
                    return true;
                }
                throw new AlreadyRegisteredException(Translatable.of("msg_already_claimed", owner.getName()).forLocale((CommandSender)this.player));
            }
            if (townBlock.getPlotPrice() == -1.0) {
                throw new TownyException(Translatable.of("msg_err_plot_nfs"));
            }
            double bankcap = TownySettings.getTownBankCap();
            if (TownyEconomyHandler.isActive() && bankcap > 0.0 && townBlock.getPlotPrice() + town.getAccount().getHoldingBalance() > bankcap) {
                throw new TownyException(Translatable.of("msg_err_deposit_capped", bankcap));
            }
            if (TownyEconomyHandler.isActive() && !this.resident.getAccount().payTo(townBlock.getPlotPrice(), town, "Plot - Buy From Town")) {
                throw new TownyException(Translatable.of("msg_no_money_purchase_plot"));
            }
            townBlock.setPlotPrice(-1.0);
            townBlock.setResident(this.resident);
            townBlock.setType(townBlock.getType());
            townBlock.save();
            return true;
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translatable.of("msg_err_not_part_town"));
        }
    }

    private boolean residentUnclaim(WorldCoord worldCoord) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            townBlock.setResident(null);
            townBlock.setPlotPrice(townBlock.getTown().getPlotTypePrice(townBlock.getType()));
            townBlock.setType(townBlock.getType());
            townBlock.save();
            this.plugin.updateCache(worldCoord);
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translatable.of("msg_not_own_place"));
        }
        return true;
    }

    private void residentUnclaimAll() {
        ArrayList<TownBlock> selection = new ArrayList<TownBlock>(this.resident.getTownBlocks());
        for (TownBlock townBlock : selection) {
            try {
                this.residentUnclaim(townBlock.getWorldCoord());
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)this.player, e.getMessage((CommandSender)this.player));
            }
        }
    }

    private void adminClaim(WorldCoord worldCoord) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            Town town = townBlock.getTown();
            townBlock.setPlotPrice(-1.0);
            townBlock.setResident(this.resident);
            townBlock.setType(townBlock.getType());
            townBlock.save();
            TownyMessaging.sendResidentMessage(this.resident, Translatable.of("msg_admin_has_given_you_a_plot", worldCoord.toString()));
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translatable.of("msg_not_claimed_1"));
        }
    }
}

