/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.time.NewHourEvent;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.jail.UnJailReason;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import com.palmergames.bukkit.towny.utils.TownRuinUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class HourlyTimerTask
extends TownyTimerTask {
    public HourlyTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        if (TownySettings.getTownRuinsEnabled()) {
            TownRuinUtil.evaluateRuinedTownRemovals();
        }
        if (TownySettings.getInviteExpirationTime() > 0L) {
            InviteHandler.searchForExpiredInvites();
        }
        if (!this.universe.getJailedResidentMap().isEmpty()) {
            this.decrementJailedHours();
        }
        Bukkit.getPluginManager().callEvent((Event)new NewHourEvent(System.currentTimeMillis()));
    }

    private void decrementJailedHours() {
        for (Resident resident : new ArrayList<Resident>(this.universe.getJailedResidentMap())) {
            if (!resident.hasJailTime()) continue;
            if (resident.getJailHours() <= 1) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> JailUtil.unJailResident(resident, UnJailReason.SENTENCE_SERVED), 20L);
                continue;
            }
            resident.setJailHours(resident.getJailHours() - 1);
            resident.save();
        }
    }
}

