/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.util.AbstractMap;
import java.util.concurrent.ConcurrentHashMap;

public class CooldownTimerTask
extends TownyTimerTask {
    private static ConcurrentHashMap<AbstractMap.SimpleEntry<String, CooldownType>, Long> cooldowns;

    public CooldownTimerTask(Towny plugin) {
        super(plugin);
        cooldowns = new ConcurrentHashMap();
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        if (!cooldowns.isEmpty()) {
            for (AbstractMap.SimpleEntry map : cooldowns.keySet()) {
                long time = cooldowns.get(map);
                if (time >= currentTime) continue;
                cooldowns.remove(map);
            }
        }
    }

    public static void addCooldownTimer(String object, CooldownType type) {
        AbstractMap.SimpleEntry<String, CooldownType> map = new AbstractMap.SimpleEntry<String, CooldownType>(object, type);
        cooldowns.put(map, System.currentTimeMillis() + (long)(type.getSeconds() * 1000));
    }

    public static boolean hasCooldown(String object, CooldownType type) {
        AbstractMap.SimpleEntry<String, CooldownType> map = new AbstractMap.SimpleEntry<String, CooldownType>(object, type);
        return cooldowns.containsKey(map);
    }

    public static int getCooldownRemaining(String object, CooldownType type) {
        AbstractMap.SimpleEntry<String, CooldownType> map = new AbstractMap.SimpleEntry<String, CooldownType>(object, type);
        if (cooldowns.containsKey(map)) {
            return (int)((cooldowns.get(map) - System.currentTimeMillis()) / 1000L);
        }
        return 0;
    }

    public static enum CooldownType {
        PVP(TownySettings.getPVPCoolDownTime()),
        TELEPORT(TownySettings.getSpawnCooldownTime());

        private final int seconds;

        private int getSeconds() {
            return this.seconds;
        }

        private CooldownType(int seconds) {
            this.seconds = seconds;
        }
    }
}

