/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.regen.block.BlockObject;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class PlotBlockData {
    private int defaultVersion = 4;
    private String worldName;
    private TownBlock townBlock;
    private int x;
    private int z;
    private int size;
    private int height;
    private int version;
    private List<String> blockList = new ArrayList<String>();
    private int blockListRestored;

    public PlotBlockData(TownBlock townBlock) {
        this.townBlock = townBlock;
        this.setX(townBlock.getX());
        this.setZ(townBlock.getZ());
        this.setSize(TownySettings.getTownBlockSize());
        this.worldName = townBlock.getWorld().getName();
        this.setVersion(this.defaultVersion);
        this.setHeight(townBlock.getWorldCoord().getBukkitWorld().getMaxHeight() - 1);
        this.blockListRestored = 0;
    }

    public void initialize() {
        List<String> blocks = this.getBlockArr();
        if (blocks != null) {
            this.setBlockList(blocks);
            this.resetBlockListRestored();
        }
    }

    private List<String> getBlockArr() {
        ArrayList<String> list = new ArrayList<String>();
        Block block = null;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        for (int z = 0; z < this.size; ++z) {
            for (int x = 0; x < this.size; ++x) {
                block5: for (int y = this.height; y > 0; --y) {
                    block = world.getBlockAt(this.getX() * this.size + x, y, this.getZ() * this.size + z);
                    switch (this.defaultVersion) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            list.add(block.getBlockData().getAsString(true));
                            continue block5;
                        }
                        default: {
                            list.add(block.getType().getKey().toString());
                        }
                    }
                }
            }
        }
        return list;
    }

    public boolean restoreNextBlock() {
        int scale;
        Block block = null;
        int worldx = this.getX() * this.size;
        int worldz = this.getZ() * this.size;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        if (!world.isChunkLoaded(BukkitTools.calcChunk(this.getX()), BukkitTools.calcChunk(this.getZ()))) {
            return true;
        }
        switch (this.version) {
            case 1: 
            case 2: 
            case 3: {
                scale = 2;
                break;
            }
            case 4: {
                scale = 1;
                break;
            }
            default: {
                scale = 1;
            }
        }
        int reverse = (this.blockList.size() - this.blockListRestored) / scale;
        block11: while (reverse > 0) {
            BlockObject storedData;
            int y = this.height - --reverse % this.height;
            int x = reverse / this.height % this.size;
            int z = reverse / this.height / this.size % this.size;
            block = world.getBlockAt(worldx + x, y, worldz + z);
            Material blockMat = block.getType();
            try {
                storedData = this.getStoredBlockData(this.blockList.size() - 1 - this.blockListRestored);
            }
            catch (IllegalArgumentException e1) {
                TownyMessaging.sendDebugMsg("Towny's revert-on-unclaim feature encountered a block which will not load on the current version of MC. Ignoring and skipping to next block.");
                continue;
            }
            switch (this.version) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.blockListRestored += scale;
                    Material mat = storedData.getMaterial();
                    if (mat == null) {
                        TownyMessaging.sendErrorMsg("PlotBlockData:restoreNextBlock() - Material Null, skipping block.");
                        continue block11;
                    }
                    if (blockMat == mat) continue block11;
                    if (!this.townBlock.getWorld().isPlotManagementIgnoreIds(mat)) {
                        try {
                            block.setType(mat, false);
                            block.setBlockData(storedData.getBlockData());
                            return true;
                        }
                        catch (Exception e) {
                            TownyMessaging.sendErrorMsg("Exception in PlotBlockData.java");
                            continue block11;
                        }
                    }
                    block.setType(Material.AIR);
                    return true;
                }
            }
            TownyMessaging.sendErrorMsg("PlotBlockData:restoreNextBlock() - You should not be seeing this message.");
        }
        this.resetBlockListRestored();
        return false;
    }

    private BlockObject getStoredBlockData(int index) {
        switch (this.version) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new BlockObject(this.blockList.get(index));
            }
        }
        return new BlockObject(this.blockList.get(index));
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<String> getBlockList() {
        return this.blockList;
    }

    public void setBlockList(List<String> blockList) {
        this.blockList = blockList;
    }

    public void resetBlockListRestored() {
        this.blockListRestored = 0;
    }
}

