/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.gui;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.gui.PermissionGUI;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import org.bukkit.inventory.Inventory;

public class EditGUI
extends PermissionGUI {
    private final Resident editor;
    private final Resident selectedResident;

    public EditGUI(Resident res, Inventory inv, String name, TownBlock townBlock, Resident selectedResident) {
        super(res, inv, name, townBlock, true);
        this.editor = res;
        this.selectedResident = selectedResident;
    }

    public void saveChanges() {
        PermissionGUIUtil.SetPermissionType[] newTypes = new PermissionGUIUtil.SetPermissionType[4];
        block4: for (int i = 0; i < 4; ++i) {
            switch (this.getInventory().getItem(PermissionGUIUtil.getWoolSlots()[i]).getType()) {
                case LIME_WOOL: {
                    newTypes[i] = PermissionGUIUtil.SetPermissionType.SET;
                    continue block4;
                }
                case RED_WOOL: {
                    newTypes[i] = PermissionGUIUtil.SetPermissionType.NEGATED;
                    continue block4;
                }
                default: {
                    newTypes[i] = PermissionGUIUtil.SetPermissionType.UNSET;
                }
            }
        }
        if (this.getTownBlock().hasPlotObjectGroup()) {
            this.getTownBlock().getPlotObjectGroup().putPermissionOverride(this.selectedResident, new PermissionData(newTypes, this.editor.getName()));
        } else {
            this.getTownBlock().getPermissionOverrides().put(this.selectedResident, new PermissionData(newTypes, this.editor.getName()));
            this.getTownBlock().save();
        }
        Towny.getPlugin().deleteCache(this.selectedResident.getName());
        this.exitScreen();
    }

    public void exitScreen() {
        PermissionGUIUtil.openPermissionGUI(this.editor, super.getTownBlock());
    }

    public void deleteResident() {
        if (this.getTownBlock().hasPlotObjectGroup()) {
            this.getTownBlock().getPlotObjectGroup().removePermissionOverride(this.selectedResident);
        } else {
            this.getTownBlock().getPermissionOverrides().remove(this.selectedResident);
            this.getTownBlock().save();
        }
        Towny.getPlugin().deleteCache(this.selectedResident.getName());
        this.exitScreen();
    }
}

