/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.event.TranslationLoadEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.compress.utils.FileNameUtils;
import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class Translation {
    private static final Map<String, String> oldLangFileNames = Translation.createLegacyLangMap();
    private static final Set<String> langFiles = Translation.createValidLang();
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    private static Locale defaultLocale;
    private static final String langFolder;

    private Translation() {
    }

    /*
     * WARNING - void declaration
     */
    public static void loadTranslationRegistry() {
        File[] overrideFiles;
        translations.clear();
        Translation.updateLegacyLangFileName(TownySettings.getString(ConfigNodes.LANGUAGE));
        Map globalOverrides = new HashMap();
        File globalFile = FileMgmt.unpackResourceFile(langFolder + File.separator + "override" + File.separator + "global.yml", "global.yml", "global.yml");
        try (FileInputStream is = new FileInputStream(globalFile);){
            globalOverrides = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load((InputStream)is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String lang : langFiles) {
            try {
                InputStream is = Translation.class.getResourceAsStream("/lang/" + lang + ".yml");
                try {
                    Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load(is);
                    Translation.saveReferenceFile(values.get("version"), lang);
                    lang = lang.replace("-", "_");
                    translations.put(lang, new HashMap());
                    for (Map.Entry entry : values.entrySet()) {
                        translations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TranslationLoadEvent translationLoadEvent = new TranslationLoadEvent();
        Bukkit.getPluginManager().callEvent((Event)translationLoadEvent);
        Map<String, Map<String, String>> addedTranslations = translationLoadEvent.getAddedTranslations();
        if (addedTranslations != null && !addedTranslations.isEmpty()) {
            for (String lang : addedTranslations.keySet()) {
                if (addedTranslations.get(lang) == null || addedTranslations.get(lang).isEmpty()) continue;
                for (Map.Entry<String, String> entry : addedTranslations.get(lang).entrySet()) {
                    translations.computeIfAbsent(lang, k -> new HashMap());
                    translations.get(lang).put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
                }
            }
        }
        if ((overrideFiles = new File(langFolder + File.separator + "override").listFiles()) != null) {
            void var7_21;
            File[] fileArray = overrideFiles;
            int n = fileArray.length;
            boolean bl = false;
            while (var7_21 < n) {
                Object file = fileArray[var7_21];
                if (((File)file).isFile() && FileNameUtils.getExtension(((File)file).getName()).equalsIgnoreCase("yml") && !((File)file).getName().equalsIgnoreCase("global.yml")) {
                    try (FileInputStream is = new FileInputStream((File)file);){
                        Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load((InputStream)is);
                        String lang = FileNameUtils.getBaseName(((File)file).getName());
                        if (values != null) {
                            translations.computeIfAbsent(lang, k -> new HashMap());
                            for (Map.Entry entry : values.entrySet()) {
                                translations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++var7_21;
            }
        }
        if (globalOverrides != null) {
            for (Map.Entry entry : globalOverrides.entrySet()) {
                for (String lang : translations.keySet()) {
                    translations.get(lang).put(((String)entry.getKey()).toLowerCase(Locale.ROOT), String.valueOf(entry.getValue()));
                }
            }
        }
        defaultLocale = Translation.loadDefaultLocale();
        Towny.getPlugin().getLogger().info(String.format("Successfully loaded translations for %d languages.", translations.keySet().size()));
        HelpMenu.loadMenus();
    }

    private static void saveReferenceFile(@Nullable Object currentVersion, String lang) {
        if (currentVersion == null) {
            return;
        }
        String res = "lang/" + lang + ".yml";
        File file = FileMgmt.unpackResourceFile(langFolder + File.separator + "reference" + File.separator + lang + ".yml", res, res);
        try (FileInputStream is = new FileInputStream(file);){
            Map values = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load((InputStream)is);
            if (values == null || ((Double)currentVersion).doubleValue() != ((Double)values.get("version")).doubleValue()) {
                FileMgmt.stringToFile(FileMgmt.convertStreamToString("/lang/" + lang + ".yml"), file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> createValidLang() {
        HashSet<String> lang = new HashSet<String>();
        try {
            URI uri = Towny.class.getResource("").toURI();
            FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            Files.list(fs.getRootDirectories().iterator().next().resolve("/lang")).forEach(p -> lang.add(FileNameUtils.getBaseName(p.toString())));
            fs.close();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return lang;
    }

    public static String of(String key) {
        if (defaultLocale == null) {
            Towny.getPlugin().getLogger().warning("Error: Tried to translate before a locale could be loaded!");
            return key;
        }
        String data = translations.get(defaultLocale.toString()).get(key.toLowerCase(Locale.ROOT));
        if (data == null) {
            TownySettings.sendError(key.toLowerCase() + " from " + TownySettings.getString(ConfigNodes.LANGUAGE));
            return key;
        }
        return Colors.translateColorCodes(data);
    }

    public static String of(String key, Object ... args) {
        return String.format(Translation.of(key), args);
    }

    public static String of(String key, Locale locale) {
        String data = translations.get(Translation.validateLocale(locale.toString())).get(key.toLowerCase(Locale.ROOT));
        if (data == null) {
            TownySettings.sendError(key.toLowerCase() + " from " + TownySettings.getString(ConfigNodes.LANGUAGE));
            return key;
        }
        return Colors.translateColorCodes(data);
    }

    public static String of(String key, Locale locale, Object ... args) {
        return String.format(Translation.of(key, locale), args);
    }

    public static String of(String key, CommandSender sender) {
        return Translation.of(key, Translation.getLocale(sender));
    }

    public static String of(String key, CommandSender sender, Object ... args) {
        return String.format(Translation.of(key, Translation.getLocale(sender)), args);
    }

    public static String of(String key, Resident resident) {
        return Translation.of(key, Translation.getLocale(resident));
    }

    public static String of(String key, Resident resident, Object ... args) {
        return String.format(Translation.of(key, Translation.getLocale(resident)), args);
    }

    private static void updateLegacyLangFileName(String lang) {
        File newFile;
        if (!oldLangFileNames.containsKey(lang)) {
            return;
        }
        String path = Towny.getPlugin().getDataFolder().getPath() + File.separator + "settings" + File.separator;
        File oldFile = new File(path + lang);
        boolean rename = oldFile.renameTo(newFile = new File(path + oldLangFileNames.get(lang)));
        if (rename) {
            Towny.getPlugin().getLogger().info("Language file name updated.");
            TownySettings.setLanguage(oldLangFileNames.get(lang));
        } else {
            Towny.getPlugin().getLogger().warning("Language file was not updated.");
        }
    }

    private static Map<String, String> createLegacyLangMap() {
        HashMap<String, String> oldLangFileNames = new HashMap<String, String>();
        oldLangFileNames.put("danish.yml", "da-DK.yml");
        oldLangFileNames.put("german.yml", "de-DE.yml");
        oldLangFileNames.put("english.yml", "en-US.yml");
        oldLangFileNames.put("spanish.yml", "es-ES.yml");
        oldLangFileNames.put("french.yml", "fr-FR.yml");
        oldLangFileNames.put("italian.yml", "it-IT.yml");
        oldLangFileNames.put("korean.yml", "ko-KR.yml");
        oldLangFileNames.put("norwegian.yml", "no-NO.yml");
        oldLangFileNames.put("polish.yml", "pl-PL.yml");
        oldLangFileNames.put("pt-br.yml", "pt-BR.yml");
        oldLangFileNames.put("russian.yml", "ru-RU.yml");
        oldLangFileNames.put("sv-SE.yml", "sv-SE.yml");
        oldLangFileNames.put("chinese.yml", "zh-CN.yml");
        return oldLangFileNames;
    }

    public static Locale toLocale(String fileName) {
        int lastIndex = fileName.lastIndexOf(".") == -1 ? fileName.length() : fileName.lastIndexOf(".");
        try {
            String[] locale = fileName.substring(0, lastIndex).split("[-_]");
            return new Locale(locale[0], locale[1]);
        }
        catch (Exception e) {
            Towny.getPlugin().getLogger().warning(String.format("Could not convert '%s' into a locale, falling back to en_US.", fileName));
            return new Locale("en", "US");
        }
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    private static String validateLocale(String locale) {
        return translations.containsKey(locale) ? locale : defaultLocale.toString();
    }

    public static String translateTranslatables(CommandSender sender, Translatable ... translatables) {
        return Translation.translateTranslatables(sender, " ", translatables);
    }

    public static String translateTranslatables(CommandSender sender, String delimiter, Translatable ... translatables) {
        Locale locale = Translation.getLocale(sender);
        return Arrays.stream(translatables).map(translatable -> translatable.translate(locale)).collect(Collectors.joining(delimiter));
    }

    public static Locale getLocale(CommandSender sender) {
        return sender instanceof Player ? Translation.toLocale(((Player)sender).getLocale()) : defaultLocale;
    }

    public static Locale getLocale(Resident resident) {
        return BukkitTools.isOnline(resident.getName()) ? Translation.getLocale((CommandSender)resident.getPlayer()) : defaultLocale;
    }

    private static Locale loadDefaultLocale() {
        Locale locale = Translation.toLocale(TownySettings.getString(ConfigNodes.LANGUAGE));
        String stringLocale = locale.toString();
        if (!translations.containsKey(stringLocale)) {
            locale = new Locale("en", "US");
            Towny.getPlugin().getLogger().warning(String.format("The locale '%s' is currently not loaded, falling back to en_US. (Is it being loaded correctly?)", stringLocale));
        }
        return locale;
    }

    static {
        langFolder = TownyUniverse.getInstance().getRootFolder() + File.separator + "settings" + File.separator + "lang";
    }
}

