/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyPermissionChange;
import com.palmergames.bukkit.towny.object.Translation;
import java.util.Arrays;

public class TownyPermission {
    protected boolean[][] perms = new boolean[PermLevel.access$000().length][ActionType.access$100().length];
    public boolean pvp;
    public boolean fire;
    public boolean explosion;
    public boolean mobs;

    public TownyPermission() {
        this.reset();
    }

    public void reset() {
        this.setAll(false);
    }

    public void change(TownyPermissionChange permChange) {
        this.change(permChange.getChangeAction(), permChange.getChangeValue(), permChange.getArgs());
    }

    public void change(TownyPermissionChange.Action permChange, boolean toValue, Object ... args) {
        if (permChange == TownyPermissionChange.Action.SINGLE_PERM && args.length == 2) {
            this.perms[((PermLevel)((Object)args[0])).getIndex()][((ActionType)((Object)args[1])).getIndex()] = toValue;
        } else if (permChange == TownyPermissionChange.Action.PERM_LEVEL && args.length == 1) {
            Arrays.fill(this.perms[((PermLevel)((Object)args[0])).getIndex()], toValue);
        } else if (permChange == TownyPermissionChange.Action.ACTION_TYPE && args.length == 1) {
            for (PermLevel permLevel : PermLevel.values) {
                this.perms[permLevel.getIndex()][((ActionType)((Object)args[0])).getIndex()] = toValue;
            }
        } else if (permChange == TownyPermissionChange.Action.ALL_PERMS) {
            this.setAllNonEnvironmental(toValue);
        } else if (permChange == TownyPermissionChange.Action.RESET && args.length == 1) {
            TownBlock tb = (TownBlock)args[0];
            tb.setType(tb.getType());
        }
    }

    public void setAllNonEnvironmental(boolean b) {
        for (boolean[] permLevel : this.perms) {
            Arrays.fill(permLevel, b);
        }
    }

    public void setAll(boolean b) {
        this.setAllNonEnvironmental(b);
        this.pvp = b;
        this.fire = b;
        this.explosion = b;
        this.mobs = b;
    }

    public void set(String s, boolean b) {
        switch (s.toLowerCase()) {
            case "denyall": {
                this.reset();
                break;
            }
            case "residentbuild": {
                this.perms[PermLevel.RESIDENT.getIndex()][ActionType.BUILD.getIndex()] = b;
                break;
            }
            case "residentdestroy": {
                this.perms[PermLevel.RESIDENT.getIndex()][ActionType.DESTROY.getIndex()] = b;
                break;
            }
            case "residentswitch": {
                this.perms[PermLevel.RESIDENT.getIndex()][ActionType.SWITCH.getIndex()] = b;
                break;
            }
            case "residentitemuse": {
                this.perms[PermLevel.RESIDENT.getIndex()][ActionType.ITEM_USE.getIndex()] = b;
                break;
            }
            case "outsiderbuild": {
                this.perms[PermLevel.OUTSIDER.getIndex()][ActionType.BUILD.getIndex()] = b;
                break;
            }
            case "outsiderdestroy": {
                this.perms[PermLevel.OUTSIDER.getIndex()][ActionType.DESTROY.getIndex()] = b;
                break;
            }
            case "outsiderswitch": {
                this.perms[PermLevel.OUTSIDER.getIndex()][ActionType.SWITCH.getIndex()] = b;
                break;
            }
            case "outsideritemuse": {
                this.perms[PermLevel.OUTSIDER.getIndex()][ActionType.ITEM_USE.getIndex()] = b;
                break;
            }
            case "nationbuild": {
                this.perms[PermLevel.NATION.getIndex()][ActionType.BUILD.getIndex()] = b;
                break;
            }
            case "nationdestroy": {
                this.perms[PermLevel.NATION.getIndex()][ActionType.DESTROY.getIndex()] = b;
                break;
            }
            case "nationswitch": {
                this.perms[PermLevel.NATION.getIndex()][ActionType.SWITCH.getIndex()] = b;
                break;
            }
            case "nationitemuse": {
                this.perms[PermLevel.NATION.getIndex()][ActionType.ITEM_USE.getIndex()] = b;
                break;
            }
            case "allybuild": {
                this.perms[PermLevel.ALLY.getIndex()][ActionType.BUILD.getIndex()] = b;
                break;
            }
            case "allydestroy": {
                this.perms[PermLevel.ALLY.getIndex()][ActionType.DESTROY.getIndex()] = b;
                break;
            }
            case "allyswitch": {
                this.perms[PermLevel.ALLY.getIndex()][ActionType.SWITCH.getIndex()] = b;
                break;
            }
            case "allyitemuse": {
                this.perms[PermLevel.ALLY.getIndex()][ActionType.ITEM_USE.getIndex()] = b;
                break;
            }
            case "pvp": {
                this.pvp = b;
                break;
            }
            case "fire": {
                this.fire = b;
                break;
            }
            case "explosion": {
                this.explosion = b;
                break;
            }
            case "mobs": {
                this.mobs = b;
            }
        }
    }

    public void load(String s) {
        String[] tokens;
        this.setAll(false);
        for (String token : tokens = s.split(",")) {
            this.set(token, true);
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (PermLevel permLevel : PermLevel.values) {
            String permLevelName = permLevel.name().toLowerCase();
            for (ActionType actionType : ActionType.values) {
                if (!this.perms[permLevel.getIndex()][actionType.getIndex()]) continue;
                if (output.length() != 0) {
                    output.append(',');
                }
                output.append(permLevelName).append(actionType.getCommonName());
            }
        }
        if (this.pvp) {
            output.append(output.length() > 0 ? "," : "").append("pvp");
        }
        if (this.fire) {
            output.append(output.length() > 0 ? "," : "").append("fire");
        }
        if (this.explosion) {
            output.append(output.length() > 0 ? "," : "").append("explosion");
        }
        if (this.mobs) {
            output.append(output.length() > 0 ? "," : "").append("mobs");
        }
        if (output.length() == 0) {
            return "denyAll";
        }
        return output.toString();
    }

    public boolean getPerm(PermLevel permLevel, ActionType type) {
        return this.perms[permLevel.getIndex()][type.getIndex()];
    }

    public boolean getResidentPerm(ActionType type) {
        return this.getPerm(PermLevel.RESIDENT, type);
    }

    public boolean getOutsiderPerm(ActionType type) {
        return this.getPerm(PermLevel.OUTSIDER, type);
    }

    public boolean getAllyPerm(ActionType type) {
        return this.getPerm(PermLevel.ALLY, type);
    }

    public boolean getNationPerm(ActionType type) {
        return this.getPerm(PermLevel.NATION, type);
    }

    public String getColoredPermLevel(ActionType type) {
        return this.getColoredPermLevel(type, type.getCommonName());
    }

    public String getColoredPermLevel(ActionType type, String typeCommonName) {
        StringBuilder output = new StringBuilder(Translation.of("status_perm_line_format", typeCommonName));
        for (PermLevel permLevel : PermLevel.values) {
            if (this.perms[permLevel.getIndex()][type.getIndex()]) {
                output.append(permLevel.getShortChar());
                continue;
            }
            output.append('-');
        }
        return output.toString();
    }

    public String getColourString() {
        return this.getColoredPermLevel(ActionType.BUILD) + " " + this.getColoredPermLevel(ActionType.DESTROY) + " " + this.getColoredPermLevel(ActionType.SWITCH) + " " + this.getColoredPermLevel(ActionType.ITEM_USE);
    }

    public void loadDefault(TownBlockOwner owner) {
        for (PermLevel permLevel : PermLevel.values) {
            for (ActionType actionType : ActionType.values) {
                this.perms[permLevel.getIndex()][actionType.getIndex()] = TownySettings.getDefaultPermission(owner, permLevel, actionType);
            }
        }
        if (owner instanceof Town) {
            this.pvp = TownySettings.getPermFlag_Town_Default_PVP();
            this.fire = TownySettings.getPermFlag_Town_Default_FIRE();
            this.explosion = TownySettings.getPermFlag_Town_Default_Explosion();
            this.mobs = TownySettings.getPermFlag_Town_Default_Mobs();
        } else {
            this.pvp = owner.getPermissions().pvp;
            this.fire = owner.getPermissions().fire;
            this.explosion = owner.getPermissions().explosion;
            this.mobs = owner.getPermissions().mobs;
        }
    }

    public static enum PermLevel {
        RESIDENT(0, 'f'),
        NATION(1, 'n'),
        ALLY(2, 'a'),
        OUTSIDER(3, 'o');

        private static final PermLevel[] values;
        private final int index;
        private final char shortVal;

        private PermLevel(int index, char shortVal) {
            this.index = index;
            this.shortVal = shortVal;
        }

        public int getIndex() {
            return this.index;
        }

        public char getShortChar() {
            return this.shortVal;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        static {
            values = PermLevel.values();
        }
    }

    public static enum ActionType {
        BUILD(0, "Build"),
        DESTROY(1, "Destroy"),
        SWITCH(2, "Switch"),
        ITEM_USE(3, "ItemUse");

        private static final ActionType[] values;
        private final int index;
        private final String commonName;

        private ActionType(int index, String commonName) {
            this.index = index;
            this.commonName = commonName;
        }

        public int getIndex() {
            return this.index;
        }

        public String getCommonName() {
            return this.commonName;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        static {
            values = ActionType.values();
        }
    }
}

