/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.annotations.Unmodifiable;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Savable;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TownyObject
implements Nameable,
Savable {
    private String name;
    private Map<String, CustomDataField<?>> metadata = null;

    protected TownyObject(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getTreeString(int depth) {
        return new ArrayList<String>();
    }

    public String getTreeDepth(int depth) {
        char[] fill = new char[depth * 4];
        Arrays.fill(fill, ' ');
        if (depth > 0) {
            fill[0] = 124;
            int offset = (depth - 1) * 4;
            fill[offset] = 43;
            fill[offset + 1] = 45;
            fill[offset + 2] = 45;
        }
        return new String(fill);
    }

    public String toString() {
        return this.getName();
    }

    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, false);
    }

    public void addMetaData(@NotNull CustomDataField<?> md, boolean save) {
        Validate.notNull(md);
        if (this.metadata == null) {
            this.metadata = new HashMap();
        }
        this.metadata.put(md.getKey(), md);
        if (save) {
            this.save();
        }
    }

    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, false);
    }

    public boolean removeMetaData(@NotNull CustomDataField<?> md, boolean save) {
        boolean removed;
        Validate.notNull(md);
        if (!this.hasMeta()) {
            return false;
        }
        boolean bl = removed = this.metadata.remove(md.getKey()) != null;
        if (this.metadata.isEmpty()) {
            this.metadata = null;
        }
        if (save && removed) {
            this.save();
        }
        return removed;
    }

    @Unmodifiable
    public Collection<CustomDataField<?>> getMetadata() {
        if (this.metadata == null || this.metadata.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.metadata.values());
    }

    @Nullable
    public CustomDataField<?> getMetadata(@NotNull String key) {
        Validate.notNull((Object)key);
        if (this.metadata != null) {
            return this.metadata.get(key);
        }
        return null;
    }

    @Nullable
    public <T extends CustomDataField<?>> T getMetadata(@NotNull String key, @NotNull Class<T> cdfClass) {
        CustomDataField<?> cdf;
        Validate.notNull(cdfClass);
        Validate.notNull((Object)key);
        if (this.metadata != null && cdfClass.isInstance(cdf = this.metadata.get(key))) {
            return (T)cdf;
        }
        return null;
    }

    public boolean hasMeta() {
        return this.metadata != null;
    }

    public boolean hasMeta(@NotNull String key) {
        Validate.notNull((Object)key);
        if (this.metadata != null) {
            return this.metadata.containsKey(key);
        }
        return false;
    }

    public <T extends CustomDataField<?>> boolean hasMeta(@NotNull String key, @NotNull Class<T> cdfClass) {
        Validate.notNull(cdfClass);
        Validate.notNull((Object)key);
        if (this.metadata != null) {
            CustomDataField<?> cdf = this.metadata.get(key);
            return cdfClass.isInstance(cdf);
        }
        return false;
    }
}

