/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.PlotChangeOwnerEvent;
import com.palmergames.bukkit.towny.event.PlotChangeTypeEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.JailUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownBlock
extends TownyObject {
    private TownyWorld world;
    private Town town = null;
    private Resident resident = null;
    private TownBlockType type = TownBlockType.RESIDENTIAL;
    private int x;
    private int z;
    private double plotPrice = -1.0;
    private boolean locked = false;
    private boolean outpost = false;
    private PlotGroup plotGroup;
    private long claimedAt;
    private Jail jail;
    private Map<Resident, PermissionData> permissionOverrides = new HashMap<Resident, PermissionData>();
    private Set<Resident> trustedResidents = new HashSet<Resident>();
    protected TownyPermission permissions = new TownyPermission();
    protected boolean isChanged = false;

    public TownBlock(int x, int z, TownyWorld world) {
        super("");
        this.x = x;
        this.z = z;
        this.setWorld(world);
    }

    public void setTown(Town town) {
        this.setTown(town, true);
    }

    public void setTown(Town town, boolean updateClaimedAt) {
        if (this.hasTown()) {
            this.town.removeTownBlock(this);
        }
        this.town = town;
        try {
            TownyUniverse.getInstance().addTownBlock(this);
            town.addTownBlock(this);
            if (updateClaimedAt) {
                this.setClaimedAt(System.currentTimeMillis());
            }
            this.permissionOverrides.clear();
        }
        catch (AlreadyRegisteredException | NullPointerException exception) {
            // empty catch block
        }
    }

    public Town getTown() throws NotRegisteredException {
        if (!this.hasTown()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a town.", this.world.getName(), this.x, this.z));
        }
        return this.town;
    }

    @Nullable
    public Town getTownOrNull() {
        return this.town;
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public void setResident(Resident resident) {
        boolean successful;
        if (this.hasResident()) {
            this.resident.removeTownBlock(this);
        }
        this.resident = resident;
        try {
            resident.addTownBlock(this);
            successful = true;
        }
        catch (AlreadyRegisteredException | NullPointerException e) {
            successful = false;
        }
        if (successful) {
            Bukkit.getPluginManager().callEvent((Event)new PlotChangeOwnerEvent(this.resident, resident, this));
        }
        this.resident = resident;
        this.permissionOverrides.clear();
    }

    public Resident getResident() throws NotRegisteredException {
        if (!this.hasResident()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a resident.", this.world.getName(), this.x, this.z));
        }
        return this.resident;
    }

    @Nullable
    public Resident getResidentOrNull() {
        return this.resident;
    }

    public boolean hasResident() {
        return this.resident != null;
    }

    public boolean isOwner(TownBlockOwner owner) {
        if (this.hasTown() && owner == this.getTownOrNull()) {
            return true;
        }
        return this.hasResident() && owner == this.getResidentOrNull();
    }

    public void setPlotPrice(double ForSale) {
        this.plotPrice = ForSale;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public boolean isForSale() {
        return this.getPlotPrice() != -1.0;
    }

    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean isOutpost() {
        return this.outpost;
    }

    public void setOutpost(boolean outpost) {
        this.outpost = outpost;
    }

    public TownBlockType getType() {
        return this.type;
    }

    public void setType(TownBlockType type) {
        if (type != this.type) {
            this.permissions.reset();
        }
        if (type != null) {
            Bukkit.getPluginManager().callEvent((Event)new PlotChangeTypeEvent(this.type, type, this));
        }
        this.type = type;
        switch (type) {
            case RESIDENTIAL: 
            case COMMERCIAL: 
            case EMBASSY: 
            case BANK: 
            case INN: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.getPermissions().toString());
                    break;
                }
                this.setPermissions(this.town.getPermissions().toString());
                break;
            }
            case ARENA: {
                this.setPermissions("pvp");
                break;
            }
            case SPLEEF: 
            case JAIL: {
                this.setPermissions("denyAll");
                break;
            }
            case FARM: 
            case WILDS: {
                this.setPermissions("residentBuild,residentDestroy");
            }
        }
        this.setChanged(false);
    }

    public void setType(int typeId) {
        this.setType(TownBlockType.lookup(typeId));
    }

    public void setType(TownBlockType type, Resident resident) throws TownyException {
        if (this.isJail() && !type.equals((Object)TownBlockType.JAIL)) {
            TownyUniverse.getInstance().getDataSource().removeJail(this.getJail());
            this.setJail(null);
        }
        if ((this.getType().equals((Object)TownBlockType.ARENA) || type.equals((Object)TownBlockType.ARENA)) && TownySettings.getPVPCoolDownTime() > 0 && !TownyUniverse.getInstance().getPermissionSource().testPermission(resident.getPlayer(), PermissionNodes.TOWNY_ADMIN.getNode())) {
            if (CooldownTimerTask.hasCooldown(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                throw new TownyException(Translation.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
            }
            this.setType(type);
            CooldownTimerTask.addCooldownTimer(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
        } else {
            this.setType(type);
        }
        if (this.isJail() && resident.getPlayer() != null) {
            JailUtil.createJailPlot(this, this.getTown(), resident.getPlayer().getLocation());
        }
        this.save();
    }

    public boolean isHomeBlock() {
        return this.hasTown() && this.getTownOrNull().isHomeBlock(this);
    }

    @Override
    public void setName(String newName) {
        super.setName(newName.replace("_", " "));
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getZ() {
        return this.z;
    }

    public Coord getCoord() {
        return new Coord(this.x, this.z);
    }

    public WorldCoord getWorldCoord() {
        return new WorldCoord(this.world.getName(), this.x, this.z);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setWorld(TownyWorld world) {
        this.world = world;
    }

    public TownyWorld getWorld() {
        return this.world;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TownBlock townBlock = (TownBlock)o;
        return this.x == townBlock.x && this.z == townBlock.z && this.world.equals(townBlock.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }

    public void clear() {
        this.setTown(null);
        this.setResident(null);
        this.setWorld(null);
    }

    @Override
    public String toString() {
        return this.getWorld().getName() + " (" + this.getCoord() + ")";
    }

    public boolean isWarZone() {
        return this.getWorld().isWarZone(this.getCoord());
    }

    public boolean isJail() {
        return this.getType() == TownBlockType.JAIL;
    }

    public Jail getJail() {
        return this.jail;
    }

    public void setJail(Jail _jail) {
        this.jail = _jail;
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    public boolean hasPlotObjectGroup() {
        return this.plotGroup != null;
    }

    public PlotGroup getPlotObjectGroup() {
        return this.plotGroup;
    }

    public void removePlotObjectGroup() {
        this.plotGroup = null;
    }

    public void setPlotObjectGroup(PlotGroup group) {
        this.plotGroup = group;
        try {
            group.addTownBlock(this);
            this.setTrustedResidents(group.getTrustedResidents());
            this.setPermissionOverrides(group.getPermissionOverrides());
        }
        catch (NullPointerException e) {
            TownyMessaging.sendErrorMsg("Townblock failed to setPlotObjectGroup(group), group is null. " + group);
        }
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveTownBlock(this);
    }

    public long getClaimedAt() {
        return this.claimedAt;
    }

    public void setClaimedAt(long claimedAt) {
        this.claimedAt = claimedAt;
    }

    public Map<Resident, PermissionData> getPermissionOverrides() {
        return this.permissionOverrides;
    }

    public Set<Resident> getTrustedResidents() {
        return this.trustedResidents;
    }

    public boolean hasTrustedResident(Resident resident) {
        return this.trustedResidents.contains(resident);
    }

    public void addTrustedResident(Resident resident) {
        this.trustedResidents.add(resident);
    }

    public void removeTrustedResident(Resident resident) {
        this.trustedResidents.remove(resident);
    }

    public boolean hasResident(Resident resident) {
        if (this.resident == null || resident == null) {
            return false;
        }
        return resident.equals(this.resident);
    }

    public void setTrustedResidents(Set<Resident> trustedResidents) {
        this.trustedResidents = new HashSet<Resident>(trustedResidents);
    }

    public void setPermissionOverrides(Map<Resident, PermissionData> permissionOverrides) {
        this.permissionOverrides = new HashMap<Resident, PermissionData>(permissionOverrides);
    }

    @Nullable
    public TownBlockOwner getTownBlockOwner() {
        if (this.hasResident()) {
            return this.getResidentOrNull();
        }
        return this.getTownOrNull();
    }
}

