/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.NationAddTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.event.town.TownMapColourLocalCalculationEvent;
import com.palmergames.bukkit.towny.event.town.TownMapColourNationalCalculationEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnPoint;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.jail.Jail;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.MathUtil;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Town
extends Government
implements TownBlockOwner {
    private static final String ECONOMY_ACCOUNT_PREFIX = TownySettings.getTownAccountPrefix();
    private final List<Resident> residents = new ArrayList<Resident>();
    private final List<Resident> outlaws = new ArrayList<Resident>();
    private final Set<Resident> trustedResidents = new HashSet<Resident>();
    private List<Location> outpostSpawns = new ArrayList<Location>();
    private List<Jail> jails = null;
    private HashMap<String, PlotGroup> plotGroups = null;
    private Resident mayor;
    private int bonusBlocks = 0;
    private int purchasedBlocks = 0;
    private double plotTax = TownySettings.getTownDefaultPlotTax();
    private double commercialPlotTax = TownySettings.getTownDefaultShopTax();
    private double plotPrice = 0.0;
    private double embassyPlotTax = TownySettings.getTownDefaultEmbassyTax();
    private double maxPercentTaxAmount = TownySettings.getMaxTownTaxPercentAmount();
    private double commercialPlotPrice;
    private double embassyPlotPrice;
    private double debtBalance = 0.0;
    private Nation nation;
    private boolean hasUpkeep = true;
    private boolean isTaxPercentage = TownySettings.getTownDefaultTaxPercentage();
    private TownBlock homeBlock;
    private TownyWorld world;
    private boolean adminDisabledPVP = false;
    private boolean adminEnabledPVP = false;
    private boolean isConquered = false;
    private int conqueredDays;
    private final ConcurrentHashMap<WorldCoord, TownBlock> townBlocks = new ConcurrentHashMap();
    private final TownyPermission permissions = new TownyPermission();
    private boolean ruined = false;
    private long ruinedTime;
    private long joinedNationAt;
    private long movedHomeBlockAt;
    private Jail primaryJail;
    private boolean residentsSorted = false;

    public Town(String name) {
        super(name);
        this.permissions.loadDefault(this);
        this.setTaxes(TownySettings.getTownDefaultTax());
        this.setOpen(TownySettings.getTownDefaultOpen());
        this.setBoard(TownySettings.getTownDefaultBoard());
        this.setNeutral(TownySettings.getTownDefaultNeutral());
    }

    public Town(String name, UUID uuid) {
        this(name);
        this.setUUID(uuid);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks.values());
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.hasTownBlock(townBlock.getWorldCoord());
    }

    public boolean hasTownBlock(WorldCoord worldCoord) {
        return this.townBlocks.containsKey(worldCoord);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.put(townBlock.getWorldCoord(), townBlock);
        if (this.townBlocks.size() < 2 && !this.hasHomeBlock()) {
            this.setHomeBlock(townBlock);
        }
    }

    public TownBlock getTownBlock(WorldCoord worldCoord) {
        if (this.hasTownBlock(worldCoord)) {
            return this.townBlocks.get(worldCoord);
        }
        return null;
    }

    public ConcurrentHashMap<WorldCoord, TownBlock> getTownBlockMap() {
        return this.townBlocks;
    }

    public Resident getMayor() {
        return this.mayor;
    }

    @Override
    public void setTaxes(double taxes) {
        this.taxes = Math.min(taxes, this.isTaxPercentage ? TownySettings.getMaxTownTaxPercent() : TownySettings.getMaxTownTax());
        if (this.taxes < 0.0) {
            this.taxes = TownySettings.getTownDefaultTax();
        }
    }

    public void forceSetMayor(Resident mayor) throws TownyException {
        if (!this.hasResident(mayor)) {
            throw new TownyException(Translation.of("msg_err_mayor_doesnt_belong_to_town"));
        }
        this.setMayor(mayor);
    }

    public void setMayor(Resident mayor) {
        if (!this.hasResident(mayor)) {
            return;
        }
        this.mayor = mayor;
        TownyPerms.assignPermissions(mayor, null);
    }

    public Nation getNation() throws NotRegisteredException {
        if (this.hasNation()) {
            return this.nation;
        }
        throw new NotRegisteredException(Translation.of("msg_err_town_doesnt_belong_to_any_nation"));
    }

    @Nullable
    public Nation getNationOrNull() {
        return this.nation;
    }

    public void removeNation() {
        if (!this.hasNation()) {
            return;
        }
        Nation nation = this.nation;
        for (Resident res : this.getResidents()) {
            if (res.hasTitle() || res.hasSurname()) {
                res.setTitle("");
                res.setSurname("");
            }
            res.updatePermsForNationRemoval();
            res.save();
        }
        try {
            nation.removeTown(this);
        }
        catch (EmptyNationException e) {
            TownyUniverse.getInstance().getDataSource().removeNation(nation);
            TownyMessaging.sendGlobalMessage(Translation.of("msg_del_nation", e.getNation().getName()));
        }
        try {
            this.setNation(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.isConquered = false;
        this.conqueredDays = 0;
        this.setJoinedNationAt(0L);
        this.save();
        BukkitTools.getPluginManager().callEvent((Event)new NationRemoveTownEvent(this, nation));
    }

    public void setNation(Nation nation) throws AlreadyRegisteredException {
        this.setNation(nation, true);
    }

    public void setNation(Nation nation, boolean updateJoinedAt) throws AlreadyRegisteredException {
        if (this.nation == nation) {
            return;
        }
        if (nation == null) {
            this.nation = null;
            return;
        }
        if (this.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.nation = nation;
        nation.addTown(this);
        if (updateJoinedAt) {
            this.setJoinedNationAt(System.currentTimeMillis());
        }
        TownyPerms.updateTownPerms(this);
        BukkitTools.getPluginManager().callEvent((Event)new NationAddTownEvent(this, nation));
    }

    public List<Resident> getResidents() {
        if (!this.residentsSorted) {
            this.sortResidents();
        }
        return Collections.unmodifiableList(this.residents);
    }

    @Deprecated
    public List<Resident> getAssistants() {
        return this.getRank("assistant");
    }

    public List<Resident> getRank(String rank) {
        ArrayList<Resident> residentsWithRank = new ArrayList<Resident>();
        for (Resident resident : this.getResidents()) {
            if (!resident.hasTownRank(rank)) continue;
            residentsWithRank.add(resident);
        }
        return Collections.unmodifiableList(residentsWithRank);
    }

    @Override
    public boolean hasResident(String name) {
        for (Resident resident : this.residents) {
            if (!resident.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResident(Resident resident) {
        return this.residents.contains(resident);
    }

    public boolean hasResident(Player player) {
        return this.hasResident(player.getUniqueId());
    }

    public boolean hasResident(UUID uuid) {
        Resident resident = TownyAPI.getInstance().getResident(uuid);
        return resident != null && this.hasResident(resident);
    }

    @Deprecated
    public boolean hasAssistant(Resident resident) {
        return resident.hasTownRank("assistant");
    }

    public boolean hasResidentWithRank(Resident resident, String rank) {
        return this.hasResident(resident) && resident.hasTownRank(rank);
    }

    void addResident(Resident resident) {
        this.residents.add(resident);
    }

    public void addResidentCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasResident(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), this.getFormattedName()));
        }
        if (resident.hasTown()) {
            try {
                if (!resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), resident.getTown().getFormattedName()));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isMayor(Resident resident) {
        return resident == this.mayor;
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public boolean isCapital() {
        return this.hasNation() && this.nation.isCapital(this);
    }

    public void setHasUpkeep(boolean hasUpkeep) {
        this.hasUpkeep = hasUpkeep;
    }

    public boolean hasUpkeep() {
        return this.hasUpkeep;
    }

    public void setHasMobs(boolean hasMobs) {
        this.permissions.mobs = hasMobs;
    }

    public boolean hasMobs() {
        return this.permissions.mobs;
    }

    public void setPVP(boolean isPVP) {
        this.permissions.pvp = isPVP;
    }

    public void setAdminDisabledPVP(boolean isPVPDisabled) {
        this.adminDisabledPVP = isPVPDisabled;
    }

    public void setAdminEnabledPVP(boolean isPVPEnabled) {
        this.adminEnabledPVP = isPVPEnabled;
    }

    public boolean isPVP() {
        if (this.isAdminEnabledPVP()) {
            return true;
        }
        if (this.isAdminDisabledPVP()) {
            return false;
        }
        return this.permissions.pvp;
    }

    public boolean isAdminDisabledPVP() {
        return this.adminDisabledPVP;
    }

    public boolean isAdminEnabledPVP() {
        return this.adminEnabledPVP;
    }

    public void setBANG(boolean isBANG) {
        this.permissions.explosion = isBANG;
    }

    public boolean isBANG() {
        return this.permissions.explosion;
    }

    public void setTaxPercentage(boolean isPercentage) {
        this.isTaxPercentage = isPercentage;
        if (this.getTaxes() > 100.0) {
            this.setTaxes(0.0);
        }
    }

    public boolean isTaxPercentage() {
        return this.isTaxPercentage;
    }

    public void setFire(boolean isFire) {
        this.permissions.fire = isFire;
    }

    public boolean isFire() {
        return this.permissions.fire;
    }

    public void setBonusBlocks(int bonusBlocks) {
        this.bonusBlocks = bonusBlocks;
    }

    public int getTotalBlocks() {
        return TownySettings.getMaxTownBlocks(this);
    }

    public int getBonusBlocks() {
        return this.bonusBlocks;
    }

    public double getBonusBlockCost() {
        double price = Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), this.getPurchasedBlocks()) * TownySettings.getPurchasedBonusBlocksCost();
        double maxprice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        return maxprice == -1.0 ? price : Math.min(price, maxprice);
    }

    public double getTownBlockCost() {
        double price = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), this.getTownBlocks().size()) * TownySettings.getClaimPrice());
        double maxprice = TownySettings.getMaxClaimPrice();
        return maxprice == -1.0 ? price : Math.min(price, maxprice);
    }

    public double getTownBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        if (inputN == 0) {
            return inputN;
        }
        double nextprice = this.getTownBlockCost();
        double cost = nextprice;
        boolean hasmaxprice = TownySettings.getMaxClaimPrice() != -1.0;
        double maxprice = TownySettings.getMaxClaimPrice();
        for (int i = 1; i < inputN; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), (double)this.getTownBlocks().size() + (double)i) * TownySettings.getClaimPrice());
            if (hasmaxprice && nextprice > maxprice) {
                cost += maxprice * (double)(inputN - i);
                break;
            }
            cost += nextprice;
        }
        cost = Math.round(cost);
        return cost;
    }

    public double getBonusBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        int current = this.getPurchasedBlocks();
        int n = current + inputN > TownySettings.getMaxPurchasedBlocks(this) ? TownySettings.getMaxPurchasedBlocks(this) - current : inputN;
        if (n == 0) {
            return n;
        }
        double nextprice = this.getBonusBlockCost();
        double cost = nextprice;
        boolean hasmaxprice = TownySettings.getPurchasedBonusBlocksMaxPrice() != -1.0;
        double maxprice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        for (int i = 1; i < n; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), (double)this.getPurchasedBlocks() + (double)i) * TownySettings.getPurchasedBonusBlocksCost());
            if (hasmaxprice && nextprice > maxprice) {
                cost += maxprice * (double)(inputN - i);
                break;
            }
            cost += nextprice;
        }
        cost = Math.round(cost);
        return cost;
    }

    public void addBonusBlocks(int bonusBlocks) {
        this.bonusBlocks += bonusBlocks;
    }

    public void setPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks = purchasedBlocks;
    }

    public int getPurchasedBlocks() {
        return this.purchasedBlocks;
    }

    public void addPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks += purchasedBlocks;
    }

    public void setHomeBlock(@Nullable TownBlock homeBlock) {
        Nation nation;
        this.homeBlock = homeBlock;
        if (homeBlock == null) {
            return;
        }
        if (!this.getHomeblockWorld().getName().equals(homeBlock.getWorld().getName())) {
            this.setWorld(homeBlock.getWorld());
        }
        if (this.spawn != null && !homeBlock.getWorldCoord().equals(WorldCoord.parseCoord(this.spawn))) {
            TownyUniverse.getInstance().removeSpawnPoint(this.spawn);
            this.spawn = null;
        }
        if (this.hasNation() && TownySettings.getNationRequiresProximity() > 0.0 && !(nation = TownyAPI.getInstance().getTownNationOrNull(this)).getCapital().equals(this) && nation.getCapital().hasHomeBlock() && this.hasHomeBlock()) {
            double distance;
            WorldCoord capitalCoord = null;
            WorldCoord townCoord = null;
            try {
                capitalCoord = nation.getCapital().getHomeBlock().getWorldCoord();
                townCoord = this.getHomeBlock().getWorldCoord();
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            if (!nation.getCapital().getHomeblockWorld().equals(this.getHomeblockWorld())) {
                TownyMessaging.sendNationMessagePrefixed(nation, Translation.of("msg_nation_town_moved_their_homeblock_too_far", this.getName()));
                this.removeNation();
            }
            if ((distance = MathUtil.distance(capitalCoord.getX(), townCoord.getX(), capitalCoord.getZ(), townCoord.getZ())) > TownySettings.getNationRequiresProximity()) {
                TownyMessaging.sendNationMessagePrefixed(nation, Translation.of("msg_nation_town_moved_their_homeblock_too_far", this.getName()));
                this.removeNation();
            }
        }
    }

    public void forceSetHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            TownyMessaging.sendErrorMsg("town.forceSetHomeblock() is returning null.");
            return;
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            this.setWorld(homeBlock.getWorld());
        }
    }

    public TownBlock getHomeBlock() throws TownyException {
        if (this.hasHomeBlock()) {
            return this.homeBlock;
        }
        throw new TownyException(this.getName() + " has not set a home block.");
    }

    @Nullable
    public TownBlock getHomeBlockOrNull() {
        return this.homeBlock;
    }

    public void setWorld(TownyWorld world) {
        if (world == null) {
            this.world = null;
            return;
        }
        if (this.world == world) {
            return;
        }
        if (this.hasWorld()) {
            try {
                world.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.world = world;
        this.world.addTown(this);
    }

    public TownyWorld getHomeblockWorld() {
        if (this.world != null) {
            return this.world;
        }
        if (this.homeBlock != null) {
            return this.homeBlock.getWorld();
        }
        return TownyUniverse.getInstance().getDataSource().getWorlds().get(0);
    }

    public boolean hasMayor() {
        return this.mayor != null;
    }

    public void removeResident(Resident resident) throws EmptyTownException, NotRegisteredException {
        if (!this.hasResident(resident)) {
            throw new NotRegisteredException();
        }
        this.remove(resident);
        resident.setJoinedTownAt(0L);
        if (this.getNumResidents() == 0) {
            throw new EmptyTownException(this);
        }
    }

    private void remove(Resident resident) {
        if (this.isMayor(resident) && this.residents.size() > 1) {
            this.findNewMayor();
            this.save();
        }
        this.residents.remove(resident);
    }

    public void findNewMayor() {
        for (String rank : TownySettings.getOrderOfMayoralSuccession()) {
            if (!this.findNewMayor(rank)) continue;
            return;
        }
        this.findNewMayorCatchAll();
    }

    private boolean findNewMayor(String rank) {
        boolean found = false;
        for (Resident newMayor : this.getRank(rank)) {
            if (newMayor == this.mayor || !newMayor.hasTownRank(rank)) continue;
            this.setMayor(newMayor);
            found = true;
            break;
        }
        return found;
    }

    private boolean findNewMayorCatchAll() {
        boolean found = false;
        for (Resident newMayor : this.getResidents()) {
            if (newMayor == this.mayor) continue;
            this.setMayor(newMayor);
            found = true;
            break;
        }
        return found;
    }

    @Override
    public void setSpawn(Location spawn) {
        this.spawn = spawn;
        if (spawn != null) {
            TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.TOWN_SPAWN));
        }
    }

    @Override
    public Location getSpawn() throws TownyException {
        if (this.hasHomeBlock() && this.spawn != null) {
            return this.spawn;
        }
        this.spawn = null;
        throw new TownyException(Translation.of("msg_err_town_has_not_set_a_spawn_location"));
    }

    @Nullable
    public Location getSpawnOrNull() {
        return this.spawn;
    }

    public boolean hasHomeBlock() {
        return this.homeBlock != null;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        if (this.hasTownBlock(townBlock)) {
            if (townBlock.isOutpost()) {
                this.removeOutpostSpawn(townBlock.getCoord());
            }
            if (townBlock.isJail()) {
                this.removeJail(townBlock.getJail());
            }
            try {
                if (this.getHomeBlock() == townBlock) {
                    this.setHomeBlock(null);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            try {
                if (this.hasNation() && this.getNationOrNull().hasSpawn() && townBlock.getWorldCoord().equals(WorldCoord.parseWorldCoord(this.getNationOrNull().getSpawn()))) {
                    this.getNationOrNull().setSpawn(null);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            this.townBlocks.remove(townBlock.getWorldCoord());
            this.save();
        }
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public void addOutpostSpawn(Location spawn) {
        this.removeOutpostSpawn(Coord.parseCoord(spawn));
        TownBlock outpost = TownyAPI.getInstance().getTownBlock(spawn);
        if (!outpost.isOutpost()) {
            outpost.setOutpost(true);
            outpost.save();
        }
        this.outpostSpawns.add(spawn);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.OUTPOST_SPAWN));
        this.save();
    }

    public void forceAddOutpostSpawn(Location spawn) {
        this.outpostSpawns.add(spawn);
        TownyUniverse.getInstance().addSpawnPoint(new SpawnPoint(spawn, SpawnPoint.SpawnPointType.OUTPOST_SPAWN));
    }

    public Location getOutpostSpawn(Integer index) throws TownyException {
        if (this.getMaxOutpostSpawn() == 0 && TownySettings.isOutpostsLimitedByLevels()) {
            throw new TownyException(Translation.of("msg_err_town_has_no_outpost_spawns_set"));
        }
        return this.outpostSpawns.get(Math.min(this.getMaxOutpostSpawn() - 1, Math.max(0, index - 1)));
    }

    public int getMaxOutpostSpawn() {
        return this.outpostSpawns.size();
    }

    public boolean hasOutpostSpawn() {
        return this.outpostSpawns.size() > 0;
    }

    public List<Location> getAllOutpostSpawns() {
        return this.outpostSpawns;
    }

    public void removeOutpostSpawn(Coord coord) {
        new ArrayList<Location>(this.outpostSpawns).stream().filter(spawn -> Coord.parseCoord(spawn).equals(coord)).forEach(spawn -> {
            this.outpostSpawns.remove(spawn);
            TownyUniverse.getInstance().removeSpawnPoint((Location)spawn);
        });
    }

    public void setPlotPrice(double plotPrice) {
        this.plotPrice = Math.min(plotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public double getPlotTypePrice(TownBlockType type) {
        double plotPrice;
        switch (type.ordinal()) {
            case 1: {
                plotPrice = this.getCommercialPlotPrice();
                break;
            }
            case 3: {
                plotPrice = this.getEmbassyPlotPrice();
                break;
            }
            default: {
                plotPrice = this.getPlotPrice();
            }
        }
        if (plotPrice < 0.0) {
            plotPrice = 0.0;
        }
        return plotPrice;
    }

    public void setCommercialPlotPrice(double commercialPlotPrice) {
        this.commercialPlotPrice = Math.min(commercialPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getCommercialPlotPrice() {
        return this.commercialPlotPrice;
    }

    public void setEmbassyPlotPrice(double embassyPlotPrice) {
        this.embassyPlotPrice = Math.min(embassyPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getEmbassyPlotPrice() {
        return this.embassyPlotPrice;
    }

    public boolean isHomeBlock(TownBlock townBlock) {
        return this.hasHomeBlock() && townBlock == this.homeBlock;
    }

    public void setPlotTax(double plotTax) {
        this.plotTax = Math.min(plotTax, TownySettings.getMaxPlotTax());
    }

    public double getPlotTax() {
        return this.plotTax;
    }

    public void setCommercialPlotTax(double commercialTax) {
        this.commercialPlotTax = Math.min(commercialTax, TownySettings.getMaxPlotTax());
    }

    public double getCommercialPlotTax() {
        return this.commercialPlotTax;
    }

    public void setEmbassyPlotTax(double embassyPlotTax) {
        this.embassyPlotTax = Math.min(embassyPlotTax, TownySettings.getMaxPlotTax());
    }

    public double getEmbassyPlotTax() {
        return this.embassyPlotTax;
    }

    public void collect(double amount) {
        if (TownyEconomyHandler.isActive()) {
            double bankcap = TownySettings.getTownBankCap();
            if (bankcap > 0.0 && amount + this.getAccount().getHoldingBalance() > bankcap) {
                TownyMessaging.sendPrefixedTownMessage(this, Translation.of("msg_err_deposit_capped", bankcap));
                return;
            }
            this.getAccount().deposit(amount, null);
        }
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Town (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Mayor: " + (this.hasMayor() ? this.getMayor().getName() : "None"));
        out.add(this.getTreeDepth(depth + 1) + "Home: " + this.homeBlock);
        out.add(this.getTreeDepth(depth + 1) + "Bonus: " + this.bonusBlocks);
        out.add(this.getTreeDepth(depth + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        List<Resident> assistants = this.getAssistants();
        if (assistants.size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Assistants (" + assistants.size() + "): " + Arrays.toString(assistants.toArray(new Resident[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + this.getResidents().size() + "):");
        for (Resident resident : this.getResidents()) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    @Override
    public Collection<Resident> getOutlaws() {
        return Collections.unmodifiableList(this.outlaws);
    }

    public boolean hasOutlaw(String name) {
        return this.outlaws.stream().anyMatch(outlaw -> outlaw.getName().equalsIgnoreCase(name));
    }

    public boolean hasOutlaw(Resident outlaw) {
        return this.outlaws.contains(outlaw);
    }

    public void addOutlaw(Resident resident) throws AlreadyRegisteredException {
        this.addOutlawCheck(resident);
        this.outlaws.add(resident);
    }

    public void addOutlawCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasOutlaw(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_resident_already_an_outlaw"));
        }
        if (resident.hasTown()) {
            try {
                if (resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(Translation.of("msg_err_not_outlaw_in_your_town"));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeOutlaw(Resident resident) {
        if (this.hasOutlaw(resident)) {
            this.outlaws.remove(resident);
        }
    }

    public boolean hasValidUUID() {
        return this.uuid != null;
    }

    public void setOutpostSpawns(List<Location> outpostSpawns) {
        this.outpostSpawns = outpostSpawns;
    }

    public boolean isAlliedWith(Town othertown) {
        if (this.hasNation() && othertown.hasNation()) {
            try {
                if (this.getNation().hasAlly(othertown.getNation())) {
                    return true;
                }
                return this.getNation().equals(othertown.getNation());
            }
            catch (NotRegisteredException e) {
                return false;
            }
        }
        return false;
    }

    public int getOutpostLimit() {
        return TownySettings.getMaxOutposts(this);
    }

    public boolean isOverOutpostLimit() {
        return this.getMaxOutpostSpawn() > this.getOutpostLimit();
    }

    public boolean isOverClaimed() {
        return this.getTownBlocks().size() > TownySettings.getMaxTownBlocks(this);
    }

    @Override
    public void addMetaData(@NotNull CustomDataField<?> md) {
        this.addMetaData(md, true);
    }

    @Override
    public void removeMetaData(@NotNull CustomDataField<?> md) {
        this.removeMetaData(md, true);
    }

    public void setConquered(boolean conquered) {
        this.isConquered = conquered;
    }

    public boolean isConquered() {
        return this.isConquered;
    }

    public void setConqueredDays(int conqueredDays) {
        this.conqueredDays = conqueredDays;
    }

    public int getConqueredDays() {
        return this.conqueredDays;
    }

    public void addJail(Jail jail) {
        if (!this.hasJails()) {
            this.jails = new ArrayList<Jail>(1);
        }
        this.jails.add(jail);
    }

    public void removeJail(Jail jail) {
        if (this.hasJails() && this.hasJail(jail)) {
            this.jails.remove(jail);
        }
        if (this.getPrimaryJail() != null && this.getPrimaryJail().getUUID().equals(jail.getUUID())) {
            this.setPrimaryJail(null);
        }
    }

    public boolean hasJails() {
        return this.jails != null;
    }

    public boolean hasJail(Jail jail) {
        return this.jails.contains(jail);
    }

    @Nullable
    public Collection<Jail> getJails() {
        if (!this.hasJails()) {
            return null;
        }
        return Collections.unmodifiableCollection(this.jails);
    }

    @Nullable
    public Jail getJail(int i) {
        if (!this.hasJails() || this.jails.size() < i) {
            return null;
        }
        return this.jails.get(--i);
    }

    public void setPrimaryJail(Jail jail) {
        this.primaryJail = jail;
    }

    @Nullable
    public Jail getPrimaryJail() {
        if (this.primaryJail == null && this.hasJails()) {
            return this.getJail(1);
        }
        return this.primaryJail;
    }

    public void renamePlotGroup(String oldName, PlotGroup group) {
        this.plotGroups.remove(oldName);
        this.plotGroups.put(group.getName(), group);
    }

    public void addPlotGroup(PlotGroup group) {
        if (!this.hasPlotGroups()) {
            this.plotGroups = new HashMap();
        }
        this.plotGroups.put(group.getName(), group);
    }

    public void removePlotGroup(PlotGroup plotGroup) {
        if (this.hasPlotGroups() && this.plotGroups.remove(plotGroup.getName()) != null) {
            for (TownBlock tb : new ArrayList<TownBlock>(plotGroup.getTownBlocks())) {
                if (!tb.hasPlotObjectGroup() || !tb.getPlotObjectGroup().getID().equals(plotGroup.getID())) continue;
                plotGroup.removeTownBlock(tb);
                tb.removePlotObjectGroup();
                tb.save();
            }
        }
    }

    public Collection<PlotGroup> getPlotGroups() {
        if (this.plotGroups == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.plotGroups.values());
    }

    @Deprecated
    public PlotGroup getObjectGroupFromID(UUID ID) {
        if (this.hasPlotGroups()) {
            for (PlotGroup pg : this.getPlotGroups()) {
                if (!pg.getID().equals(ID)) continue;
                return pg;
            }
        }
        return null;
    }

    public boolean hasPlotGroups() {
        return this.plotGroups != null;
    }

    public boolean hasPlotGroupName(String name) {
        return this.hasPlotGroups() && this.plotGroups.containsKey(name);
    }

    @Nullable
    public PlotGroup getPlotObjectGroupFromName(String name) {
        if (this.hasPlotGroups() && this.hasPlotGroupName(name)) {
            return this.plotGroups.get(name);
        }
        return null;
    }

    @Override
    public double getBankCap() {
        return TownySettings.getTownBankCap();
    }

    @Override
    public World getWorld() {
        return this.hasWorld() ? BukkitTools.getWorld(this.getHomeblockWorld().getName()) : BukkitTools.getWorlds().get(0);
    }

    @Override
    public String getBankAccountPrefix() {
        return ECONOMY_ACCOUNT_PREFIX;
    }

    @Override
    public String getFormattedName() {
        if (this.isCapital()) {
            return TownySettings.getCapitalPrefix(this) + this.getName().replaceAll("_", " ") + TownySettings.getCapitalPostfix(this);
        }
        return TownySettings.getTownPrefix(this) + this.getName().replaceAll("_", " ") + TownySettings.getTownPostfix(this);
    }

    public String getPrefix() {
        return TownySettings.getTownPrefix(this);
    }

    public String getPostfix() {
        return TownySettings.getTownPostfix(this);
    }

    public double getMaxPercentTaxAmount() {
        return this.maxPercentTaxAmount;
    }

    public void setMaxPercentTaxAmount(double maxPercentTaxAmount) {
        this.maxPercentTaxAmount = Math.min(maxPercentTaxAmount, TownySettings.getMaxTownTaxPercentAmount());
    }

    public boolean isBankrupt() {
        return TownyEconomyHandler.isActive() && this.debtBalance > 0.0;
    }

    public double getDebtBalance() {
        return this.debtBalance;
    }

    public void setDebtBalance(double balance) {
        this.debtBalance = balance;
    }

    public boolean isRuined() {
        if (!this.ruined && this.residents.size() == 0) {
            this.ruined = true;
        }
        return this.ruined;
    }

    public void setRuined(boolean b) {
        this.ruined = b;
    }

    public void setRuinedTime(long time) {
        this.ruinedTime = time;
    }

    public long getRuinedTime() {
        return this.ruinedTime;
    }

    @Override
    @Nullable
    public String getMapColorHexCode() {
        String rawMapColorHexCode = super.getMapColorHexCode();
        TownMapColourLocalCalculationEvent event = new TownMapColourLocalCalculationEvent(this, rawMapColorHexCode);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getMapColorHexCode();
    }

    @Nullable
    public String getNationMapColorHexCode() {
        String rawMapColorHexCode = this.hasNation() ? this.nation.getMapColorHexCode() : null;
        TownMapColourNationalCalculationEvent event = new TownMapColourNationalCalculationEvent(this, rawMapColorHexCode);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getMapColorHexCode();
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveTown(this);
    }

    @Deprecated
    public World getBukkitWorld() {
        if (this.hasWorld()) {
            return BukkitTools.getWorld(this.getHomeblockWorld().getName());
        }
        return BukkitTools.getWorlds().get(0);
    }

    @Deprecated
    public String getEconomyName() {
        return StringMgmt.trimMaxLength(ECONOMY_ACCOUNT_PREFIX + this.getName(), 32);
    }

    @Deprecated
    public String getTownBoard() {
        return this.getBoard();
    }

    @Deprecated
    public UUID getUuid() {
        return this.getUUID();
    }

    public long getJoinedNationAt() {
        return this.joinedNationAt;
    }

    public void setJoinedNationAt(long joinedNationAt) {
        this.joinedNationAt = joinedNationAt;
    }

    public long getMovedHomeBlockAt() {
        return this.movedHomeBlockAt;
    }

    public void setMovedHomeBlockAt(long movedHomeBlockAt) {
        this.movedHomeBlockAt = movedHomeBlockAt;
    }

    private void sortResidents() {
        List sortedResidents = this.residents.stream().sorted(Comparator.comparingLong(Resident::getJoinedTownAt)).collect(Collectors.toList());
        this.residents.clear();
        this.residents.addAll(sortedResidents);
        this.residentsSorted = true;
    }

    public Set<Resident> getTrustedResidents() {
        return this.trustedResidents;
    }

    public boolean hasTrustedResident(Resident resident) {
        return this.trustedResidents.contains(resident);
    }

    public void addTrustedResident(Resident resident) {
        this.trustedResidents.add(resident);
    }

    public void removeTrustedResident(Resident resident) {
        this.trustedResidents.remove(resident);
    }
}

