/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.adventure.key.Key;
import com.palmergames.adventure.sound.Sound;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyInventory;
import com.palmergames.bukkit.towny.object.gui.EditGUI;
import com.palmergames.bukkit.towny.object.gui.PermissionGUI;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import com.palmergames.bukkit.util.Colors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;

public class TownyInventoryListener
implements Listener {
    Sound clickSound = Sound.sound(Key.key("minecraft", "block.stone_button.click_on"), Sound.Source.PLAYER, 1.0f, 1.0f);

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof TownyInventory) || event.getCurrentItem() == null) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null || event.getClickedInventory() != null && !(event.getClickedInventory().getHolder() instanceof TownyInventory)) {
            return;
        }
        if (event.getInventory().getHolder() instanceof EditGUI) {
            ItemMeta meta = event.getCurrentItem().getItemMeta();
            switch (event.getCurrentItem().getType()) {
                case LIME_WOOL: {
                    if (meta.getDisplayName().equals("\u00a7a" + ChatColor.BOLD + "Save")) {
                        ((EditGUI)event.getInventory().getHolder()).saveChanges();
                        break;
                    }
                    meta.setDisplayName("\u00a74" + ChatColor.BOLD + Colors.strip(meta.getDisplayName()));
                    event.getCurrentItem().setType(Material.RED_WOOL);
                    break;
                }
                case RED_WOOL: {
                    if (meta.getDisplayName().equals("\u00a74" + ChatColor.BOLD + "Back")) {
                        ((EditGUI)event.getInventory().getHolder()).exitScreen();
                        break;
                    }
                    if (meta.getDisplayName().equals("\u00a74" + ChatColor.BOLD + "Delete")) {
                        ((EditGUI)event.getInventory().getHolder()).deleteResident();
                        break;
                    }
                    meta.setDisplayName("\u00a78" + ChatColor.BOLD + Colors.strip(meta.getDisplayName()));
                    event.getCurrentItem().setType(Material.GRAY_WOOL);
                    break;
                }
                case GRAY_WOOL: {
                    meta.setDisplayName("\u00a7a" + ChatColor.BOLD + Colors.strip(meta.getDisplayName()));
                    event.getCurrentItem().setType(Material.LIME_WOOL);
                    break;
                }
                default: {
                    return;
                }
            }
            event.getCurrentItem().setItemMeta(meta);
            Towny.getAdventure().player(player).playSound(this.clickSound);
        } else {
            InventoryHolder meta = event.getInventory().getHolder();
            if (meta instanceof PermissionGUI) {
                PermissionGUI permissionGUI = (PermissionGUI)meta;
                if (event.getCurrentItem().getType() == Material.PLAYER_HEAD && permissionGUI.canEdit()) {
                    PermissionGUIUtil.openPermissionEditorGUI(resident, permissionGUI.getTownBlock(), event.getCurrentItem());
                    Towny.getAdventure().player(player).playSound(this.clickSound);
                } else if (event.getCurrentItem().getType() == Material.WRITTEN_BOOK) {
                    player.openBook(PermissionGUIUtil.createTutorialBook());
                } else if (event.getCurrentItem().getType() == Material.NAME_TAG) {
                    PermissionGUIUtil.handleConversation(player);
                    event.getWhoClicked().closeInventory();
                } else {
                    int currentPage = resident.getGUIPageNum();
                    try {
                        if (event.getCurrentItem().getItemMeta().getDisplayName().equals("\u00a76Next")) {
                            if (resident.getGUIPageNum() <= resident.getGUIPages().size() - 1) {
                                resident.setGUIPageNum(++currentPage);
                                new PermissionGUI(resident, resident.getGUIPage(), event.getView().getTitle(), permissionGUI.getTownBlock(), permissionGUI.canEdit());
                                Towny.getAdventure().player(player).playSound(this.clickSound);
                            }
                        } else if (event.getCurrentItem().getItemMeta().getDisplayName().equals("\u00a76Back") && resident.getGUIPageNum() > 0) {
                            resident.setGUIPageNum(--currentPage);
                            new PermissionGUI(resident, resident.getGUIPage(), event.getView().getTitle(), permissionGUI.getTownBlock(), permissionGUI.canEdit());
                            Towny.getAdventure().player(player).playSound(this.clickSound);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                int currentPage = resident.getGUIPageNum();
                try {
                    if (event.getCurrentItem().getItemMeta().getDisplayName().equals("\u00a76Next")) {
                        if (resident.getGUIPageNum() >= resident.getGUIPages().size() - 1) {
                            return;
                        }
                        resident.setGUIPageNum(++currentPage);
                        new TownyInventory(resident, resident.getGUIPage(), event.getView().getTitle());
                        Towny.getAdventure().player(player).playSound(this.clickSound);
                    } else if (event.getCurrentItem().getItemMeta().getDisplayName().equals("\u00a76Back") && resident.getGUIPageNum() > 0) {
                        resident.setGUIPageNum(--currentPage);
                        new TownyInventory(resident, resident.getGUIPage(), event.getView().getTitle());
                        Towny.getAdventure().player(player).playSound(this.clickSound);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

