/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.huds;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.huds.MapHUD;
import com.palmergames.bukkit.towny.huds.PermHUD;
import com.palmergames.bukkit.towny.huds.WarHUD;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.war.eventwar.PlotAttackedEvent;
import com.palmergames.bukkit.towny.war.eventwar.TownScoredEvent;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class HUDManager
implements Listener {
    static List<Player> warUsers;
    static List<Player> permUsers;
    static List<Player> mapUsers;

    public HUDManager(Towny plugin) {
        warUsers = new ArrayList<Player>();
        permUsers = new ArrayList<Player>();
        mapUsers = new ArrayList<Player>();
    }

    public static void toggleWarHUD(Player p) {
        if (!warUsers.contains(p)) {
            HUDManager.toggleAllOff(p);
            warUsers.add(p);
            WarHUD.toggleOn(p, TownyUniverse.getInstance().getWarEvent());
        } else {
            HUDManager.toggleAllOff(p);
        }
    }

    public static void togglePermHUD(Player p) {
        if (!permUsers.contains(p)) {
            HUDManager.toggleAllOff(p);
            permUsers.add(p);
            PermHUD.toggleOn(p);
        } else {
            HUDManager.toggleAllOff(p);
        }
    }

    public static void toggleMapHud(Player player) {
        if (!mapUsers.contains(player)) {
            HUDManager.toggleAllOff(player);
            mapUsers.add(player);
            MapHUD.toggleOn(player);
        } else {
            HUDManager.toggleAllOff(player);
        }
    }

    public static void toggleAllWarHUD() {
        for (Player p : warUsers) {
            HUDManager.toggleOff(p);
        }
        warUsers.clear();
    }

    public static void toggleAllOff(Player p) {
        warUsers.remove(p);
        permUsers.remove(p);
        mapUsers.remove(p);
        if (p.isOnline()) {
            HUDManager.toggleOff(p);
        }
    }

    public static void toggleOff(Player p) {
        p.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        warUsers.remove(event.getPlayer());
        permUsers.remove(event.getPlayer());
        mapUsers.remove(event.getPlayer());
    }

    @EventHandler
    public void onPlayerMovePlotsEvent(PlayerChangePlotEvent event) throws NotRegisteredException {
        Player p = event.getPlayer();
        if (warUsers.contains(p)) {
            if (!HUDManager.isWarHUDActive(p)) {
                warUsers.remove(p);
            } else {
                WarHUD.updateLocation(p, event.getTo());
                WarHUD.updateAttackable(p, event.getTo(), TownyUniverse.getInstance().getWarEvent());
                WarHUD.updateHealth(p, event.getTo(), TownyUniverse.getInstance().getWarEvent());
            }
        } else if (permUsers.contains(p)) {
            if (!HUDManager.isPermHUDActive(p)) {
                permUsers.remove(p);
            } else if (event.getTo().getTownyWorld().isUsingTowny()) {
                PermHUD.updatePerms(p, event.getTo());
            } else {
                HUDManager.toggleAllOff(p);
            }
        } else if (mapUsers.contains(p)) {
            if (!HUDManager.isMapHudActive(p)) {
                mapUsers.remove(p);
            } else if (event.getTo().getTownyWorld().isUsingTowny()) {
                MapHUD.updateMap(p, event.getTo());
            } else {
                HUDManager.toggleAllOff(p);
            }
        }
    }

    @EventHandler
    public void onPlotAttacked(PlotAttackedEvent event) {
        boolean home = event.getTownBlock().isHomeBlock();
        for (Player p : event.getPlayers()) {
            if (!warUsers.contains(p)) continue;
            WarHUD.updateHealth(p, event.getHP(), home);
        }
    }

    @EventHandler
    public void onTownScored(TownScoredEvent event) {
        War warEvent = TownyUniverse.getInstance().getWarEvent();
        for (Resident r : event.getTown().getResidents()) {
            Player player = BukkitTools.getPlayer(r.getName());
            if (player == null || !warUsers.contains(player)) continue;
            WarHUD.updateScore(player, event.getScore());
        }
        String[] top = warEvent.getTopThree();
        for (Player p : warUsers) {
            WarHUD.updateTopScores(p, top);
        }
    }

    @EventHandler
    public void onTownBlockSettingsChanged(TownBlockSettingsChangedEvent e) {
        block8: {
            block9: {
                block7: {
                    if (e.getTownyWorld() == null) break block7;
                    for (Player p : permUsers) {
                        PermHUD.updatePerms(p);
                    }
                    break block8;
                }
                if (e.getTown() == null) break block9;
                for (Player p : permUsers) {
                    try {
                        if (new WorldCoord(p.getWorld().getName(), Coord.parseCoord((Entity)p)).getTownBlock().getTown() != e.getTown()) continue;
                        PermHUD.updatePerms(p);
                    }
                    catch (Exception exception) {}
                }
                break block8;
            }
            if (e.getTownBlock() == null) break block8;
            for (Player p : permUsers) {
                try {
                    if (new WorldCoord(p.getWorld().getName(), Coord.parseCoord((Entity)p)).getTownBlock() != e.getTownBlock()) continue;
                    PermHUD.updatePerms(p);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String check(String string) {
        return string.length() > 64 ? string.substring(0, 64) : string;
    }

    public static boolean isUsingHUD(Player player) {
        return permUsers.contains(player) || warUsers.contains(player);
    }

    public static List<Player> getPermHUDUsers() {
        return permUsers;
    }

    public static List<Player> getWarHUDUsers() {
        return warUsers;
    }

    public static List<Player> getMapHUDUsers() {
        return mapUsers;
    }

    public static void removePermHUDUser(Player player) {
        if (permUsers.remove(player)) {
            HUDManager.toggleOff(player);
        }
    }

    public static void removeWarHUDUser(Player player) {
        if (warUsers.remove(player)) {
            HUDManager.toggleOff(player);
        }
    }

    public static void removeMapHUDUser(Player player) {
        if (mapUsers.remove(player)) {
            HUDManager.toggleOff(player);
        }
    }

    public static boolean isPermHUDActive(Player player) {
        return player.getScoreboard().getTeam("plot") != null;
    }

    public static boolean isWarHUDActive(Player player) {
        return player.getScoreboard().getTeam("space1") != null;
    }

    public static boolean isMapHudActive(Player player) {
        return player.getScoreboard().getTeam("mapTeam1") != null;
    }
}

