/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.nation.toggle;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Translation;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Nullable;

public abstract class NationToggleEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private Player player = null;
    private final CommandSender sender;
    private final Nation nation;
    private final boolean isAdminAction;
    private boolean isCancelled = false;
    private String cancelMessage = Translation.of("msg_err_command_disable");

    public NationToggleEvent(CommandSender sender, Nation nation, boolean admin) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.sender = sender;
        if (sender instanceof Player) {
            this.player = (Player)sender;
        }
        this.nation = nation;
        this.isAdminAction = admin;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    @Nullable
    public Resident getResident() {
        return TownyUniverse.getInstance().getResident(this.player.getUniqueId());
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public Nation getNation() {
        return this.nation;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public void setCancelMessage(String cancelMessage) {
        this.cancelMessage = cancelMessage;
    }

    public boolean isAdminAction() {
        return this.isAdminAction;
    }
}

