/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ConfirmationHandler {
    private static final Towny plugin = Towny.getPlugin();
    private static final Map<CommandSender, ConfirmationContext> confirmations = new ConcurrentHashMap<CommandSender, ConfirmationContext>();

    public static void revokeConfirmation(CommandSender sender) {
        ConfirmationContext context = confirmations.get(sender);
        Bukkit.getScheduler().cancelTask(context.taskID);
        Confirmation confirmation = context.confirmation;
        confirmations.remove(sender);
        if (confirmation.getCancelHandler() != null) {
            confirmation.getCancelHandler().run();
        }
        TownyMessaging.sendMsg(sender, Translatable.of("successful_cancel"));
    }

    public static void sendConfirmation(CommandSender sender, Confirmation confirmation) {
        if (confirmations.containsKey(sender)) {
            ConfirmationHandler.revokeConfirmation(sender);
        }
        String title = confirmation.getTitle(Translation.getLocale(sender));
        TownyMessaging.sendConfirmationMessage(sender, title, null, null, null);
        int duration = confirmation.getDuration();
        Runnable handler = () -> {
            if (ConfirmationHandler.hasConfirmation(sender)) {
                confirmations.remove(sender);
                TownyMessaging.sendErrorMsg((Object)sender, "Confirmation Timed out.");
            }
        };
        long ticks = 20L * (long)duration;
        int taskID = Bukkit.getScheduler().runTaskLater((Plugin)plugin, handler, ticks).getTaskId();
        confirmations.put(sender, new ConfirmationContext(confirmation, taskID));
    }

    public static void acceptConfirmation(CommandSender sender) {
        ConfirmationContext context = confirmations.get(sender);
        Runnable handler = context.confirmation.getAcceptHandler();
        Bukkit.getScheduler().cancelTask(context.taskID);
        confirmations.remove(sender);
        if (context.confirmation.isAsync()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, handler);
        } else {
            Bukkit.getScheduler().runTask((Plugin)plugin, handler);
        }
    }

    public static boolean hasConfirmation(CommandSender sender) {
        return confirmations.containsKey(sender);
    }

    private static final class ConfirmationContext {
        final Confirmation confirmation;
        final int taskID;

        ConfirmationContext(Confirmation confirmation, int taskID) {
            this.confirmation = confirmation;
            this.taskID = taskID;
        }
    }
}

