/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BaseCommand
implements TabCompleter {
    private static final List<String> setPermTabCompletes = Arrays.asList("on", "off", "resident", "friend", "town", "nation", "ally", "outsider", "build", "destroy", "switch", "itemuse", "reset");
    private static final List<String> setLevelCompletes = Arrays.asList("resident", "ally", "outsider", "nation", "friend", "town");
    private static final List<String> setTypeCompletes = Arrays.asList("build", "destroy", "switch", "itemuse");
    public static final List<String> setOnOffCompletes = Collections.unmodifiableList(Arrays.asList("on", "off"));
    private static final List<String> toggleTypeOnOffCompletes = Arrays.asList("build", "destroy", "switch", "itemuse", "on", "off");

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return BaseCommand.getTownyStartingWith(args[args.length - 1], "rtn");
    }

    static List<String> getTownyStartingWith(String arg, String type) {
        ArrayList<String> matches = new ArrayList<String>();
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (type.contains("r")) {
            matches.addAll(townyUniverse.getResidentsTrie().getStringsFromKey(arg));
        }
        if (type.contains("t")) {
            matches.addAll(townyUniverse.getTownsTrie().getStringsFromKey(arg));
        }
        if (type.contains("n")) {
            matches.addAll(townyUniverse.getNationsTrie().getStringsFromKey(arg));
        }
        if (type.contains("w")) {
            matches.addAll(NameUtil.filterByStart(NameUtil.getNames(townyUniverse.getWorldMap().values()), arg));
        }
        return matches;
    }

    static List<String> filterByStartOrGetTownyStartingWith(List<String> filters, String arg, String type) {
        List<String> filtered = NameUtil.filterByStart(filters, arg);
        if (type.isEmpty()) {
            return filtered;
        }
        if (type.contains("+")) {
            filtered.addAll(BaseCommand.getTownyStartingWith(arg, type));
            return filtered;
        }
        if (filtered.size() > 0) {
            return filtered;
        }
        return BaseCommand.getTownyStartingWith(arg, type);
    }

    static List<String> permTabComplete(String[] args) {
        switch (args.length) {
            case 1: {
                return NameUtil.filterByStart(setPermTabCompletes, args[0]);
            }
            case 2: {
                if (setTypeCompletes.contains(args[0].toLowerCase())) {
                    return NameUtil.filterByStart(setOnOffCompletes, args[1]);
                }
                if (!setLevelCompletes.contains(args[0].toLowerCase())) break;
                return NameUtil.filterByStart(toggleTypeOnOffCompletes, args[1]);
            }
            case 3: {
                return NameUtil.filterByStart(setOnOffCompletes, args[2]);
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getTownResidentNamesOfPlayerStartingWith(Player player, String str) {
        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (res != null && res.hasTown()) {
            return NameUtil.filterByStart(NameUtil.getNames(res.getTownOrNull().getResidents()), str);
        }
        return Collections.emptyList();
    }

    public static List<String> getResidentsOfTownStartingWith(String townName, String str) {
        Town town = TownyUniverse.getInstance().getTown(townName);
        if (town != null) {
            return NameUtil.filterByStart(NameUtil.getNames(town.getResidents()), str);
        }
        return Collections.emptyList();
    }

    public static List<String> getResidentsWithoutTownStartingWith(String str) {
        List<Resident> residents = BaseCommand.getOnlinePlayersWithoutTown();
        if (!residents.isEmpty()) {
            return NameUtil.filterByStart(NameUtil.getNames(residents), str);
        }
        return Collections.emptyList();
    }

    protected static Optional<Boolean> parseToggleChoice(String str) {
        if (str.equalsIgnoreCase("on")) {
            return Optional.of(true);
        }
        if (str.equalsIgnoreCase("off")) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @NotNull
    protected static Resident getResidentOrThrow(UUID playerUUID) throws NotRegisteredException {
        Resident res = TownyUniverse.getInstance().getResident(playerUUID);
        if (res == null) {
            throw new NotRegisteredException(Translation.of("msg_err_not_registered"));
        }
        return res;
    }

    @NotNull
    protected static Resident getResidentOrThrow(String residentName) throws NotRegisteredException {
        Resident res = TownyUniverse.getInstance().getResident(residentName);
        if (res == null) {
            throw new NotRegisteredException(Translation.of("msg_err_not_registered_1", residentName));
        }
        return res;
    }

    private static List<Resident> getOnlinePlayersWithoutTown() {
        ArrayList<Resident> townlessResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident.hasTown()) continue;
            townlessResidents.add(resident);
        }
        return townlessResidents;
    }
}

