/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.chat.types;

import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.tnemc.tnc.core.common.chat.ChatType;
import org.bukkit.entity.Player;

public class TownType
extends ChatType {
    public TownType() {
        super("town", "<aqua>$display: <white>$message");
    }

    public boolean canChat(Player player) {
        Resident res = TownyUniverse.getInstance().getResident(player.getUniqueId());
        return res != null && res.hasTown();
    }

    public Collection<Player> getRecipients(Collection<Player> recipients, Player player) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident resident = townyUniverse.getResident(player.getUniqueId());
        if (resident == null) {
            return recipients;
        }
        try {
            UUID town = resident.getTown().getUUID();
            HashSet<Player> newRecipients = new HashSet<Player>();
            for (Player p : recipients) {
                Resident playerResident = townyUniverse.getResident(p.getUniqueId());
                if (playerResident == null || !playerResident.hasTown() || !playerResident.getTown().getUUID().equals(town)) continue;
                newRecipients.add(p);
            }
            return newRecipients;
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
            return recipients;
        }
    }
}

