/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.economy.Account;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class TownyLogger {
    private static final TownyLogger instance = new TownyLogger();
    private static final Logger LOGGER_MONEY = LogManager.getLogger((String)"com.palmergames.bukkit.towny.money");

    private TownyLogger() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        String logFolderName = TownyUniverse.getInstance().getRootFolder() + File.separator + "logs";
        FileAppender townyMainAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "towny.log").withName("Towny-Main-Log")).withAppend(TownySettings.isAppendingToLog()).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).setConfiguration(config)).withLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d [%t]: %m%n").withConfiguration(config).build())).build();
        FileAppender townyMoneyAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "money.csv").withName("Towny-Money")).withAppend(TownySettings.isAppendingToLog()).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).setConfiguration(config)).withLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d{dd MMM yyyy HH:mm:ss},%m%n").withConfiguration(config).build())).build();
        FileAppender townyDebugAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "debug.log").withName("Towny-Debug")).withAppend(TownySettings.isAppendingToLog()).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).setConfiguration(config)).withLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d [%t]: %m%n").withConfiguration(config).build())).build();
        FileAppender townyDatabaseAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "database.log").withName("Towny-Database")).withAppend(TownySettings.isAppendingToLog()).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).setConfiguration(config)).withLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d [%t]: %m%n").withConfiguration(config).build())).build();
        townyMainAppender.start();
        townyMoneyAppender.start();
        townyDebugAppender.start();
        townyDatabaseAppender.start();
        LoggerConfig townyMainConfig = LoggerConfig.createLogger((boolean)true, (Level)Level.ALL, (String)"Towny", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)config, null);
        townyMainConfig.addAppender((Appender)townyMainAppender, Level.ALL, null);
        config.addLogger(Towny.class.getName(), townyMainConfig);
        LoggerConfig townyDebugConfig = LoggerConfig.createLogger((boolean)TownySettings.getDebug(), (Level)Level.ALL, (String)"Towny-Debug", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)config, null);
        townyDebugConfig.addAppender((Appender)townyDebugAppender, Level.ALL, null);
        config.addLogger("com.palmergames.bukkit.towny.debug", townyDebugConfig);
        LoggerConfig townyMoneyConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)"Towny-Money", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)config, null);
        townyMoneyConfig.addAppender((Appender)townyMoneyAppender, Level.ALL, null);
        config.addLogger("com.palmergames.bukkit.towny.money", townyMoneyConfig);
        LoggerConfig townyDatabaseConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)"Towny-Database", null, (AppenderRef[])new AppenderRef[0], null, (Configuration)config, null);
        townyDatabaseConfig.addAppender((Appender)townyDatabaseAppender, Level.ALL, null);
        ctx.updateLoggers();
    }

    public void refreshDebugLogger() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig townyDebugConfig = config.getLoggerConfig("com.palmergames.bukkit.towny.debug");
        townyDebugConfig.setAdditive(TownySettings.getDebug());
        ctx.updateLoggers();
    }

    public void logMoneyTransaction(Account a, double amount, Account b, String reason) {
        String sender = a == null ? "None" : a.getName();
        String receiver = b == null ? "None" : b.getName();
        if (reason == null) {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", "Unknown Reason", sender, amount, receiver));
        } else {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", reason, sender, amount, receiver));
        }
    }

    public void logMoneyTransaction(String a, double amount, String b, String reason) {
        if (reason == null) {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", "Unknown Reason", a, amount, b));
        } else {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", reason, a, amount, b));
        }
    }

    public static TownyLogger getInstance() {
        return instance;
    }
}

