/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.adventure.text.Component;
import com.palmergames.adventure.text.TextComponent;
import com.palmergames.adventure.text.event.ClickEvent;
import com.palmergames.adventure.text.event.HoverEvent;
import com.palmergames.adventure.text.format.NamedTextColor;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.asciimap.WildernessMapEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.map.TownyMapData;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Compass;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TownyAsciiMap {
    public static final int lineWidth = 27;
    public static final int halfLineWidth = 13;
    private static final int townBlockSize = TownySettings.getTownBlockSize();

    public static String[] generateHelp(Player player) {
        return new String[]{"  \u00a78-\u00a77 = " + Translatable.of("towny_map_unclaimed").forLocale((CommandSender)player), "  \u00a7f+\u00a77 = " + Translatable.of("towny_map_claimed").forLocale((CommandSender)player), "  \u00a7f$\u00a77 = " + Translatable.of("towny_map_forsale").forLocale((CommandSender)player), "  \u00a7a+\u00a77 = " + Translatable.of("towny_map_yourtown").forLocale((CommandSender)player), "  \u00a7e+\u00a77 = " + Translatable.of("towny_map_yourplot").forLocale((CommandSender)player), "  \u00a72+\u00a77 = " + Translatable.of("towny_map_ally").forLocale((CommandSender)player), "  \u00a74+\u00a77 = " + Translatable.of("towny_map_enemy").forLocale((CommandSender)player)};
    }

    public static String[] generateCompass(Player player) {
        Compass.Point dir = Compass.getCompassPointForDirection(player.getLocation().getYaw());
        return new String[]{"\u00a70  -----  ", "\u00a70  -" + (dir == Compass.Point.NW ? "\u00a76\\" : "-") + (dir == Compass.Point.N ? "\u00a76" : "\u00a7f") + "N" + (dir == Compass.Point.NE ? "\u00a76/\u00a70" : "\u00a70-") + "-  ", "\u00a70  -" + (dir == Compass.Point.W ? "\u00a76W" : "\u00a7fW") + "\u00a77" + "+" + (dir == Compass.Point.E ? "\u00a76" : "\u00a7f") + "E" + "\u00a70" + "-  ", "\u00a70  -" + (dir == Compass.Point.SW ? "\u00a76/" : "-") + (dir == Compass.Point.S ? "\u00a76" : "\u00a7f") + "S" + (dir == Compass.Point.SE ? "\u00a76\\\u00a70" : "\u00a70-") + "-  "};
    }

    public static void generateAndSend(Towny plugin, Player player, int lineHeight) {
        TownyWorld world;
        boolean hasTown = false;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident resident = townyUniverse.getResident(player.getUniqueId());
        if (resident == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_registered"));
            return;
        }
        if (resident.hasTown()) {
            hasTown = true;
        }
        if ((world = TownyAPI.getInstance().getTownyWorld(player.getWorld().getName())) == null) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_err_not_configured"));
            return;
        }
        if (!world.isUsingTowny()) {
            TownyMessaging.sendErrorMsg((CommandSender)player, Translatable.of("msg_set_use_towny_off"));
            return;
        }
        Coord pos = Coord.parseCoord(plugin.getCache(player).getLastLocation());
        int halfLineHeight = lineHeight / 2;
        TextComponent[][] townyMap = new TextComponent[27][lineHeight];
        int y = 0;
        for (int tby = pos.getX() + 13; tby >= pos.getX() - 13; --tby) {
            int x = 0;
            for (int tbx = pos.getZ() - halfLineHeight; tbx <= pos.getZ() + (lineHeight - halfLineHeight - 1); ++tbx) {
                try {
                    double cost;
                    townyMap[y][x] = (TextComponent)Component.empty().color(NamedTextColor.WHITE);
                    TownBlock townblock = world.getTownBlock(tby, tbx);
                    if (!townblock.hasTown()) {
                        throw new TownyException();
                    }
                    Town town = townblock.getTownOrNull();
                    if (x == halfLineHeight && y == 13) {
                        townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.GOLD);
                    } else if (hasTown) {
                        if (resident.getTown() == town) {
                            townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.GREEN);
                            if (townblock.hasResident() && resident == townblock.getResidentOrNull()) {
                                townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.YELLOW);
                            }
                        } else if (resident.hasNation()) {
                            if (resident.getTown().getNation().hasTown(town)) {
                                townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.DARK_GREEN);
                            } else if (town.hasNation()) {
                                Nation nation = resident.getTown().getNation();
                                if (nation.hasAlly(town.getNation())) {
                                    townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.GREEN);
                                } else if (nation.hasEnemy(town.getNation())) {
                                    townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.DARK_RED);
                                }
                            }
                        }
                    }
                    if (townblock.getPlotPrice() != -1.0 || townblock.hasPlotObjectGroup() && townblock.getPlotObjectGroup().getPrice() != -1.0) {
                        if (townblock.getType().equals((Object)TownBlockType.COMMERCIAL)) {
                            townyMap[y][x] = (TextComponent)townyMap[y][x].color(NamedTextColor.BLUE);
                        }
                        townyMap[y][x] = townyMap[y][x].content("$");
                    } else {
                        townyMap[y][x] = townblock.isHomeBlock() ? townyMap[y][x].content("H") : townyMap[y][x].content(townblock.getType().getAsciiMapKey());
                    }
                    TextComponent forSaleComponent = Component.empty();
                    TextComponent claimedAtComponent = Component.empty();
                    TextComponent groupComponent = Component.empty();
                    if (TownyEconomyHandler.isActive() && (cost = townblock.hasPlotObjectGroup() ? townblock.getPlotObjectGroup().getPrice() : townblock.getPlotPrice()) > -1.0) {
                        forSaleComponent = (TextComponent)((TextComponent)Component.text(String.format(ChunkNotification.forSaleNotificationFormat, TownyEconomyHandler.getFormattedBalance(cost)).replaceAll("[\\[\\]]", "") + " " + Translatable.of("msg_click_purchase").forLocale((CommandSender)player)).color(NamedTextColor.YELLOW)).append(Component.newline());
                    }
                    if (townblock.getClaimedAt() > 0L) {
                        claimedAtComponent = (TextComponent)Component.text(Translatable.of("msg_plot_perm_claimed_at", TownyFormatter.registeredFormat.format(townblock.getClaimedAt())).forLocale((CommandSender)player)).append(Component.newline());
                    }
                    if (townblock.hasPlotObjectGroup()) {
                        groupComponent = (TextComponent)((TextComponent)Component.text(Translatable.of("map_hover_plot_group").forLocale((CommandSender)player)).color(NamedTextColor.DARK_GREEN)).append(((TextComponent)Component.text(townblock.getPlotObjectGroup().getFormattedName()).color(NamedTextColor.GREEN)).append(((TextComponent)Component.text(Translatable.of("map_hover_plot_group_size").forLocale((CommandSender)player)).color(NamedTextColor.DARK_GREEN)).append(((TextComponent)Component.text(Translatable.of("map_hover_plots", townblock.getPlotObjectGroup().getTownBlocks().size()).forLocale((CommandSender)player)).color(NamedTextColor.GREEN)).append(Component.newline()))));
                    }
                    TextComponent hoverComponent = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text(Translatable.of("status_town").forLocale((CommandSender)player) + town.getName() + (townblock.hasResident() ? " (" + townblock.getResidentOrNull().getName() + ")" : "")).color(NamedTextColor.GREEN)).append(Component.text(" (" + tby + ", " + tbx + ")").color(NamedTextColor.WHITE))).append(Component.newline())).append(((TextComponent)Component.text(Translatable.of("status_plot_type").forLocale((CommandSender)player)).color(NamedTextColor.DARK_GREEN)).append(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text(townblock.getType().getName()).color(NamedTextColor.GREEN)).append(Component.newline())).append(groupComponent)).append(forSaleComponent)).append(claimedAtComponent)).append(Component.text(Translatable.of("towny_map_detailed_information").forLocale((CommandSender)player)).color(NamedTextColor.DARK_GREEN))));
                    ClickEvent clickEvent = ClickEvent.runCommand("/towny:plot info " + tby + " " + tbx);
                    if (!forSaleComponent.equals(Component.empty())) {
                        clickEvent = ClickEvent.runCommand("/towny:plot claim " + world.getName() + " x" + tby + " z" + tbx);
                    }
                    townyMap[y][x] = (TextComponent)((TextComponent)townyMap[y][x].hoverEvent(HoverEvent.showText(hoverComponent))).clickEvent(clickEvent);
                }
                catch (TownyException e) {
                    String clickCommand;
                    TextComponent hoverText;
                    String symbol;
                    townyMap[y][x] = x == halfLineHeight && y == 13 ? (TextComponent)townyMap[y][x].color(NamedTextColor.GOLD) : (TextComponent)townyMap[y][x].color(NamedTextColor.DARK_GRAY);
                    WorldCoord wc = WorldCoord.parseWorldCoord(world.getName(), tby * townBlockSize, tbx * townBlockSize);
                    if (TownyAsciiMap.getWildernessMapDataMap().containsKey(wc) && !TownyAsciiMap.getWildernessMapDataMap().get(wc).isOld()) {
                        TownyMapData mapData = TownyAsciiMap.getWildernessMapDataMap().get(wc);
                        symbol = mapData.getSymbol();
                        hoverText = mapData.getHoverText();
                        clickCommand = mapData.getClickCommand();
                    } else {
                        if (TownyAsciiMap.getWildernessMapDataMap().containsKey(wc)) {
                            TownyAsciiMap.getWildernessMapDataMap().remove(wc);
                        }
                        WildernessMapEvent wildMapEvent = new WildernessMapEvent(wc);
                        Bukkit.getPluginManager().callEvent((Event)wildMapEvent);
                        symbol = wildMapEvent.getMapSymbol();
                        hoverText = wildMapEvent.getHoverText();
                        clickCommand = wildMapEvent.getClickCommand();
                        TownyAsciiMap.getWildernessMapDataMap().put(wc, new TownyMapData(wc, symbol, hoverText, clickCommand));
                        Bukkit.getScheduler().runTaskLater((Plugin)Towny.getPlugin(), () -> {
                            if (TownyAsciiMap.getWildernessMapDataMap().containsKey(wc) && TownyAsciiMap.getWildernessMapDataMap().get(wc).isOld()) {
                                TownyAsciiMap.getWildernessMapDataMap().remove(wc);
                            }
                        }, 700L);
                    }
                    townyMap[y][x] = (TextComponent)((TextComponent)townyMap[y][x].content(symbol).clickEvent(ClickEvent.runCommand(clickCommand))).hoverEvent(HoverEvent.showText(hoverText));
                }
                ++x;
            }
            ++y;
        }
        String[] compass = TownyAsciiMap.generateCompass(player);
        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(Translatable.of("towny_map_header").forLocale((CommandSender)player) + "\u00a7f" + "(" + pos.toString() + ")"));
        String[] help = TownyAsciiMap.generateHelp(player);
        int lineCount = 0;
        for (int my = 0; my < lineHeight; ++my) {
            String line = compass[0];
            if (lineCount < compass.length) {
                line = compass[lineCount];
            }
            TextComponent compassComponent = Component.text(line);
            TextComponent fullComponent = Component.empty();
            for (int mx = 26; mx >= 0; --mx) {
                fullComponent = (TextComponent)fullComponent.append(townyMap[mx][my]);
            }
            if (lineCount < help.length) {
                fullComponent = (TextComponent)fullComponent.append(Component.text(help[lineCount]));
            }
            Towny.getAdventure().player(player).sendMessage(compassComponent.append(fullComponent));
            ++lineCount;
        }
        TownBlock townblock = TownyAPI.getInstance().getTownBlock(plugin.getCache(player).getLastLocation());
        TownyMessaging.sendMsg((CommandSender)player, Translatable.of("town_sing").forLocale((CommandSender)player) + ": " + (townblock != null && townblock.hasTown() ? townblock.getTownOrNull().getName() : Translatable.of("status_no_town").forLocale((CommandSender)player)) + " : " + Translatable.of("owner_status").forLocale((CommandSender)player) + ": " + (townblock != null && townblock.hasResident() ? townblock.getResidentOrNull().getName() : Translatable.of("status_no_town").forLocale((CommandSender)player)));
    }

    private static Map<WorldCoord, TownyMapData> getWildernessMapDataMap() {
        return TownyUniverse.getInstance().getWildernessMapDataMap();
    }
}

