/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.content.Context;
import android.content.SharedPreferences;
import com.tonytangandroid.wood.Logger;
import com.tonytangandroid.wood.WoodDatabase;
import com.tonytangandroid.wood.WoodTree;
import java.util.Date;
import java.util.concurrent.TimeUnit;

class RetentionManager {
    private static final String PREFS_NAME = "wood_preferences";
    private static final String KEY_LAST_CLEANUP = "last_cleanup";
    private static long LAST_CLEAN_UP;
    private final WoodDatabase woodDatabase;
    private final long period;
    private final long cleanupFrequency;
    private final SharedPreferences prefs;

    public RetentionManager(Context context, WoodTree.Period retentionPeriod) {
        this.woodDatabase = WoodDatabase.getInstance(context);
        this.period = this.toMillis(retentionPeriod);
        this.prefs = context.getSharedPreferences(PREFS_NAME, 0);
        this.cleanupFrequency = retentionPeriod == WoodTree.Period.ONE_HOUR ? TimeUnit.MINUTES.toMillis(30L) : TimeUnit.HOURS.toMillis(2L);
    }

    public synchronized void doMaintenance() {
        long now;
        if (this.period > 0L && this.isCleanupDue(now = new Date().getTime())) {
            Logger.i("Performing data retention maintenance...");
            this.deleteSince(this.getThreshold(now));
            this.updateLastCleanup(now);
        }
    }

    private long getLastCleanup(long fallback) {
        if (LAST_CLEAN_UP == 0L) {
            LAST_CLEAN_UP = this.prefs.getLong(KEY_LAST_CLEANUP, fallback);
        }
        return LAST_CLEAN_UP;
    }

    private void updateLastCleanup(long time) {
        LAST_CLEAN_UP = time;
        this.prefs.edit().putLong(KEY_LAST_CLEANUP, time).apply();
    }

    private void deleteSince(long threshold) {
        long rows = this.woodDatabase.leafDao().deleteTransactionsBefore(threshold);
        Logger.i(rows + " transactions deleted");
    }

    private boolean isCleanupDue(long now) {
        return now - this.getLastCleanup(now) > this.cleanupFrequency;
    }

    private long getThreshold(long now) {
        return this.period == 0L ? now : now - this.period;
    }

    private long toMillis(WoodTree.Period period) {
        switch (period) {
            case ONE_HOUR: {
                return TimeUnit.HOURS.toMillis(1L);
            }
            case ONE_DAY: {
                return TimeUnit.DAYS.toMillis(1L);
            }
            case ONE_WEEK: {
                return TimeUnit.DAYS.toMillis(7L);
            }
        }
        return 0L;
    }
}

