/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.LeafDao;
import com.tonytangandroid.wood.WoodDatabase;

public class LeafListViewModel
extends AndroidViewModel {
    private static final PagedList.Config config = new PagedList.Config.Builder().setPageSize(15).setInitialLoadSizeHint(30).setPrefetchDistance(10).setEnablePlaceholders(true).build();
    private final LeafDao leafDao;
    private final LiveData<PagedList<Leaf>> transactions;

    public LeafListViewModel(Application application) {
        super(application);
        this.leafDao = WoodDatabase.getInstance((Context)application).leafDao();
        this.transactions = new LivePagedListBuilder(this.leafDao.getAllTransactions(), config).build();
    }

    LiveData<PagedList<Leaf>> getTransactions(String key) {
        if (key == null || key.trim().length() == 0) {
            return this.transactions;
        }
        DataSource.Factory<Integer, Leaf> factory = this.leafDao.getAllTransactionsWith(key, 2);
        return new LivePagedListBuilder(factory, config).build();
    }

    public void deleteItem(Leaf transaction) {
        new DeleteAsyncTask(this.leafDao).execute(new Leaf[]{transaction});
    }

    void clearAll() {
        new ClearAsyncTask(this.leafDao).execute(new Leaf[0]);
    }

    private static class ClearAsyncTask
    extends AsyncTask<Leaf, Void, Integer> {
        private final LeafDao leafDao;

        ClearAsyncTask(LeafDao leafDao) {
            this.leafDao = leafDao;
        }

        protected Integer doInBackground(Leaf ... params) {
            return this.leafDao.clearAll();
        }
    }

    private static class DeleteAsyncTask
    extends AsyncTask<Leaf, Void, Integer> {
        private final LeafDao leafDao;

        DeleteAsyncTask(LeafDao leafDao) {
            this.leafDao = leafDao;
        }

        protected Integer doInBackground(Leaf ... params) {
            return this.leafDao.deleteTransactions(params);
        }
    }
}

