/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.LongSparseArray;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.tony.tang.safe.pending.intent.sdk.SafePendingIntent;
import com.tonytangandroid.wood.ClearTransactionsService;
import com.tonytangandroid.wood.DismissNotificationService;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.R;
import com.tonytangandroid.wood.Wood;
import com.tonytangandroid.wood.WoodColorUtil;

class NotificationHelper {
    private static final String CHANNEL_ID = "wood_notification_log_channel";
    private static final int BUFFER_SIZE = 10;
    private static final LongSparseArray<Leaf> TRANSACTION_BUFFER = new LongSparseArray();
    private static int TRANSACTION_COUNT;
    private final Context mContext;
    private final NotificationManager mNotificationManager;
    private final WoodColorUtil mColorUtil;

    public NotificationHelper(Context context) {
        this.mContext = context;
        this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
        this.mColorUtil = WoodColorUtil.getInstance(context);
        this.setUpChannelIfNecessary();
    }

    public static synchronized void clearBuffer() {
        TRANSACTION_BUFFER.clear();
        TRANSACTION_COUNT = 0;
    }

    private static synchronized void addToBuffer(Leaf transaction) {
        ++TRANSACTION_COUNT;
        TRANSACTION_BUFFER.put(transaction.getId(), (Object)transaction);
        if (TRANSACTION_BUFFER.size() > 10) {
            TRANSACTION_BUFFER.removeAt(0);
        }
    }

    private void setUpChannelIfNecessary() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)this.mContext.getString(R.string.wood_notification_category), 2);
            channel.setShowBadge(false);
            this.mNotificationManager.createNotificationChannel(channel);
        }
    }

    public synchronized void show(Leaf transaction, boolean stickyNotification) {
        NotificationHelper.addToBuffer(transaction);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext, CHANNEL_ID).setContentIntent(SafePendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)Wood.getLaunchIntent(this.mContext), (int)0)).setLocalOnly(true).setSmallIcon(R.drawable.wood_icon).setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.wood_colorPrimary)).setOngoing(stickyNotification).setContentTitle((CharSequence)this.mContext.getString(R.string.wood_notification_title));
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        int count = 0;
        for (int i = TRANSACTION_BUFFER.size() - 1; i >= 0; --i) {
            if (count < 10) {
                if (count == 0) {
                    builder.setContentText(this.getNotificationText((Leaf)TRANSACTION_BUFFER.valueAt(i)));
                }
                inboxStyle.addLine(this.getNotificationText((Leaf)TRANSACTION_BUFFER.valueAt(i)));
            }
            ++count;
        }
        builder.setAutoCancel(true);
        builder.setStyle((NotificationCompat.Style)inboxStyle);
        if (Build.VERSION.SDK_INT >= 24) {
            builder.setSubText((CharSequence)String.valueOf(TRANSACTION_COUNT));
        } else {
            builder.setNumber(TRANSACTION_COUNT);
        }
        builder.addAction(this.getDismissAction());
        builder.addAction(this.getClearAction());
        this.mNotificationManager.notify(CHANNEL_ID.hashCode(), builder.build());
    }

    private CharSequence getNotificationText(Leaf transaction) {
        int color2 = this.mColorUtil.getTransactionColor(transaction);
        String text = transaction.body();
        SpannableString spannableString = new SpannableString((CharSequence)text);
        spannableString.setSpan((Object)new ForegroundColorSpan(color2), 0, text.length(), 17);
        return spannableString;
    }

    @NonNull
    private NotificationCompat.Action getClearAction() {
        String clearTitle = this.mContext.getString(R.string.wood_clear);
        Intent deleteIntent = new Intent(this.mContext, ClearTransactionsService.class);
        PendingIntent intent = SafePendingIntent.getService((Context)this.mContext, (int)11, (Intent)deleteIntent, (int)0x40000000);
        return new NotificationCompat.Action(R.drawable.wood_ic_delete_white_24dp, (CharSequence)clearTitle, intent);
    }

    @NonNull
    private NotificationCompat.Action getDismissAction() {
        String dismissTitle = this.mContext.getString(R.string.wood_dismiss);
        Intent dismissIntent = new Intent(this.mContext, DismissNotificationService.class);
        PendingIntent intent = SafePendingIntent.getService((Context)this.mContext, (int)12, (Intent)dismissIntent, (int)0x40000000);
        return new NotificationCompat.Action(0, (CharSequence)dismissTitle, intent);
    }

    public void dismiss() {
        this.mNotificationManager.cancel(CHANNEL_ID.hashCode());
    }
}

