/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.LeafDao;
import com.tonytangandroid.wood.WoodDatabase;

public class LeafListViewModel
extends AndroidViewModel {
    private static final PagedList.Config config = new PagedList.Config.Builder().setPageSize(15).setInitialLoadSizeHint(30).setPrefetchDistance(10).setEnablePlaceholders(true).build();
    private final LeafDao mLeafDao;
    private LiveData<PagedList<Leaf>> mTransactions;

    public LeafListViewModel(Application application) {
        super(application);
        this.mLeafDao = WoodDatabase.getInstance((Context)application).leafDao();
        DataSource.Factory<Integer, Leaf> factory = this.mLeafDao.getAllTransactions();
        this.mTransactions = new LivePagedListBuilder(factory, config).build();
    }

    LiveData<PagedList<Leaf>> getTransactions(String key) {
        if (key == null || key.trim().length() == 0) {
            return this.mTransactions;
        }
        DataSource.Factory<Integer, Leaf> factory = this.mLeafDao.getAllTransactionsWith(key, 2);
        return new LivePagedListBuilder(factory, config).build();
    }

    public void deleteItem(Leaf transaction) {
        new deleteAsyncTask(this.mLeafDao).execute(new Leaf[]{transaction});
    }

    void clearAll() {
        new clearAsyncTask(this.mLeafDao).execute(new Leaf[0]);
    }

    private static class clearAsyncTask
    extends AsyncTask<Leaf, Void, Integer> {
        private final LeafDao leafDao;

        clearAsyncTask(LeafDao leafDao) {
            this.leafDao = leafDao;
        }

        protected Integer doInBackground(Leaf ... params) {
            return this.leafDao.clearAll();
        }
    }

    private static class deleteAsyncTask
    extends AsyncTask<Leaf, Void, Integer> {
        private final LeafDao leafDao;

        deleteAsyncTask(LeafDao leafDao) {
            this.leafDao = leafDao;
        }

        protected Integer doInBackground(Leaf ... params) {
            return this.leafDao.deleteTransactions(params);
        }
    }
}

