/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.ViewModelProviders;
import android.arch.paging.PagedList;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.tonytangandroid.wood.Callback;
import com.tonytangandroid.wood.Debouncer;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.LeafAdapter;
import com.tonytangandroid.wood.LeafDetailsActivity;
import com.tonytangandroid.wood.LeafListViewModel;
import com.tonytangandroid.wood.ListDiffUtil;
import com.tonytangandroid.wood.NotificationHelper;
import com.tonytangandroid.wood.R;
import com.tonytangandroid.wood.Sampler;
import com.tonytangandroid.wood.WoodTree;

public class LeavesCollectionFragment
extends Fragment
implements LeafAdapter.Listener,
SearchView.OnQueryTextListener {
    private LeafAdapter adapter;
    private ListDiffUtil listDiffUtil;
    private RecyclerView recyclerView;
    private LeafListViewModel viewModel;
    private LiveData<PagedList<Leaf>> currentSubscription;
    private Sampler<TransactionListWithSearchKeyModel> transactionSampler = new Sampler<TransactionListWithSearchKeyModel>(100, new Callback<TransactionListWithSearchKeyModel>(){

        @Override
        public void onEmit(TransactionListWithSearchKeyModel event) {
            LeavesCollectionFragment.this.listDiffUtil.setSearchKey(event.searchKey);
            LeavesCollectionFragment.this.adapter.setSearchKey(event.searchKey).submitList(event.pagedList);
        }
    });
    private Debouncer<String> searchDebouncer = new Debouncer<String>(300, new Callback<String>(){

        @Override
        public void onEmit(String event) {
            LeavesCollectionFragment.this.loadResults(event, (LiveData<PagedList<Leaf>>)LeavesCollectionFragment.this.viewModel.getTransactions(event));
        }
    });

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.wood_fragment_leaves_collection, container, false);
        this.bindView(rootView);
        return rootView;
    }

    private void bindView(View rootView) {
        this.recyclerView = (RecyclerView)rootView.findViewById(R.id.wood_transaction_list);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.listDiffUtil = new ListDiffUtil();
        this.adapter = new LeafAdapter(this.requireContext(), this.listDiffUtil, this);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.requireContext()));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.requireContext(), 1));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.viewModel = (LeafListViewModel)ViewModelProviders.of((Fragment)this).get(LeafListViewModel.class);
        this.loadResults(null, this.viewModel.getTransactions(null));
    }

    private void loadResults(String searchKey, LiveData<PagedList<Leaf>> pagedListLiveData) {
        if (this.currentSubscription != null && this.currentSubscription.hasObservers()) {
            this.currentSubscription.removeObservers((LifecycleOwner)this);
        }
        this.currentSubscription = pagedListLiveData;
        this.currentSubscription.observe((LifecycleOwner)this, list -> this.consume((PagedList<Leaf>)list, searchKey));
    }

    private void consume(@Nullable PagedList<Leaf> transactionPagedList, String searchKey) {
        this.transactionSampler.consume(new TransactionListWithSearchKeyModel(searchKey, transactionPagedList));
    }

    @Override
    public void onTransactionClicked(Leaf transaction) {
        LeafDetailsActivity.start(this.requireContext(), transaction.getId(), transaction.getPriority());
    }

    @Override
    public void onItemsInserted(int firstInsertedItemPosition) {
        if (WoodTree.autoScroll(this.requireContext())) {
            this.recyclerView.smoothScrollToPosition(firstInsertedItemPosition);
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        menuInflater.inflate(R.menu.wood_list_menu, menu2);
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        SearchView searchView = (SearchView)searchMenuItem.getActionView();
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.viewModel.clearAll();
            NotificationHelper.clearBuffer();
            return true;
        }
        if (item.getItemId() == R.id.browse_sql) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        this.searchDebouncer.consume(newText);
        return true;
    }

    static class TransactionListWithSearchKeyModel {
        final String searchKey;
        final PagedList<Leaf> pagedList;

        TransactionListWithSearchKeyModel(String searchKey, PagedList<Leaf> pagedList) {
            this.searchKey = searchKey;
            this.pagedList = pagedList;
        }
    }
}

