/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.widget.TextView;
import com.tonytangandroid.wood.HighlightSpan;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.R;
import com.tonytangandroid.wood.TextUtil;
import com.tonytangandroid.wood.WoodColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;

class FormatUtils {
    FormatUtils() {
    }

    public static CharSequence formatTextHighlight(String text, String searchKey) {
        if (TextUtil.isNullOrWhiteSpace(text) || TextUtil.isNullOrWhiteSpace(searchKey)) {
            return text;
        }
        List<Integer> startIndexes = FormatUtils.indexOf(text, searchKey);
        SpannableString spannableString = new SpannableString((CharSequence)text);
        FormatUtils.applyHighlightSpan((Spannable)spannableString, startIndexes, searchKey.length());
        return spannableString;
    }

    @NonNull
    public static List<Integer> indexOf(CharSequence charSequence, String criteria) {
        String text = charSequence.toString().toLowerCase();
        criteria = criteria.toLowerCase();
        ArrayList<Integer> startPositions = new ArrayList<Integer>();
        int index = text.indexOf(criteria);
        while (index >= 0) {
            startPositions.add(index);
            index = text.indexOf(criteria, index + 1);
        }
        return startPositions;
    }

    public static void applyHighlightSpan(Spannable spannableString, List<Integer> indexes, int length) {
        for (Integer position : indexes) {
            spannableString.setSpan((Object)new HighlightSpan(WoodColorUtil.HIGHLIGHT_BACKGROUND_COLOR, 0, false), position.intValue(), position + length, 33);
        }
    }

    public static CharSequence getShareText(Context context, Leaf transaction) {
        SpannableStringBuilder text = new SpannableStringBuilder();
        text.append((CharSequence)context.getString(R.string.wood_tag)).append((CharSequence)": ").append(FormatUtils.v(transaction.getTag())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.wood_time)).append((CharSequence)": ").append((CharSequence)FormatUtils.timeDesc(transaction.getCreateAt())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.wood_size)).append((CharSequence)": ").append((CharSequence)String.valueOf(transaction.length())).append((CharSequence)"\n");
        text.append((CharSequence)context.getString(R.string.wood_body_truncated)).append((CharSequence)": ").append((CharSequence)String.valueOf(transaction.body())).append((CharSequence)"\n");
        text.append((CharSequence)"---------- ").append((CharSequence)" ----------\n\n");
        return text;
    }

    private static CharSequence v(CharSequence charSequence) {
        return charSequence != null ? charSequence : "";
    }

    public static List<Integer> highlightSearchKeyword(TextView textView, String searchKey) {
        CharSequence body = textView.getText();
        if (body instanceof Spannable) {
            HighlightSpan[] spansToRemove;
            Spannable spannableBody = (Spannable)body;
            for (HighlightSpan span : spansToRemove = (HighlightSpan[])spannableBody.getSpans(0, spannableBody.length() - 1, HighlightSpan.class)) {
                spannableBody.removeSpan((Object)span);
            }
            if (searchKey != null && searchKey.length() > 0) {
                List<Integer> startIndexes = FormatUtils.indexOf(body.toString(), searchKey);
                FormatUtils.applyHighlightSpan(spannableBody, startIndexes, searchKey.length());
                return startIndexes;
            }
        }
        return new ArrayList<Integer>(0);
    }

    public static String timeDesc(long nowInMilliseconds) {
        ZoneId zoneId = ZoneId.of((String)TimeZone.getDefault().getID());
        Instant timeInstant = Instant.ofEpochMilli((long)nowInMilliseconds);
        ZonedDateTime zoneDateTime = ZonedDateTime.ofInstant((Instant)timeInstant, (ZoneId)zoneId);
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern((String)"HH:mm:ss.SSS MMM-dd", (Locale)Locale.US);
        return zoneDateTime.format(pattern);
    }
}

