/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.tonytangandroid.wood.FormatUtils;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.LeafAdapter;
import com.tonytangandroid.wood.R;
import com.tonytangandroid.wood.WoodColorUtil;
import javax.inject.Provider;

class LeafViewHolder
extends RecyclerView.ViewHolder {
    private final Context context;
    private final Provider<String> searchKey;
    private final LeafAdapter.Listener listener;
    private final TextView tv_time;
    private final TextView tv_tag;
    private final TextView tv_id;
    private final TextView tv_body;

    LeafViewHolder(View itemView, Context context, Provider<String> searchKey, LeafAdapter.Listener listener) {
        super(itemView);
        this.context = context;
        this.listener = listener;
        this.searchKey = searchKey;
        this.tv_time = (TextView)itemView.findViewById(R.id.tv_time);
        this.tv_id = (TextView)itemView.findViewById(R.id.tv_id);
        this.tv_tag = (TextView)itemView.findViewById(R.id.tv_tag);
        this.tv_body = (TextView)itemView.findViewById(R.id.tv_body);
    }

    void bind(Leaf transaction) {
        this.tv_tag.setText((CharSequence)transaction.getTag());
        this.tv_time.setText((CharSequence)FormatUtils.timeDesc(transaction.getCreateAt()));
        this.tv_body.setText(this.getHighlightedText(String.valueOf(transaction.body())));
        this.tv_id.setText((CharSequence)String.valueOf(transaction.getId()));
        this.tv_tag.setTextColor(WoodColorUtil.getInstance(this.context).getTransactionColor(transaction));
        this.itemView.setOnClickListener(v -> this.listener.onTransactionClicked(transaction));
    }

    private CharSequence getHighlightedText(String text) {
        return FormatUtils.formatTextHighlight(text, (String)this.searchKey.get());
    }
}

