/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ViewModelProviders;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatTextView;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextWatcher;
import android.text.style.BackgroundColorSpan;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.tonytangandroid.wood.Debouncer;
import com.tonytangandroid.wood.FormatUtils;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.LeafDetailViewModel;
import com.tonytangandroid.wood.R;
import com.tonytangandroid.wood.TextUtil;
import com.tonytangandroid.wood.WoodColorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LeafDetailFragment
extends Fragment
implements View.OnClickListener,
TextUtil.AsyncTextProvider,
TextWatcher {
    private static final String ARG_ID = "arg_id";
    private final BackgroundColorSpan colorSpan = new BackgroundColorSpan(WoodColorUtil.SEARCHED_HIGHLIGHT_BACKGROUND_COLOR);
    private long id;
    private String searchKey;
    private WoodColorUtil colorUtil;
    private int currentSearchIndex;
    private Leaf leaf;
    private List<Integer> searchIndexList = new ArrayList<Integer>(0);
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private View search_bar;
    private EditText et_key_word;
    private TextView tv_search_count;
    private AppCompatTextView tv_body;
    private final Debouncer<String> searchDebouncer = new Debouncer<String>(400, this::onSearchKeyEmitted);
    private NestedScrollView nested_scroll_view;
    private FloatingActionButton floating_action_button;

    public static LeafDetailFragment newInstance(long id2) {
        LeafDetailFragment fragment = new LeafDetailFragment();
        Bundle b = new Bundle();
        b.putLong(ARG_ID, id2);
        fragment.setArguments(b);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        assert (this.getArguments() != null);
        this.id = this.getArguments().getLong(ARG_ID);
        this.colorUtil = WoodColorUtil.getInstance(this.getContext());
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.wood_fragment_leaf_detail, container, false);
        this.bindView(rootView);
        return rootView;
    }

    private void bindView(View rootView) {
        this.tv_body = (AppCompatTextView)rootView.findViewById(R.id.wood_details_body);
        this.nested_scroll_view = (NestedScrollView)rootView.findViewById(R.id.wood_details_scroll_parent);
        this.floating_action_button = (FloatingActionButton)rootView.findViewById(R.id.wood_details_search_fab);
        this.search_bar = rootView.findViewById(R.id.wood_details_search_bar);
        View searchBarPrev = rootView.findViewById(R.id.wood_details_search_prev);
        View searchBarNext = rootView.findViewById(R.id.wood_details_search_next);
        View searchBarClose = rootView.findViewById(R.id.wood_details_search_close);
        this.et_key_word = (EditText)rootView.findViewById(R.id.wood_details_search);
        this.tv_search_count = (TextView)rootView.findViewById(R.id.wood_details_search_count);
        this.floating_action_button.setOnClickListener((View.OnClickListener)this);
        searchBarPrev.setOnClickListener((View.OnClickListener)this);
        searchBarNext.setOnClickListener((View.OnClickListener)this);
        searchBarClose.setOnClickListener((View.OnClickListener)this);
        this.et_key_word.addTextChangedListener((TextWatcher)this);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.searchDebouncer.consume(s.toString());
    }

    public void afterTextChanged(Editable s) {
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.observe();
    }

    private void observe() {
        LeafDetailViewModel viewModel = (LeafDetailViewModel)ViewModelProviders.of((FragmentActivity)this.requireActivity()).get(LeafDetailViewModel.class);
        viewModel.getTransactionWithId(this.id).observe((LifecycleOwner)this, this::transactionUpdated);
    }

    private void transactionUpdated(Leaf transaction) {
        this.leaf = transaction;
        this.populateUI();
    }

    private void populateUI() {
        int color2 = this.colorUtil.getTransactionColor(this.leaf);
        this.floating_action_button.setBackgroundTintList(this.colorStateList(color2));
        this.search_bar.setBackgroundColor(color2);
        this.et_key_word.setHint(R.string.wood_search_hint);
        this.populateBody();
    }

    @NonNull
    private ColorStateList colorStateList(int color2) {
        return new ColorStateList((int[][])new int[][]{{0}}, new int[]{color2});
    }

    private void onSearchKeyEmitted(String searchKey) {
        this.searchKey = searchKey;
        this.updateUI();
    }

    private void updateUI() {
        this.searchIndexList = FormatUtils.highlightSearchKeyword((TextView)this.tv_body, this.searchKey);
        this.updateSearch(1, this.searchKey);
    }

    private void populateBody() {
        ActionBar actionBar = ((AppCompatActivity)this.requireActivity()).getSupportActionBar();
        assert (actionBar != null);
        actionBar.setTitle((CharSequence)this.leaf.getTag());
        actionBar.setSubtitle((CharSequence)this.timeDesc(this.leaf));
        TextUtil.asyncSetText(this.executor, this);
    }

    @NonNull
    private String timeDesc(Leaf leaf) {
        return FormatUtils.timeDesc(leaf.getCreateAt());
    }

    @Override
    public CharSequence getText() {
        String body = this.leaf.body();
        if (TextUtil.isNullOrWhiteSpace(body) || TextUtil.isNullOrWhiteSpace(this.searchKey)) {
            return body;
        }
        List<Integer> indexList = FormatUtils.indexOf(body, this.searchKey);
        SpannableString spannableBody = new SpannableString((CharSequence)body);
        FormatUtils.applyHighlightSpan((Spannable)spannableBody, indexList, this.searchKey.length());
        this.searchIndexList = indexList;
        return spannableBody;
    }

    @Override
    public AppCompatTextView getTextView() {
        return this.tv_body;
    }

    private void updateSearch(int targetIndex, String searchKey) {
        List<Integer> list = this.searchIndexList;
        int size = list.size();
        targetIndex = this.adjustTargetIndex(targetIndex, size);
        this.tv_search_count.setText((CharSequence)String.valueOf(targetIndex).concat("/").concat(String.valueOf(size)));
        ((Spannable)this.tv_body.getText()).removeSpan((Object)this.colorSpan);
        if (targetIndex > 0) {
            this.updateSpan(targetIndex, searchKey, list);
        }
        this.currentSearchIndex = targetIndex;
    }

    private void updateSpan(int targetIndex, String searchKey, List<Integer> list) {
        int begin = list.get(targetIndex - 1);
        int end = begin + searchKey.length();
        int lineNumber = this.tv_body.getLayout().getLineForOffset(begin);
        ((Spannable)this.tv_body.getText()).setSpan((Object)this.colorSpan, begin, end, 33);
        int scrollToY = this.tv_body.getLayout().getLineTop(lineNumber);
        this.nested_scroll_view.scrollTo(0, scrollToY);
    }

    private int adjustTargetIndex(int targetIndex, int size) {
        if (size == 0) {
            targetIndex = 0;
        } else if (targetIndex > size) {
            targetIndex = 1;
        } else if (targetIndex <= 0) {
            targetIndex = size;
        }
        return targetIndex;
    }

    private void showKeyboard() {
        this.et_key_word.requestFocus();
        InputMethodManager imm = this.inputMethodManager();
        if (imm != null) {
            imm.showSoftInput((View)this.et_key_word, 1);
        }
    }

    private InputMethodManager inputMethodManager() {
        return (InputMethodManager)this.requireContext().getSystemService("input_method");
    }

    private void hideKeyboard() {
        InputMethodManager imm = this.inputMethodManager();
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.et_key_word.getWindowToken(), 0);
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (!isVisibleToUser) {
            this.hideKeyboard();
        }
        super.setUserVisibleHint(isVisibleToUser);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.wood_details_search_fab) {
            this.showSearch();
        } else if (id2 == R.id.wood_details_search_close) {
            this.clearSearch();
        } else if (id2 == R.id.wood_details_search_prev) {
            this.updateSearch(this.currentSearchIndex - 1, this.searchKey);
        } else if (id2 == R.id.wood_details_search_next) {
            this.updateSearch(this.currentSearchIndex + 1, this.searchKey);
        }
    }

    private void clearSearch() {
        if (TextUtil.isNullOrWhiteSpace(this.searchKey)) {
            this.floating_action_button.show();
            this.search_bar.setVisibility(8);
            this.nested_scroll_view.setPadding(0, 0, 0, this.nested_scroll_view.getBottom());
            this.hideKeyboard();
        } else {
            this.et_key_word.setText((CharSequence)"");
        }
    }

    private void showSearch() {
        this.floating_action_button.hide();
        this.search_bar.setVisibility(0);
        this.nested_scroll_view.setPadding(0, this.getResources().getDimensionPixelSize(R.dimen.wood_search_bar_height), 0, this.nested_scroll_view.getBottom());
        this.showKeyboard();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        menuInflater.inflate(R.menu.wood_details_menu, menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.share_text) {
            this.share(FormatUtils.getShareText(this.requireContext(), this.leaf));
            return true;
        }
        if (itemId == R.id.copy) {
            this.copy(FormatUtils.getShareText(this.requireContext(), this.leaf));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void copy(CharSequence text) {
        ClipboardManager clipboard = (ClipboardManager)this.requireContext().getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"log", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
        Toast.makeText((Context)this.requireContext(), (CharSequence)"Copied", (int)0).show();
    }

    private void share(CharSequence content) {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", content);
        sendIntent.setType("text/plain");
        this.startActivity(Intent.createChooser((Intent)sendIntent, null));
    }
}

