/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core.lifecycle;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.uber.rib.core.lifecycle.ActivityEvent;
import java.util.Locale;

public class ActivityCallbackEvent
implements ActivityEvent {
    private static final ActivityCallbackEvent LOW_MEMORY_EVENT = new ActivityCallbackEvent(Type.LOW_MEMORY);
    private final Type type;

    private ActivityCallbackEvent(Type type) {
        this.type = type;
    }

    public static ActivityResult createOnActivityResultEvent(int requestCode, int resultCode, @Nullable Intent resultData) {
        return new ActivityResult(resultData, requestCode, resultCode);
    }

    public static ActivityCallbackEvent create(Type type) {
        switch (type) {
            case LOW_MEMORY: {
                return LOW_MEMORY_EVENT;
            }
        }
        throw new IllegalArgumentException("Use the createOn" + ActivityCallbackEvent.capitalize(type.name().toLowerCase(Locale.US)) + "Event() method for this type!");
    }

    public static ActivityCallbackEvent createOnSaveInstanceStateEvent(@Nullable Bundle outState) {
        return new SaveInstanceState(outState);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    private static String capitalize(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    public static class SaveInstanceState
    extends ActivityCallbackEvent {
        @Nullable
        private Bundle outState;

        private SaveInstanceState(@Nullable Bundle outState) {
            super(Type.SAVE_INSTANCE_STATE);
            this.outState = outState;
        }

        @Nullable
        public Bundle getOutState() {
            return this.outState;
        }
    }

    public static class ActivityResult
    extends ActivityCallbackEvent {
        @Nullable
        private final Intent data;
        private final int requestCode;
        private final int resultCode;

        private ActivityResult(@Nullable Intent data, int requestCode, int resultCode) {
            super(Type.ACTIVITY_RESULT);
            this.data = data;
            this.requestCode = requestCode;
            this.resultCode = resultCode;
        }

        @Nullable
        public Intent getData() {
            return this.data;
        }

        public int getRequestCode() {
            return this.requestCode;
        }

        public int getResultCode() {
            return this.resultCode;
        }
    }

    public static enum Type implements ActivityEvent.BaseType
    {
        LOW_MEMORY,
        ACTIVITY_RESULT,
        SAVE_INSTANCE_STATE;

    }
}

