/*
 * Decompiled with CFR 0.152.
 */
package com.uber.rib.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.uber.rib.core.Builder;
import com.uber.rib.core.Router;
import com.uber.rib.core.XRay;

public abstract class ViewBuilder<ViewType extends View, RouterT extends Router, DependencyT>
extends Builder<RouterT, DependencyT> {
    public ViewBuilder(DependencyT dependency) {
        super(dependency);
    }

    protected final ViewType createView(ViewGroup parentViewGroup) {
        Context context = parentViewGroup.getContext();
        ViewType view = this.inflateView(LayoutInflater.from((Context)this.onThemeContext(context)), parentViewGroup);
        if (XRay.isEnabled()) {
            XRay.apply(this, view);
        }
        return view;
    }

    protected abstract ViewType inflateView(LayoutInflater var1, ViewGroup var2);

    protected Context onThemeContext(Context parentContext) {
        return parentContext;
    }
}

